/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DbUiUtilCore;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0002H\u0016J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\"\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dataSource/IntrospectionScheduleOptionProvider;", "Lcom/intellij/database/dataSource/DbOptionProvider$LocalDataSourceOptionProvider;", "", "<init>", "()V", "isApplicable", "", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "getDisplayName", "getDescription", "load", "getEditor", "Lcom/intellij/database/dataSource/DbOptionProvider$EditorDesc;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getLocation", "Lcom/intellij/database/dataSource/DbOptionProvider$UiLocation;", "store", "", "value", "intellij.database.connectivity"})
public final class IntrospectionScheduleOptionProvider
extends DbOptionProvider.LocalDataSourceOptionProvider<String> {
    public boolean isApplicable(@NotNull LocalDataSource target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return true;
    }

    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message((String)"IntrospectionScheduleOptionProvider.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = DatabaseBundle.message((String)"IntrospectionScheduleOptionProvider.desc", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public String load(@Nullable LocalDataSource target) {
        Object object = target;
        return object != null && (object = object.getAdditionalProperty("auto-refresh-interval")) != null ? StringKt.nullize$default((String)object, (boolean)false, (int)1, null) : null;
    }

    @NotNull
    public DbOptionProvider.EditorDesc<String> getEditor(@Nullable LocalDataSource target, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DbOptionProvider.EditorDesc $this$getEditor_u24lambda_u240 = DbOptionProvider.getTextField(null);
        boolean bl = false;
        JComponent jComponent = $this$getEditor_u24lambda_u240.component;
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type javax.swing.JTextField");
        JTextField textField = (JTextField)jComponent;
        textField.setColumns(6);
        Object[] objectArray = new Object[]{DatabaseBundle.message((String)"IntrospectionScheduleOptionProvider.unit", (Object[])new Object[0])};
        String textFieldAccessibleName = AccessibleContextUtil.combineAccessibleStrings((String)DatabaseBundle.message((String)"IntrospectionScheduleOptionProvider.text", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"inline.text.field.accessible.name.time.in.prefix", (Object[])objectArray));
        textField.getAccessibleContext().setAccessibleName(textFieldAccessibleName);
        textField.getAccessibleContext().setAccessibleDescription(this.getDescription());
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(textField){
            final /* synthetic */ JTextField $textField;
            {
                this.$textField = $textField;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JComponent jComponent = this.$textField;
                String string = this.$textField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                DbUiUtilCore.setError((JComponent)jComponent, (String)this.getError(string));
            }

            private final String getError(String text) {
                String string;
                try {
                    if (((CharSequence)text).length() > 0) {
                        Double.parseDouble(text);
                    }
                    string = null;
                }
                catch (NumberFormatException e) {
                    string = "Should be integer or decimal number";
                }
                return string;
            }
        });
        return new DbOptionProvider.EditorDesc((JComponent)JBUI.Panels.simplePanel().addToLeft((Component)$this$getEditor_u24lambda_u240.component).addToCenter((Component)new JLabel(DatabaseBundle.message((String)"IntrospectionScheduleOptionProvider.unit", (Object[])new Object[0]))), $this$getEditor_u24lambda_u240.setter, $this$getEditor_u24lambda_u240.getter, $this$getEditor_u24lambda_u240.changed);
    }

    @NotNull
    public DbOptionProvider.UiLocation getLocation() {
        return DbOptionProvider.UiLocation.INTROSPECTION;
    }

    public void store(@NotNull LocalDataSource target, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.setAdditionalProperty("auto-refresh-interval", StringKt.nullize$default((String)value, (boolean)false, (int)1, null));
    }
}

