/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.input;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.Stack;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.query.ComponentShowingQuery;

class MouseInfo {
    static final int BUTTON_MASK = 28;
    private Point location = new Point(0, 0);
    private Point locationOnScreen = new Point(0, 0);
    private final Stack<WeakReference<Component>> componentStack = new Stack();
    private final Stack<Point> locationStack = new Stack();
    private final Stack<Point> screenLocationStack = new Stack();
    private int buttons;
    private int modifiers;
    private int clickCount;

    MouseInfo() {
    }

    void clear() {
        this.clickCount = 0;
        this.modifiers = 0;
        this.buttons = 0;
        this.componentStack.clear();
        this.locationStack.clear();
        this.screenLocationStack.clear();
    }

    void update(@Nonnull MouseEvent event, @Nullable Point eventScreenLocation) {
        this.clickCount(event.getClickCount());
        this.updateOnMousePressed(event);
        this.updateOnMouseReleased(event);
        this.updateOnMouseEntered(event, eventScreenLocation);
        this.updateOnMouseExited(event);
        if (eventScreenLocation != null) {
            Point where = event.getPoint();
            this.location = this.componentStack.empty() ? null : new Point(where);
            this.locationOnScreen.setLocation(eventScreenLocation);
            this.locationOnScreen.translate(where.x, where.y);
        }
    }

    private void updateOnMousePressed(@Nonnull MouseEvent event) {
        if (event.getID() != 501) {
            return;
        }
        int buttonUsed = this.buttonUsed(event);
        this.buttons |= buttonUsed;
        this.modifiers |= buttonUsed;
    }

    private void updateOnMouseReleased(@Nonnull MouseEvent event) {
        if (event.getID() != 502) {
            return;
        }
        int buttonUsed = this.buttonUsed(event);
        this.buttons &= ~buttonUsed;
        this.modifiers &= ~buttonUsed;
    }

    private int buttonUsed(@Nonnull MouseEvent event) {
        return event.getModifiers() & 0x1C;
    }

    private void updateOnMouseEntered(@Nonnull MouseEvent event, @Nullable Point eventScreenLocation) {
        if (event.getID() != 504) {
            return;
        }
        this.componentStack.push(new WeakReference<Component>(event.getComponent()));
        Point eventPoint = event.getPoint();
        this.locationStack.push(eventPoint);
        this.screenLocationStack.push(eventScreenLocation != null ? eventScreenLocation : eventPoint);
    }

    private void updateOnMouseExited(@Nonnull MouseEvent event) {
        if (event.getID() != 505 || this.componentStack.empty()) {
            return;
        }
        this.componentStack.pop();
        this.locationStack.pop();
        this.screenLocationStack.pop();
    }

    @Nullable
    public Component component() {
        if (this.componentStack.empty()) {
            return null;
        }
        Component c = (Component)this.componentStack.peek().get();
        if (c != null && ComponentShowingQuery.isShowing(c)) {
            return c;
        }
        this.componentStack.pop();
        this.locationStack.pop();
        this.screenLocationStack.pop();
        c = this.component();
        if (c != null) {
            this.location = this.locationStack.peek();
            this.locationOnScreen = this.screenLocationStack.peek();
        }
        return c;
    }

    int buttons() {
        return this.buttons;
    }

    void buttons(int newButtons) {
        this.buttons = newButtons;
    }

    int modifiers() {
        return this.modifiers;
    }

    void modifiers(int newModifiers) {
        this.modifiers = newModifiers;
    }

    int clickCount() {
        return this.clickCount;
    }

    void clickCount(int newClickCount) {
        this.clickCount = newClickCount;
    }

    @Nullable
    Point location() {
        return this.pointFrom(this.location);
    }

    @Nullable
    Point locationOnScreen() {
        return this.pointFrom(this.locationOnScreen);
    }

    @Nullable
    private Point pointFrom(Point source) {
        return source != null ? new Point(source) : null;
    }
}

