/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.python.remoteInterpreter.PyRemoteProcessHandlerUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.net.NetUtils;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationClient;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J=\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u001dR\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/python/remoteInterpreter/console/PythonConsoleSshProcessCreatorBase;", "T", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$annotations", "remotePortForwardingMap", "", "Lcom/intellij/ssh/SshSession;", "", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "runnerFileFromHelpers", "", "credentials", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/jetbrains/python/remote/PyRemotePathMapper;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;Ljava/lang/String;Ljava/lang/Object;)Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "createRemoteTunnel", "localPort", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;I)Ljava/lang/Integer;", "intellij.python.remoteInterpreter"})
public abstract class PythonConsoleSshProcessCreatorBase<T>
implements PythonConsoleRemoteProcessCreator<T> {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final Map<SshSession, Integer> remotePortForwardingMap;

    public PythonConsoleSshProcessCreatorBase() {
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        Map map = Collections.synchronizedMap(new WeakHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.remotePortForwardingMap = map;
    }

    private static /* synthetic */ void getLOG$annotations() {
    }

    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, T credentials) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        int scriptPort = NetUtils.findAvailableSocketPort();
        PydevConsoleCli.setupPythonConsoleScriptInServerMode$default((GeneralCommandLine)commandLine, (SdkAdditionalData)((SdkAdditionalData)data), null, (int)2, null);
        try {
            PyRemoteProcessHandlerUtil.SshExecProcessWithHandler sshExecProcessWithHandler = PyRemoteProcessHandlerUtil.startRemoteProcess(project, commandLine, data, pathMapper);
            Intrinsics.checkNotNullExpressionValue((Object)sshExecProcessWithHandler, (String)"startRemoteProcess(...)");
            PyRemoteProcessHandlerUtil.SshExecProcessWithHandler result = sshExecProcessWithHandler;
            PyRemoteProcessHandler pyRemoteProcessHandler = result.getHandler();
            Intrinsics.checkNotNullExpressionValue((Object)pyRemoteProcessHandler, (String)"getHandler(...)");
            PyRemoteProcessHandler processHandler = pyRemoteProcessHandler;
            SshExecProcess sshExecProcess = result.getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)sshExecProcess, (String)"getProcess(...)");
            SshExecProcess remoteProcess = sshExecProcess;
            int remoteScriptPort = PydevConsoleRunnerImpl.getRemotePortFromProcess((Process)((Process)remoteProcess));
            remoteProcess.addLocalTunnel(scriptPort, "localhost", remoteScriptPort);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Using tunneled communication for Python console: port " + scriptPort + " (=> " + remoteScriptPort + ") on pydevconsole.py side");
            }
            PydevConsoleCommunicationClient remoteConsoleCommunication = new PydevConsoleCommunicationClient(project, "localhost", scriptPort, (Process)remoteProcess);
            remoteConsoleCommunication.connect();
            PydevConsoleCommunication pydevConsoleCommunication = (PydevConsoleCommunication)remoteConsoleCommunication;
            String string = processHandler.getCommandLine();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLine(...)");
            Process process = processHandler.getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
            PyRemoteSocketToLocalHostProvider pyRemoteSocketToLocalHostProvider = processHandler.getRemoteSocketToLocalHostProvider();
            Intrinsics.checkNotNullExpressionValue((Object)pyRemoteSocketToLocalHostProvider, (String)"getRemoteSocketToLocalHostProvider(...)");
            return new RemoteConsoleProcessData(pydevConsoleCommunication, string, process, pyRemoteSocketToLocalHostProvider);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public Integer createRemoteTunnel(@NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, int localPort) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            this.remotePortForwardingMap.keySet().removeIf(arg_0 -> PythonConsoleSshProcessCreatorBase.createRemoteTunnel$lambda$1(PythonConsoleSshProcessCreatorBase::createRemoteTunnel$lambda$0, arg_0));
            RemoteCredentials remoteCredentials = data.getRemoteCredentials(project, false);
            Intrinsics.checkNotNullExpressionValue((Object)remoteCredentials, (String)"getRemoteCredentials(...)");
            SshSession session = RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)remoteCredentials, (Project)project, null, (boolean)false, null, (int)14, null).connect();
            Integer n2 = this.remotePortForwardingMap.computeIfAbsent(session, arg_0 -> PythonConsoleSshProcessCreatorBase.createRemoteTunnel$lambda$3(arg_0 -> PythonConsoleSshProcessCreatorBase.createRemoteTunnel$lambda$2(session, localPort, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)n2);
            n = ((Number)n2).intValue();
        }
        catch (SshException e) {
            throw new IOException(e.getMessage(), e);
        }
        return n;
    }

    private static final boolean createRemoteTunnel$lambda$0(SshSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isConnected();
    }

    private static final boolean createRemoteTunnel$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Integer createRemoteTunnel$lambda$2(SshSession $session, int $localPort, SshSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $session.addRemoteTunnelWithRandomRemotePort("localhost", $localPort);
    }

    private static final Integer createRemoteTunnel$lambda$3(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }
}

