/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.transformer;

import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricher;
import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionParameters;
import com.intellij.ml.inline.completion.impl.MLCompletionProposal;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.CorrectnessAnalysisState;
import com.intellij.ml.inline.completion.impl.postprocessing.transformer.DiagnosableProposalTransformer;
import com.intellij.ml.inline.completion.impl.postprocessing.util.MLCompletionCommentsUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/RemoveCommentsTransformer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/DiagnosableProposalTransformer;", "kit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "parameters", "Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;)V", "transformRaw", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposal", "transformAnalyzed", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "getOrder", "", "intellij.fullLine.core.completion"})
public final class RemoveCommentsTransformer
extends DiagnosableProposalTransformer {
    @NotNull
    private final MLCompletionLanguageKit kit;
    @NotNull
    private final MLCompletionParameters parameters;

    public RemoveCommentsTransformer(@NotNull MLCompletionLanguageKit kit, @NotNull MLCompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        super("Remove comments");
        this.kit = kit;
        this.parameters = parameters;
    }

    @Override
    @NotNull
    public RawMLCompletionProposal transformRaw(@NotNull RawMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        return proposal;
    }

    @Override
    @NotNull
    public AnalyzedMLCompletionProposal transformAnalyzed(@NotNull AnalyzedMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        return (AnalyzedMLCompletionProposal)this.diagnoseMapping((MLCompletionProposal)proposal, () -> RemoveCommentsTransformer.transformAnalyzed$lambda$0(this, proposal));
    }

    @Override
    public int getOrder() {
        return 1000;
    }

    private static final AnalyzedMLCompletionProposal transformAnalyzed$lambda$0(RemoveCommentsTransformer this$0, AnalyzedMLCompletionProposal $proposal) {
        int startOffset;
        if (this$0.parameters.isComment()) {
            return $proposal;
        }
        CorrectnessAnalysisState correctnessState = $proposal.getCorrectnessState();
        if (!(correctnessState instanceof CorrectnessAnalysisState.Analyzed)) {
            if (Intrinsics.areEqual((Object)correctnessState, (Object)CorrectnessAnalysisState.Unknown.INSTANCE)) {
                return $proposal;
            }
            throw new NoWhenBranchMatchedException();
        }
        SuggestionEnricher.Enrichment enrichment = ((CorrectnessAnalysisState.Analyzed)correctnessState).getEnrichment();
        PsiFile file = enrichment.component2();
        TextRange range = enrichment.component3();
        if (file == null) {
            return $proposal;
        }
        List comments = MLCompletionCommentsUtil.findComments$default(MLCompletionCommentsUtil.INSTANCE, this$0.kit, file, range, 0, 8, null);
        TextRange singleComment = (TextRange)CollectionsKt.singleOrNull((List)comments);
        if (singleComment == null || range.getEndOffset() != singleComment.getEndOffset()) {
            return $proposal;
        }
        singleComment = singleComment.shiftLeft(range.getStartOffset());
        for (startOffset = singleComment.getStartOffset(); startOffset > 0 && CharsKt.isWhitespace((char)$proposal.getSuggestion().charAt(startOffset - 1)); --startOffset) {
        }
        if (startOffset == 0) {
            return $proposal;
        }
        AnalyzedMLCompletionProposal analyzedMLCompletionProposal = $proposal.trimSuffix(StringsKt.drop((String)$proposal.getSuggestion(), (int)startOffset));
        if (analyzedMLCompletionProposal == null) {
            analyzedMLCompletionProposal = $proposal;
        }
        return analyzedMLCompletionProposal;
    }
}

