/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.google.common.base.Joiner;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssTableValueBase<V extends CssTableValue, T>
implements CssTableValue<V, T> {
    private final List<V> myChildren;
    private final T myValue;
    private int myMinCount;
    private int myMaxCount;
    private String myPrefix;
    private String myValuesDelimiter;
    private CssTableValue.Type myType;
    private boolean hasImmutablePrefix;

    protected CssTableValueBase(@NotNull CssTableValue.Type type) {
        if (type == null) {
            CssTableValueBase.$$$reportNull$$$0(0);
        }
        this(null, type);
    }

    protected CssTableValueBase(@Nullable T value, @NotNull CssTableValue.Type type) {
        if (type == null) {
            CssTableValueBase.$$$reportNull$$$0(1);
        }
        this.myChildren = new SmartList();
        this.myMinCount = -1;
        this.myMaxCount = -1;
        this.myValuesDelimiter = " ";
        this.hasImmutablePrefix = false;
        this.myValue = value;
        this.myType = type;
    }

    protected CssTableValueBase(@Nullable T value) {
        this(value, CssTableValue.Type.DEFAULT);
    }

    @Override
    public V addChild(@NotNull V child) {
        if (child == null) {
            CssTableValueBase.$$$reportNull$$$0(2);
        }
        this.myChildren.add(child);
        return child;
    }

    protected void removeChild(@NotNull V child) {
        if (child == null) {
            CssTableValueBase.$$$reportNull$$$0(3);
        }
        this.myChildren.remove(child);
    }

    protected void removeAllChildren() {
        this.myChildren.clear();
    }

    @Override
    public T getValue() {
        return this.myValue;
    }

    @Override
    @NotNull
    public CssTableValue.Type getType() {
        CssTableValue.Type type = this.myType;
        if (type == null) {
            CssTableValueBase.$$$reportNull$$$0(4);
        }
        return type;
    }

    @Override
    public void setType(@NotNull CssTableValue.Type type) {
        if (type == null) {
            CssTableValueBase.$$$reportNull$$$0(5);
        }
        this.myType = type;
    }

    @Override
    public String getPrefix() {
        return this.myPrefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.myPrefix = prefix;
    }

    @Override
    public boolean hasImmutablePrefix() {
        return this.hasImmutablePrefix;
    }

    @Override
    public void setHasImmutablePrefix(boolean hasImmutablePrefix) {
        this.hasImmutablePrefix = hasImmutablePrefix;
    }

    @Override
    public String getValuesDelimiter() {
        return this.myValuesDelimiter;
    }

    @Override
    public void setValuesDelimiter(String valuesDelimiter) {
        this.myValuesDelimiter = valuesDelimiter;
    }

    @Override
    public boolean isGroup() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public int getMinCount() {
        return this.myMinCount;
    }

    @Override
    public void setMinCount(int minCount) {
        this.myMinCount = minCount;
    }

    @Override
    public int getMaxCount() {
        return this.myMaxCount;
    }

    @Override
    public void setMaxCount(int maxCount) {
        this.myMaxCount = maxCount;
    }

    @Override
    public List<V> getChildren() {
        return this.myChildren;
    }

    @Override
    public void accept(@NotNull CssTableValueVisitor visitor) {
        if (visitor == null) {
            CssTableValueBase.$$$reportNull$$$0(6);
        }
        visitor.visit(this);
    }

    public String toString() {
        if (!this.isGroup()) {
            return this.getValue().toString();
        }
        String separator = switch (this.myType) {
            default -> throw new IncompatibleClassChangeError();
            case CssTableValue.Type.OR -> " | ";
            case CssTableValue.Type.ANY -> " || ";
            case CssTableValue.Type.FULL_ANY -> " && ";
            case CssTableValue.Type.DEFAULT -> " ";
        };
        return "[" + Joiner.on((String)separator).join(this.myChildren) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssTableValueBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssTableValueBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

