/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;

public class SharedTextColors
implements ISharedTextColors {
    public static final RGB COLOR_WARNING = new RGB(255, 99, 71);
    private final Map<Display, Map<RGB, Color>> fDisplayTable = new HashMap<Display, Map<RGB, Color>>();
    private final Map<String, RGB> rgbMap = new HashMap<String, RGB>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Color getColor(String rgbString) {
        RGB rgb;
        Map<String, RGB> map = this.rgbMap;
        synchronized (map) {
            rgb = this.rgbMap.get(rgbString);
            if (rgb == null) {
                rgb = StringConverter.asRGB((String)rgbString);
                this.rgbMap.put(rgbString, rgb);
            }
        }
        return this.getColor(rgb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Color getColor(@NotNull RGB rgb) {
        Map<RGB, Color> colorTable;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Display curDisplay = display;
        Map<Display, Map<RGB, Color>> map = this.fDisplayTable;
        synchronized (map) {
            colorTable = this.fDisplayTable.get(display);
            if (colorTable == null) {
                colorTable = new HashMap<RGB, Color>(10);
                this.fDisplayTable.put(curDisplay, colorTable);
                display.disposeExec(() -> this.dispose(curDisplay));
            }
        }
        Color color = colorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)curDisplay, rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        for (Map<RGB, Color> rgbColorMap : this.fDisplayTable.values()) {
            this.dispose(rgbColorMap);
        }
        this.fDisplayTable.clear();
    }

    private void dispose(Display display) {
        this.dispose(this.fDisplayTable.remove(display));
    }

    private void dispose(Map<RGB, Color> colorTable) {
        if (colorTable == null) {
            return;
        }
        for (Color color : colorTable.values()) {
            color.dispose();
        }
        colorTable.clear();
    }
}

