//! This file is auto-generated by tools/update_cpu_features.zig.

const std = @import("../std.zig");
const CpuFeature = std.Target.Cpu.Feature;
const CpuModel = std.Target.Cpu.Model;

pub const Feature = enum {
    isa_68000,
    isa_68010,
    isa_68020,
    isa_68030,
    isa_68040,
    isa_68060,
    isa_68881,
    isa_68882,
    reserve_a0,
    reserve_a1,
    reserve_a2,
    reserve_a3,
    reserve_a4,
    reserve_a5,
    reserve_a6,
    reserve_d0,
    reserve_d1,
    reserve_d2,
    reserve_d3,
    reserve_d4,
    reserve_d5,
    reserve_d6,
    reserve_d7,
};

pub const featureSet = CpuFeature.FeatureSetFns(Feature).featureSet;
pub const featureSetHas = CpuFeature.FeatureSetFns(Feature).featureSetHas;
pub const featureSetHasAny = CpuFeature.FeatureSetFns(Feature).featureSetHasAny;
pub const featureSetHasAll = CpuFeature.FeatureSetFns(Feature).featureSetHasAll;

pub const all_features = blk: {
    const len = @typeInfo(Feature).@"enum".fields.len;
    std.debug.assert(len <= CpuFeature.Set.needed_bit_count);
    var result: [len]CpuFeature = undefined;
    result[@intFromEnum(Feature.isa_68000)] = .{
        .llvm_name = "isa-68000",
        .description = "Is M68000 ISA supported",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.isa_68010)] = .{
        .llvm_name = "isa-68010",
        .description = "Is M68010 ISA supported",
        .dependencies = featureSet(&[_]Feature{
            .isa_68000,
        }),
    };
    result[@intFromEnum(Feature.isa_68020)] = .{
        .llvm_name = "isa-68020",
        .description = "Is M68020 ISA supported",
        .dependencies = featureSet(&[_]Feature{
            .isa_68010,
        }),
    };
    result[@intFromEnum(Feature.isa_68030)] = .{
        .llvm_name = "isa-68030",
        .description = "Is M68030 ISA supported",
        .dependencies = featureSet(&[_]Feature{
            .isa_68020,
        }),
    };
    result[@intFromEnum(Feature.isa_68040)] = .{
        .llvm_name = "isa-68040",
        .description = "Is M68040 ISA supported",
        .dependencies = featureSet(&[_]Feature{
            .isa_68030,
            .isa_68882,
        }),
    };
    result[@intFromEnum(Feature.isa_68060)] = .{
        .llvm_name = "isa-68060",
        .description = "Is M68060 ISA supported",
        .dependencies = featureSet(&[_]Feature{
            .isa_68040,
        }),
    };
    result[@intFromEnum(Feature.isa_68881)] = .{
        .llvm_name = "isa-68881",
        .description = "Is M68881 (FPU) ISA supported",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.isa_68882)] = .{
        .llvm_name = "isa-68882",
        .description = "Is M68882 (FPU) ISA supported",
        .dependencies = featureSet(&[_]Feature{
            .isa_68881,
        }),
    };
    result[@intFromEnum(Feature.reserve_a0)] = .{
        .llvm_name = "reserve-a0",
        .description = "Reserve A0 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_a1)] = .{
        .llvm_name = "reserve-a1",
        .description = "Reserve A1 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_a2)] = .{
        .llvm_name = "reserve-a2",
        .description = "Reserve A2 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_a3)] = .{
        .llvm_name = "reserve-a3",
        .description = "Reserve A3 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_a4)] = .{
        .llvm_name = "reserve-a4",
        .description = "Reserve A4 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_a5)] = .{
        .llvm_name = "reserve-a5",
        .description = "Reserve A5 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_a6)] = .{
        .llvm_name = "reserve-a6",
        .description = "Reserve A6 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_d0)] = .{
        .llvm_name = "reserve-d0",
        .description = "Reserve D0 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_d1)] = .{
        .llvm_name = "reserve-d1",
        .description = "Reserve D1 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_d2)] = .{
        .llvm_name = "reserve-d2",
        .description = "Reserve D2 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_d3)] = .{
        .llvm_name = "reserve-d3",
        .description = "Reserve D3 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_d4)] = .{
        .llvm_name = "reserve-d4",
        .description = "Reserve D4 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_d5)] = .{
        .llvm_name = "reserve-d5",
        .description = "Reserve D5 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_d6)] = .{
        .llvm_name = "reserve-d6",
        .description = "Reserve D6 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_d7)] = .{
        .llvm_name = "reserve-d7",
        .description = "Reserve D7 register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    const ti = @typeInfo(Feature);
    for (&result, 0..) |*elem, i| {
        elem.index = i;
        elem.name = ti.@"enum".fields[i].name;
    }
    break :blk result;
};

pub const cpu = struct {
    pub const generic: CpuModel = .{
        .name = "generic",
        .llvm_name = "generic",
        .features = featureSet(&[_]Feature{
            .isa_68000,
        }),
    };
    pub const M68000: CpuModel = .{
        .name = "M68000",
        .llvm_name = "M68000",
        .features = featureSet(&[_]Feature{
            .isa_68000,
        }),
    };
    pub const M68010: CpuModel = .{
        .name = "M68010",
        .llvm_name = "M68010",
        .features = featureSet(&[_]Feature{
            .isa_68010,
        }),
    };
    pub const M68020: CpuModel = .{
        .name = "M68020",
        .llvm_name = "M68020",
        .features = featureSet(&[_]Feature{
            .isa_68020,
        }),
    };
    pub const M68030: CpuModel = .{
        .name = "M68030",
        .llvm_name = "M68030",
        .features = featureSet(&[_]Feature{
            .isa_68030,
        }),
    };
    pub const M68040: CpuModel = .{
        .name = "M68040",
        .llvm_name = "M68040",
        .features = featureSet(&[_]Feature{
            .isa_68040,
        }),
    };
    pub const M68060: CpuModel = .{
        .name = "M68060",
        .llvm_name = "M68060",
        .features = featureSet(&[_]Feature{
            .isa_68060,
        }),
    };
};
