/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    String toolTipText;
    long imageHandle;
    long tooltipsHandle;
    ImageList imageList;
    Image highlightImage;

    public TrayItem(Tray parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.parent.createItem(this, index);
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        this.handle = GTK.gtk_status_icon_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        this.imageHandle = GTK.gtk_image_new();
        GTK.gtk_status_icon_set_visible(this.handle, true);
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.imageHandle);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Image getHighlightImage() {
        this.checkWidget();
        return this.highlightImage;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    long gtk_activate(long widget) {
        this.sendSelectionEvent(13);
        long nextEvent = GDK.gdk_event_peek();
        if (nextEvent != 0L) {
            int nextEventType = GDK.GDK_EVENT_TYPE(nextEvent);
            long currEvent = GTK.gtk_get_current_event();
            int currEventType = 0;
            if (currEvent != 0L) {
                currEventType = GDK.GDK_EVENT_TYPE(currEvent);
                this.gdk_event_free(currEvent);
            }
            this.gdk_event_free(nextEvent);
            currEventType = Control.fixGdkEventTypeValues(currEventType);
            nextEventType = Control.fixGdkEventTypeValues(nextEventType);
            if (currEventType == 4 && nextEventType == 5) {
                this.sendSelectionEvent(14);
            }
        }
        return 0L;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        int eventType = GDK.gdk_event_get_event_type(event);
        int[] eventButton = new int[1];
        GDK.gdk_event_get_button(event, eventButton);
        if (eventType == 6) {
            return 0L;
        }
        if (eventButton[0] == 3 && eventType == 4) {
            this.sendEvent(35);
            return 0L;
        }
        if (eventType == 5) {
            this.sendSelectionEvent(14);
        } else {
            this.sendSelectionEvent(13);
        }
        return 0L;
    }

    @Override
    long gtk_gesture_press_event(long gesture, int n_press, double x, double y, long event) {
        switch (n_press) {
            case 1: {
                int eventButton = GDK.gdk_button_event_get_button(event);
                if (eventButton == 3) {
                    this.sendEvent(35);
                    break;
                }
                this.sendEvent(13);
                break;
            }
            case 2: {
                this.sendSelectionEvent(14);
                break;
            }
        }
        return 0L;
    }

    @Override
    long gtk_size_allocate(long widget, long allocation) {
        return 0L;
    }

    @Override
    long gtk_status_icon_popup_menu(long widget, long button, long activate_time) {
        Display display = this.display;
        display.currentTrayItem = this;
        this.sendEvent(35);
        if (!this.isDisposed()) {
            display.runPopups();
        }
        display.currentTrayItem = null;
        return 0L;
    }

    @Override
    void hookEvents() {
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
        OS.g_signal_connect_closure(this.handle, OS.popup_menu, this.display.getClosure(63), false);
    }

    public boolean getVisible() {
        this.checkWidget();
        return GTK.gtk_status_icon_get_visible(this.handle);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.imageHandle, this);
    }

    @Override
    void releaseHandle() {
        if (this.handle != 0L) {
            OS.g_object_unref(this.handle);
        }
        this.imageHandle = 0L;
        this.handle = 0L;
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.tooltipsHandle != 0L) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.toolTipText = null;
        this.highlightImage = null;
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setHighlightImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.highlightImage = image;
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        if (image != null) {
            int imageIndex;
            if (this.imageList == null) {
                this.imageList = new ImageList();
            }
            if ((imageIndex = this.imageList.indexOf(image)) == -1) {
                imageIndex = this.imageList.add(image);
            } else {
                this.imageList.put(imageIndex, image);
            }
            long pixbuf = ImageList.createPixbuf(image);
            GTK.gtk_status_icon_set_from_pixbuf(this.handle, pixbuf);
            GTK.gtk_status_icon_set_visible(this.handle, true);
        } else {
            GTK.gtk_widget_set_size_request(this.handle, 1, 1);
            GTK.gtk_status_icon_set_from_pixbuf(this.handle, 0L);
            GTK.gtk_status_icon_set_visible(this.handle, false);
        }
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip oldTip = this.toolTip;
        ToolTip newTip = toolTip;
        if (oldTip != null) {
            oldTip.item = null;
        }
        this.toolTip = newTip;
        if (newTip != null) {
            newTip.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        byte[] buffer = null;
        if (string != null && string.length() > 0) {
            buffer = Converter.wcsToMbcs(string, true);
        }
        GTK.gtk_status_icon_set_tooltip_text(this.handle, buffer);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (GTK.gtk_status_icon_get_visible(this.handle) == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            GTK.gtk_status_icon_set_visible(this.handle, visible);
        } else {
            GTK.gtk_status_icon_set_visible(this.handle, visible);
            this.sendEvent(23);
        }
    }
}

