# This code is part of Qiskit.
#
# (C) Copyright IBM 2017, 2020.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.

"""The circuit library module on generalized gates."""

from .diagonal import Diagonal, DiagonalGate
from .permutation import Permutation, PermutationGate
from .mcmt import MCMT, MCMTVChain, MCMTGate
from .gms import GMS, MSGate
from .gr import GR, GRX, GRY, GRZ
from .pauli import PauliGate
from .rv import RVGate
from .linear_function import LinearFunction
from .isometry import Isometry
from .uc import UCGate
from .uc_pauli_rot import UCPauliRotGate
from .ucrx import UCRXGate
from .ucry import UCRYGate
from .ucrz import UCRZGate
from .unitary import UnitaryGate
from .mcg_up_to_diagonal import MCGupDiag
