/// \file
// Range v3 library
//
//  Copyright Eric Niebler 2019-present
//
//  Use, modification and distribution is subject to the
//  Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt)
//
// Project home: https://github.com/ericniebler/range-v3
//

#ifndef RANGES_V3_UTILITY_HPP
#define RANGES_V3_UTILITY_HPP

#include <range/v3/utility/any.hpp>
#include <range/v3/utility/box.hpp>
#include <range/v3/utility/common_tuple.hpp>
#include <range/v3/utility/common_type.hpp>
#include <range/v3/utility/compressed_pair.hpp>
#include <range/v3/utility/copy.hpp>
#include <range/v3/utility/get.hpp>
#include <range/v3/utility/in_place.hpp>
#include <range/v3/utility/memory.hpp>
#include <range/v3/utility/move.hpp>
#include <range/v3/utility/optional.hpp>
#include <range/v3/utility/polymorphic_cast.hpp>
#include <range/v3/utility/random.hpp>
#include <range/v3/utility/scope_exit.hpp>
#include <range/v3/utility/semiregular_box.hpp>
#include <range/v3/utility/static_const.hpp>
#include <range/v3/utility/swap.hpp>
#include <range/v3/utility/tuple_algorithm.hpp>
#include <range/v3/utility/variant.hpp>

#endif
