/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.cglib.MetaClass;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.InstantiationException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.PropertyAccessException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.ReflectHelper;

public class ComponentType
extends AbstractType
implements AbstractComponentType {
    private final Class componentClass;
    private final Constructor constructor;
    private final Type[] types;
    private final ReflectHelper.Getter[] getters;
    private final ReflectHelper.Setter[] setters;
    private final String[] propertyNames;
    private final int propertySpan;
    private final Cascades.CascadeStyle[] cascade;
    private final int[] joinedFetch;
    private final ReflectHelper.Setter parentSetter;
    private final MetaClass optimizer;

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        int[] sqlTypes = new int[this.getColumnSpan(mapping)];
        int n = 0;
        int i = 0;
        while (i < this.propertySpan) {
            int[] subtypes = this.types[i].sqlTypes(mapping);
            int j = 0;
            while (j < subtypes.length) {
                sqlTypes[n++] = subtypes[j];
                ++j;
            }
            ++i;
        }
        return sqlTypes;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        int span = 0;
        int i = 0;
        while (i < this.propertySpan) {
            span += this.types[i].getColumnSpan(mapping);
            ++i;
        }
        return span;
    }

    public ComponentType(Class componentClass, String[] properties, Type[] types, int[] joinedFetch, Cascades.CascadeStyle[] cascade, String parentProperty, boolean embedded) throws MappingException {
        this.componentClass = componentClass;
        this.types = types;
        this.propertySpan = properties.length;
        this.getters = new ReflectHelper.Getter[this.propertySpan];
        this.setters = new ReflectHelper.Setter[this.propertySpan];
        String[] getterNames = new String[this.propertySpan];
        String[] setterNames = new String[this.propertySpan];
        Class[] propTypes = new Class[this.propertySpan];
        int i = 0;
        while (i < this.propertySpan) {
            this.getters[i] = ReflectHelper.getGetter(componentClass, properties[i]);
            this.setters[i] = ReflectHelper.getSetter(componentClass, properties[i]);
            getterNames[i] = this.getters[i].getMethod().getName();
            setterNames[i] = this.setters[i].getMethod().getName();
            propTypes[i] = this.getters[i].getMethod().getReturnType();
            ++i;
        }
        this.parentSetter = parentProperty == null ? null : ReflectHelper.getSetter(componentClass, parentProperty);
        this.propertyNames = properties;
        this.cascade = cascade;
        this.joinedFetch = joinedFetch;
        this.constructor = ReflectHelper.getDefaultConstructor(componentClass);
        this.optimizer = Environment.useReflectionOptimizer() ? ReflectHelper.getMetaClass(componentClass, getterNames, setterNames, propTypes) : null;
    }

    public boolean isPersistentCollectionType() {
        return false;
    }

    public final boolean isComponentType() {
        return true;
    }

    public final boolean isEntityType() {
        return false;
    }

    public Class getReturnedClass() {
        return this.componentClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        int i = 0;
        while (i < this.propertySpan) {
            if (!this.types[i].equals(this.getters[i].get(x), this.getters[i].get(y))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isDirty(Object x, Object y, SessionImplementor session) throws HibernateException {
        if (x == y) {
            return false;
        }
        if (x == null || y == null) {
            return true;
        }
        int i = 0;
        while (i < this.getters.length) {
            if (this.types[i].isDirty(this.getters[i].get(x), this.getters[i].get(y), session)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        int begin = 0;
        boolean notNull = false;
        Object[] values = new Object[this.propertySpan];
        int i = 0;
        while (i < this.propertySpan) {
            int length = this.types[i].getColumnSpan(session.getFactory());
            String[] range = ArrayHelper.slice(names, begin, length);
            Object val = this.types[i].nullSafeGet(rs, range, session, owner);
            if (val != null) {
                notNull = true;
            }
            values[i] = val;
            begin += length;
            ++i;
        }
        if (notNull) {
            Object result = this.instantiate(owner, session);
            int i2 = 0;
            while (i2 < this.propertySpan) {
                this.setters[i2].set(result, values[i2]);
                ++i2;
            }
            return result;
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int begin, SessionImplementor session) throws HibernateException, SQLException {
        Object[] subvalues = this.nullSafeGetValues(value);
        int i = 0;
        while (i < this.propertySpan) {
            this.types[i].nullSafeSet(st, subvalues[i], begin, session);
            begin += this.types[i].getColumnSpan(session.getFactory());
            ++i;
        }
    }

    private Object[] nullSafeGetValues(Object value) throws HibernateException {
        if (value == null) {
            return new Object[this.propertySpan];
        }
        return this.getPropertyValues(value);
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public Object getPropertyValue(Object component, int i, SessionImplementor session) throws HibernateException {
        return this.getPropertyValue(component, i);
    }

    public Object getPropertyValue(Object component, int i) throws HibernateException {
        return this.getters[i].get(component);
    }

    public Object[] getPropertyValues(Object component, SessionImplementor session) throws HibernateException {
        return this.getPropertyValues(component);
    }

    public Object[] getPropertyValues(Object component) throws HibernateException {
        if (this.optimizer != null) {
            try {
                return this.optimizer.getPropertyValues(component);
            }
            catch (Throwable t) {
                throw new PropertyAccessException(t, "exception getting property value with CGLIB", false, this.componentClass, "?");
            }
        }
        Object[] values = new Object[this.propertySpan];
        int i = 0;
        while (i < this.propertySpan) {
            values[i] = this.getPropertyValue(component, i);
            ++i;
        }
        return values;
    }

    public void setPropertyValues(Object component, Object[] values) throws HibernateException {
        if (this.optimizer != null) {
            try {
                this.optimizer.setPropertyValues(component, values);
                return;
            }
            catch (Throwable t) {
                throw new PropertyAccessException(t, "exception setting property value with CGLIB", true, this.componentClass, "?");
            }
        }
        int i = 0;
        while (i < this.propertySpan) {
            this.setters[i].set(component, values[i]);
            ++i;
        }
    }

    public Type[] getSubtypes() {
        return this.types;
    }

    public String getName() {
        return this.componentClass.getName();
    }

    public String toXML(Object value, SessionFactoryImplementor factory) {
        return value == null ? null : value.toString();
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Object deepCopy(Object component) throws HibernateException {
        if (component == null) {
            return null;
        }
        Object[] values = this.getPropertyValues(component);
        int i = 0;
        while (i < this.propertySpan) {
            values[i] = this.types[i].deepCopy(values[i]);
            ++i;
        }
        Object result = this.instantiate();
        this.setPropertyValues(result, values);
        return result;
    }

    public Object instantiate() throws HibernateException {
        if (this.optimizer != null) {
            try {
                return this.optimizer.newInstance();
            }
            catch (Throwable t) {
                throw new InstantiationException("Could not instantiate component with CGLIB: ", this.componentClass, t);
            }
        }
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate component: ", this.componentClass, e);
        }
    }

    public Object instantiate(Object parent, SessionImplementor session) throws HibernateException {
        Object result = this.instantiate();
        try {
            if (this.parentSetter != null && parent != null) {
                this.parentSetter.set(result, session.proxyFor(parent));
            }
            return result;
        }
        catch (Exception e) {
            throw new InstantiationException("Could not set component parent for: ", this.componentClass, e);
        }
    }

    public Cascades.CascadeStyle cascade(int i) {
        return this.cascade[i];
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        Object[] values = this.getPropertyValues(value);
        int i = 0;
        while (i < this.types.length) {
            values[i] = this.types[i].disassemble(values[i], session);
            ++i;
        }
        return values;
    }

    public Object assemble(Serializable object, SessionImplementor session, Object owner) throws HibernateException {
        if (object == null) {
            return null;
        }
        Object[] values = (Object[])object;
        Object[] assembled = new Object[values.length];
        int i = 0;
        while (i < this.types.length) {
            assembled[i] = this.types[i].assemble((Serializable)values[i], session, owner);
            ++i;
        }
        Object result = this.instantiate();
        this.setPropertyValues(result, assembled);
        return result;
    }

    public boolean hasNiceEquals() {
        return false;
    }

    public int enableJoinedFetch(int i) {
        return this.joinedFetch[i];
    }
}

