// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _ --version 3
// REQUIRES: amdgpu-registered-target

// Tests if -fno-openmp-allow-kernel-io suppresses print.
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa  -fno-openmp-allow-kernel-io -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fno-openmp-allow-kernel-io -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck -check-prefix=CHECK-NOPE %s

// Tests if -fopenmp-allow-kernel-io produces print.
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa  -fopenmp-allow-kernel-io -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-allow-kernel-io -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck -check-prefix=CHECK %s

// Tests if -fopenmp-target-fast -fopenmp-allow-kernel-io produces print.
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa  -fopenmp-target-fast -fopenmp-allow-kernel-io -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-target-fast -fopenmp-allow-kernel-io -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck -check-prefix=CHECK %s

// Tests if -fopenmp-target-fast -fno-openmp-allow-kernel-io suppresses print.
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa  -fopenmp-target-fast -fno-openmp-allow-kernel-io -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-target-fast -fno-openmp-allow-kernel-io -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck -check-prefix=CHECK-NOPE %s


extern "C" int printf(const char *format, ...);

int main(void) {

#pragma omp target
  {
    printf("howdy GPU\n");
  }

  return 0;
}

// CHECK: target triple = "amdgcn-amd-amdhsa"
// CHECK:  entry:
// CHECK:  call ptr @printf_allocate

// CHECK-NOPE: target triple = "amdgcn-amd-amdhsa"
// CHECK-NOPE:  entry:
// CHECK-NOPE:  call i32 @__llvm_omp_vprintf
