from __future__ import absolute_import
from __future__ import division

import argparse
import sys

from pwn import *
from pwnlib.commandline import common

parser = common.parser_commands.add_parser(
    'checksec',
    help = 'Check binary security settings',
    description = 'Check binary security settings',
)
parser.add_argument(
    'elf',
    nargs='*',
    type=argparse.FileType('rb'),
    help='Files to check'
)
parser.add_argument(
    '--file',
    nargs='*',
    dest='elf2',
    metavar='elf',
    type=argparse.FileType('rb'),
    help='File to check (for compatibility with checksec.sh)'
)

def main(args):
    files  = args.elf or args.elf2 or []

    if not files:
        parser.print_usage()
        return

    for f in files:
        try:
            e = ELF(f.name)
        except Exception as e:
            print("{name}: {error}".format(name=f.name, error=e))

if __name__ == '__main__':
    common.main(__file__, main)
