/*
 * Decompiled with CFR 0.152.
 */
package org.cts.registry;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.cts.registry.AbstractProjRegistry;
import org.cts.registry.Registry;
import org.cts.registry.RegistryException;

public class EPSGRegistry
extends AbstractProjRegistry
implements Registry {
    static final Pattern EPSG_REGEX = Pattern.compile("\\s+|<>");

    @Override
    public String getRegistryName() {
        return "epsg";
    }

    @Override
    public Map<String, String> getParameters(String code) throws RegistryException {
        try {
            return this.projParser.readParameters(code, EPSG_REGEX);
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the EPSG registry", ex);
        }
    }

    @Override
    public Set<String> getSupportedCodes() throws RegistryException {
        try {
            return this.projParser.getSupportedCodes(EPSG_REGEX);
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the EPSG registry", ex);
        }
    }
}

