/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.ui.IEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLParserContext;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.sql.semantics.OffsetKeyedTreeMap;
import org.jkiss.dbeaver.model.sql.semantics.SQLCommandModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentScriptItemSyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentSyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionProblemInfo;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLScriptItemAtOffset;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModel;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.utils.ListNode;

public class SQLBackgroundParsingJob {
    private static final Log log = Log.getLog(SQLBackgroundParsingJob.class);
    private static final boolean DEBUG = false;
    private static final long schedulingTimeoutMilliseconds = 500L;
    @NotNull
    private final OffsetKeyedTreeMap<QueuedRegionInfo> queuedForReparse = new OffsetKeyedTreeMap();
    @NotNull
    private final Object syncRoot = new Object();
    @NotNull
    private final SQLEditorBase editor;
    @NotNull
    private final SQLDocumentSyntaxContext context = new SQLDocumentSyntaxContext();
    @Nullable
    private IDocument document = null;
    @NotNull
    private final AbstractJob job = new AbstractJob("Background parsing job"){

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                SQLBackgroundParsingJob.this.doWork(monitor);
                return Status.OK_STATUS;
            }
            catch (BadLocationException e) {
                log.debug((Object)e);
                return Status.CANCEL_STATUS;
            }
        }
    };
    private volatile CompletableFuture<Long> lastParsingFinishStamp = new CompletableFuture<Long>(){
        {
            this.complete(0L);
        }
    };
    private volatile boolean isRunning = false;
    private volatile int knownRegionStart = 0;
    private volatile int knownRegionEnd = 0;
    @NotNull
    private final DocumentLifecycleListener documentListener = new DocumentLifecycleListener();

    public SQLBackgroundParsingJob(@NotNull SQLEditorBase editor) {
        this.editor = editor;
    }

    @NotNull
    public SQLDocumentSyntaxContext getCurrentContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.editor.getTextViewer() != null) {
                IDocument document;
                this.editor.getTextViewer().addTextInputListener((ITextInputListener)this.documentListener);
                this.editor.getTextViewer().addViewportListener((IViewportListener)this.documentListener);
                if (this.document == null && (document = this.editor.getTextViewer().getDocument()) != null) {
                    this.document = document;
                    this.document.addDocumentListener((IDocumentListener)this.documentListener);
                }
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.cancel();
            TextViewer textViewer = this.editor.getTextViewer();
            if (textViewer != null) {
                textViewer.removeViewportListener((IViewportListener)this.documentListener);
                textViewer.removeTextInputListener((ITextInputListener)this.documentListener);
                if (this.document != null) {
                    this.document.removeDocumentListener((IDocumentListener)this.documentListener);
                }
            }
        }
    }

    private static <T> T getFutureOrCancel(Future<T> future, IProgressMonitor monitor) throws ExecutionException, InterruptedException {
        while (!monitor.isCanceled()) {
            try {
                return future.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {}
        }
        throw new CancellationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SQLQueryCompletionContext obtainCompletionContext(DBRProgressMonitor monitor, @NotNull Position completionRequestPosition) {
        SQLScriptItemAtOffset scriptItem = null;
        do {
            CompletableFuture<Long> expectedParsingSessionFinishStamp;
            long requestStamp = System.currentTimeMillis();
            Object object = this.syncRoot;
            synchronized (object) {
                if (scriptItem == null || this.queuedForReparse.size() == 0) {
                    boolean positionIsQueued;
                    int requestOffset = completionRequestPosition.getOffset();
                    OffsetKeyedTreeMap.NodesIterator qit = this.queuedForReparse.nodesIteratorAt(requestOffset);
                    QueuedRegionInfo region = qit.getCurrValue() != null ? (QueuedRegionInfo)qit.getCurrValue() : (qit.prev() ? (QueuedRegionInfo)qit.getCurrValue() : null);
                    boolean bl = positionIsQueued = region != null && (qit.getCurrOffset() + region.length >= requestOffset || region.length == Integer.MAX_VALUE);
                    if (!positionIsQueued) {
                        scriptItem = this.context.findScriptItem(requestOffset - 1);
                        if (scriptItem != null) {
                            if (!scriptItem.item.isDirty()) {
                                DBCExecutionContext executionContext = this.editor.getExecutionContext();
                                SQLDialect dialect = this.obtainCurrentSqlDialect(executionContext);
                                return SQLQueryCompletionContext.prepareCompletionContext((SQLScriptItemAtOffset)scriptItem, (int)completionRequestPosition.getOffset(), (DBCExecutionContext)executionContext, (SQLDialect)dialect);
                            }
                        } else if (this.queuedForReparse.size() <= 0) {
                            return SQLQueryCompletionContext.prepareOffquery((int)0, (int)completionRequestPosition.getOffset());
                        }
                    }
                }
                expectedParsingSessionFinishStamp = this.lastParsingFinishStamp;
            }
            try {
                if (SQLBackgroundParsingJob.getFutureOrCancel(expectedParsingSessionFinishStamp, monitor.getNestedMonitor()) < requestStamp) {
                    return SQLQueryCompletionContext.prepareEmpty((int)0, (int)completionRequestPosition.getOffset());
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                break;
            }
        } while (!completionRequestPosition.isDeleted());
        return SQLQueryCompletionContext.prepareEmpty((int)0, (int)completionRequestPosition.getOffset());
    }

    @NotNull
    private SQLDocumentSyntaxContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeDocumentModification(DocumentEvent event) {
        this.cancel();
        int insertedLength = event.getText() == null ? 0 : event.getText().length();
        IRegion regionToReparse = this.context.applyDelta(event.getOffset(), event.getLength(), insertedLength);
        int reparseStart = regionToReparse.getOffset();
        int reparseLength = 0;
        reparseLength = regionToReparse.getLength() < Integer.MAX_VALUE ? regionToReparse.getLength() : (event.getOffset() + insertedLength > this.editor.getTextViewer().getBottomIndexEndOffset() ? event.getOffset() + insertedLength : this.editor.getTextViewer().getBottomIndexEndOffset() - reparseStart);
        Object object = this.syncRoot;
        synchronized (object) {
            int delta = insertedLength - event.getLength();
            if (delta > 0) {
                this.queuedForReparse.applyOffset(event.getOffset(), delta);
                this.enqueueToReparse(reparseStart, reparseLength);
            } else {
                ListNode keyOffsetsToRemove = null;
                OffsetKeyedTreeMap.NodesIterator it = this.queuedForReparse.nodesIteratorAt(reparseStart);
                if (it.getCurrValue() != null || it.prev()) {
                    int firstAffectedReparseOffset = it.getCurrOffset();
                    if (firstAffectedReparseOffset < reparseStart && firstAffectedReparseOffset + ((QueuedRegionInfo)it.getCurrValue()).length > reparseStart + insertedLength) {
                        return;
                    }
                    keyOffsetsToRemove = ListNode.push(keyOffsetsToRemove, (Object)firstAffectedReparseOffset);
                }
                while (it.next()) {
                    keyOffsetsToRemove = ListNode.push(keyOffsetsToRemove, (Object)it.getCurrOffset());
                }
                ListNode kn = keyOffsetsToRemove;
                while (kn != null) {
                    this.queuedForReparse.removeAt(((Integer)kn.data).intValue());
                    kn = kn.next;
                }
                this.enqueueToReparse(reparseStart, Integer.MAX_VALUE);
            }
            this.resetLastParsingFinishTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueToReparse(int toParseStart, int toParseLength) {
        Object object = this.syncRoot;
        synchronized (object) {
            OffsetKeyedTreeMap.NodesIterator it = this.queuedForReparse.nodesIteratorAt(toParseStart);
            QueuedRegionInfo region = (QueuedRegionInfo)it.getCurrValue();
            int regionOffset = it.getCurrOffset();
            if (region == null && it.prev()) {
                region = (QueuedRegionInfo)it.getCurrValue();
                regionOffset = it.getCurrOffset();
            }
            if (region != null && regionOffset <= toParseStart && regionOffset + region.length > toParseStart) {
                region.length = Math.max(region.length, toParseStart + toParseLength - regionOffset);
            } else {
                this.queuedForReparse.put(toParseStart, (Object)new QueuedRegionInfo(toParseLength));
                this.resetLastParsingFinishTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLastParsingFinishTime() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.lastParsingFinishStamp.isDone()) {
                this.lastParsingFinishStamp = new CompletableFuture();
            }
        }
    }

    private void ensureVisibleRangeIsParsed() {
        int endOffset;
        TextViewer viewer = this.editor.getTextViewer();
        if (viewer == null || viewer.getDocument() == null) {
            return;
        }
        Interval knownRange = new Interval(this.knownRegionStart, this.knownRegionEnd);
        int startOffset = viewer.getTopIndexStartOffset();
        Interval visibleRange = new Interval(startOffset, endOffset = viewer.getBottomIndexEndOffset());
        if (!knownRange.properlyContains(visibleRange)) {
            Interval unknownRange = visibleRange.differenceNotProperlyContained(knownRange);
            if (unknownRange == null) {
                unknownRange = visibleRange;
            }
            this.enqueueToReparse(unknownRange.a, unknownRange.length());
            this.schedule(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(@Nullable DocumentEvent event) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.editor.getRuleManager() == null || !this.editor.isAdvancedHighlightingEnabled() || !SQLEditorUtils.isSQLSyntaxParserApplied(this.editor.getEditorInput())) {
                return;
            }
            if (this.job.getState() != 4) {
                this.job.cancel();
            }
            long delay = event != null && ".".equals(event.getText()) ? (this.isRunning ? 250L : 0L) : 500L * (long)(this.isRunning ? 2 : 1);
            this.job.schedule(delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.job.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDocument(@Nullable IDocument newDocument) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.document != null) {
                this.cancel();
            }
            if (newDocument != null && SQLEditorUtils.isSQLSyntaxParserApplied(this.editor.getEditorInput())) {
                this.document = newDocument;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.context.clear();
            this.queuedForReparse.clear();
            this.knownRegionEnd = 0;
            this.knownRegionStart = 0;
            this.ensureVisibleRangeIsParsed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork(DBRProgressMonitor monitor) throws BadLocationException {
        SQLScriptElement lastElement;
        List elements;
        int workLength;
        int workOffset;
        TextViewer viewer;
        block33: {
            SQLScriptElement followingElement;
            SQLParserContext parserContext;
            block32: {
                block31: {
                    viewer = this.editor.getTextViewer();
                    if (viewer == null || this.editor.getRuleManager() == null) {
                        this.signalAccomplished();
                        return;
                    }
                    Interval actualFragment = (Interval)UIUtils.syncExec((RunnableWithResult)new RunnableWithResult<Interval>(){

                        public Interval runWithResult() {
                            if (viewer.getDocument() == null) {
                                return null;
                            }
                            IDocument doc = viewer.getDocument();
                            int stepsToKeep = 2;
                            int startOffset = viewer.getTopIndexStartOffset();
                            int firstVisibleLine = 0;
                            try {
                                firstVisibleLine = doc.getLineOfOffset(startOffset);
                                int visibleLinesCount = viewer.getTextWidget().getSize().y / viewer.getTextWidget().getLineHeight();
                                int rangeStart = doc.getLineOffset(Math.max(0, firstVisibleLine - visibleLinesCount * stepsToKeep));
                                int rangeEnd = doc.getLineOffset(Math.min(doc.getNumberOfLines(), firstVisibleLine + visibleLinesCount * (stepsToKeep + 1)));
                                return new Interval(rangeStart, rangeEnd);
                            }
                            catch (BadLocationException badLocationException) {
                                int endOffset = viewer.getBottomIndexEndOffset();
                                return new Interval(startOffset, endOffset);
                            }
                        }
                    });
                    if (actualFragment == null) {
                        this.signalAccomplished();
                        return;
                    }
                    try {
                        Object object = this.syncRoot;
                        synchronized (object) {
                            int docTailDelta;
                            this.isRunning = true;
                            Interval preservedRegion = this.context.dropInvisibleScriptItems(actualFragment);
                            this.knownRegionStart = preservedRegion.a;
                            this.knownRegionEnd = preservedRegion.b;
                            OffsetKeyedTreeMap.NodesIterator it = this.queuedForReparse.nodesIteratorAt(0);
                            workOffset = it.getCurrValue() != null || it.next() ? it.getCurrOffset() : 0;
                            it = this.queuedForReparse.nodesIteratorAt(Integer.MAX_VALUE);
                            workLength = it.getCurrValue() != null || it.prev() ? it.getCurrOffset() + ((QueuedRegionInfo)it.getCurrValue()).length - workOffset : 0;
                            Interval workInterval = new Interval(workOffset, SQLBackgroundParsingJob.saturatedSum(workOffset, workLength));
                            if (!actualFragment.properlyContains(workInterval)) {
                                workInterval = actualFragment.intersection(workInterval);
                                workOffset = workInterval.a;
                                workLength = workInterval.length();
                            }
                            if ((docTailDelta = this.document.getLength() - SQLBackgroundParsingJob.saturatedSum(workOffset, workLength)) < 0) {
                                workLength += docTailDelta;
                            }
                            this.queuedForReparse.clear();
                        }
                    }
                    catch (Throwable ex) {
                        log.error((Object)ex);
                        this.signalAccomplished();
                        return;
                    }
                    if (workLength != 0) break block31;
                    this.signalAccomplished();
                    monitor.done();
                    return;
                }
                parserContext = new SQLParserContext(this.editor.getDataSource(), this.editor.getSyntaxManager(), this.editor.getRuleManager(), this.document);
                SQLScriptElement firstElement = SQLScriptParser.extractQueryAtPos((SQLParserContext)parserContext, (int)workOffset, (boolean)false);
                if (firstElement != null) {
                    workLength = Math.max(workOffset + workLength, firstElement.getOffset() + firstElement.getLength());
                    workOffset = Math.min(workOffset, firstElement.getOffset());
                    workLength -= workOffset;
                }
                if (!(elements = SQLScriptParser.extractScriptQueries((SQLParserContext)parserContext, (int)workOffset, (int)workLength, (boolean)false, (boolean)false, (boolean)false)).isEmpty()) break block32;
                this.accomplishWork(workOffset, workLength);
                monitor.done();
                return;
            }
            SQLScriptElement element = SQLScriptParser.extractQueryAtPos((SQLParserContext)parserContext, (int)((SQLScriptElement)elements.get(0)).getOffset(), (boolean)false);
            if (element != null && element.getOffset() < ((SQLScriptElement)elements.get(0)).getOffset()) {
                elements.set(0, element);
            }
            int lastElementIndex = elements.size() - 1;
            SQLScriptElement lastElement2 = (SQLScriptElement)elements.get(lastElementIndex);
            if (elements.size() > 1 && (element = SQLScriptParser.extractQueryAtPos((SQLParserContext)parserContext, (int)lastElement2.getOffset(), (boolean)false)) != null) {
                elements.set(lastElementIndex, element);
                lastElement2 = element;
            }
            if ((followingElement = SQLScriptParser.extractNextQuery((SQLParserContext)parserContext, (SQLScriptElement)lastElement2, (boolean)true)) != null && followingElement.getOffset() < workOffset + workLength && followingElement.getOffset() > lastElement2.getOffset() + lastElement2.getLength()) {
                elements.add(followingElement);
            }
            if ((lastElement = (SQLScriptElement)elements.get(elements.size() - 1)) != null) break block33;
            this.accomplishWork(workOffset, workLength);
            monitor.done();
            return;
        }
        try {
            try {
                workOffset = ((SQLScriptElement)elements.get(0)).getOffset();
                workLength = lastElement.getOffset() + lastElement.getLength() - workOffset;
                boolean useRealMetadata = this.isReadMetadataEnabled();
                boolean validateFunctions = this.isValidateFunctionsEnabled();
                DBCExecutionContext executionContext = this.editor.getExecutionContext();
                monitor.beginTask("Background query analysis for " + this.editor.getTitle(), 1 + elements.size());
                monitor.worked(1);
                SQLSyntaxManager syntaxManager = this.editor.getSyntaxManager();
                SQLDialect dialect = this.obtainCurrentSqlDialect(executionContext);
                SQLQueryRecognitionContext recognitionContext = new SQLQueryRecognitionContext(monitor, executionContext, useRealMetadata, validateFunctions, syntaxManager, dialect);
                int i = 1;
                for (SQLScriptElement element : elements) {
                    if (monitor.isCanceled()) break;
                    try {
                        SQLQueryModel queryModel;
                        recognitionContext.reset();
                        if (element instanceof SQLControlCommand) {
                            SQLScriptContext sQLScriptContext;
                            String string = element.getText();
                            SQLEditorBase sQLEditorBase = this.editor;
                            if (sQLEditorBase instanceof SQLEditor) {
                                SQLEditor e = (SQLEditor)sQLEditorBase;
                                sQLScriptContext = e.getGlobalScriptContext();
                            } else {
                                sQLScriptContext = null;
                            }
                            v3 = SQLCommandModelRecognizer.recognizeCommand((SQLQueryRecognitionContext)recognitionContext, (String)string, sQLScriptContext);
                        } else {
                            v3 = queryModel = SQLQueryModelRecognizer.recognizeQuery((SQLQueryRecognitionContext)recognitionContext, (String)element.getOriginalText());
                        }
                        if (queryModel != null) {
                            SQLQuery queryElement;
                            SQLDocumentScriptItemSyntaxContext itemContext = this.context.registerScriptItemContext(element.getOriginalText(), queryModel, element.getOffset(), element.getLength(), element instanceof SQLQuery && Boolean.TRUE.equals((queryElement = (SQLQuery)element).isEndsWithDelimiter()));
                            itemContext.clear();
                            List problems = recognitionContext.getProblems();
                            if (problems.size() >= 50 && queryModel.getQueryModel() != null) {
                                problems.add(new SQLQueryRecognitionProblemInfo(SQLQueryRecognitionProblemInfo.Severity.WARNING, queryModel.getSyntaxNode(), null, "Too many errors found in one query of " + this.editor.getTitle() + "! Displaying first 50 of them.", null));
                            }
                            itemContext.setProblems(problems);
                            for (SQLQuerySymbolEntry entry : queryModel.getAllSymbols()) {
                                itemContext.registerToken(entry.getInterval().a, entry);
                            }
                            itemContext.refreshCompleted();
                        }
                    }
                    catch (Throwable ex) {
                        log.debug((Object)("Error while analyzing query text: " + element.getOriginalText()), ex);
                    }
                    monitor.worked(1);
                    monitor.subTask("Background query analysis: subtask #" + i + " of " + elements.size());
                    ++i;
                }
                this.context.resetLastAccessCache();
            }
            catch (Throwable ex) {
                log.debug((Object)ex);
                monitor.done();
            }
        }
        catch (Throwable throwable) {
            monitor.done();
            throw throwable;
        }
        monitor.done();
        int parsedOffset = workOffset;
        int parsedLength = workLength;
        this.accomplishWork(parsedOffset, parsedLength);
        UIUtils.asyncExec(() -> viewer.invalidateTextPresentation(parsedOffset, parsedLength));
    }

    @NotNull
    private SQLDialect obtainCurrentSqlDialect(@Nullable DBCExecutionContext executionContext) {
        try {
            DBPDataSourceContainer dsContainer = EditorUtils.getInputDataSource((IEditorInput)this.editor.getEditorInput());
            BasicSQLDialect dialect = executionContext != null && executionContext.getDataSource() != null ? executionContext.getDataSource().getSQLDialect() : (dsContainer != null ? dsContainer.getScriptDialect().createInstance() : BasicSQLDialect.INSTANCE);
            return dialect;
        }
        catch (DBException dBException) {
            return BasicSQLDialect.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalAccomplished() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.lastParsingFinishStamp.complete(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accomplishWork(int parsedOffset, int parsedLength) {
        Object object = this.syncRoot;
        synchronized (object) {
            this.knownRegionStart = Math.min(this.knownRegionStart, parsedOffset);
            this.knownRegionEnd = Math.max(this.knownRegionEnd, parsedOffset + parsedLength);
            this.isRunning = false;
            this.signalAccomplished();
        }
    }

    private static int saturatedSum(int a, int b) {
        int r = a + b;
        if (r < a || r < b) {
            return Integer.MAX_VALUE;
        }
        return r;
    }

    private boolean isReadMetadataEnabled() {
        DBPPreferenceStore prefStore = this.editor.getActivePreferenceStore();
        return prefStore.getBoolean("SQLEditor.Semantics.metadata.read.enable") && !prefStore.getBoolean("database.meta.disableAdditionalRead");
    }

    private boolean isValidateFunctionsEnabled() {
        DBPPreferenceStore prefStore = this.editor.getActivePreferenceStore();
        return prefStore.getBoolean("SQLEditor.Semantics.validate.functions.enable") && this.isReadMetadataEnabled();
    }

    private class DocumentLifecycleListener
    implements IDocumentListener,
    ITextInputListener,
    IViewportListener {
        private DocumentLifecycleListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            SQLBackgroundParsingJob.this.beforeDocumentModification(event);
        }

        public void documentChanged(DocumentEvent event) {
            SQLBackgroundParsingJob.this.schedule(event);
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null) {
                SQLBackgroundParsingJob.this.cancel();
                oldInput.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput != null) {
                newInput.addDocumentListener((IDocumentListener)this);
                SQLBackgroundParsingJob.this.setDocument(newInput);
            }
        }

        public void viewportChanged(int verticalOffset) {
            SQLBackgroundParsingJob.this.ensureVisibleRangeIsParsed();
        }
    }

    private static class QueuedRegionInfo {
        public int length;

        public QueuedRegionInfo(int length) {
            this.length = length;
        }
    }
}

