/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableAlterActionKind;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableConstraintSpec;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryTableAlterActionSpec
extends SQLQueryNodeModel {
    @NotNull
    private final SQLQueryTableAlterActionKind actionKind;
    @Nullable
    private final SQLQueryColumnSpec columnSpec;
    @Nullable
    private final SQLQuerySymbolEntry columnName;
    @Nullable
    private final SQLQueryTableConstraintSpec tableConstraintSpec;
    @Nullable
    private final SQLQueryComplexName tableConstraintName;

    protected SQLQueryTableAlterActionSpec(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryTableAlterActionKind actionKind, @Nullable SQLQueryColumnSpec columnSpec, @Nullable SQLQuerySymbolEntry columnName, @Nullable SQLQueryTableConstraintSpec tableConstraintSpec, @Nullable SQLQueryComplexName tableConstraintName) {
        super(syntaxNode.getRealInterval(), syntaxNode, columnSpec, tableConstraintSpec);
        this.actionKind = actionKind;
        this.columnSpec = columnSpec;
        this.columnName = columnName;
        this.tableConstraintSpec = tableConstraintSpec;
        this.tableConstraintName = tableConstraintName;
    }

    @NotNull
    public SQLQueryTableAlterActionKind getActionKind() {
        return this.actionKind;
    }

    @Nullable
    public SQLQueryColumnSpec getColumnSpec() {
        return this.columnSpec;
    }

    @Nullable
    public SQLQueryTableConstraintSpec getTableConstraintSpec() {
        return this.tableConstraintSpec;
    }

    public void resolveRelations(@NotNull SQLQueryRowsSourceContext dataContext, @Nullable SQLQueryRowsDataContext tableContext, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQuerySymbolEntry columnRef;
        SQLQuerySymbolOrigin.ColumnNameFromRowsData columnRefOrigin;
        SQLQuerySymbolOrigin.ColumnNameFromRowsData columnNameFromRowsData = columnRefOrigin = tableContext == null ? null : new SQLQuerySymbolOrigin.ColumnNameFromRowsData(tableContext);
        if (this.columnSpec != null && (columnRef = this.columnSpec.getColumnName()) != null) {
            SQLQuerySymbol columnName = columnRef.getSymbol();
            if (columnRef.isNotClassified()) {
                if (tableContext != null) {
                    SQLQueryResultColumn rc = tableContext.resolveColumn(statistics.getMonitor(), columnName.getName());
                    SQLQuerySemanticUtils.propagateColumnDefinition(columnRef, rc, statistics, columnRefOrigin);
                } else {
                    columnName.setDefinition(columnRef);
                    columnName.setSymbolClass(SQLQuerySymbolClass.COLUMN);
                    columnRef.setOrigin(columnRefOrigin);
                }
            }
            this.columnSpec.resolveRelations(dataContext, tableContext, statistics);
        }
        if (this.columnName != null && this.columnName.isNotClassified()) {
            if (tableContext != null) {
                SQLQueryResultColumn rc = tableContext.resolveColumn(statistics.getMonitor(), this.columnName.getName());
                if (rc != null) {
                    SQLQuerySemanticUtils.propagateColumnDefinition(this.columnName, rc, statistics, columnRefOrigin);
                } else {
                    this.columnName.getSymbol().setSymbolClass(SQLQuerySymbolClass.COLUMN);
                    this.columnName.setOrigin(columnRefOrigin);
                    statistics.appendWarning(this.columnName, "Column " + this.columnName.getName() + " not found");
                }
            } else {
                this.columnName.getSymbol().setSymbolClass(SQLQuerySymbolClass.COLUMN);
            }
        }
        if (this.tableConstraintSpec != null) {
            this.tableConstraintSpec.resolveRelations(dataContext, tableContext, statistics);
        }
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, T arg) {
        return visitor.visitAlterTableAction(this, arg);
    }
}

