/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.driver.libsql;

import com.dbeaver.jdbc.driver.libsql.LibSqlDatabaseMetaData;
import com.dbeaver.jdbc.driver.libsql.LibSqlDriver;
import com.dbeaver.jdbc.driver.libsql.LibSqlPreparedStatement;
import com.dbeaver.jdbc.driver.libsql.LibSqlStatement;
import com.dbeaver.jdbc.driver.libsql.LibSqlUtils;
import com.dbeaver.jdbc.driver.libsql.client.LibSqlClient;
import com.dbeaver.jdbc.model.AbstractJdbcConnection;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;

public class LibSqlConnection
extends AbstractJdbcConnection {
    @NotNull
    private final LibSqlDriver driver;
    @NotNull
    private final LibSqlClient client;
    @NotNull
    private final String url;
    @NotNull
    private final Map<String, Object> driverProperties;
    private LibSqlDatabaseMetaData databaseMetaData;

    public LibSqlConnection(@NotNull LibSqlDriver driver, @NotNull String url, @NotNull Map<String, Object> driverProperties) throws SQLException {
        this.driver = driver;
        this.url = url;
        this.driverProperties = driverProperties;
        try {
            String token = CommonUtils.toString((Object)driverProperties.get("password"), null);
            this.client = new LibSqlClient(new URL(url), token);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        try {
            LibSqlUtils.executeQuery((Connection)((Object)this), "SELECT 1");
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public LibSqlClient getClient() {
        String applicationName = this.getClientApplicationName();
        if (!CommonUtils.isEmpty((String)applicationName)) {
            this.client.setUserAgent(applicationName);
        }
        return this.client;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public Map<String, Object> getDriverProperties() {
        return this.driverProperties;
    }

    @NotNull
    public LibSqlDriver getDriver() {
        return this.driver;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LibSqlStatement(this);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatementImpl(sql);
    }

    @NotNull
    private LibSqlPreparedStatement prepareStatementImpl(String sql) throws SQLException {
        return new LibSqlPreparedStatement(this, sql);
    }

    public void close() throws SQLException {
        this.client.close();
    }

    public boolean isClosed() {
        return false;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new LibSqlDatabaseMetaData(this);
        }
        return this.databaseMetaData;
    }
}

