/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleHandleProvider;
import org.eclipse.gef.Handle;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;

public abstract class SelectionHandlesEditPolicy
extends SelectionEditPolicy
implements IAdaptable {
    protected List<? extends Handle> handles;

    protected void addSelectionHandles() {
        this.removeSelectionHandles();
        IFigure layer = this.getLayer("Handle Layer");
        this.handles = this.createSelectionHandles();
        this.getHandleFigures().forEach(arg_0 -> ((IFigure)layer).add(arg_0));
    }

    protected abstract List<? extends Handle> createSelectionHandles();

    public <T> T getAdapter(Class<T> key) {
        if (key == AccessibleHandleProvider.class) {
            return key.cast(() -> {
                ArrayList<Point> result = new ArrayList<Point>();
                if (this.handles != null) {
                    for (Handle handle : this.handles) {
                        Point p = handle.getAccessibleLocation();
                        if (p == null) continue;
                        result.add(p);
                    }
                }
                return result;
            });
        }
        return null;
    }

    private Stream<IFigure> getHandleFigures() {
        return this.handles != null ? this.handles.stream().filter(IFigure.class::isInstance).map(IFigure.class::cast) : Stream.empty();
    }

    @Override
    protected void hideSelection() {
        this.removeSelectionHandles();
    }

    protected void removeSelectionHandles() {
        if (this.handles == null) {
            return;
        }
        IFigure layer = this.getLayer("Handle Layer");
        this.getHandleFigures().forEach(arg_0 -> ((IFigure)layer).remove(arg_0));
        this.handles = null;
    }

    @Override
    protected void showSelection() {
        this.addSelectionHandles();
    }
}

