/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ClassPathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassPathUtilsTest
extends AbstractLangTest {
    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new ClassPathUtils());
        Constructor<?>[] cons = ClassPathUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(ClassPathUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(ClassPathUtils.class.getModifiers()));
    }

    @Test
    public void testPackageToPath() {
        Assertions.assertEquals((Object)"a", (Object)ClassPathUtils.packageToPath((String)"a"));
        Assertions.assertEquals((Object)"a/b", (Object)ClassPathUtils.packageToPath((String)"a.b"));
        Assertions.assertEquals((Object)"a/b/c", (Object)ClassPathUtils.packageToPath((String)"a.b.c"));
    }

    @Test
    public void testPathToPackage() {
        Assertions.assertEquals((Object)"a", (Object)ClassPathUtils.pathToPackage((String)"a"));
        Assertions.assertEquals((Object)"a.b", (Object)ClassPathUtils.pathToPackage((String)"a/b"));
        Assertions.assertEquals((Object)"a.b.c", (Object)ClassPathUtils.pathToPackage((String)"a/b/c"));
    }

    @Test
    public void testToFullyQualifiedNameClassNull() {
        Assertions.assertThrows(NullPointerException.class, () -> ClassPathUtils.toFullyQualifiedName(ClassPathUtils.class, null));
    }

    @Test
    public void testToFullyQualifiedNameClassString() {
        String expected = "org.apache.commons.lang3.Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedName(ClassPathUtils.class, (String)"Test.properties");
        Assertions.assertEquals((Object)"org.apache.commons.lang3.Test.properties", (Object)actual);
    }

    @Test
    public void testToFullyQualifiedNameNullClassString() {
        Assertions.assertThrows(NullPointerException.class, () -> ClassPathUtils.toFullyQualifiedName((Class)null, (String)"Test.properties"));
    }

    @Test
    public void testToFullyQualifiedNameNullPackageString() {
        Assertions.assertThrows(NullPointerException.class, () -> ClassPathUtils.toFullyQualifiedName((Package)null, (String)"Test.properties"));
    }

    @Test
    public void testToFullyQualifiedNamePackageNull() {
        Assertions.assertThrows(NullPointerException.class, () -> ClassPathUtils.toFullyQualifiedName((Package)ClassPathUtils.class.getPackage(), null));
    }

    @Test
    public void testToFullyQualifiedNamePackageString() {
        String expected = "org.apache.commons.lang3.Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedName((Package)ClassPathUtils.class.getPackage(), (String)"Test.properties");
        Assertions.assertEquals((Object)"org.apache.commons.lang3.Test.properties", (Object)actual);
    }

    @Test
    public void testToFullyQualifiedPathClass() {
        String expected = "org/apache/commons/lang3/Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedPath(ClassPathUtils.class, (String)"Test.properties");
        Assertions.assertEquals((Object)"org/apache/commons/lang3/Test.properties", (Object)actual);
    }

    @Test
    public void testToFullyQualifiedPathClassNull() {
        Assertions.assertThrows(NullPointerException.class, () -> ClassPathUtils.toFullyQualifiedPath(ClassPathUtils.class, null));
    }

    @Test
    public void testToFullyQualifiedPathClassNullString() {
        Assertions.assertThrows(NullPointerException.class, () -> ClassPathUtils.toFullyQualifiedPath((Class)null, (String)"Test.properties"));
    }

    @Test
    public void testToFullyQualifiedPathPackage() {
        String expected = "org/apache/commons/lang3/Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedPath((Package)ClassPathUtils.class.getPackage(), (String)"Test.properties");
        Assertions.assertEquals((Object)"org/apache/commons/lang3/Test.properties", (Object)actual);
    }

    @Test
    public void testToFullyQualifiedPathPackageNull() {
        Assertions.assertThrows(NullPointerException.class, () -> ClassPathUtils.toFullyQualifiedPath((Package)ClassPathUtils.class.getPackage(), null));
    }

    @Test
    public void testToFullyQualifiedPathPackageNullString() {
        Assertions.assertThrows(NullPointerException.class, () -> ClassPathUtils.toFullyQualifiedPath((Package)null, (String)"Test.properties"));
    }
}

