/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.concurrent.CallableBackgroundInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CallableBackgroundInitializerTest
extends AbstractLangTest {
    private static final Integer RESULT = 42;

    @Test
    public void testInitExecutor() throws InterruptedException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        CallableBackgroundInitializer init = new CallableBackgroundInitializer((Callable)new TestCallable(), exec);
        Assertions.assertEquals((Object)exec, (Object)init.getExternalExecutor(), (String)"Executor not set");
        exec.shutdown();
        exec.awaitTermination(1L, TimeUnit.SECONDS);
    }

    @Test
    public void testInitExecutorNullCallable() throws InterruptedException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            Assertions.assertThrows(NullPointerException.class, () -> new CallableBackgroundInitializer(null, exec));
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testInitialize() throws Exception {
        TestCallable call = new TestCallable();
        CallableBackgroundInitializer init = new CallableBackgroundInitializer((Callable)call);
        Assertions.assertEquals((Integer)RESULT, (Integer)((Integer)init.initialize()), (String)"Wrong result");
        Assertions.assertEquals((int)1, (int)call.callCount, (String)"Wrong number of invocations");
    }

    @Test
    public void testInitNullCallable() {
        Assertions.assertThrows(NullPointerException.class, () -> new CallableBackgroundInitializer(null));
    }

    private static final class TestCallable
    implements Callable<Integer> {
        int callCount;

        private TestCallable() {
        }

        @Override
        public Integer call() {
            ++this.callCount;
            return RESULT;
        }
    }
}

