"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDroppableData = isDroppableData;
exports.useDroppableData = useDroppableData;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
/**
 * Private symbol that is intentionally not exported from this file.
 */
var privateKey = Symbol('DroppableData');

/**
 * Data that is attached to drags.
 */

/**
 * Checks if the passed data satisfies `DroppableData` using the private symbol.
 */
function isDroppableData(data) {
  return data[privateKey] === true;
}

/**
 * Adds the private symbol to the passed data.
 *
 * The symbol allows us to quickly check if an object satisfies `DroppableData`.
 */
function useDroppableData(_ref) {
  var contextId = _ref.contextId,
    droppableId = _ref.droppableId,
    getIsDropDisabled = _ref.getIsDropDisabled;
  return (0, _react.useMemo)(function () {
    return (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, privateKey, true), "contextId", contextId), "droppableId", droppableId), "getIsDropDisabled", getIsDropDisabled);
  }, [contextId, droppableId, getIsDropDisabled]);
}