import _defineProperty from "@babel/runtime/helpers/defineProperty";
export const isAnalyticsEvent = obj => {
  var _obj$constructor;
  return obj instanceof AnalyticsEvent || !!(obj !== null && obj !== void 0 && obj._isAnalyticsEvent) ||
  // Backwards compatibility with older analytics-next packages
  (obj === null || obj === void 0 ? void 0 : (_obj$constructor = obj.constructor) === null || _obj$constructor === void 0 ? void 0 : _obj$constructor.name) === 'AnalyticsEvent';
};
export default class AnalyticsEvent {
  constructor(props) {
    _defineProperty(this, "_isAnalyticsEvent", true);
    _defineProperty(this, "clone", () => {
      // just a shallow clone, don't change sub refs unless you want to
      // affect the original's too
      const payload = {
        ...this.payload
      };
      return new AnalyticsEvent({
        payload
      });
    });
    this.payload = props.payload;
  }
  update(updater) {
    if (typeof updater === 'function') {
      this.payload = updater(this.payload);
    }
    if (typeof updater === 'object') {
      this.payload = {
        ...this.payload,
        ...updater
      };
    }
    return this;
  }
}