"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scroll = void 0;
var _getElementFromPointWithoutHoneyPot = require("@atlaskit/pragmatic-drag-and-drop/private/get-element-from-point-without-honey-pot");
var _getClosestScrollableElement = require("./get-closest-scrollable-element");
var _getScrollable = require("./get-scrollable");
var _getScrollableScrollChange = _interopRequireDefault(require("./get-scrollable-scroll-change"));
var _getWindowScrollChange = _interopRequireDefault(require("./get-window-scroll-change"));
var _getViewport = _interopRequireDefault(require("./window/get-viewport"));
var scroll = exports.scroll = function scroll(_ref) {
  var input = _ref.input,
    dragStartTime = _ref.dragStartTime,
    shouldUseTimeDampening = _ref.shouldUseTimeDampening,
    scrollElement = _ref.scrollElement,
    scrollWindow = _ref.scrollWindow,
    behavior = _ref.behavior;
  var tryScrollWindow = function tryScrollWindow() {
    var viewport = (0, _getViewport.default)();
    var windowScrollChange = (0, _getWindowScrollChange.default)({
      dragStartTime: dragStartTime,
      viewport: viewport,
      center: {
        x: input.clientX + viewport.scroll.current.x,
        y: input.clientY + viewport.scroll.current.y
      },
      shouldUseTimeDampening: shouldUseTimeDampening
    });
    if (windowScrollChange) {
      scrollWindow(windowScrollChange);
      return true;
    }
    return false;
  };
  var tryScrollContainer = function tryScrollContainer() {
    var over = (0, _getElementFromPointWithoutHoneyPot.getElementFromPointWithoutHoneypot)({
      x: input.clientX,
      y: input.clientY
    });
    var closestScrollable = (0, _getClosestScrollableElement.getClosestScrollableElement)(over);
    if (!closestScrollable) {
      return false;
    }
    var scrollable = (0, _getScrollable.getScrollable)({
      closestScrollable: closestScrollable
    });
    var scrollableScrollChange = (0, _getScrollableScrollChange.default)({
      dragStartTime: dragStartTime,
      scrollable: scrollable,
      center: {
        x: input.clientX,
        y: input.clientY
      },
      shouldUseTimeDampening: shouldUseTimeDampening
    });
    if (scrollableScrollChange) {
      scrollElement(closestScrollable, scrollableScrollChange);
      return true;
    }
    return false;
  };
  if (behavior === 'container-only') {
    tryScrollContainer();
  }
  if (behavior === 'window-only') {
    tryScrollWindow();
  }
  if (behavior === 'container-then-window') {
    tryScrollContainer() || tryScrollWindow();
  }
  if (behavior === 'window-then-container') {
    tryScrollWindow() || tryScrollContainer();
  }
};