//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuelementstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIMenuElementState(pub NSInteger);
impl UIMenuElementState {
    #[doc(alias = "UIMenuElementStateOff")]
    pub const Off: Self = Self(0);
    #[doc(alias = "UIMenuElementStateOn")]
    pub const On: Self = Self(1);
    #[doc(alias = "UIMenuElementStateMixed")]
    pub const Mixed: Self = Self(2);
}

unsafe impl Encode for UIMenuElementState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIMenuElementState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuelementattributes?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIMenuElementAttributes(pub NSUInteger);
bitflags::bitflags! {
    impl UIMenuElementAttributes: NSUInteger {
        #[doc(alias = "UIMenuElementAttributesDisabled")]
        const Disabled = 1<<0;
        #[doc(alias = "UIMenuElementAttributesDestructive")]
        const Destructive = 1<<1;
        #[doc(alias = "UIMenuElementAttributesHidden")]
        const Hidden = 1<<2;
/// Indicates that the menu should remain presented after firing
/// the element's action rather than dismissing as it normally does.
/// This attribute has no effect on Mac Catalyst.
        #[doc(alias = "UIMenuElementAttributesKeepsMenuPresented")]
        const KeepsMenuPresented = 1<<3;
    }
}

unsafe impl Encode for UIMenuElementAttributes {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIMenuElementAttributes {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuelement?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIMenuElement;
);

extern_conformance!(
    unsafe impl NSCoding for UIMenuElement {}
);

extern_conformance!(
    unsafe impl NSCopying for UIMenuElement {}
);

unsafe impl CopyingHelper for UIMenuElement {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIMenuElement {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UIMenuElement {}
);

impl UIMenuElement {
    extern_methods!(
        /// The element's title.
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub unsafe fn title(&self) -> Retained<NSString>;

        /// The element's subtitle.
        #[unsafe(method(subtitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn subtitle(&self) -> Option<Retained<NSString>>;

        /// Setter for [`subtitle`][Self::subtitle].
        #[unsafe(method(setSubtitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSubtitle(&self, subtitle: Option<&NSString>);

        #[cfg(feature = "UIImage")]
        /// Image to be displayed alongside the element's title.
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub unsafe fn image(&self) -> Option<Retained<UIImage>>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
