/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableConstraintSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableValueModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SQLQueryTableCreateModel
extends SQLQueryModelContent {
    @Nullable
    private final SQLQueryComplexName tableName;
    @NotNull
    private final List<SQLQueryColumnSpec> columns;
    @NotNull
    private final List<SQLQueryTableConstraintSpec> constraints;

    public SQLQueryTableCreateModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryComplexName tableName, @NotNull List<SQLQueryColumnSpec> columns, @NotNull List<SQLQueryTableConstraintSpec> constraints) {
        super(syntaxNode.getRealInterval(), syntaxNode, new SQLQueryNodeModel[0]);
        this.tableName = tableName;
        this.columns = List.copyOf(columns);
        this.constraints = List.copyOf(constraints);
        this.columns.forEach(sQLQueryNodeModel -> super.registerSubnode((SQLQueryNodeModel)sQLQueryNodeModel));
        this.constraints.forEach(sQLQueryNodeModel -> super.registerSubnode((SQLQueryNodeModel)sQLQueryNodeModel));
    }

    @Nullable
    public SQLQueryComplexName getTableName() {
        return this.tableName;
    }

    @NotNull
    public List<SQLQueryColumnSpec> getColumns() {
        return this.columns;
    }

    @NotNull
    public List<SQLQueryTableConstraintSpec> getConstraints() {
        return this.constraints;
    }

    @Override
    public void resolveObjectAndRowsReferences(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.tableName != null && this.tableName.isNotClassified()) {
            List<DBSEntity> realTables = context.getConnectionInfo().findRealTables(statistics.getMonitor(), this.tableName.stringParts);
            DBSEntity realTable = realTables.size() == 1 ? realTables.getFirst() : null;
            SQLQuerySymbolOrigin.DbObjectRef nameOrigin = new SQLQuerySymbolOrigin.DbObjectRef(context, RelationalObjectType.TYPE_TABLE);
            if (realTable != null) {
                SQLQuerySemanticUtils.setNamePartsDefinition(this.tableName, (DBSObject)realTable, (SQLQuerySymbolOrigin)nameOrigin);
            } else {
                SQLQuerySemanticUtils.performPartialResolution(context, statistics, this.tableName, nameOrigin, Set.of(RelationalObjectType.TYPE_UNKNOWN), SQLQuerySymbolClass.TABLE);
            }
            SQLQueryRowsTableValueModel virtualTableRows = new SQLQueryRowsTableValueModel(this.getSyntaxNode(), Collections.emptyList(), false);
            ArrayList<SQLQueryResultColumn> columns = new ArrayList<SQLQueryResultColumn>(this.columns.size());
            for (SQLQueryColumnSpec columnSpec : this.columns) {
                SQLQuerySymbol columnName;
                SQLQuerySymbolEntry columnNameEntry = columnSpec.getColumnName();
                if (columnNameEntry != null) {
                    columnName = columnNameEntry.getSymbol();
                    if (columnNameEntry.isNotClassified()) {
                        columnName.setDefinition(columnNameEntry);
                        columnName.setSymbolClass(SQLQuerySymbolClass.COLUMN);
                    }
                } else {
                    columnName = new SQLQuerySymbol("?");
                }
                columns.add(new SQLQueryResultColumn(columns.size(), columnName, virtualTableRows, null, null, columnSpec.getDeclaredColumnType()));
            }
            SQLQueryRowsDataContext tableContext = context.makeTuple(null, columns, Collections.emptyList());
            for (SQLQueryColumnSpec columnSpec : this.columns) {
                columnSpec.resolveRelations(context, tableContext, statistics);
            }
            for (SQLQueryTableConstraintSpec constraintSpec : this.constraints) {
                constraintSpec.resolveRelations(context, tableContext, statistics);
            }
        }
    }

    @Override
    public void resolveValueRelations(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, T arg) {
        return visitor.visitCreateTable(this, arg);
    }

    public static SQLQueryTableCreateModel recognize(SQLQueryModelRecognizer recognizer, STMTreeNode node) {
        SQLQueryComplexName tableName = recognizer.collectTableName(node);
        LinkedList<SQLQueryColumnSpec> columns = new LinkedList<SQLQueryColumnSpec>();
        LinkedList<SQLQueryTableConstraintSpec> constraints = new LinkedList<SQLQueryTableConstraintSpec>();
        STMTreeNode elementsNode = node.findFirstChildOfName(STMKnownRuleNames.tableElementList);
        if (elementsNode != null) {
            for (STMTreeNode elementNode : elementsNode.findChildrenOfName(STMKnownRuleNames.tableElement)) {
                STMTreeNode payloadNode = elementNode.findFirstNonErrorChild();
                if (payloadNode == null) continue;
                switch (payloadNode.getNodeKindId()) {
                    case 32: {
                        columns.addLast(SQLQueryColumnSpec.recognize(recognizer, payloadNode));
                        break;
                    }
                    case 194: {
                        constraints.addLast(SQLQueryTableConstraintSpec.recognize(recognizer, payloadNode));
                    }
                }
            }
        }
        return new SQLQueryTableCreateModel(node, tableName, columns, constraints);
    }
}

