/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.ui.editors.NodeEditorInput;

public class NodeEditorInputFactory
implements IElementFactory {
    private static final Log log = Log.getLog(NodeEditorInputFactory.class);
    public static final String ID_FACTORY = NodeEditorInputFactory.class.getName();
    private static final String TAG_NODE = "node";

    public IAdaptable createElement(IMemento memento) {
        String nodePath = memento.getString(TAG_NODE);
        if (nodePath == null) {
            log.debug((Object)"No node ID found in memento");
            return null;
        }
        return new NodeEditorInput(nodePath);
    }

    public static void saveState(IMemento memento, NodeEditorInput input) {
        DBNNode node = input.getNavigatorNode();
        if (node.isDisposed() || node instanceof DBNObjectNode) {
            return;
        }
        memento.putString(TAG_NODE, node.getNodeUri());
    }
}

