/* Following matrices come from the implementation provided by
 * https://www.ipol.im/pub/art/2011/ys-dct/
 * Copyright (c) 2010, Guoshen Yu <yu@cmap.polytechnique.fr>,
 *                     Guillermo Sapiro <guille@umn.edu>
 */

/* A 8x8 1D DCT basis (each ROW is a vector of the forward transform basis */

const gfloat DCTbasis8x8[8][8] = {
  {  0.35355339059327373085750423342688009142875671386719,
     0.35355339059327373085750423342688009142875671386719,
     0.35355339059327373085750423342688009142875671386719,
     0.35355339059327373085750423342688009142875671386719,
     0.35355339059327373085750423342688009142875671386719,
     0.35355339059327373085750423342688009142875671386719,
     0.35355339059327373085750423342688009142875671386719,
     0.35355339059327373085750423342688009142875671386719,  },

  {  0.49039264020161521528962111915461719036102294921875,
     0.41573480615127261783570133957255166023969650268555,
     0.27778511650980114433551193542371038347482681274414,
     0.09754516100806412404189416065491968765854835510254,
    -0.09754516100806412404189416065491968765854835510254,
    -0.27778511650980114433551193542371038347482681274414,
    -0.41573480615127261783570133957255166023969650268555,
    -0.49039264020161521528962111915461719036102294921875,  },

  {  0.46193976625564336924156805253005586564540863037109,
     0.19134171618254489088961634024599334225058555603027,
    -0.19134171618254489088961634024599334225058555603027,
    -0.46193976625564336924156805253005586564540863037109,
    -0.46193976625564336924156805253005586564540863037109,
    -0.19134171618254489088961634024599334225058555603027,
     0.19134171618254489088961634024599334225058555603027,
     0.46193976625564336924156805253005586564540863037109,  },

  {  0.41573480615127261783570133957255166023969650268555,
    -0.09754516100806417955304539191274670884013175964355,
    -0.49039264020161521528962111915461719036102294921875,
    -0.27778511650980108882436070416588336229324340820312,
     0.27778511650980108882436070416588336229324340820312,
     0.49039264020161521528962111915461719036102294921875,
     0.09754516100806417955304539191274670884013175964355,
    -0.41573480615127261783570133957255166023969650268555,  },

  {  0.35355339059327378636865546468470711261034011840820,
    -0.35355339059327378636865546468470711261034011840820,
    -0.35355339059327378636865546468470711261034011840820,
     0.35355339059327378636865546468470711261034011840820,
     0.35355339059327378636865546468470711261034011840820,
    -0.35355339059327378636865546468470711261034011840820,
    -0.35355339059327378636865546468470711261034011840820,
     0.35355339059327378636865546468470711261034011840820,  },

  {  0.27778511650980114433551193542371038347482681274414,
    -0.49039264020161532631192358167027123272418975830078,
     0.09754516100806412404189416065491968765854835510254,
     0.41573480615127261783570133957255166023969650268555,
    -0.41573480615127261783570133957255166023969650268555,
    -0.09754516100806412404189416065491968765854835510254,
     0.49039264020161532631192358167027123272418975830078,
    -0.27778511650980114433551193542371038347482681274414,  },

  {  0.19134171618254491864519195587490685284137725830078,
    -0.46193976625564336924156805253005586564540863037109,
     0.46193976625564336924156805253005586564540863037109,
    -0.19134171618254491864519195587490685284137725830078,
    -0.19134171618254491864519195587490685284137725830078,
     0.46193976625564336924156805253005586564540863037109,
    -0.46193976625564336924156805253005586564540863037109,
     0.19134171618254491864519195587490685284137725830078,  },

  {  0.09754516100806416567525758409828995354473590850830,
    -0.27778511650980108882436070416588336229324340820312,
     0.41573480615127267334685257083037868142127990722656,
    -0.49039264020161521528962111915461719036102294921875,
     0.49039264020161521528962111915461719036102294921875,
    -0.41573480615127267334685257083037868142127990722656,
     0.27778511650980108882436070416588336229324340820312,
    -0.09754516100806416567525758409828995354473590850830   }
};

/* A 16x16 1D DCT basis (each ROW is a vector of the forward transform basis */

const gfloat DCTbasis16x16[16][16] = {
  {  0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,
     0.25000000000000000000000000000000000000000000000000,  },

  {  0.35185093438159564804834644746733829379081726074219,
     0.33832950029358815902114088203234132379293441772461,
     0.31180625324666783049210039280296768993139266967773,
     0.27330046675043939696791994720115326344966888427734,
     0.22429189658565909515353098413470434024930000305176,
     0.16666391461943663721001485100714489817619323730469,
     0.10263113188058936575686175274313427507877349853516,
     0.03465429229977286945674208595846721436828374862671,
    -0.03465429229977286945674208595846721436828374862671,
    -0.10263113188058936575686175274313427507877349853516,
    -0.16666391461943663721001485100714489817619323730469,
    -0.22429189658565909515353098413470434024930000305176,
    -0.27330046675043939696791994720115326344966888427734,
    -0.31180625324666783049210039280296768993139266967773,
    -0.33832950029358815902114088203234132379293441772461,
    -0.35185093438159564804834644746733829379081726074219,  },

  {  0.34675996133053688108560663749813102185726165771484,
     0.29396890060483971129912106334813870489597320556641,
     0.19642373959677555950165128706430550664663314819336,
     0.06897484482073575062788250988887739367783069610596,
    -0.06897484482073575062788250988887739367783069610596,
    -0.19642373959677555950165128706430550664663314819336,
    -0.29396890060483971129912106334813870489597320556641,
    -0.34675996133053688108560663749813102185726165771484,
    -0.34675996133053688108560663749813102185726165771484,
    -0.29396890060483971129912106334813870489597320556641,
    -0.19642373959677555950165128706430550664663314819336,
    -0.06897484482073575062788250988887739367783069610596,
     0.06897484482073575062788250988887739367783069610596,
     0.19642373959677555950165128706430550664663314819336,
     0.29396890060483971129912106334813870489597320556641,
     0.34675996133053688108560663749813102185726165771484,  },

  {  0.33832950029358815902114088203234132379293441772461,
     0.22429189658565906739795536850579082965850830078125,
     0.03465429229977286251784818205123883672058582305908,
    -0.16666391461943663721001485100714489817619323730469,
    -0.31180625324666783049210039280296768993139266967773,
    -0.35185093438159559253719521620951127260923385620117,
    -0.27330046675043934145676871594332624226808547973633,
    -0.10263113188058933800128613711422076448798179626465,
     0.10263113188058933800128613711422076448798179626465,
     0.27330046675043934145676871594332624226808547973633,
     0.35185093438159559253719521620951127260923385620117,
     0.31180625324666783049210039280296768993139266967773,
     0.16666391461943663721001485100714489817619323730469,
    -0.03465429229977286251784818205123883672058582305908,
    -0.22429189658565906739795536850579082965850830078125,
    -0.33832950029358815902114088203234132379293441772461,  },

  {  0.32664074121909414394338000420248135924339294433594,
     0.13529902503654925305376366395648801699280738830566,
    -0.13529902503654925305376366395648801699280738830566,
    -0.32664074121909414394338000420248135924339294433594,
    -0.32664074121909414394338000420248135924339294433594,
    -0.13529902503654925305376366395648801699280738830566,
     0.13529902503654925305376366395648801699280738830566,
     0.32664074121909414394338000420248135924339294433594,
     0.32664074121909414394338000420248135924339294433594,
     0.13529902503654925305376366395648801699280738830566,
    -0.13529902503654925305376366395648801699280738830566,
    -0.32664074121909414394338000420248135924339294433594,
    -0.32664074121909414394338000420248135924339294433594,
    -0.13529902503654925305376366395648801699280738830566,
     0.13529902503654925305376366395648801699280738830566,
     0.32664074121909414394338000420248135924339294433594,  },

  {  0.31180625324666783049210039280296768993139266967773,
     0.03465429229977286251784818205123883672058582305908,
    -0.27330046675043939696791994720115326344966888427734,
    -0.33832950029358821453229211329016834497451782226562,
    -0.10263113188058936575686175274313427507877349853516,
     0.22429189658565906739795536850579082965850830078125,
     0.35185093438159564804834644746733829379081726074219,
     0.16666391461943663721001485100714489817619323730469,
    -0.16666391461943663721001485100714489817619323730469,
    -0.35185093438159564804834644746733829379081726074219,
    -0.22429189658565906739795536850579082965850830078125,
     0.10263113188058936575686175274313427507877349853516,
     0.33832950029358821453229211329016834497451782226562,
     0.27330046675043939696791994720115326344966888427734,
    -0.03465429229977286251784818205123883672058582305908,
    -0.31180625324666783049210039280296768993139266967773,  },

  {  0.29396890060483971129912106334813870489597320556641,
    -0.06897484482073579226124593333224765956401824951172,
    -0.34675996133053688108560663749813102185726165771484,
    -0.19642373959677553174607567143539199605584144592285,
     0.19642373959677553174607567143539199605584144592285,
     0.34675996133053688108560663749813102185726165771484,
     0.06897484482073579226124593333224765956401824951172,
    -0.29396890060483971129912106334813870489597320556641,
    -0.29396890060483971129912106334813870489597320556641,
     0.06897484482073579226124593333224765956401824951172,
     0.34675996133053688108560663749813102185726165771484,
     0.19642373959677553174607567143539199605584144592285,
    -0.19642373959677553174607567143539199605584144592285,
    -0.34675996133053688108560663749813102185726165771484,
    -0.06897484482073579226124593333224765956401824951172,
     0.29396890060483971129912106334813870489597320556641,  },

  {  0.27330046675043939696791994720115326344966888427734,
    -0.16666391461943663721001485100714489817619323730469,
    -0.33832950029358821453229211329016834497451782226562,
     0.03465429229977287639563598986569559201598167419434,
     0.35185093438159564804834644746733829379081726074219,
     0.10263113188058935187907394492867751978337764739990,
    -0.31180625324666783049210039280296768993139266967773,
    -0.22429189658565909515353098413470434024930000305176,
     0.22429189658565909515353098413470434024930000305176,
     0.31180625324666783049210039280296768993139266967773,
    -0.10263113188058935187907394492867751978337764739990,
    -0.35185093438159564804834644746733829379081726074219,
    -0.03465429229977287639563598986569559201598167419434,
     0.33832950029358821453229211329016834497451782226562,
     0.16666391461943663721001485100714489817619323730469,
    -0.27330046675043939696791994720115326344966888427734,  },

  {  0.25000000000000005551115123125782702118158340454102,
    -0.25000000000000005551115123125782702118158340454102,
    -0.25000000000000005551115123125782702118158340454102,
     0.25000000000000005551115123125782702118158340454102,
     0.25000000000000005551115123125782702118158340454102,
    -0.25000000000000005551115123125782702118158340454102,
    -0.25000000000000005551115123125782702118158340454102,
     0.25000000000000005551115123125782702118158340454102,
     0.25000000000000005551115123125782702118158340454102,
    -0.25000000000000005551115123125782702118158340454102,
    -0.25000000000000005551115123125782702118158340454102,
     0.25000000000000005551115123125782702118158340454102,
     0.25000000000000005551115123125782702118158340454102,
    -0.25000000000000005551115123125782702118158340454102,
    -0.25000000000000005551115123125782702118158340454102,
     0.25000000000000005551115123125782702118158340454102,  },

  {  0.22429189658565909515353098413470434024930000305176,
    -0.31180625324666783049210039280296768993139266967773,
    -0.10263113188058937963464956055759103037416934967041,
     0.35185093438159564804834644746733829379081726074219,
    -0.03465429229977282088448475860786857083439826965332,
    -0.33832950029358815902114088203234132379293441772461,
     0.16666391461943658169886361974931787699460983276367,
     0.27330046675043934145676871594332624226808547973633,
    -0.27330046675043934145676871594332624226808547973633,
    -0.16666391461943658169886361974931787699460983276367,
     0.33832950029358815902114088203234132379293441772461,
     0.03465429229977282088448475860786857083439826965332,
    -0.35185093438159564804834644746733829379081726074219,
     0.10263113188058937963464956055759103037416934967041,
     0.31180625324666783049210039280296768993139266967773,
    -0.22429189658565909515353098413470434024930000305176,  },

  {  0.19642373959677558725722690269321901723742485046387,
    -0.34675996133053693659675786875595804303884506225586,
     0.06897484482073573675009470207442063838243484497070,
     0.29396890060483971129912106334813870489597320556641,
    -0.29396890060483971129912106334813870489597320556641,
    -0.06897484482073573675009470207442063838243484497070,
     0.34675996133053693659675786875595804303884506225586,
    -0.19642373959677558725722690269321901723742485046387,
    -0.19642373959677558725722690269321901723742485046387,
     0.34675996133053693659675786875595804303884506225586,
    -0.06897484482073573675009470207442063838243484497070,
    -0.29396890060483971129912106334813870489597320556641,
     0.29396890060483971129912106334813870489597320556641,
     0.06897484482073573675009470207442063838243484497070,
    -0.34675996133053693659675786875595804303884506225586,
     0.19642373959677558725722690269321901723742485046387,  },

  {  0.16666391461943669272116608226497191935777664184570,
    -0.35185093438159559253719521620951127260923385620117,
     0.22429189658565901188680413724796380847692489624023,
     0.10263113188058929636792271367085049860179424285889,
    -0.33832950029358821453229211329016834497451782226562,
     0.27330046675043939696791994720115326344966888427734,
     0.03465429229977293190678722112352261319756507873535,
    -0.31180625324666777498094916154514066874980926513672,
     0.31180625324666777498094916154514066874980926513672,
    -0.03465429229977293190678722112352261319756507873535,
    -0.27330046675043939696791994720115326344966888427734,
     0.33832950029358821453229211329016834497451782226562,
    -0.10263113188058929636792271367085049860179424285889,
    -0.22429189658565901188680413724796380847692489624023,
     0.35185093438159559253719521620951127260923385620117,
    -0.16666391461943669272116608226497191935777664184570,  },

  {  0.13529902503654928080933927958540152758359909057617,
    -0.32664074121909414394338000420248135924339294433594,
     0.32664074121909414394338000420248135924339294433594,
    -0.13529902503654928080933927958540152758359909057617,
    -0.13529902503654928080933927958540152758359909057617,
     0.32664074121909414394338000420248135924339294433594,
    -0.32664074121909414394338000420248135924339294433594,
     0.13529902503654928080933927958540152758359909057617,
     0.13529902503654928080933927958540152758359909057617,
    -0.32664074121909414394338000420248135924339294433594,
     0.32664074121909414394338000420248135924339294433594,
    -0.13529902503654928080933927958540152758359909057617,
    -0.13529902503654928080933927958540152758359909057617,
     0.32664074121909414394338000420248135924339294433594,
    -0.32664074121909414394338000420248135924339294433594,
     0.13529902503654928080933927958540152758359909057617,  },

  {  0.10263113188058933800128613711422076448798179626465,
    -0.27330046675043939696791994720115326344966888427734,
     0.35185093438159564804834644746733829379081726074219,
    -0.31180625324666788600325162406079471111297607421875,
     0.16666391461943666496559046663605840876698493957520,
     0.03465429229977289027342379768015234731137752532959,
    -0.22429189658565906739795536850579082965850830078125,
     0.33832950029358821453229211329016834497451782226562,
    -0.33832950029358821453229211329016834497451782226562,
     0.22429189658565906739795536850579082965850830078125,
    -0.03465429229977289027342379768015234731137752532959,
    -0.16666391461943666496559046663605840876698493957520,
     0.31180625324666788600325162406079471111297607421875,
    -0.35185093438159564804834644746733829379081726074219,
     0.27330046675043939696791994720115326344966888427734,
    -0.10263113188058933800128613711422076448798179626465,  },

  {  0.06897484482073577838345812551779090426862239837646,
    -0.19642373959677555950165128706430550664663314819336,
     0.29396890060483971129912106334813870489597320556641,
    -0.34675996133053688108560663749813102185726165771484,
     0.34675996133053688108560663749813102185726165771484,
    -0.29396890060483971129912106334813870489597320556641,
     0.19642373959677555950165128706430550664663314819336,
    -0.06897484482073577838345812551779090426862239837646,
    -0.06897484482073577838345812551779090426862239837646,
     0.19642373959677555950165128706430550664663314819336,
    -0.29396890060483971129912106334813870489597320556641,
     0.34675996133053688108560663749813102185726165771484,
    -0.34675996133053688108560663749813102185726165771484,
     0.29396890060483971129912106334813870489597320556641,
    -0.19642373959677555950165128706430550664663314819336,
     0.06897484482073577838345812551779090426862239837646,  },

  {  0.03465429229977292496789331721629423554986715316772,
    -0.10263113188058928249013490585639374330639839172363,
     0.16666391461943666496559046663605840876698493957520,
    -0.22429189658565903964237975287687731906771659851074,
     0.27330046675043939696791994720115326344966888427734,
    -0.31180625324666771946979793028731364756822586059570,
     0.33832950029358815902114088203234132379293441772461,
    -0.35185093438159559253719521620951127260923385620117,
     0.35185093438159559253719521620951127260923385620117,
    -0.33832950029358815902114088203234132379293441772461,
     0.31180625324666771946979793028731364756822586059570,
    -0.27330046675043939696791994720115326344966888427734,
     0.22429189658565903964237975287687731906771659851074,
    -0.16666391461943666496559046663605840876698493957520,
     0.10263113188058928249013490585639374330639839172363,
    -0.03465429229977292496789331721629423554986715316772  }
};