// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.18.1
// source: google/apps/drive/labels/v2beta/requests.proto

package labels

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Resource view that can be applied to label responses. The default value
// `LABEL_VIEW_BASIC` implies the field mask:
// `name,id,revision_id,label_type,properties.*`\
type LabelView int32

const (
	// Implies the field mask:
	// `name,id,revision_id,label_type,properties.*`
	LabelView_LABEL_VIEW_BASIC LabelView = 0
	// All possible fields.
	LabelView_LABEL_VIEW_FULL LabelView = 1
)

// Enum value maps for LabelView.
var (
	LabelView_name = map[int32]string{
		0: "LABEL_VIEW_BASIC",
		1: "LABEL_VIEW_FULL",
	}
	LabelView_value = map[string]int32{
		"LABEL_VIEW_BASIC": 0,
		"LABEL_VIEW_FULL":  1,
	}
)

func (x LabelView) Enum() *LabelView {
	p := new(LabelView)
	*p = x
	return p
}

func (x LabelView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LabelView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_labels_v2beta_requests_proto_enumTypes[0].Descriptor()
}

func (LabelView) Type() protoreflect.EnumType {
	return &file_google_apps_drive_labels_v2beta_requests_proto_enumTypes[0]
}

func (x LabelView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LabelView.Descriptor instead.
func (LabelView) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{0}
}

// Provides control over how write requests are executed. When not specified,
// the last write wins.
type WriteControl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Determines the revision of the label to write to and how the request
	// should behave if that revision is not the current revision of the
	// label.
	//
	// Types that are assignable to Control:
	//
	//	*WriteControl_RequiredRevisionId
	Control isWriteControl_Control `protobuf_oneof:"control"`
}

func (x *WriteControl) Reset() {
	*x = WriteControl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteControl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteControl) ProtoMessage() {}

func (x *WriteControl) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteControl.ProtoReflect.Descriptor instead.
func (*WriteControl) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{0}
}

func (m *WriteControl) GetControl() isWriteControl_Control {
	if m != nil {
		return m.Control
	}
	return nil
}

func (x *WriteControl) GetRequiredRevisionId() string {
	if x, ok := x.GetControl().(*WriteControl_RequiredRevisionId); ok {
		return x.RequiredRevisionId
	}
	return ""
}

type isWriteControl_Control interface {
	isWriteControl_Control()
}

type WriteControl_RequiredRevisionId struct {
	// The [revision_id][google.apps.drive.labels.v1.Label.revision_id] of the
	// label that the write request will be applied to. If this is not the
	// latest revision of the label, the request will not be processed and will
	// return a 400 Bad Request error.
	RequiredRevisionId string `protobuf:"bytes,1,opt,name=required_revision_id,json=requiredRevisionId,proto3,oneof"`
}

func (*WriteControl_RequiredRevisionId) isWriteControl_Control() {}

// Request to get the capabilities for a user.
type GetUserCapabilitiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the user. Only "users/me/capabilities" is
	// supported.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetUserCapabilitiesRequest) Reset() {
	*x = GetUserCapabilitiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetUserCapabilitiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserCapabilitiesRequest) ProtoMessage() {}

func (x *GetUserCapabilitiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUserCapabilitiesRequest.ProtoReflect.Descriptor instead.
func (*GetUserCapabilitiesRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{1}
}

func (x *GetUserCapabilitiesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to create a Label.
type CreateLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The label to create.
	Label *Label `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	// Set to `true` in order to use the user's admin privileges. The server
	// will verify the user is an admin before allowing access.
	UseAdminAccess bool `protobuf:"varint,2,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// The BCP-47 language code to use for evaluating localized Field labels in
	// response. When not specified, values in the default configured language
	// will be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *CreateLabelRequest) Reset() {
	*x = CreateLabelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateLabelRequest) ProtoMessage() {}

func (x *CreateLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateLabelRequest.ProtoReflect.Descriptor instead.
func (*CreateLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{2}
}

func (x *CreateLabelRequest) GetLabel() *Label {
	if x != nil {
		return x.Label
	}
	return nil
}

func (x *CreateLabelRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *CreateLabelRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Request to get a label by resource name.
type GetLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Label resource name.
	//
	// May be any of:
	//
	// * `labels/{id}` (equivalent to labels/{id}@latest)
	// * `labels/{id}@latest`
	// * `labels/{id}@published`
	// * `labels/{id}@{revision_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// verifies that the user is an admin for the label before allowing access.
	UseAdminAccess bool `protobuf:"varint,2,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// The BCP-47 language code to use for evaluating localized field labels.
	// When not specified, values in the default configured language are used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// When specified, only certain fields belonging to the indicated view are
	// returned.
	View LabelView `protobuf:"varint,4,opt,name=view,proto3,enum=google.apps.drive.labels.v2beta.LabelView" json:"view,omitempty"`
}

func (x *GetLabelRequest) Reset() {
	*x = GetLabelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLabelRequest) ProtoMessage() {}

func (x *GetLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLabelRequest.ProtoReflect.Descriptor instead.
func (*GetLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{3}
}

func (x *GetLabelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetLabelRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *GetLabelRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *GetLabelRequest) GetView() LabelView {
	if x != nil {
		return x.View
	}
	return LabelView_LABEL_VIEW_BASIC
}

// The set of requests for updating aspects of a Label. If any request is not
// valid, no requests will be applied.
type DeltaUpdateLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Label to update.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Provides control over how write requests are executed.
	WriteControl *WriteControl `protobuf:"bytes,2,opt,name=write_control,json=writeControl,proto3" json:"write_control,omitempty"`
	// A list of updates to apply to the Label.
	// Requests will be applied in the order they are specified.
	Requests []*DeltaUpdateLabelRequest_Request `protobuf:"bytes,3,rep,name=requests,proto3" json:"requests,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// will verify the user is an admin for the Label before allowing access.
	UseAdminAccess bool `protobuf:"varint,4,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// When specified, only certain fields belonging to the indicated view will be
	// returned.
	View LabelView `protobuf:"varint,5,opt,name=view,proto3,enum=google.apps.drive.labels.v2beta.LabelView" json:"view,omitempty"`
	// The BCP-47 language code to use for evaluating localized Field labels when
	// `include_label_in_response` is `true`.
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *DeltaUpdateLabelRequest) Reset() {
	*x = DeltaUpdateLabelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4}
}

func (x *DeltaUpdateLabelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeltaUpdateLabelRequest) GetWriteControl() *WriteControl {
	if x != nil {
		return x.WriteControl
	}
	return nil
}

func (x *DeltaUpdateLabelRequest) GetRequests() []*DeltaUpdateLabelRequest_Request {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *DeltaUpdateLabelRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *DeltaUpdateLabelRequest) GetView() LabelView {
	if x != nil {
		return x.View
	}
	return LabelView_LABEL_VIEW_BASIC
}

func (x *DeltaUpdateLabelRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Response for Label update.
type DeltaUpdateLabelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The reply of the updates. This maps 1:1 with the updates, although
	// responses to some requests may be empty.
	Responses []*DeltaUpdateLabelResponse_Response `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
	// The label after updates were applied. This is only set if
	// [BatchUpdateLabelResponse2.include_label_in_response] is `true` and there
	// were no errors.
	UpdatedLabel *Label `protobuf:"bytes,6,opt,name=updated_label,json=updatedLabel,proto3" json:"updated_label,omitempty"`
}

func (x *DeltaUpdateLabelResponse) Reset() {
	*x = DeltaUpdateLabelResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5}
}

func (x *DeltaUpdateLabelResponse) GetResponses() []*DeltaUpdateLabelResponse_Response {
	if x != nil {
		return x.Responses
	}
	return nil
}

func (x *DeltaUpdateLabelResponse) GetUpdatedLabel() *Label {
	if x != nil {
		return x.UpdatedLabel
	}
	return nil
}

// Request to update the `CopyMode` of the given Label. Changes to this policy
// are not revisioned, do not require publishing, and take effect immediately.
// \
type UpdateLabelCopyModeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Label to update.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Indicates how the applied Label, and Field values should be copied
	// when a Drive item is copied.
	CopyMode Label_AppliedLabelPolicy_CopyMode `protobuf:"varint,2,opt,name=copy_mode,json=copyMode,proto3,enum=google.apps.drive.labels.v2beta.Label_AppliedLabelPolicy_CopyMode" json:"copy_mode,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// will verify the user is an admin for the Label before allowing access.
	UseAdminAccess bool `protobuf:"varint,3,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// The BCP-47 language code to use for evaluating localized field labels.
	// When not specified, values in the default configured language will be used.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// When specified, only certain fields belonging to the indicated view will be
	// returned.
	View LabelView `protobuf:"varint,5,opt,name=view,proto3,enum=google.apps.drive.labels.v2beta.LabelView" json:"view,omitempty"`
}

func (x *UpdateLabelCopyModeRequest) Reset() {
	*x = UpdateLabelCopyModeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateLabelCopyModeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateLabelCopyModeRequest) ProtoMessage() {}

func (x *UpdateLabelCopyModeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateLabelCopyModeRequest.ProtoReflect.Descriptor instead.
func (*UpdateLabelCopyModeRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateLabelCopyModeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateLabelCopyModeRequest) GetCopyMode() Label_AppliedLabelPolicy_CopyMode {
	if x != nil {
		return x.CopyMode
	}
	return Label_AppliedLabelPolicy_COPY_MODE_UNSPECIFIED
}

func (x *UpdateLabelCopyModeRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *UpdateLabelCopyModeRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *UpdateLabelCopyModeRequest) GetView() LabelView {
	if x != nil {
		return x.View
	}
	return LabelView_LABEL_VIEW_BASIC
}

// Request to get the limits for a Label.
type GetLabelLimitsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Label revision resource name
	// Must be: "limits/label"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLabelLimitsRequest) Reset() {
	*x = GetLabelLimitsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLabelLimitsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLabelLimitsRequest) ProtoMessage() {}

func (x *GetLabelLimitsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLabelLimitsRequest.ProtoReflect.Descriptor instead.
func (*GetLabelLimitsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{7}
}

func (x *GetLabelLimitsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list labels available to the current user.
type ListLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Access:
	//
	//	*ListLabelsRequest_UseAdminAccess
	//	*ListLabelsRequest_MinimumRole
	Access isListLabelsRequest_Access `protobuf_oneof:"access"`
	// Whether to include only published labels in the results.
	//
	//   - When `true`, only the current published label revisions are returned.
	//     Disabled labels are included. Returned label resource names
	//     reference the published revision (`labels/{id}/{revision_id}`).
	//   - When `false`, the current label revisions are returned, which might not
	//     be published. Returned label resource names don't reference a specific
	//     revision (`labels/{id}`).
	PublishedOnly bool `protobuf:"varint,1,opt,name=published_only,json=publishedOnly,proto3" json:"published_only,omitempty"`
	// The BCP-47 language code to use for evaluating localized field labels.
	// When not specified, values in the default configured language are used.
	LanguageCode string `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Maximum number of labels to return per page. Default: 50. Max: 200.
	PageSize int32 `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The token of the page to return.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// When specified, only certain fields belonging to the indicated view are
	// returned.
	View LabelView `protobuf:"varint,8,opt,name=view,proto3,enum=google.apps.drive.labels.v2beta.LabelView" json:"view,omitempty"`
}

func (x *ListLabelsRequest) Reset() {
	*x = ListLabelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelsRequest) ProtoMessage() {}

func (x *ListLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelsRequest.ProtoReflect.Descriptor instead.
func (*ListLabelsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{8}
}

func (m *ListLabelsRequest) GetAccess() isListLabelsRequest_Access {
	if m != nil {
		return m.Access
	}
	return nil
}

func (x *ListLabelsRequest) GetUseAdminAccess() bool {
	if x, ok := x.GetAccess().(*ListLabelsRequest_UseAdminAccess); ok {
		return x.UseAdminAccess
	}
	return false
}

func (x *ListLabelsRequest) GetMinimumRole() LabelPermission_LabelRole {
	if x, ok := x.GetAccess().(*ListLabelsRequest_MinimumRole); ok {
		return x.MinimumRole
	}
	return LabelPermission_LABEL_ROLE_UNSPECIFIED
}

func (x *ListLabelsRequest) GetPublishedOnly() bool {
	if x != nil {
		return x.PublishedOnly
	}
	return false
}

func (x *ListLabelsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListLabelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLabelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListLabelsRequest) GetView() LabelView {
	if x != nil {
		return x.View
	}
	return LabelView_LABEL_VIEW_BASIC
}

type isListLabelsRequest_Access interface {
	isListLabelsRequest_Access()
}

type ListLabelsRequest_UseAdminAccess struct {
	// Set to `true` in order to use the user's admin credentials. This will
	// return all Labels within the customer.
	UseAdminAccess bool `protobuf:"varint,3,opt,name=use_admin_access,json=useAdminAccess,proto3,oneof"`
}

type ListLabelsRequest_MinimumRole struct {
	// Specifies the level of access the user must have on the returned Labels.
	// The minimum role a user must have on a label.
	// Defaults to `READER`.
	MinimumRole LabelPermission_LabelRole `protobuf:"varint,4,opt,name=minimum_role,json=minimumRole,proto3,enum=google.apps.drive.labels.v2beta.LabelPermission_LabelRole,oneof"`
}

func (*ListLabelsRequest_UseAdminAccess) isListLabelsRequest_Access() {}

func (*ListLabelsRequest_MinimumRole) isListLabelsRequest_Access() {}

// Response for listing Labels.
type ListLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Labels.
	Labels []*Label `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// The token of the next page in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLabelsResponse) Reset() {
	*x = ListLabelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelsResponse) ProtoMessage() {}

func (x *ListLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelsResponse.ProtoReflect.Descriptor instead.
func (*ListLabelsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{9}
}

func (x *ListLabelsResponse) GetLabels() []*Label {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ListLabelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Creates or updates a permission on the Label. Permissions affect the Label
// resource as a whole, are not revisioned, and do not require publishing.
type CreateLabelPermissionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent Label resource name on the Label Permission is
	// created. Format: labels/{label}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The permission to create or update on the Label.
	LabelPermission *LabelPermission `protobuf:"bytes,2,opt,name=label_permission,json=labelPermission,proto3" json:"label_permission,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// will verify the user is an admin for the Label before allowing access.
	UseAdminAccess bool `protobuf:"varint,3,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
}

func (x *CreateLabelPermissionRequest) Reset() {
	*x = CreateLabelPermissionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateLabelPermissionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateLabelPermissionRequest) ProtoMessage() {}

func (x *CreateLabelPermissionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateLabelPermissionRequest.ProtoReflect.Descriptor instead.
func (*CreateLabelPermissionRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{10}
}

func (x *CreateLabelPermissionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateLabelPermissionRequest) GetLabelPermission() *LabelPermission {
	if x != nil {
		return x.LabelPermission
	}
	return nil
}

func (x *CreateLabelPermissionRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

// Request to list the permissions on a Label.
type ListLabelPermissionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent Label resource name on which Label Permission are
	// listed. Format: labels/{label}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server will
	// verify the user is an admin for the Label before allowing access.
	UseAdminAccess bool `protobuf:"varint,2,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// Maximum number of permissions to return per page. Default: 50. Max: 200.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The token of the page to return.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListLabelPermissionsRequest) Reset() {
	*x = ListLabelPermissionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelPermissionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelPermissionsRequest) ProtoMessage() {}

func (x *ListLabelPermissionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelPermissionsRequest.ProtoReflect.Descriptor instead.
func (*ListLabelPermissionsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{11}
}

func (x *ListLabelPermissionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLabelPermissionsRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *ListLabelPermissionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLabelPermissionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for listing the permissions on a Label.
type ListLabelPermissionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Label permissions.
	LabelPermissions []*LabelPermission `protobuf:"bytes,1,rep,name=label_permissions,json=labelPermissions,proto3" json:"label_permissions,omitempty"`
	// The token of the next page in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLabelPermissionsResponse) Reset() {
	*x = ListLabelPermissionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelPermissionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelPermissionsResponse) ProtoMessage() {}

func (x *ListLabelPermissionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelPermissionsResponse.ProtoReflect.Descriptor instead.
func (*ListLabelPermissionsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{12}
}

func (x *ListLabelPermissionsResponse) GetLabelPermissions() []*LabelPermission {
	if x != nil {
		return x.LabelPermissions
	}
	return nil
}

func (x *ListLabelPermissionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Updates a Label Permission. Permissions affect the Label resource as a whole,
// are not revisioned, and do not require publishing.
type UpdateLabelPermissionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent Label resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The permission to create or update on the Label.
	LabelPermission *LabelPermission `protobuf:"bytes,2,opt,name=label_permission,json=labelPermission,proto3" json:"label_permission,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// will verify the user is an admin for the Label before allowing access.
	UseAdminAccess bool `protobuf:"varint,3,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
}

func (x *UpdateLabelPermissionRequest) Reset() {
	*x = UpdateLabelPermissionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateLabelPermissionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateLabelPermissionRequest) ProtoMessage() {}

func (x *UpdateLabelPermissionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateLabelPermissionRequest.ProtoReflect.Descriptor instead.
func (*UpdateLabelPermissionRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateLabelPermissionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *UpdateLabelPermissionRequest) GetLabelPermission() *LabelPermission {
	if x != nil {
		return x.LabelPermission
	}
	return nil
}

func (x *UpdateLabelPermissionRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

// Deletes a Label Permission. Permissions affect the Label resource as a whole,
// are not revisioned, and do not require publishing.
type DeleteLabelPermissionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Label Permission resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// will verify the user is an admin for the Label before allowing access.
	UseAdminAccess bool `protobuf:"varint,2,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
}

func (x *DeleteLabelPermissionRequest) Reset() {
	*x = DeleteLabelPermissionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteLabelPermissionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteLabelPermissionRequest) ProtoMessage() {}

func (x *DeleteLabelPermissionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteLabelPermissionRequest.ProtoReflect.Descriptor instead.
func (*DeleteLabelPermissionRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{14}
}

func (x *DeleteLabelPermissionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteLabelPermissionRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

// Updates one or more Label Permissions.
type BatchUpdateLabelPermissionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent Label resource name shared by all permissions being
	// updated. Format: labels/{label} If this is set, the parent field in the
	// UpdateLabelPermissionRequest messages must either be empty or match this
	// field.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request message specifying the resources to update.
	Requests []*UpdateLabelPermissionRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// will verify the user is an admin for the Label before allowing access.
	// If this is set, the use_admin_access field in the
	// UpdateLabelPermissionRequest messages must either be empty or match this
	// field.
	UseAdminAccess bool `protobuf:"varint,3,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
}

func (x *BatchUpdateLabelPermissionsRequest) Reset() {
	*x = BatchUpdateLabelPermissionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateLabelPermissionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateLabelPermissionsRequest) ProtoMessage() {}

func (x *BatchUpdateLabelPermissionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateLabelPermissionsRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateLabelPermissionsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{15}
}

func (x *BatchUpdateLabelPermissionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchUpdateLabelPermissionsRequest) GetRequests() []*UpdateLabelPermissionRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *BatchUpdateLabelPermissionsRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

// Response for updating one or more Label Permissions.
type BatchUpdateLabelPermissionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Permissions updated.
	Permissions []*LabelPermission `protobuf:"bytes,1,rep,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *BatchUpdateLabelPermissionsResponse) Reset() {
	*x = BatchUpdateLabelPermissionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateLabelPermissionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateLabelPermissionsResponse) ProtoMessage() {}

func (x *BatchUpdateLabelPermissionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateLabelPermissionsResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateLabelPermissionsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{16}
}

func (x *BatchUpdateLabelPermissionsResponse) GetPermissions() []*LabelPermission {
	if x != nil {
		return x.Permissions
	}
	return nil
}

// Deletes one of more Label Permissions.
type BatchDeleteLabelPermissionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The request message specifying the resources to update.
	Requests []*DeleteLabelPermissionRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// will verify the user is an admin for the Label before allowing access.
	// If this is set, the use_admin_access field in the
	// DeleteLabelPermissionRequest messages must either be empty or match this
	// field.
	UseAdminAccess bool `protobuf:"varint,2,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// Required. The parent Label resource name shared by all permissions being
	// deleted. Format: labels/{label} If this is set, the parent field in the
	// UpdateLabelPermissionRequest messages must either be empty or match this
	// field.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *BatchDeleteLabelPermissionsRequest) Reset() {
	*x = BatchDeleteLabelPermissionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteLabelPermissionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteLabelPermissionsRequest) ProtoMessage() {}

func (x *BatchDeleteLabelPermissionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteLabelPermissionsRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteLabelPermissionsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{17}
}

func (x *BatchDeleteLabelPermissionsRequest) GetRequests() []*DeleteLabelPermissionRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *BatchDeleteLabelPermissionsRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *BatchDeleteLabelPermissionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request to deprecate a published Label.
type DisableLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fields that should be updated. At least one field must be specified.
	// The root `disabled_policy` is implied and should not be specified. A
	// single `*` can be used as short-hand for updating every field.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Label resource name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// will verify the user is an admin for the Label before allowing access.
	UseAdminAccess bool `protobuf:"varint,3,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// Provides control over how write requests are executed. Defaults to unset,
	// which means last write wins.
	WriteControl *WriteControl `protobuf:"bytes,4,opt,name=write_control,json=writeControl,proto3" json:"write_control,omitempty"`
	// Disabled policy to use.
	DisabledPolicy *Lifecycle_DisabledPolicy `protobuf:"bytes,5,opt,name=disabled_policy,json=disabledPolicy,proto3" json:"disabled_policy,omitempty"`
	// The BCP-47 language code to use for evaluating localized field labels.
	// When not specified, values in the default configured language will be used.
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *DisableLabelRequest) Reset() {
	*x = DisableLabelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableLabelRequest) ProtoMessage() {}

func (x *DisableLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableLabelRequest.ProtoReflect.Descriptor instead.
func (*DisableLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{18}
}

func (x *DisableLabelRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *DisableLabelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DisableLabelRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *DisableLabelRequest) GetWriteControl() *WriteControl {
	if x != nil {
		return x.WriteControl
	}
	return nil
}

func (x *DisableLabelRequest) GetDisabledPolicy() *Lifecycle_DisabledPolicy {
	if x != nil {
		return x.DisabledPolicy
	}
	return nil
}

func (x *DisableLabelRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Request to publish a label.
type PublishLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Label resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// will verify the user is an admin for the Label before allowing access.
	UseAdminAccess bool `protobuf:"varint,2,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// Provides control over how write requests are executed. Defaults to unset,
	// which means last write wins.
	WriteControl *WriteControl `protobuf:"bytes,3,opt,name=write_control,json=writeControl,proto3" json:"write_control,omitempty"`
	// The BCP-47 language code to use for evaluating localized field labels.
	// When not specified, values in the default configured language will be used.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *PublishLabelRequest) Reset() {
	*x = PublishLabelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublishLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublishLabelRequest) ProtoMessage() {}

func (x *PublishLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublishLabelRequest.ProtoReflect.Descriptor instead.
func (*PublishLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{19}
}

func (x *PublishLabelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PublishLabelRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *PublishLabelRequest) GetWriteControl() *WriteControl {
	if x != nil {
		return x.WriteControl
	}
	return nil
}

func (x *PublishLabelRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Request to enable a label.
type EnableLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Label resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// will verify the user is an admin for the Label before allowing access.
	UseAdminAccess bool `protobuf:"varint,2,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// Provides control over how write requests are executed. Defaults to unset,
	// which means last write wins.
	WriteControl *WriteControl `protobuf:"bytes,3,opt,name=write_control,json=writeControl,proto3" json:"write_control,omitempty"`
	// The BCP-47 language code to use for evaluating localized field labels.
	// When not specified, values in the default configured language will be used.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *EnableLabelRequest) Reset() {
	*x = EnableLabelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableLabelRequest) ProtoMessage() {}

func (x *EnableLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableLabelRequest.ProtoReflect.Descriptor instead.
func (*EnableLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{20}
}

func (x *EnableLabelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnableLabelRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *EnableLabelRequest) GetWriteControl() *WriteControl {
	if x != nil {
		return x.WriteControl
	}
	return nil
}

func (x *EnableLabelRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Request to delete a label.
type DeleteLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Label resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// will verify the user is an admin for the Label before allowing access.
	UseAdminAccess bool `protobuf:"varint,2,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// Provides control over how write requests are executed. Defaults to unset,
	// which means last write wins.
	WriteControl *WriteControl `protobuf:"bytes,3,opt,name=write_control,json=writeControl,proto3" json:"write_control,omitempty"`
}

func (x *DeleteLabelRequest) Reset() {
	*x = DeleteLabelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteLabelRequest) ProtoMessage() {}

func (x *DeleteLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteLabelRequest.ProtoReflect.Descriptor instead.
func (*DeleteLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteLabelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteLabelRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *DeleteLabelRequest) GetWriteControl() *WriteControl {
	if x != nil {
		return x.WriteControl
	}
	return nil
}

// A request to list the LabelLocks on a Label.
type ListLabelLocksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Label on which Locks are applied.
	// Format: labels/{label}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of Locks to return per page. Default: 100. Max: 200.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The token of the page to return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListLabelLocksRequest) Reset() {
	*x = ListLabelLocksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelLocksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelLocksRequest) ProtoMessage() {}

func (x *ListLabelLocksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelLocksRequest.ProtoReflect.Descriptor instead.
func (*ListLabelLocksRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{22}
}

func (x *ListLabelLocksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLabelLocksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLabelLocksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response to a ListLabelLocksRequest.
type ListLabelLocksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// LabelLocks.
	LabelLocks []*LabelLock `protobuf:"bytes,1,rep,name=label_locks,json=labelLocks,proto3" json:"label_locks,omitempty"`
	// The token of the next page in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLabelLocksResponse) Reset() {
	*x = ListLabelLocksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelLocksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelLocksResponse) ProtoMessage() {}

func (x *ListLabelLocksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelLocksResponse.ProtoReflect.Descriptor instead.
func (*ListLabelLocksResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{23}
}

func (x *ListLabelLocksResponse) GetLabelLocks() []*LabelLock {
	if x != nil {
		return x.LabelLocks
	}
	return nil
}

func (x *ListLabelLocksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A single kind of update to apply to a Label.
type DeltaUpdateLabelRequest_Request struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kind of update. Exactly one Field is required.
	//
	// Types that are assignable to Kind:
	//
	//	*DeltaUpdateLabelRequest_Request_UpdateLabel
	//	*DeltaUpdateLabelRequest_Request_CreateField
	//	*DeltaUpdateLabelRequest_Request_UpdateField
	//	*DeltaUpdateLabelRequest_Request_UpdateFieldType
	//	*DeltaUpdateLabelRequest_Request_EnableField
	//	*DeltaUpdateLabelRequest_Request_DisableField
	//	*DeltaUpdateLabelRequest_Request_DeleteField
	//	*DeltaUpdateLabelRequest_Request_CreateSelectionChoice
	//	*DeltaUpdateLabelRequest_Request_UpdateSelectionChoiceProperties
	//	*DeltaUpdateLabelRequest_Request_EnableSelectionChoice
	//	*DeltaUpdateLabelRequest_Request_DisableSelectionChoice
	//	*DeltaUpdateLabelRequest_Request_DeleteSelectionChoice
	Kind isDeltaUpdateLabelRequest_Request_Kind `protobuf_oneof:"kind"`
}

func (x *DeltaUpdateLabelRequest_Request) Reset() {
	*x = DeltaUpdateLabelRequest_Request{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_Request) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_Request) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_Request.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_Request) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 0}
}

func (m *DeltaUpdateLabelRequest_Request) GetKind() isDeltaUpdateLabelRequest_Request_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetUpdateLabel() *DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_UpdateLabel); ok {
		return x.UpdateLabel
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetCreateField() *DeltaUpdateLabelRequest_CreateFieldRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_CreateField); ok {
		return x.CreateField
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetUpdateField() *DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_UpdateField); ok {
		return x.UpdateField
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetUpdateFieldType() *DeltaUpdateLabelRequest_UpdateFieldTypeRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_UpdateFieldType); ok {
		return x.UpdateFieldType
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetEnableField() *DeltaUpdateLabelRequest_EnableFieldRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_EnableField); ok {
		return x.EnableField
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetDisableField() *DeltaUpdateLabelRequest_DisableFieldRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_DisableField); ok {
		return x.DisableField
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetDeleteField() *DeltaUpdateLabelRequest_DeleteFieldRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_DeleteField); ok {
		return x.DeleteField
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetCreateSelectionChoice() *DeltaUpdateLabelRequest_CreateSelectionChoiceRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_CreateSelectionChoice); ok {
		return x.CreateSelectionChoice
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetUpdateSelectionChoiceProperties() *DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_UpdateSelectionChoiceProperties); ok {
		return x.UpdateSelectionChoiceProperties
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetEnableSelectionChoice() *DeltaUpdateLabelRequest_EnableSelectionChoiceRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_EnableSelectionChoice); ok {
		return x.EnableSelectionChoice
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetDisableSelectionChoice() *DeltaUpdateLabelRequest_DisableSelectionChoiceRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_DisableSelectionChoice); ok {
		return x.DisableSelectionChoice
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_Request) GetDeleteSelectionChoice() *DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest {
	if x, ok := x.GetKind().(*DeltaUpdateLabelRequest_Request_DeleteSelectionChoice); ok {
		return x.DeleteSelectionChoice
	}
	return nil
}

type isDeltaUpdateLabelRequest_Request_Kind interface {
	isDeltaUpdateLabelRequest_Request_Kind()
}

type DeltaUpdateLabelRequest_Request_UpdateLabel struct {
	// Updates the Label properties.
	UpdateLabel *DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest `protobuf:"bytes,1,opt,name=update_label,json=updateLabel,proto3,oneof"`
}

type DeltaUpdateLabelRequest_Request_CreateField struct {
	// Creates a new Field.
	CreateField *DeltaUpdateLabelRequest_CreateFieldRequest `protobuf:"bytes,2,opt,name=create_field,json=createField,proto3,oneof"`
}

type DeltaUpdateLabelRequest_Request_UpdateField struct {
	// Updates basic properties of a Field.
	UpdateField *DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest `protobuf:"bytes,3,opt,name=update_field,json=updateField,proto3,oneof"`
}

type DeltaUpdateLabelRequest_Request_UpdateFieldType struct {
	// Update Field type and/or type options.
	UpdateFieldType *DeltaUpdateLabelRequest_UpdateFieldTypeRequest `protobuf:"bytes,4,opt,name=update_field_type,json=updateFieldType,proto3,oneof"`
}

type DeltaUpdateLabelRequest_Request_EnableField struct {
	// Enables the Field.
	EnableField *DeltaUpdateLabelRequest_EnableFieldRequest `protobuf:"bytes,5,opt,name=enable_field,json=enableField,proto3,oneof"`
}

type DeltaUpdateLabelRequest_Request_DisableField struct {
	// Disables the Field.
	DisableField *DeltaUpdateLabelRequest_DisableFieldRequest `protobuf:"bytes,6,opt,name=disable_field,json=disableField,proto3,oneof"`
}

type DeltaUpdateLabelRequest_Request_DeleteField struct {
	// Deletes a Field from the label.
	DeleteField *DeltaUpdateLabelRequest_DeleteFieldRequest `protobuf:"bytes,7,opt,name=delete_field,json=deleteField,proto3,oneof"`
}

type DeltaUpdateLabelRequest_Request_CreateSelectionChoice struct {
	// Creates Choice within a Selection field.
	CreateSelectionChoice *DeltaUpdateLabelRequest_CreateSelectionChoiceRequest `protobuf:"bytes,8,opt,name=create_selection_choice,json=createSelectionChoice,proto3,oneof"`
}

type DeltaUpdateLabelRequest_Request_UpdateSelectionChoiceProperties struct {
	// Update a Choice properties within a Selection Field.
	UpdateSelectionChoiceProperties *DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest `protobuf:"bytes,9,opt,name=update_selection_choice_properties,json=updateSelectionChoiceProperties,proto3,oneof"`
}

type DeltaUpdateLabelRequest_Request_EnableSelectionChoice struct {
	// Enable a Choice within a Selection Field.
	EnableSelectionChoice *DeltaUpdateLabelRequest_EnableSelectionChoiceRequest `protobuf:"bytes,10,opt,name=enable_selection_choice,json=enableSelectionChoice,proto3,oneof"`
}

type DeltaUpdateLabelRequest_Request_DisableSelectionChoice struct {
	// Disable a Choice within a Selection Field.
	DisableSelectionChoice *DeltaUpdateLabelRequest_DisableSelectionChoiceRequest `protobuf:"bytes,11,opt,name=disable_selection_choice,json=disableSelectionChoice,proto3,oneof"`
}

type DeltaUpdateLabelRequest_Request_DeleteSelectionChoice struct {
	// Delete a Choice within a Selection Field.
	DeleteSelectionChoice *DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest `protobuf:"bytes,12,opt,name=delete_selection_choice,json=deleteSelectionChoice,proto3,oneof"`
}

func (*DeltaUpdateLabelRequest_Request_UpdateLabel) isDeltaUpdateLabelRequest_Request_Kind() {}

func (*DeltaUpdateLabelRequest_Request_CreateField) isDeltaUpdateLabelRequest_Request_Kind() {}

func (*DeltaUpdateLabelRequest_Request_UpdateField) isDeltaUpdateLabelRequest_Request_Kind() {}

func (*DeltaUpdateLabelRequest_Request_UpdateFieldType) isDeltaUpdateLabelRequest_Request_Kind() {}

func (*DeltaUpdateLabelRequest_Request_EnableField) isDeltaUpdateLabelRequest_Request_Kind() {}

func (*DeltaUpdateLabelRequest_Request_DisableField) isDeltaUpdateLabelRequest_Request_Kind() {}

func (*DeltaUpdateLabelRequest_Request_DeleteField) isDeltaUpdateLabelRequest_Request_Kind() {}

func (*DeltaUpdateLabelRequest_Request_CreateSelectionChoice) isDeltaUpdateLabelRequest_Request_Kind() {
}

func (*DeltaUpdateLabelRequest_Request_UpdateSelectionChoiceProperties) isDeltaUpdateLabelRequest_Request_Kind() {
}

func (*DeltaUpdateLabelRequest_Request_EnableSelectionChoice) isDeltaUpdateLabelRequest_Request_Kind() {
}

func (*DeltaUpdateLabelRequest_Request_DisableSelectionChoice) isDeltaUpdateLabelRequest_Request_Kind() {
}

func (*DeltaUpdateLabelRequest_Request_DeleteSelectionChoice) isDeltaUpdateLabelRequest_Request_Kind() {
}

// Updates basic properties of a Label.
type DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fields that should be updated. At least one field must be specified.
	// The root `label_properties` is implied and should not be specified. A
	// single `*` can be used as short-hand for updating every field.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Label properties to update.
	Properties *Label_Properties `protobuf:"bytes,2,opt,name=properties,proto3" json:"properties,omitempty"`
}

func (x *DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest) Reset() {
	*x = DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 1}
}

func (x *DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest) GetProperties() *Label_Properties {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Request to disable the Field.
type DeltaUpdateLabelRequest_DisableFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fields that should be updated. At least one field must be specified.
	// The root `disabled_policy` is implied and should not be specified. A
	// single `*` can be used as short-hand for updating every field.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Key of the Field to disable.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Required. Field Disabled Policy.
	DisabledPolicy *Lifecycle_DisabledPolicy `protobuf:"bytes,3,opt,name=disabled_policy,json=disabledPolicy,proto3" json:"disabled_policy,omitempty"`
}

func (x *DeltaUpdateLabelRequest_DisableFieldRequest) Reset() {
	*x = DeltaUpdateLabelRequest_DisableFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_DisableFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_DisableFieldRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_DisableFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_DisableFieldRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_DisableFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 2}
}

func (x *DeltaUpdateLabelRequest_DisableFieldRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_DisableFieldRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DeltaUpdateLabelRequest_DisableFieldRequest) GetDisabledPolicy() *Lifecycle_DisabledPolicy {
	if x != nil {
		return x.DisabledPolicy
	}
	return nil
}

// Request to enable the Field.
type DeltaUpdateLabelRequest_EnableFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the Field to enable.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *DeltaUpdateLabelRequest_EnableFieldRequest) Reset() {
	*x = DeltaUpdateLabelRequest_EnableFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_EnableFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_EnableFieldRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_EnableFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_EnableFieldRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_EnableFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 3}
}

func (x *DeltaUpdateLabelRequest_EnableFieldRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Request to delete the Field.
type DeltaUpdateLabelRequest_DeleteFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the Field to delete.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *DeltaUpdateLabelRequest_DeleteFieldRequest) Reset() {
	*x = DeltaUpdateLabelRequest_DeleteFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_DeleteFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_DeleteFieldRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_DeleteFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_DeleteFieldRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_DeleteFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 4}
}

func (x *DeltaUpdateLabelRequest_DeleteFieldRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Request to create a Field within a Label.
type DeltaUpdateLabelRequest_CreateFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field to create.
	Field *Field `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
}

func (x *DeltaUpdateLabelRequest_CreateFieldRequest) Reset() {
	*x = DeltaUpdateLabelRequest_CreateFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_CreateFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_CreateFieldRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_CreateFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_CreateFieldRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_CreateFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 5}
}

func (x *DeltaUpdateLabelRequest_CreateFieldRequest) GetField() *Field {
	if x != nil {
		return x.Field
	}
	return nil
}

// Request to update Field properties.
type DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fields that should be updated. At least one field must be specified.
	// The root `properties` is implied and should not be specified. A single
	// `*` can be used as short-hand for updating every field.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The Field to update.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Required. Basic Field properties.
	Properties *Field_Properties `protobuf:"bytes,3,opt,name=properties,proto3" json:"properties,omitempty"`
}

func (x *DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest) Reset() {
	*x = DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 6}
}

func (x *DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest) GetProperties() *Field_Properties {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Request to change the type of a Field.
type DeltaUpdateLabelRequest_UpdateFieldTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to TypeOptions:
	//
	//	*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_TextOptions
	//	*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_LongTextOptions
	//	*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_IntegerOptions
	//	*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_DateOptions
	//	*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_SelectionOptions
	//	*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_UserOptions
	TypeOptions isDeltaUpdateLabelRequest_UpdateFieldTypeRequest_TypeOptions `protobuf_oneof:"type_options"`
	// The fields that should be updated. At least one field must be specified.
	// The root of `type_options` is implied and should not be specified. A
	// single `*` can be used as short-hand for updating every field.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The Field to update.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) Reset() {
	*x = DeltaUpdateLabelRequest_UpdateFieldTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_UpdateFieldTypeRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_UpdateFieldTypeRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_UpdateFieldTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 7}
}

func (m *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) GetTypeOptions() isDeltaUpdateLabelRequest_UpdateFieldTypeRequest_TypeOptions {
	if m != nil {
		return m.TypeOptions
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) GetTextOptions() *Field_TextOptions {
	if x, ok := x.GetTypeOptions().(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_TextOptions); ok {
		return x.TextOptions
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) GetLongTextOptions() *Field_LongTextOptions {
	if x, ok := x.GetTypeOptions().(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_LongTextOptions); ok {
		return x.LongTextOptions
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) GetIntegerOptions() *Field_IntegerOptions {
	if x, ok := x.GetTypeOptions().(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_IntegerOptions); ok {
		return x.IntegerOptions
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) GetDateOptions() *Field_DateOptions {
	if x, ok := x.GetTypeOptions().(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_DateOptions); ok {
		return x.DateOptions
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) GetSelectionOptions() *Field_SelectionOptions {
	if x, ok := x.GetTypeOptions().(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_SelectionOptions); ok {
		return x.SelectionOptions
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) GetUserOptions() *Field_UserOptions {
	if x, ok := x.GetTypeOptions().(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_UserOptions); ok {
		return x.UserOptions
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_UpdateFieldTypeRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type isDeltaUpdateLabelRequest_UpdateFieldTypeRequest_TypeOptions interface {
	isDeltaUpdateLabelRequest_UpdateFieldTypeRequest_TypeOptions()
}

type DeltaUpdateLabelRequest_UpdateFieldTypeRequest_TextOptions struct {
	// Update field to Text.
	TextOptions *Field_TextOptions `protobuf:"bytes,3,opt,name=text_options,json=textOptions,proto3,oneof"`
}

type DeltaUpdateLabelRequest_UpdateFieldTypeRequest_LongTextOptions struct {
	// Update field to Long Text.
	LongTextOptions *Field_LongTextOptions `protobuf:"bytes,4,opt,name=long_text_options,json=longTextOptions,proto3,oneof"`
}

type DeltaUpdateLabelRequest_UpdateFieldTypeRequest_IntegerOptions struct {
	// Update field to Integer.
	IntegerOptions *Field_IntegerOptions `protobuf:"bytes,5,opt,name=integer_options,json=integerOptions,proto3,oneof"`
}

type DeltaUpdateLabelRequest_UpdateFieldTypeRequest_DateOptions struct {
	// Update field to Date.
	DateOptions *Field_DateOptions `protobuf:"bytes,6,opt,name=date_options,json=dateOptions,proto3,oneof"`
}

type DeltaUpdateLabelRequest_UpdateFieldTypeRequest_SelectionOptions struct {
	// Update field to Selection.
	SelectionOptions *Field_SelectionOptions `protobuf:"bytes,7,opt,name=selection_options,json=selectionOptions,proto3,oneof"`
}

type DeltaUpdateLabelRequest_UpdateFieldTypeRequest_UserOptions struct {
	// Update field to User.
	UserOptions *Field_UserOptions `protobuf:"bytes,8,opt,name=user_options,json=userOptions,proto3,oneof"`
}

func (*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_TextOptions) isDeltaUpdateLabelRequest_UpdateFieldTypeRequest_TypeOptions() {
}

func (*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_LongTextOptions) isDeltaUpdateLabelRequest_UpdateFieldTypeRequest_TypeOptions() {
}

func (*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_IntegerOptions) isDeltaUpdateLabelRequest_UpdateFieldTypeRequest_TypeOptions() {
}

func (*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_DateOptions) isDeltaUpdateLabelRequest_UpdateFieldTypeRequest_TypeOptions() {
}

func (*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_SelectionOptions) isDeltaUpdateLabelRequest_UpdateFieldTypeRequest_TypeOptions() {
}

func (*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_UserOptions) isDeltaUpdateLabelRequest_UpdateFieldTypeRequest_TypeOptions() {
}

// Request to create a Selection Choice.
type DeltaUpdateLabelRequest_CreateSelectionChoiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Selection Field in which a Choice will be created.
	FieldId string `protobuf:"bytes,1,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Required. The Choice to create.
	Choice *Field_SelectionOptions_Choice `protobuf:"bytes,2,opt,name=choice,proto3" json:"choice,omitempty"`
}

func (x *DeltaUpdateLabelRequest_CreateSelectionChoiceRequest) Reset() {
	*x = DeltaUpdateLabelRequest_CreateSelectionChoiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_CreateSelectionChoiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_CreateSelectionChoiceRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_CreateSelectionChoiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_CreateSelectionChoiceRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_CreateSelectionChoiceRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 8}
}

func (x *DeltaUpdateLabelRequest_CreateSelectionChoiceRequest) GetFieldId() string {
	if x != nil {
		return x.FieldId
	}
	return ""
}

func (x *DeltaUpdateLabelRequest_CreateSelectionChoiceRequest) GetChoice() *Field_SelectionOptions_Choice {
	if x != nil {
		return x.Choice
	}
	return nil
}

// Request to update a Choice properties.
type DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fields that should be updated. At least one field must be specified.
	// The root `properties` is implied and should not be specified. A single
	// `*` can be used as short-hand for updating every field.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The Selection Field to update.
	FieldId string `protobuf:"bytes,2,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Required. The Choice to update.
	Id string `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// Required. The Choice properties to update.
	Properties *Field_SelectionOptions_Choice_Properties `protobuf:"bytes,4,opt,name=properties,proto3" json:"properties,omitempty"`
}

func (x *DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest) Reset() {
	*x = DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 9}
}

func (x *DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest) GetFieldId() string {
	if x != nil {
		return x.FieldId
	}
	return ""
}

func (x *DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest) GetProperties() *Field_SelectionOptions_Choice_Properties {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Request to delete a Choice.
type DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Selection Field from which a Choice will be deleted.
	FieldId string `protobuf:"bytes,1,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Required. Choice to delete.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest) Reset() {
	*x = DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 10}
}

func (x *DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest) GetFieldId() string {
	if x != nil {
		return x.FieldId
	}
	return ""
}

func (x *DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Request to disable a Choice.
type DeltaUpdateLabelRequest_DisableSelectionChoiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fields that should be updated. At least one field must be specified.
	// The root `disabled_policy` is implied and should not be specified. A
	// single `*` can be used as short-hand for updating every field.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The Selection Field in which a Choice will be disabled.
	FieldId string `protobuf:"bytes,2,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Required. Choice to disable.
	Id string `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// Required. The disabled policy to update.
	DisabledPolicy *Lifecycle_DisabledPolicy `protobuf:"bytes,4,opt,name=disabled_policy,json=disabledPolicy,proto3" json:"disabled_policy,omitempty"`
}

func (x *DeltaUpdateLabelRequest_DisableSelectionChoiceRequest) Reset() {
	*x = DeltaUpdateLabelRequest_DisableSelectionChoiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_DisableSelectionChoiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_DisableSelectionChoiceRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_DisableSelectionChoiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_DisableSelectionChoiceRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_DisableSelectionChoiceRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 11}
}

func (x *DeltaUpdateLabelRequest_DisableSelectionChoiceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *DeltaUpdateLabelRequest_DisableSelectionChoiceRequest) GetFieldId() string {
	if x != nil {
		return x.FieldId
	}
	return ""
}

func (x *DeltaUpdateLabelRequest_DisableSelectionChoiceRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DeltaUpdateLabelRequest_DisableSelectionChoiceRequest) GetDisabledPolicy() *Lifecycle_DisabledPolicy {
	if x != nil {
		return x.DisabledPolicy
	}
	return nil
}

// Request to enable a Choice.
type DeltaUpdateLabelRequest_EnableSelectionChoiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Selection Field in which a Choice will be enabled.
	FieldId string `protobuf:"bytes,1,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Required. Choice to enable.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *DeltaUpdateLabelRequest_EnableSelectionChoiceRequest) Reset() {
	*x = DeltaUpdateLabelRequest_EnableSelectionChoiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelRequest_EnableSelectionChoiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelRequest_EnableSelectionChoiceRequest) ProtoMessage() {}

func (x *DeltaUpdateLabelRequest_EnableSelectionChoiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelRequest_EnableSelectionChoiceRequest.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelRequest_EnableSelectionChoiceRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{4, 12}
}

func (x *DeltaUpdateLabelRequest_EnableSelectionChoiceRequest) GetFieldId() string {
	if x != nil {
		return x.FieldId
	}
	return ""
}

func (x *DeltaUpdateLabelRequest_EnableSelectionChoiceRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// A single response from an update.
type DeltaUpdateLabelResponse_Response struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The response for the corresponding request.
	//
	// Types that are assignable to Response:
	//
	//	*DeltaUpdateLabelResponse_Response_UpdateLabel
	//	*DeltaUpdateLabelResponse_Response_CreateField
	//	*DeltaUpdateLabelResponse_Response_UpdateField
	//	*DeltaUpdateLabelResponse_Response_UpdateFieldType
	//	*DeltaUpdateLabelResponse_Response_EnableField
	//	*DeltaUpdateLabelResponse_Response_DisableField
	//	*DeltaUpdateLabelResponse_Response_DeleteField
	//	*DeltaUpdateLabelResponse_Response_CreateSelectionChoice
	//	*DeltaUpdateLabelResponse_Response_UpdateSelectionChoiceProperties
	//	*DeltaUpdateLabelResponse_Response_EnableSelectionChoice
	//	*DeltaUpdateLabelResponse_Response_DisableSelectionChoice
	//	*DeltaUpdateLabelResponse_Response_DeleteSelectionChoice
	Response isDeltaUpdateLabelResponse_Response_Response `protobuf_oneof:"response"`
}

func (x *DeltaUpdateLabelResponse_Response) Reset() {
	*x = DeltaUpdateLabelResponse_Response{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_Response) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_Response) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_Response.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_Response) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 0}
}

func (m *DeltaUpdateLabelResponse_Response) GetResponse() isDeltaUpdateLabelResponse_Response_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetUpdateLabel() *DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_UpdateLabel); ok {
		return x.UpdateLabel
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetCreateField() *DeltaUpdateLabelResponse_CreateFieldResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_CreateField); ok {
		return x.CreateField
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetUpdateField() *DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_UpdateField); ok {
		return x.UpdateField
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetUpdateFieldType() *DeltaUpdateLabelResponse_UpdateFieldTypeResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_UpdateFieldType); ok {
		return x.UpdateFieldType
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetEnableField() *DeltaUpdateLabelResponse_EnableFieldResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_EnableField); ok {
		return x.EnableField
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetDisableField() *DeltaUpdateLabelResponse_DisableFieldResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_DisableField); ok {
		return x.DisableField
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetDeleteField() *DeltaUpdateLabelResponse_DeleteFieldResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_DeleteField); ok {
		return x.DeleteField
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetCreateSelectionChoice() *DeltaUpdateLabelResponse_CreateSelectionChoiceResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_CreateSelectionChoice); ok {
		return x.CreateSelectionChoice
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetUpdateSelectionChoiceProperties() *DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_UpdateSelectionChoiceProperties); ok {
		return x.UpdateSelectionChoiceProperties
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetEnableSelectionChoice() *DeltaUpdateLabelResponse_EnableSelectionChoiceResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_EnableSelectionChoice); ok {
		return x.EnableSelectionChoice
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetDisableSelectionChoice() *DeltaUpdateLabelResponse_DisableSelectionChoiceResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_DisableSelectionChoice); ok {
		return x.DisableSelectionChoice
	}
	return nil
}

func (x *DeltaUpdateLabelResponse_Response) GetDeleteSelectionChoice() *DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse {
	if x, ok := x.GetResponse().(*DeltaUpdateLabelResponse_Response_DeleteSelectionChoice); ok {
		return x.DeleteSelectionChoice
	}
	return nil
}

type isDeltaUpdateLabelResponse_Response_Response interface {
	isDeltaUpdateLabelResponse_Response_Response()
}

type DeltaUpdateLabelResponse_Response_UpdateLabel struct {
	// Updated basic properties of a Label.
	UpdateLabel *DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse `protobuf:"bytes,1,opt,name=update_label,json=updateLabel,proto3,oneof"`
}

type DeltaUpdateLabelResponse_Response_CreateField struct {
	// Creates a new Field.
	CreateField *DeltaUpdateLabelResponse_CreateFieldResponse `protobuf:"bytes,2,opt,name=create_field,json=createField,proto3,oneof"`
}

type DeltaUpdateLabelResponse_Response_UpdateField struct {
	// Updates basic properties of a Field.
	UpdateField *DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse `protobuf:"bytes,3,opt,name=update_field,json=updateField,proto3,oneof"`
}

type DeltaUpdateLabelResponse_Response_UpdateFieldType struct {
	// Update Field type and/or type options.
	UpdateFieldType *DeltaUpdateLabelResponse_UpdateFieldTypeResponse `protobuf:"bytes,4,opt,name=update_field_type,json=updateFieldType,proto3,oneof"`
}

type DeltaUpdateLabelResponse_Response_EnableField struct {
	// Enables Field.
	EnableField *DeltaUpdateLabelResponse_EnableFieldResponse `protobuf:"bytes,5,opt,name=enable_field,json=enableField,proto3,oneof"`
}

type DeltaUpdateLabelResponse_Response_DisableField struct {
	// Disables Field.
	DisableField *DeltaUpdateLabelResponse_DisableFieldResponse `protobuf:"bytes,6,opt,name=disable_field,json=disableField,proto3,oneof"`
}

type DeltaUpdateLabelResponse_Response_DeleteField struct {
	// Deletes a Field from the label.
	DeleteField *DeltaUpdateLabelResponse_DeleteFieldResponse `protobuf:"bytes,7,opt,name=delete_field,json=deleteField,proto3,oneof"`
}

type DeltaUpdateLabelResponse_Response_CreateSelectionChoice struct {
	// Creates a new selection list option to add to a Selection Field.
	CreateSelectionChoice *DeltaUpdateLabelResponse_CreateSelectionChoiceResponse `protobuf:"bytes,8,opt,name=create_selection_choice,json=createSelectionChoice,proto3,oneof"`
}

type DeltaUpdateLabelResponse_Response_UpdateSelectionChoiceProperties struct {
	// Updates a Choice within a Selection Field.
	UpdateSelectionChoiceProperties *DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse `protobuf:"bytes,9,opt,name=update_selection_choice_properties,json=updateSelectionChoiceProperties,proto3,oneof"`
}

type DeltaUpdateLabelResponse_Response_EnableSelectionChoice struct {
	// Enables a Choice within a Selection Field.
	EnableSelectionChoice *DeltaUpdateLabelResponse_EnableSelectionChoiceResponse `protobuf:"bytes,10,opt,name=enable_selection_choice,json=enableSelectionChoice,proto3,oneof"`
}

type DeltaUpdateLabelResponse_Response_DisableSelectionChoice struct {
	// Disables a Choice within a Selection Field.
	DisableSelectionChoice *DeltaUpdateLabelResponse_DisableSelectionChoiceResponse `protobuf:"bytes,11,opt,name=disable_selection_choice,json=disableSelectionChoice,proto3,oneof"`
}

type DeltaUpdateLabelResponse_Response_DeleteSelectionChoice struct {
	// Deletes a Choice from a Selection Field.
	DeleteSelectionChoice *DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse `protobuf:"bytes,12,opt,name=delete_selection_choice,json=deleteSelectionChoice,proto3,oneof"`
}

func (*DeltaUpdateLabelResponse_Response_UpdateLabel) isDeltaUpdateLabelResponse_Response_Response() {
}

func (*DeltaUpdateLabelResponse_Response_CreateField) isDeltaUpdateLabelResponse_Response_Response() {
}

func (*DeltaUpdateLabelResponse_Response_UpdateField) isDeltaUpdateLabelResponse_Response_Response() {
}

func (*DeltaUpdateLabelResponse_Response_UpdateFieldType) isDeltaUpdateLabelResponse_Response_Response() {
}

func (*DeltaUpdateLabelResponse_Response_EnableField) isDeltaUpdateLabelResponse_Response_Response() {
}

func (*DeltaUpdateLabelResponse_Response_DisableField) isDeltaUpdateLabelResponse_Response_Response() {
}

func (*DeltaUpdateLabelResponse_Response_DeleteField) isDeltaUpdateLabelResponse_Response_Response() {
}

func (*DeltaUpdateLabelResponse_Response_CreateSelectionChoice) isDeltaUpdateLabelResponse_Response_Response() {
}

func (*DeltaUpdateLabelResponse_Response_UpdateSelectionChoiceProperties) isDeltaUpdateLabelResponse_Response_Response() {
}

func (*DeltaUpdateLabelResponse_Response_EnableSelectionChoice) isDeltaUpdateLabelResponse_Response_Response() {
}

func (*DeltaUpdateLabelResponse_Response_DisableSelectionChoice) isDeltaUpdateLabelResponse_Response_Response() {
}

func (*DeltaUpdateLabelResponse_Response_DeleteSelectionChoice) isDeltaUpdateLabelResponse_Response_Response() {
}

// Response following update to Label properties.
type DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse) Reset() {
	*x = DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 1}
}

// Response following Field create.
type DeltaUpdateLabelResponse_CreateFieldResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field of the created field. When left blank in a create request,
	// a key will be autogenerated and can be identified here.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The priority of the created field. The priority may change from what
	// was specified to assure contiguous priorities between fields (1-n).
	Priority int32 `protobuf:"varint,2,opt,name=priority,proto3" json:"priority,omitempty"`
}

func (x *DeltaUpdateLabelResponse_CreateFieldResponse) Reset() {
	*x = DeltaUpdateLabelResponse_CreateFieldResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_CreateFieldResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_CreateFieldResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_CreateFieldResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_CreateFieldResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_CreateFieldResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 2}
}

func (x *DeltaUpdateLabelResponse_CreateFieldResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DeltaUpdateLabelResponse_CreateFieldResponse) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

// Response following update to Field properties.
type DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The priority of the updated field. The priority may change from what
	// was specified to assure contiguous priorities between fields (1-n).
	Priority int32 `protobuf:"varint,1,opt,name=priority,proto3" json:"priority,omitempty"`
}

func (x *DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse) Reset() {
	*x = DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 3}
}

func (x *DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

// Response following update to Field type.
type DeltaUpdateLabelResponse_UpdateFieldTypeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeltaUpdateLabelResponse_UpdateFieldTypeResponse) Reset() {
	*x = DeltaUpdateLabelResponse_UpdateFieldTypeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_UpdateFieldTypeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_UpdateFieldTypeResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_UpdateFieldTypeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_UpdateFieldTypeResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_UpdateFieldTypeResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 4}
}

// Response following Field enable.
type DeltaUpdateLabelResponse_EnableFieldResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeltaUpdateLabelResponse_EnableFieldResponse) Reset() {
	*x = DeltaUpdateLabelResponse_EnableFieldResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_EnableFieldResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_EnableFieldResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_EnableFieldResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_EnableFieldResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_EnableFieldResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 5}
}

// Response following Field disable.
type DeltaUpdateLabelResponse_DisableFieldResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeltaUpdateLabelResponse_DisableFieldResponse) Reset() {
	*x = DeltaUpdateLabelResponse_DisableFieldResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_DisableFieldResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_DisableFieldResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_DisableFieldResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_DisableFieldResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_DisableFieldResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 6}
}

// Response following Field delete.
type DeltaUpdateLabelResponse_DeleteFieldResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeltaUpdateLabelResponse_DeleteFieldResponse) Reset() {
	*x = DeltaUpdateLabelResponse_DeleteFieldResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_DeleteFieldResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_DeleteFieldResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_DeleteFieldResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_DeleteFieldResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_DeleteFieldResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 7}
}

// Response following Selection Choice create.
type DeltaUpdateLabelResponse_CreateSelectionChoiceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The server-generated id of the field.
	FieldId string `protobuf:"bytes,1,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// The server-generated ID of the created choice within the Field
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *DeltaUpdateLabelResponse_CreateSelectionChoiceResponse) Reset() {
	*x = DeltaUpdateLabelResponse_CreateSelectionChoiceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_CreateSelectionChoiceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_CreateSelectionChoiceResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_CreateSelectionChoiceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_CreateSelectionChoiceResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_CreateSelectionChoiceResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 8}
}

func (x *DeltaUpdateLabelResponse_CreateSelectionChoiceResponse) GetFieldId() string {
	if x != nil {
		return x.FieldId
	}
	return ""
}

func (x *DeltaUpdateLabelResponse_CreateSelectionChoiceResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Response following update to Selection Choice properties.
type DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The priority of the updated choice. The priority may change from what
	// was specified to assure contiguous priorities between choices (1-n).
	Priority int32 `protobuf:"varint,1,opt,name=priority,proto3" json:"priority,omitempty"`
}

func (x *DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse) Reset() {
	*x = DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 9}
}

func (x *DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

// Response following Choice enable.
type DeltaUpdateLabelResponse_EnableSelectionChoiceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeltaUpdateLabelResponse_EnableSelectionChoiceResponse) Reset() {
	*x = DeltaUpdateLabelResponse_EnableSelectionChoiceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_EnableSelectionChoiceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_EnableSelectionChoiceResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_EnableSelectionChoiceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_EnableSelectionChoiceResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_EnableSelectionChoiceResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 10}
}

// Response following Choice disable.
type DeltaUpdateLabelResponse_DisableSelectionChoiceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeltaUpdateLabelResponse_DisableSelectionChoiceResponse) Reset() {
	*x = DeltaUpdateLabelResponse_DisableSelectionChoiceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_DisableSelectionChoiceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_DisableSelectionChoiceResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_DisableSelectionChoiceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_DisableSelectionChoiceResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_DisableSelectionChoiceResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 11}
}

// Response following Choice delete.
type DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse) Reset() {
	*x = DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse) ProtoMessage() {}

func (x *DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse.ProtoReflect.Descriptor instead.
func (*DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP(), []int{5, 12}
}

var File_google_apps_drive_labels_v2beta_requests_proto protoreflect.FileDescriptor

var file_google_apps_drive_labels_v2beta_requests_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6c, 0x6f, 0x63,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x4d, 0x0a, 0x0c, 0x57, 0x72, 0x69, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x12, 0x32, 0x0a, 0x14, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x12, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x22, 0x65, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73, 0x65,
	0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65,
	0x22, 0xde, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73,
	0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x23, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x3e, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x22, 0xf7, 0x21, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x52, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12,
	0x5c, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x28, 0x0a,
	0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x41, 0x64, 0x6d, 0x69,
	0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x3e, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0xcf, 0x0c, 0x0a,
	0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7a, 0x0a, 0x0c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x12, 0x70, 0x0a, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x7a, 0x0a, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44,
	0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x7d, 0x0a, 0x11, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00,
	0x52, 0x0f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x70, 0x0a, 0x0c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x12, 0x73, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x70, 0x0a, 0x0c, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x8f, 0x01, 0x0a, 0x17, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44,
	0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x15, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x12, 0xae, 0x01, 0x0a,
	0x22, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74,
	0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x1f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f,
	0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x8f, 0x01,
	0x0a, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x12,
	0x92, 0x01, 0x0a, 0x18, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x16, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68,
	0x6f, 0x69, 0x63, 0x65, 0x12, 0x8f, 0x01, 0x0a, 0x17, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52,
	0x15, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0xb3,
	0x01, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x56, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x1a, 0xd0, 0x01, 0x0a, 0x13, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x12, 0x67,
	0x0a, 0x0f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79,
	0x63, 0x6c, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x29, 0x0a, 0x12, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x13, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02,
	0x69, 0x64, 0x1a, 0x29, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x1a, 0x57, 0x0a,
	0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x1a, 0xc8, 0x01, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x12, 0x56, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x1a, 0xb5, 0x05, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0c,
	0x74, 0x65, 0x78, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x64, 0x0a, 0x11, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x74, 0x65,
	0x78, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x4c, 0x6f, 0x6e, 0x67, 0x54, 0x65, 0x78,
	0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x6c, 0x6f, 0x6e, 0x67,
	0x54, 0x65, 0x78, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x60, 0x0a, 0x0f, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x67, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x57, 0x0a,
	0x0c, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x66, 0x0a, 0x11, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x10, 0x73, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x57,
	0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x73, 0x65, 0x72,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x9b, 0x01, 0x0a, 0x1c, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x5b, 0x0a, 0x06, 0x63, 0x68,
	0x6f, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x1a, 0x8a, 0x02, 0x0a, 0x26, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x1e, 0x0a, 0x08, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x12,
	0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x6e, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x1a, 0x53, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x49, 0x64, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x1a, 0xfa, 0x01, 0x0a, 0x1d, 0x44, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68,
	0x6f, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x1e, 0x0a, 0x08, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x12, 0x67, 0x0a,
	0x0f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63,
	0x6c, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x53, 0x0a, 0x1c, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x22, 0xb1, 0x12, 0x0a, 0x18,
	0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65,
	0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52,
	0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x0d, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x1a, 0xec, 0x0c, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7c, 0x0a, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x12, 0x72, 0x0a, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x7c, 0x0a, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44,
	0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x12, 0x7f, 0x0a, 0x11, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x72, 0x0a, 0x0c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65,
	0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x75, 0x0a, 0x0d, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x48, 0x00, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x72, 0x0a, 0x0c, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x12, 0x91, 0x01, 0x0a, 0x17, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48,
	0x00, 0x52, 0x15, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x12, 0xb0, 0x01, 0x0a, 0x22, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68,
	0x6f, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x1f, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x91, 0x01, 0x0a, 0x17,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x12,
	0x94, 0x01, 0x0a, 0x18, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x44, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68,
	0x6f, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x16,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x91, 0x01, 0x0a, 0x17, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x6f, 0x69,
	0x63, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x48, 0x00, 0x52, 0x15, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x1a, 0x1f, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x1a, 0x41, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1a,
	0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x1a, 0x3b, 0x0a, 0x1d, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x1a, 0x19, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x1a, 0x15, 0x0a, 0x13, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x1a, 0x16, 0x0a, 0x14, 0x44, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x1a, 0x15, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x1a, 0x4a, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x1a, 0x45, 0x0a, 0x27, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x1a, 0x1f, 0x0a, 0x1d, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68,
	0x6f, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x1a, 0x20, 0x0a, 0x1e,
	0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x1a, 0x1f,
	0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xcf, 0x02, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x43,
	0x6f, 0x70, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x64, 0x0a, 0x09,
	0x63, 0x6f, 0x70, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x43, 0x6f, 0x70, 0x79, 0x4d,
	0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x70, 0x79, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73,
	0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x23, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x3e, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x22, 0x55, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf2, 0x02, 0x0a, 0x11, 0x4c, 0x69, 0x73,
	0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a,
	0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x5f, 0x0a, 0x0c, 0x6d, 0x69,
	0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x6f, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0b,
	0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x4f, 0x6e,
	0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x3e, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x22, 0x7c, 0x0a,
	0x12, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xec, 0x01, 0x0a, 0x1c,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x60,
	0x0a, 0x10, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x22, 0xc5, 0x01, 0x0a, 0x1b, 0x4c,
	0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x10,
	0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xa5, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x11, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x10, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xec, 0x01, 0x0a, 0x1c, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x60, 0x0a,
	0x10, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x22, 0x90, 0x01, 0x0a, 0x1c, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c,
	0x0a, 0x2a, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73,
	0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x22, 0xf0, 0x01, 0x0a,
	0x22, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0e, 0x75, 0x73, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x22,
	0x7e, 0x0a, 0x23, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0xf0, 0x01, 0x0a, 0x22, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0e, 0x75, 0x73, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x22, 0x97, 0x03, 0x0a, 0x13, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0e, 0x75, 0x73, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12,
	0x52, 0x0a, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x12, 0x62, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xf6, 0x01, 0x0a,
	0x13, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73,
	0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x52, 0x0a, 0x0d,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x52, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xf5, 0x01, 0x0a, 0x12, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73,
	0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x12, 0x52, 0x0a, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x0c, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xd0, 0x01,
	0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73,
	0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x52, 0x0a, 0x0d,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x52, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x22, 0x95, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4c, 0x6f,
	0x63, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x0a, 0x20, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73,
	0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4c, 0x6f, 0x63, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x4c, 0x6f, 0x63, 0x6b, 0x52, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x4c, 0x6f, 0x63, 0x6b, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2a, 0x36, 0x0a, 0x09, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x56, 0x69, 0x65, 0x77, 0x12, 0x14, 0x0a, 0x10, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x56,
	0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4c,
	0x41, 0x42, 0x45, 0x4c, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x01,
	0x42, 0x84, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x3b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0xa2, 0x02, 0x04, 0x44, 0x4c, 0x42, 0x4c, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_drive_labels_v2beta_requests_proto_rawDescOnce sync.Once
	file_google_apps_drive_labels_v2beta_requests_proto_rawDescData = file_google_apps_drive_labels_v2beta_requests_proto_rawDesc
)

func file_google_apps_drive_labels_v2beta_requests_proto_rawDescGZIP() []byte {
	file_google_apps_drive_labels_v2beta_requests_proto_rawDescOnce.Do(func() {
		file_google_apps_drive_labels_v2beta_requests_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_drive_labels_v2beta_requests_proto_rawDescData)
	})
	return file_google_apps_drive_labels_v2beta_requests_proto_rawDescData
}

var file_google_apps_drive_labels_v2beta_requests_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_apps_drive_labels_v2beta_requests_proto_msgTypes = make([]protoimpl.MessageInfo, 50)
var file_google_apps_drive_labels_v2beta_requests_proto_goTypes = []interface{}{
	(LabelView)(0),                                                           // 0: google.apps.drive.labels.v2beta.LabelView
	(*WriteControl)(nil),                                                     // 1: google.apps.drive.labels.v2beta.WriteControl
	(*GetUserCapabilitiesRequest)(nil),                                       // 2: google.apps.drive.labels.v2beta.GetUserCapabilitiesRequest
	(*CreateLabelRequest)(nil),                                               // 3: google.apps.drive.labels.v2beta.CreateLabelRequest
	(*GetLabelRequest)(nil),                                                  // 4: google.apps.drive.labels.v2beta.GetLabelRequest
	(*DeltaUpdateLabelRequest)(nil),                                          // 5: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest
	(*DeltaUpdateLabelResponse)(nil),                                         // 6: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse
	(*UpdateLabelCopyModeRequest)(nil),                                       // 7: google.apps.drive.labels.v2beta.UpdateLabelCopyModeRequest
	(*GetLabelLimitsRequest)(nil),                                            // 8: google.apps.drive.labels.v2beta.GetLabelLimitsRequest
	(*ListLabelsRequest)(nil),                                                // 9: google.apps.drive.labels.v2beta.ListLabelsRequest
	(*ListLabelsResponse)(nil),                                               // 10: google.apps.drive.labels.v2beta.ListLabelsResponse
	(*CreateLabelPermissionRequest)(nil),                                     // 11: google.apps.drive.labels.v2beta.CreateLabelPermissionRequest
	(*ListLabelPermissionsRequest)(nil),                                      // 12: google.apps.drive.labels.v2beta.ListLabelPermissionsRequest
	(*ListLabelPermissionsResponse)(nil),                                     // 13: google.apps.drive.labels.v2beta.ListLabelPermissionsResponse
	(*UpdateLabelPermissionRequest)(nil),                                     // 14: google.apps.drive.labels.v2beta.UpdateLabelPermissionRequest
	(*DeleteLabelPermissionRequest)(nil),                                     // 15: google.apps.drive.labels.v2beta.DeleteLabelPermissionRequest
	(*BatchUpdateLabelPermissionsRequest)(nil),                               // 16: google.apps.drive.labels.v2beta.BatchUpdateLabelPermissionsRequest
	(*BatchUpdateLabelPermissionsResponse)(nil),                              // 17: google.apps.drive.labels.v2beta.BatchUpdateLabelPermissionsResponse
	(*BatchDeleteLabelPermissionsRequest)(nil),                               // 18: google.apps.drive.labels.v2beta.BatchDeleteLabelPermissionsRequest
	(*DisableLabelRequest)(nil),                                              // 19: google.apps.drive.labels.v2beta.DisableLabelRequest
	(*PublishLabelRequest)(nil),                                              // 20: google.apps.drive.labels.v2beta.PublishLabelRequest
	(*EnableLabelRequest)(nil),                                               // 21: google.apps.drive.labels.v2beta.EnableLabelRequest
	(*DeleteLabelRequest)(nil),                                               // 22: google.apps.drive.labels.v2beta.DeleteLabelRequest
	(*ListLabelLocksRequest)(nil),                                            // 23: google.apps.drive.labels.v2beta.ListLabelLocksRequest
	(*ListLabelLocksResponse)(nil),                                           // 24: google.apps.drive.labels.v2beta.ListLabelLocksResponse
	(*DeltaUpdateLabelRequest_Request)(nil),                                  // 25: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request
	(*DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest)(nil),             // 26: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateLabelPropertiesRequest
	(*DeltaUpdateLabelRequest_DisableFieldRequest)(nil),                      // 27: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DisableFieldRequest
	(*DeltaUpdateLabelRequest_EnableFieldRequest)(nil),                       // 28: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.EnableFieldRequest
	(*DeltaUpdateLabelRequest_DeleteFieldRequest)(nil),                       // 29: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DeleteFieldRequest
	(*DeltaUpdateLabelRequest_CreateFieldRequest)(nil),                       // 30: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.CreateFieldRequest
	(*DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest)(nil),             // 31: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldPropertiesRequest
	(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest)(nil),                   // 32: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldTypeRequest
	(*DeltaUpdateLabelRequest_CreateSelectionChoiceRequest)(nil),             // 33: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.CreateSelectionChoiceRequest
	(*DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest)(nil),   // 34: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateSelectionChoicePropertiesRequest
	(*DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest)(nil),             // 35: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DeleteSelectionChoiceRequest
	(*DeltaUpdateLabelRequest_DisableSelectionChoiceRequest)(nil),            // 36: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DisableSelectionChoiceRequest
	(*DeltaUpdateLabelRequest_EnableSelectionChoiceRequest)(nil),             // 37: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.EnableSelectionChoiceRequest
	(*DeltaUpdateLabelResponse_Response)(nil),                                // 38: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response
	(*DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse)(nil),           // 39: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.UpdateLabelPropertiesResponse
	(*DeltaUpdateLabelResponse_CreateFieldResponse)(nil),                     // 40: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.CreateFieldResponse
	(*DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse)(nil),           // 41: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.UpdateFieldPropertiesResponse
	(*DeltaUpdateLabelResponse_UpdateFieldTypeResponse)(nil),                 // 42: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.UpdateFieldTypeResponse
	(*DeltaUpdateLabelResponse_EnableFieldResponse)(nil),                     // 43: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.EnableFieldResponse
	(*DeltaUpdateLabelResponse_DisableFieldResponse)(nil),                    // 44: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.DisableFieldResponse
	(*DeltaUpdateLabelResponse_DeleteFieldResponse)(nil),                     // 45: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.DeleteFieldResponse
	(*DeltaUpdateLabelResponse_CreateSelectionChoiceResponse)(nil),           // 46: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.CreateSelectionChoiceResponse
	(*DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse)(nil), // 47: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.UpdateSelectionChoicePropertiesResponse
	(*DeltaUpdateLabelResponse_EnableSelectionChoiceResponse)(nil),           // 48: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.EnableSelectionChoiceResponse
	(*DeltaUpdateLabelResponse_DisableSelectionChoiceResponse)(nil),          // 49: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.DisableSelectionChoiceResponse
	(*DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse)(nil),           // 50: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.DeleteSelectionChoiceResponse
	(*Label)(nil),                                    // 51: google.apps.drive.labels.v2beta.Label
	(Label_AppliedLabelPolicy_CopyMode)(0),           // 52: google.apps.drive.labels.v2beta.Label.AppliedLabelPolicy.CopyMode
	(LabelPermission_LabelRole)(0),                   // 53: google.apps.drive.labels.v2beta.LabelPermission.LabelRole
	(*LabelPermission)(nil),                          // 54: google.apps.drive.labels.v2beta.LabelPermission
	(*fieldmaskpb.FieldMask)(nil),                    // 55: google.protobuf.FieldMask
	(*Lifecycle_DisabledPolicy)(nil),                 // 56: google.apps.drive.labels.v2beta.Lifecycle.DisabledPolicy
	(*LabelLock)(nil),                                // 57: google.apps.drive.labels.v2beta.LabelLock
	(*Label_Properties)(nil),                         // 58: google.apps.drive.labels.v2beta.Label.Properties
	(*Field)(nil),                                    // 59: google.apps.drive.labels.v2beta.Field
	(*Field_Properties)(nil),                         // 60: google.apps.drive.labels.v2beta.Field.Properties
	(*Field_TextOptions)(nil),                        // 61: google.apps.drive.labels.v2beta.Field.TextOptions
	(*Field_LongTextOptions)(nil),                    // 62: google.apps.drive.labels.v2beta.Field.LongTextOptions
	(*Field_IntegerOptions)(nil),                     // 63: google.apps.drive.labels.v2beta.Field.IntegerOptions
	(*Field_DateOptions)(nil),                        // 64: google.apps.drive.labels.v2beta.Field.DateOptions
	(*Field_SelectionOptions)(nil),                   // 65: google.apps.drive.labels.v2beta.Field.SelectionOptions
	(*Field_UserOptions)(nil),                        // 66: google.apps.drive.labels.v2beta.Field.UserOptions
	(*Field_SelectionOptions_Choice)(nil),            // 67: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice
	(*Field_SelectionOptions_Choice_Properties)(nil), // 68: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.Properties
}
var file_google_apps_drive_labels_v2beta_requests_proto_depIdxs = []int32{
	51, // 0: google.apps.drive.labels.v2beta.CreateLabelRequest.label:type_name -> google.apps.drive.labels.v2beta.Label
	0,  // 1: google.apps.drive.labels.v2beta.GetLabelRequest.view:type_name -> google.apps.drive.labels.v2beta.LabelView
	1,  // 2: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.write_control:type_name -> google.apps.drive.labels.v2beta.WriteControl
	25, // 3: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.requests:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request
	0,  // 4: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.view:type_name -> google.apps.drive.labels.v2beta.LabelView
	38, // 5: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.responses:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response
	51, // 6: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.updated_label:type_name -> google.apps.drive.labels.v2beta.Label
	52, // 7: google.apps.drive.labels.v2beta.UpdateLabelCopyModeRequest.copy_mode:type_name -> google.apps.drive.labels.v2beta.Label.AppliedLabelPolicy.CopyMode
	0,  // 8: google.apps.drive.labels.v2beta.UpdateLabelCopyModeRequest.view:type_name -> google.apps.drive.labels.v2beta.LabelView
	53, // 9: google.apps.drive.labels.v2beta.ListLabelsRequest.minimum_role:type_name -> google.apps.drive.labels.v2beta.LabelPermission.LabelRole
	0,  // 10: google.apps.drive.labels.v2beta.ListLabelsRequest.view:type_name -> google.apps.drive.labels.v2beta.LabelView
	51, // 11: google.apps.drive.labels.v2beta.ListLabelsResponse.labels:type_name -> google.apps.drive.labels.v2beta.Label
	54, // 12: google.apps.drive.labels.v2beta.CreateLabelPermissionRequest.label_permission:type_name -> google.apps.drive.labels.v2beta.LabelPermission
	54, // 13: google.apps.drive.labels.v2beta.ListLabelPermissionsResponse.label_permissions:type_name -> google.apps.drive.labels.v2beta.LabelPermission
	54, // 14: google.apps.drive.labels.v2beta.UpdateLabelPermissionRequest.label_permission:type_name -> google.apps.drive.labels.v2beta.LabelPermission
	14, // 15: google.apps.drive.labels.v2beta.BatchUpdateLabelPermissionsRequest.requests:type_name -> google.apps.drive.labels.v2beta.UpdateLabelPermissionRequest
	54, // 16: google.apps.drive.labels.v2beta.BatchUpdateLabelPermissionsResponse.permissions:type_name -> google.apps.drive.labels.v2beta.LabelPermission
	15, // 17: google.apps.drive.labels.v2beta.BatchDeleteLabelPermissionsRequest.requests:type_name -> google.apps.drive.labels.v2beta.DeleteLabelPermissionRequest
	55, // 18: google.apps.drive.labels.v2beta.DisableLabelRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 19: google.apps.drive.labels.v2beta.DisableLabelRequest.write_control:type_name -> google.apps.drive.labels.v2beta.WriteControl
	56, // 20: google.apps.drive.labels.v2beta.DisableLabelRequest.disabled_policy:type_name -> google.apps.drive.labels.v2beta.Lifecycle.DisabledPolicy
	1,  // 21: google.apps.drive.labels.v2beta.PublishLabelRequest.write_control:type_name -> google.apps.drive.labels.v2beta.WriteControl
	1,  // 22: google.apps.drive.labels.v2beta.EnableLabelRequest.write_control:type_name -> google.apps.drive.labels.v2beta.WriteControl
	1,  // 23: google.apps.drive.labels.v2beta.DeleteLabelRequest.write_control:type_name -> google.apps.drive.labels.v2beta.WriteControl
	57, // 24: google.apps.drive.labels.v2beta.ListLabelLocksResponse.label_locks:type_name -> google.apps.drive.labels.v2beta.LabelLock
	26, // 25: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.update_label:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateLabelPropertiesRequest
	30, // 26: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.create_field:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.CreateFieldRequest
	31, // 27: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.update_field:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldPropertiesRequest
	32, // 28: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.update_field_type:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldTypeRequest
	28, // 29: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.enable_field:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.EnableFieldRequest
	27, // 30: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.disable_field:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DisableFieldRequest
	29, // 31: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.delete_field:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DeleteFieldRequest
	33, // 32: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.create_selection_choice:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.CreateSelectionChoiceRequest
	34, // 33: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.update_selection_choice_properties:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateSelectionChoicePropertiesRequest
	37, // 34: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.enable_selection_choice:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.EnableSelectionChoiceRequest
	36, // 35: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.disable_selection_choice:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DisableSelectionChoiceRequest
	35, // 36: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.Request.delete_selection_choice:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DeleteSelectionChoiceRequest
	55, // 37: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateLabelPropertiesRequest.update_mask:type_name -> google.protobuf.FieldMask
	58, // 38: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateLabelPropertiesRequest.properties:type_name -> google.apps.drive.labels.v2beta.Label.Properties
	55, // 39: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DisableFieldRequest.update_mask:type_name -> google.protobuf.FieldMask
	56, // 40: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DisableFieldRequest.disabled_policy:type_name -> google.apps.drive.labels.v2beta.Lifecycle.DisabledPolicy
	59, // 41: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.CreateFieldRequest.field:type_name -> google.apps.drive.labels.v2beta.Field
	55, // 42: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldPropertiesRequest.update_mask:type_name -> google.protobuf.FieldMask
	60, // 43: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldPropertiesRequest.properties:type_name -> google.apps.drive.labels.v2beta.Field.Properties
	61, // 44: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldTypeRequest.text_options:type_name -> google.apps.drive.labels.v2beta.Field.TextOptions
	62, // 45: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldTypeRequest.long_text_options:type_name -> google.apps.drive.labels.v2beta.Field.LongTextOptions
	63, // 46: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldTypeRequest.integer_options:type_name -> google.apps.drive.labels.v2beta.Field.IntegerOptions
	64, // 47: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldTypeRequest.date_options:type_name -> google.apps.drive.labels.v2beta.Field.DateOptions
	65, // 48: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldTypeRequest.selection_options:type_name -> google.apps.drive.labels.v2beta.Field.SelectionOptions
	66, // 49: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldTypeRequest.user_options:type_name -> google.apps.drive.labels.v2beta.Field.UserOptions
	55, // 50: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateFieldTypeRequest.update_mask:type_name -> google.protobuf.FieldMask
	67, // 51: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.CreateSelectionChoiceRequest.choice:type_name -> google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice
	55, // 52: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateSelectionChoicePropertiesRequest.update_mask:type_name -> google.protobuf.FieldMask
	68, // 53: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.UpdateSelectionChoicePropertiesRequest.properties:type_name -> google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.Properties
	55, // 54: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DisableSelectionChoiceRequest.update_mask:type_name -> google.protobuf.FieldMask
	56, // 55: google.apps.drive.labels.v2beta.DeltaUpdateLabelRequest.DisableSelectionChoiceRequest.disabled_policy:type_name -> google.apps.drive.labels.v2beta.Lifecycle.DisabledPolicy
	39, // 56: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.update_label:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.UpdateLabelPropertiesResponse
	40, // 57: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.create_field:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.CreateFieldResponse
	41, // 58: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.update_field:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.UpdateFieldPropertiesResponse
	42, // 59: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.update_field_type:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.UpdateFieldTypeResponse
	43, // 60: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.enable_field:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.EnableFieldResponse
	44, // 61: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.disable_field:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.DisableFieldResponse
	45, // 62: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.delete_field:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.DeleteFieldResponse
	46, // 63: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.create_selection_choice:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.CreateSelectionChoiceResponse
	47, // 64: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.update_selection_choice_properties:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.UpdateSelectionChoicePropertiesResponse
	48, // 65: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.enable_selection_choice:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.EnableSelectionChoiceResponse
	49, // 66: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.disable_selection_choice:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.DisableSelectionChoiceResponse
	50, // 67: google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.Response.delete_selection_choice:type_name -> google.apps.drive.labels.v2beta.DeltaUpdateLabelResponse.DeleteSelectionChoiceResponse
	68, // [68:68] is the sub-list for method output_type
	68, // [68:68] is the sub-list for method input_type
	68, // [68:68] is the sub-list for extension type_name
	68, // [68:68] is the sub-list for extension extendee
	0,  // [0:68] is the sub-list for field type_name
}

func init() { file_google_apps_drive_labels_v2beta_requests_proto_init() }
func file_google_apps_drive_labels_v2beta_requests_proto_init() {
	if File_google_apps_drive_labels_v2beta_requests_proto != nil {
		return
	}
	file_google_apps_drive_labels_v2beta_common_proto_init()
	file_google_apps_drive_labels_v2beta_field_proto_init()
	file_google_apps_drive_labels_v2beta_label_proto_init()
	file_google_apps_drive_labels_v2beta_label_lock_proto_init()
	file_google_apps_drive_labels_v2beta_label_permission_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteControl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetUserCapabilitiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateLabelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLabelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateLabelCopyModeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLabelLimitsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLabelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLabelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateLabelPermissionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLabelPermissionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLabelPermissionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateLabelPermissionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteLabelPermissionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateLabelPermissionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateLabelPermissionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteLabelPermissionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableLabelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublishLabelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableLabelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteLabelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLabelLocksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLabelLocksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_Request); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_UpdateLabelPropertiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_DisableFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_EnableFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_DeleteFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_CreateFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_UpdateFieldPropertiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_CreateSelectionChoiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_UpdateSelectionChoicePropertiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_DeleteSelectionChoiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_DisableSelectionChoiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelRequest_EnableSelectionChoiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_Response); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_UpdateLabelPropertiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_CreateFieldResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_UpdateFieldPropertiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_UpdateFieldTypeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_EnableFieldResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_DisableFieldResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_DeleteFieldResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_CreateSelectionChoiceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_UpdateSelectionChoicePropertiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_EnableSelectionChoiceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_DisableSelectionChoiceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaUpdateLabelResponse_DeleteSelectionChoiceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*WriteControl_RequiredRevisionId)(nil),
	}
	file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*ListLabelsRequest_UseAdminAccess)(nil),
		(*ListLabelsRequest_MinimumRole)(nil),
	}
	file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[24].OneofWrappers = []interface{}{
		(*DeltaUpdateLabelRequest_Request_UpdateLabel)(nil),
		(*DeltaUpdateLabelRequest_Request_CreateField)(nil),
		(*DeltaUpdateLabelRequest_Request_UpdateField)(nil),
		(*DeltaUpdateLabelRequest_Request_UpdateFieldType)(nil),
		(*DeltaUpdateLabelRequest_Request_EnableField)(nil),
		(*DeltaUpdateLabelRequest_Request_DisableField)(nil),
		(*DeltaUpdateLabelRequest_Request_DeleteField)(nil),
		(*DeltaUpdateLabelRequest_Request_CreateSelectionChoice)(nil),
		(*DeltaUpdateLabelRequest_Request_UpdateSelectionChoiceProperties)(nil),
		(*DeltaUpdateLabelRequest_Request_EnableSelectionChoice)(nil),
		(*DeltaUpdateLabelRequest_Request_DisableSelectionChoice)(nil),
		(*DeltaUpdateLabelRequest_Request_DeleteSelectionChoice)(nil),
	}
	file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[31].OneofWrappers = []interface{}{
		(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_TextOptions)(nil),
		(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_LongTextOptions)(nil),
		(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_IntegerOptions)(nil),
		(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_DateOptions)(nil),
		(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_SelectionOptions)(nil),
		(*DeltaUpdateLabelRequest_UpdateFieldTypeRequest_UserOptions)(nil),
	}
	file_google_apps_drive_labels_v2beta_requests_proto_msgTypes[37].OneofWrappers = []interface{}{
		(*DeltaUpdateLabelResponse_Response_UpdateLabel)(nil),
		(*DeltaUpdateLabelResponse_Response_CreateField)(nil),
		(*DeltaUpdateLabelResponse_Response_UpdateField)(nil),
		(*DeltaUpdateLabelResponse_Response_UpdateFieldType)(nil),
		(*DeltaUpdateLabelResponse_Response_EnableField)(nil),
		(*DeltaUpdateLabelResponse_Response_DisableField)(nil),
		(*DeltaUpdateLabelResponse_Response_DeleteField)(nil),
		(*DeltaUpdateLabelResponse_Response_CreateSelectionChoice)(nil),
		(*DeltaUpdateLabelResponse_Response_UpdateSelectionChoiceProperties)(nil),
		(*DeltaUpdateLabelResponse_Response_EnableSelectionChoice)(nil),
		(*DeltaUpdateLabelResponse_Response_DisableSelectionChoice)(nil),
		(*DeltaUpdateLabelResponse_Response_DeleteSelectionChoice)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_drive_labels_v2beta_requests_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   50,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_drive_labels_v2beta_requests_proto_goTypes,
		DependencyIndexes: file_google_apps_drive_labels_v2beta_requests_proto_depIdxs,
		EnumInfos:         file_google_apps_drive_labels_v2beta_requests_proto_enumTypes,
		MessageInfos:      file_google_apps_drive_labels_v2beta_requests_proto_msgTypes,
	}.Build()
	File_google_apps_drive_labels_v2beta_requests_proto = out.File
	file_google_apps_drive_labels_v2beta_requests_proto_rawDesc = nil
	file_google_apps_drive_labels_v2beta_requests_proto_goTypes = nil
	file_google_apps_drive_labels_v2beta_requests_proto_depIdxs = nil
}
