## RabbitMQ 4.0.9

RabbitMQ `4.0.9` is a maintenance release in the `4.0.x` [release series](https://www.rabbitmq.com/release-information).

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

It is **strongly recommended** that you read [4.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.0.1)
in detail if upgrading from a version prior to `4.0.0`.


### Minimum Supported Erlang Version

This release requires Erlang 26 and supports Erlang versions up to `27.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.0.x/release-notes).


### Management Plugin

#### Enhancements

 * It is now possible to require authentication for the HTTP API reference page
   accessible at `/api`:

   ```ini
   management.require_auth_for_api_reference = true
   ```

   GitHub issue: [#13715](https://github.com/rabbitmq/rabbitmq-server/pull/13715)


### Federation Plugin

#### Bug Fixes

 * Federation status command and HTTP API endpoint could run into an exception.

   GitHub issue: [#13711](https://github.com/rabbitmq/rabbitmq-server/pull/13711)


### AMQP 1.0 Erlang Client for RabbitMQ

#### Bug Fixes

 * Concurrent queue declarations could fail with an exception.

   GitHub issue: [#13732](https://github.com/rabbitmq/rabbitmq-server/pull/13732)


### Dependency Changes

 * `osiris` was updated to [`1.8.7`](https://github.com/rabbitmq/osiris/releases)
 * `khepri_mnesia_migration` was upgraded to [`0.7.2`](https://github.com/rabbitmq/khepri_mnesia_migration/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-4.0.9.tar.xz`
instead of the source tarball produced by GitHub.
