## RabbitMQ 3.7.13

RabbitMQ `3.7.13` is a maintenance release. It focuses on bug fixes and
minor usability improvements. This release [**requires Erlang/OTP 20.3**](https://www.rabbitmq.com/which-erlang.html) or later.

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 19.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories)
explains what package repositories and tools can be used to provision latest patch versions of
Erlang `20.3.x` and `21.x`.

### Compatibility Notes

#### Minimum Required Erlang Version

This release requires Erlang/OTP 20.3 or later.

#### Upgrading to Erlang 21.x

When upgrading to this release **and upgrading Erlang to 21.x** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and
compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Bug Fixes

 * Binding and unbinding operations could fail with a `NOT_FOUND` channel exception if binding tables
   got out of sync.

   GitHub issues: [rabbitmq/rabbitmq-server#1873](https://github.com/rabbitmq/rabbitmq-server/issues/1873), [rabbitmq/rabbitmq-server#1878](https://github.com/rabbitmq/rabbitmq-server/pull/1878), [rabbitmq/rabbitmq-server#1884](https://github.com/rabbitmq/rabbitmq-server/pull/1884)

 * Eliminated an accumulating inefficiency around topic-based authorisation (only topic
   exchanges are affected).

   Contributed by [Ayanda Dube](https://github.com/Ayanda-D).

   GitHub issue: [rabbitmq/rabbitmq-server#1886](https://github.com/rabbitmq/rabbitmq-server/pull/1886)

 * TCP connections could accumulate when [Proxy protocol](https://www.rabbitmq.com/networking.html#proxy-protocol)
   was enabled and proxy's TCP connections were closed before Proxy protocol header was received and parsed.

   GitHub issue: [rabbitmq/rabbitmq-server#1901](https://github.com/rabbitmq/rabbitmq-server/issues/1901)

 * When a queue was deleted, [internal events](https://github.com/rabbitmq/rabbitmq-event-exchange)
   about consumer cancellation (`consumer.deleted`) were not emitted.

   GitHub issue: [rabbitmq/rabbitmq-server#1892](https://github.com/rabbitmq/rabbitmq-server/issues/1892)

 * Connection tracking subsystem failed and logged an exception when connection was closed before it could
   be registered.

   GitHub issue: [rabbitmq/rabbitmq-server#1898](https://github.com/rabbitmq/rabbitmq-server/pull/1898)

#### Enhancements

 * Exclusive queue property mismatch during queue declaration now produces a more helpful
   error message.

   GitHub issue: [rabbitmq/rabbitmq-server#1887](https://github.com/rabbitmq/rabbitmq-server/issues/1887)

 * Erlang 22 forward compatibility: support more cipher suites for config value encryption.

   GitHub issue: [rabbitmq/rabbitmq-common#307](https://github.com/rabbitmq/rabbitmq-common/pull/307)


### CLI Tools

#### Enhancements

 * `rabbitmqctl shutdown` in `--wait` mode now uses node names instead of `gethostname(2)` when inferring
    if target node is remote. This is more reliable as it takes explicitly set node names and `ERL_INETRC`
    settings into account. In addition, it treats all nodes that have `@localhost` in the name as local
    (running on the same host).
    
    GitHub issue: [rabbitmq/rabbitmq-cli#327](https://github.com/rabbitmq/rabbitmq-cli/issues/327).

 * `rabbitmqctl forget_cluster_node` produces a more helpful error message when asked to remove a node with running
   RabbitMQ application.

   GitHub issue: [rabbitmq/rabbitmq-cli#323](https://github.com/rabbitmq/rabbitmq-cli/issues/323)

 * New command, `rabbitmqctl force_gc`, that requests fullsweep GC for all processes on the target node.

   GitHub issue: [rabbitmq/rabbitmq-cli#319](https://github.com/rabbitmq/rabbitmq-cli/issues/319)

 * All RabbitMQ CLI tools now support `--version` as well as `version` as a command.

   GitHub issue: [rabbitmq/rabbitmq-cli#314](https://github.com/rabbitmq/rabbitmq-cli/issues/314)


### Management Plugin

#### Bug Fixes

 * `rabbitmqadmin`'s' `declare vhost_limit` and `delete vhost_limit` did not support the vhost
   parameter.

   GitHub issue: [rabbitmq/rabbitmq-management#667](https://github.com/rabbitmq/rabbitmq-management/issues/667)

 * `PUT /api/vhost-limits/{vhost}/{limit}` documentation was incorrect and used confusing language.

   GitHub issue: [rabbitmq/rabbitmq-management#667](https://github.com/rabbitmq/rabbitmq-management/issues/667)


### Debian and RPM Packages

#### Bug Fixes

 * Debian and RPM packages no longer source `/etc/profile` in post installation scripts.

   GitHub issue: [rabbitmq/rabbitmq-server-release#93](https://github.com/rabbitmq/rabbitmq-server-release/issues/93)


### Federation Plugin

#### Bug Fixes

 * Federation links could fail to start with an `{error, already_started} `.
 
   GitHub issue: [rabbitmq/rabbitmq-federation#84](https://github.com/rabbitmq/rabbitmq-federation/issues/84)


### Shovel Plugin

#### Bug Fixes

 * AMQP 1.0 endpoint URIs could fail to parse.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0-client#23](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/issues/23)


### HTTP AuthN/AuthZ Backend Plugin

#### Enhnanceements

 * User tags are now passed to virtual host, resource and topic authorisation check endpoints as a space-separated string.

   Contributed by [romerod](https://github.com/romerod).

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-http#79](https://github.com/rabbitmq/rabbitmq-auth-backend-http/issues/79)


### Trust Store Plugin

#### Bug Fixes

 * HTTP provider did not correctly update `If-Modified-Since` request header when certificates
   (and thus their `Last-Modified` response header) were updated.

   GitHub issue: [rabbitmq/rabbitmq-trust-store#68](https://github.com/rabbitmq/rabbitmq-trust-store/issues/68)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.13.tar.gz`.
