// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

import (
	"encoding/json"
	"encoding/xml"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
	"time"
)

// MarshalXML implements the xml.Marshaller interface for type AccessPolicy.
func (a AccessPolicy) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias AccessPolicy
	aux := &struct {
		*alias
		Expiry *dateTimeRFC3339 `xml:"Expiry"`
		Start  *dateTimeRFC3339 `xml:"Start"`
	}{
		alias:  (*alias)(&a),
		Expiry: (*dateTimeRFC3339)(a.Expiry),
		Start:  (*dateTimeRFC3339)(a.Start),
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type AccessPolicy.
func (a *AccessPolicy) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias AccessPolicy
	aux := &struct {
		*alias
		Expiry *dateTimeRFC3339 `xml:"Expiry"`
		Start  *dateTimeRFC3339 `xml:"Start"`
	}{
		alias: (*alias)(a),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	if aux.Expiry != nil && !(*time.Time)(aux.Expiry).IsZero() {
		a.Expiry = (*time.Time)(aux.Expiry)
	}
	if aux.Start != nil && !(*time.Time)(aux.Start).IsZero() {
		a.Start = (*time.Time)(aux.Start)
	}
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type ArrowConfiguration.
func (a ArrowConfiguration) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias ArrowConfiguration
	aux := &struct {
		*alias
		Schema *[]*ArrowField `xml:"Schema>Field"`
	}{
		alias: (*alias)(&a),
	}
	if a.Schema != nil {
		aux.Schema = &a.Schema
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type BlobFlatListSegment.
func (b BlobFlatListSegment) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias BlobFlatListSegment
	aux := &struct {
		*alias
		BlobItems *[]*BlobItem `xml:"Blob"`
	}{
		alias: (*alias)(&b),
	}
	if b.BlobItems != nil {
		aux.BlobItems = &b.BlobItems
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type BlobHierarchyListSegment.
func (b BlobHierarchyListSegment) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias BlobHierarchyListSegment
	aux := &struct {
		*alias
		BlobItems    *[]*BlobItem   `xml:"Blob"`
		BlobPrefixes *[]*BlobPrefix `xml:"BlobPrefix"`
	}{
		alias: (*alias)(&b),
	}
	if b.BlobItems != nil {
		aux.BlobItems = &b.BlobItems
	}
	if b.BlobPrefixes != nil {
		aux.BlobPrefixes = &b.BlobPrefixes
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type BlobProperties.
func (b BlobProperties) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias BlobProperties
	aux := &struct {
		*alias
		AccessTierChangeTime        *dateTimeRFC1123 `xml:"AccessTierChangeTime"`
		ContentMD5                  *string          `xml:"Content-MD5"`
		CopyCompletionTime          *dateTimeRFC1123 `xml:"CopyCompletionTime"`
		CreationTime                *dateTimeRFC1123 `xml:"Creation-Time"`
		DeletedTime                 *dateTimeRFC1123 `xml:"DeletedTime"`
		ExpiresOn                   *dateTimeRFC1123 `xml:"Expiry-Time"`
		ImmutabilityPolicyExpiresOn *dateTimeRFC1123 `xml:"ImmutabilityPolicyUntilDate"`
		LastAccessedOn              *dateTimeRFC1123 `xml:"LastAccessTime"`
		LastModified                *dateTimeRFC1123 `xml:"Last-Modified"`
	}{
		alias:                       (*alias)(&b),
		AccessTierChangeTime:        (*dateTimeRFC1123)(b.AccessTierChangeTime),
		CopyCompletionTime:          (*dateTimeRFC1123)(b.CopyCompletionTime),
		CreationTime:                (*dateTimeRFC1123)(b.CreationTime),
		DeletedTime:                 (*dateTimeRFC1123)(b.DeletedTime),
		ExpiresOn:                   (*dateTimeRFC1123)(b.ExpiresOn),
		ImmutabilityPolicyExpiresOn: (*dateTimeRFC1123)(b.ImmutabilityPolicyExpiresOn),
		LastAccessedOn:              (*dateTimeRFC1123)(b.LastAccessedOn),
		LastModified:                (*dateTimeRFC1123)(b.LastModified),
	}
	if b.ContentMD5 != nil {
		encodedContentMD5 := runtime.EncodeByteArray(b.ContentMD5, runtime.Base64StdFormat)
		aux.ContentMD5 = &encodedContentMD5
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type BlobProperties.
func (b *BlobProperties) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias BlobProperties
	aux := &struct {
		*alias
		AccessTierChangeTime        *dateTimeRFC1123 `xml:"AccessTierChangeTime"`
		ContentMD5                  *string          `xml:"Content-MD5"`
		CopyCompletionTime          *dateTimeRFC1123 `xml:"CopyCompletionTime"`
		CreationTime                *dateTimeRFC1123 `xml:"Creation-Time"`
		DeletedTime                 *dateTimeRFC1123 `xml:"DeletedTime"`
		ExpiresOn                   *dateTimeRFC1123 `xml:"Expiry-Time"`
		ImmutabilityPolicyExpiresOn *dateTimeRFC1123 `xml:"ImmutabilityPolicyUntilDate"`
		LastAccessedOn              *dateTimeRFC1123 `xml:"LastAccessTime"`
		LastModified                *dateTimeRFC1123 `xml:"Last-Modified"`
	}{
		alias: (*alias)(b),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	if aux.AccessTierChangeTime != nil && !(*time.Time)(aux.AccessTierChangeTime).IsZero() {
		b.AccessTierChangeTime = (*time.Time)(aux.AccessTierChangeTime)
	}
	if aux.ContentMD5 != nil {
		if err := runtime.DecodeByteArray(*aux.ContentMD5, &b.ContentMD5, runtime.Base64StdFormat); err != nil {
			return err
		}
	}
	if aux.CopyCompletionTime != nil && !(*time.Time)(aux.CopyCompletionTime).IsZero() {
		b.CopyCompletionTime = (*time.Time)(aux.CopyCompletionTime)
	}
	if aux.CreationTime != nil && !(*time.Time)(aux.CreationTime).IsZero() {
		b.CreationTime = (*time.Time)(aux.CreationTime)
	}
	if aux.DeletedTime != nil && !(*time.Time)(aux.DeletedTime).IsZero() {
		b.DeletedTime = (*time.Time)(aux.DeletedTime)
	}
	if aux.ExpiresOn != nil && !(*time.Time)(aux.ExpiresOn).IsZero() {
		b.ExpiresOn = (*time.Time)(aux.ExpiresOn)
	}
	if aux.ImmutabilityPolicyExpiresOn != nil && !(*time.Time)(aux.ImmutabilityPolicyExpiresOn).IsZero() {
		b.ImmutabilityPolicyExpiresOn = (*time.Time)(aux.ImmutabilityPolicyExpiresOn)
	}
	if aux.LastAccessedOn != nil && !(*time.Time)(aux.LastAccessedOn).IsZero() {
		b.LastAccessedOn = (*time.Time)(aux.LastAccessedOn)
	}
	if aux.LastModified != nil && !(*time.Time)(aux.LastModified).IsZero() {
		b.LastModified = (*time.Time)(aux.LastModified)
	}
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type BlobTags.
func (b BlobTags) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	start.Name.Local = "Tags"
	type alias BlobTags
	aux := &struct {
		*alias
		BlobTagSet *[]*BlobTag `xml:"TagSet>Tag"`
	}{
		alias: (*alias)(&b),
	}
	if b.BlobTagSet != nil {
		aux.BlobTagSet = &b.BlobTagSet
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type BlockList.
func (b BlockList) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias BlockList
	aux := &struct {
		*alias
		CommittedBlocks   *[]*Block `xml:"CommittedBlocks>Block"`
		UncommittedBlocks *[]*Block `xml:"UncommittedBlocks>Block"`
	}{
		alias: (*alias)(&b),
	}
	if b.CommittedBlocks != nil {
		aux.CommittedBlocks = &b.CommittedBlocks
	}
	if b.UncommittedBlocks != nil {
		aux.UncommittedBlocks = &b.UncommittedBlocks
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type BlockLookupList.
func (b BlockLookupList) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	start.Name.Local = "BlockList"
	type alias BlockLookupList
	aux := &struct {
		*alias
		Committed   *[]*string `xml:"Committed"`
		Latest      *[]*string `xml:"Latest"`
		Uncommitted *[]*string `xml:"Uncommitted"`
	}{
		alias: (*alias)(&b),
	}
	if b.Committed != nil {
		aux.Committed = &b.Committed
	}
	if b.Latest != nil {
		aux.Latest = &b.Latest
	}
	if b.Uncommitted != nil {
		aux.Uncommitted = &b.Uncommitted
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type ContainerItem.
func (c *ContainerItem) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias ContainerItem
	aux := &struct {
		*alias
		Metadata additionalProperties `xml:"Metadata"`
	}{
		alias: (*alias)(c),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	c.Metadata = (map[string]*string)(aux.Metadata)
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type ContainerProperties.
func (c ContainerProperties) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias ContainerProperties
	aux := &struct {
		*alias
		DeletedTime  *dateTimeRFC1123 `xml:"DeletedTime"`
		LastModified *dateTimeRFC1123 `xml:"Last-Modified"`
	}{
		alias:        (*alias)(&c),
		DeletedTime:  (*dateTimeRFC1123)(c.DeletedTime),
		LastModified: (*dateTimeRFC1123)(c.LastModified),
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type ContainerProperties.
func (c *ContainerProperties) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias ContainerProperties
	aux := &struct {
		*alias
		DeletedTime  *dateTimeRFC1123 `xml:"DeletedTime"`
		LastModified *dateTimeRFC1123 `xml:"Last-Modified"`
	}{
		alias: (*alias)(c),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	if aux.DeletedTime != nil && !(*time.Time)(aux.DeletedTime).IsZero() {
		c.DeletedTime = (*time.Time)(aux.DeletedTime)
	}
	if aux.LastModified != nil && !(*time.Time)(aux.LastModified).IsZero() {
		c.LastModified = (*time.Time)(aux.LastModified)
	}
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type FilterBlobSegment.
func (f FilterBlobSegment) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias FilterBlobSegment
	aux := &struct {
		*alias
		Blobs *[]*FilterBlobItem `xml:"Blobs>Blob"`
	}{
		alias: (*alias)(&f),
	}
	if f.Blobs != nil {
		aux.Blobs = &f.Blobs
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type GeoReplication.
func (g GeoReplication) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias GeoReplication
	aux := &struct {
		*alias
		LastSyncTime *dateTimeRFC1123 `xml:"LastSyncTime"`
	}{
		alias:        (*alias)(&g),
		LastSyncTime: (*dateTimeRFC1123)(g.LastSyncTime),
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type GeoReplication.
func (g *GeoReplication) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias GeoReplication
	aux := &struct {
		*alias
		LastSyncTime *dateTimeRFC1123 `xml:"LastSyncTime"`
	}{
		alias: (*alias)(g),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	if aux.LastSyncTime != nil && !(*time.Time)(aux.LastSyncTime).IsZero() {
		g.LastSyncTime = (*time.Time)(aux.LastSyncTime)
	}
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type ListContainersSegmentResponse.
func (l ListContainersSegmentResponse) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias ListContainersSegmentResponse
	aux := &struct {
		*alias
		ContainerItems *[]*ContainerItem `xml:"Containers>Container"`
	}{
		alias: (*alias)(&l),
	}
	if l.ContainerItems != nil {
		aux.ContainerItems = &l.ContainerItems
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type PageList.
func (p PageList) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias PageList
	aux := &struct {
		*alias
		ClearRange *[]*ClearRange `xml:"ClearRange"`
		PageRange  *[]*PageRange  `xml:"PageRange"`
	}{
		alias: (*alias)(&p),
	}
	if p.ClearRange != nil {
		aux.ClearRange = &p.ClearRange
	}
	if p.PageRange != nil {
		aux.PageRange = &p.PageRange
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type QueryRequest.
func (q QueryRequest) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	start.Name.Local = "QueryRequest"
	type alias QueryRequest
	aux := &struct {
		*alias
	}{
		alias: (*alias)(&q),
	}
	return enc.EncodeElement(aux, start)
}

// MarshalJSON implements the json.Marshaller interface for type StorageError.
func (s StorageError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Message", s.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageError.
func (s *StorageError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type StorageServiceProperties.
func (s StorageServiceProperties) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias StorageServiceProperties
	aux := &struct {
		*alias
		CORS *[]*CORSRule `xml:"Cors>CorsRule"`
	}{
		alias: (*alias)(&s),
	}
	if s.CORS != nil {
		aux.CORS = &s.CORS
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type UserDelegationKey.
func (u UserDelegationKey) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias UserDelegationKey
	aux := &struct {
		*alias
		SignedExpiry *dateTimeRFC3339 `xml:"SignedExpiry"`
		SignedStart  *dateTimeRFC3339 `xml:"SignedStart"`
	}{
		alias:        (*alias)(&u),
		SignedExpiry: (*dateTimeRFC3339)(u.SignedExpiry),
		SignedStart:  (*dateTimeRFC3339)(u.SignedStart),
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type UserDelegationKey.
func (u *UserDelegationKey) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias UserDelegationKey
	aux := &struct {
		*alias
		SignedExpiry *dateTimeRFC3339 `xml:"SignedExpiry"`
		SignedStart  *dateTimeRFC3339 `xml:"SignedStart"`
	}{
		alias: (*alias)(u),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	if aux.SignedExpiry != nil && !(*time.Time)(aux.SignedExpiry).IsZero() {
		u.SignedExpiry = (*time.Time)(aux.SignedExpiry)
	}
	if aux.SignedStart != nil && !(*time.Time)(aux.SignedStart).IsZero() {
		u.SignedStart = (*time.Time)(aux.SignedStart)
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
