# frozen_string_literal: true
#--
# Ruby/OpenSSL Project
# Copyright (C) 2017 Ruby/OpenSSL Project Authors
#++

require_relative 'marshal'

module OpenSSL::PKey
  class DH
    include OpenSSL::Marshal
  end

  class DSA
    include OpenSSL::Marshal
  end

  if defined?(EC)
  class EC
    include OpenSSL::Marshal
  end
  class EC::Point
    # :call-seq:
    #    point.to_bn([conversion_form]) -> OpenSSL::BN
    #
    # Returns the octet string representation of the EC point as an instance of
    # OpenSSL::BN.
    #
    # If _conversion_form_ is not given, the _point_conversion_form_ attribute
    # set to the group is used.
    #
    # See #to_octet_string for more information.
    # def to_bn(conversion_form = group.point_conversion_form)
    #   OpenSSL::BN.new(to_octet_string(conversion_form), 2)
    # end
  end
  end

  class RSA
    include OpenSSL::Marshal
  end
end
