-- This file and its contents are licensed under the Timescale License.
-- Please see the included NOTICE for copyright information and
-- LICENSE-TIMESCALE for a copy of the license.

-- A test for https://github.com/timescale/timescaledb/issues/6681

-- create hypertable with enabled compression
CREATE TABLE corrupt_float8 (
  time timestamptz NOT NULL,
  value double precision NULL
);

SELECT create_hypertable('corrupt_float8','time');

ALTER TABLE corrupt_float8 SET (timescaledb.compress);

-- insert these 1000 values
INSERT INTO corrupt_float8 VALUES
('2023-09-21 01:47:02.979+00', 11510.1), ('2023-09-21 01:48:03.58+00', 11510.6), ('2023-09-21 01:49:01.92+00', 11511), ('2023-09-21 01:50:02.49+00', 11511.5), ('2023-09-21 01:51:03.057+00', 11511.9),
('2023-09-21 01:52:01.554+00', 11512.4), ('2023-09-21 01:53:02.046+00', 11512.8), ('2023-09-21 01:54:02.826+00', 11513.3), ('2023-09-21 01:55:01.146+00', 11513.7), ('2023-09-21 01:56:01.816+00', 11514.2),
('2023-09-21 01:57:02.965+00', 11514.6), ('2023-09-21 01:58:02.167+00', 11515.1), ('2023-09-21 01:59:02.156+00', 11515.5), ('2023-09-21 02:00:02.447+00', 11516), ('2023-09-21 02:01:02.417+00', 11516.4),
('2023-09-21 02:02:02.581+00', 11516.9), ('2023-09-21 02:03:02.738+00', 11517.3), ('2023-09-21 02:04:03.17+00', 11517.8), ('2023-09-21 02:05:02.911+00', 11518.2), ('2023-09-21 02:06:02.123+00', 11518.7),
('2023-09-21 02:07:02.146+00', 11519.1), ('2023-09-21 02:08:02.247+00', 11519.5), ('2023-09-21 02:09:02.487+00', 11520), ('2023-09-21 02:10:02.804+00', 11520.4), ('2023-09-21 02:11:02.74+00', 11520.9),
('2023-09-21 02:12:02.932+00', 11521.3), ('2023-09-21 02:13:03.136+00', 11521.8), ('2023-09-21 02:14:02.162+00', 11522.2), ('2023-09-21 02:15:02.095+00', 11522.7), ('2023-09-21 02:16:02.506+00', 11523.1),
('2023-09-21 02:17:02.415+00', 11523.6), ('2023-09-21 02:18:02.822+00', 11524), ('2023-09-21 02:19:02.741+00', 11524.5), ('2023-09-21 02:20:02.918+00', 11524.9), ('2023-09-21 02:20:56.717+00', 11525.4),
('2023-09-21 02:21:57.127+00', 11525.8), ('2023-09-21 02:22:55.815+00', 11526.3), ('2023-09-21 02:23:56.451+00', 11526.7), ('2023-09-21 02:24:56.807+00', 11527.2), ('2023-09-21 02:25:55.308+00', 11527.6),
('2023-09-21 02:26:56.045+00', 11528.1), ('2023-09-21 02:27:56.367+00', 11528.5), ('2023-09-21 02:28:57.977+00', 11529), ('2023-09-21 02:29:58.144+00', 11529.4), ('2023-09-21 02:30:58.068+00', 11529.9),
('2023-09-21 02:31:57.158+00', 11530.3), ('2023-09-21 02:32:57.335+00', 11530.8), ('2023-09-21 02:33:57.451+00', 11531.2), ('2023-09-21 02:34:57.638+00', 11531.7), ('2023-09-21 02:35:57.792+00', 11532.1),
('2023-09-21 02:36:58.004+00', 11532.6), ('2023-09-21 02:37:58.344+00', 11533), ('2023-09-21 02:38:58.149+00', 11533.5), ('2023-09-21 02:39:57.412+00', 11533.9), ('2023-09-21 02:40:57.304+00', 11534.4),
('2023-09-21 02:41:57.685+00', 11534.8), ('2023-09-21 02:42:57.646+00', 11535.3), ('2023-09-21 02:43:57.785+00', 11535.7), ('2023-09-21 02:44:58.146+00', 11536.2), ('2023-09-21 02:45:51.775+00', 11536.6),
('2023-09-21 02:46:58.2+00', 11537.1), ('2023-09-21 02:47:57.326+00', 11537.5), ('2023-09-21 02:48:51.291+00', 11538), ('2023-09-21 02:49:51.858+00', 11538.4), ('2023-09-21 02:50:52.619+00', 11538.9),
('2023-09-21 02:51:50.777+00', 11539.3), ('2023-09-21 02:52:51.612+00', 11539.8), ('2023-09-21 02:53:51.985+00', 11540.2), ('2023-09-21 02:54:50.686+00', 11540.7), ('2023-09-21 02:55:51.064+00', 11541.1),
('2023-09-21 02:56:49.45+00', 11541.5), ('2023-09-21 02:57:50.012+00', 11542), ('2023-09-21 02:58:50.812+00', 11542.4), ('2023-09-21 02:59:49.043+00', 11542.9), ('2023-09-21 03:00:49.771+00', 11543.3),
('2023-09-21 03:01:52.277+00', 11543.8), ('2023-09-21 03:02:53.108+00', 11544.2), ('2023-09-21 03:03:53.297+00', 11544.7), ('2023-09-21 03:04:52.198+00', 11545.1), ('2023-09-21 03:05:52.32+00', 11545.6),
('2023-09-21 03:06:52.705+00', 11546), ('2023-09-21 03:07:52.653+00', 11546.5), ('2023-09-21 03:08:53.057+00', 11546.9), ('2023-09-21 03:09:52.978+00', 11547.4), ('2023-09-21 03:10:53.347+00', 11547.8),
('2023-09-21 03:11:53.323+00', 11548.3), ('2023-09-21 03:12:52.369+00', 11548.7), ('2023-09-21 03:13:52.352+00', 11549.2), ('2023-09-21 03:14:47.077+00', 11549.6), ('2023-09-21 03:15:47.383+00', 11550.1),
('2023-09-21 03:16:45.782+00', 11550.5), ('2023-09-21 03:17:46.458+00', 11551), ('2023-09-21 03:18:47.182+00', 11551.4), ('2023-09-21 03:19:47.6+00', 11551.9), ('2023-09-21 03:20:45.985+00', 11552.3),
('2023-09-21 03:21:46.534+00', 11552.7), ('2023-09-21 03:22:44.923+00', 11553.2), ('2023-09-21 03:23:45.56+00', 11553.6), ('2023-09-21 03:24:46.298+00', 11554.1), ('2023-09-21 03:25:44.604+00', 11554.5),
('2023-09-21 03:26:45.336+00', 11555), ('2023-09-21 03:27:45.636+00', 11555.4), ('2023-09-21 03:28:44.379+00', 11555.9), ('2023-09-21 03:29:44.737+00', 11556.3), ('2023-09-21 03:30:45.456+00', 11556.8),
('2023-09-21 03:31:43.739+00', 11557.2), ('2023-09-21 03:32:44.469+00', 11557.7), ('2023-09-21 03:33:42.794+00', 11558.1), ('2023-09-21 03:34:43.601+00', 11558.6), ('2023-09-21 03:35:43.845+00', 11559),
('2023-09-21 03:36:43.557+00', 11559.5), ('2023-09-21 03:37:44.316+00', 11559.9), ('2023-09-21 03:38:43.429+00', 11560.4), ('2023-09-21 03:39:42.446+00', 11560.8), ('2023-09-21 03:40:42.807+00', 11561.3),
('2023-09-21 03:41:43.031+00', 11561.7), ('2023-09-21 03:42:43.143+00', 11562.2), ('2023-09-21 03:43:43.107+00', 11562.6), ('2023-09-21 03:44:43.412+00', 11563.1), ('2023-09-21 03:45:43.438+00', 11563.5),
('2023-09-21 03:46:43.625+00', 11564), ('2023-09-21 03:47:42.403+00', 11564.4), ('2023-09-21 03:48:42.798+00', 11564.8), ('2023-09-21 03:49:42.735+00', 11565.3), ('2023-09-21 03:50:43.084+00', 11565.7),
('2023-09-21 03:51:43.065+00', 11566.2), ('2023-09-21 03:52:43.273+00', 11566.6), ('2023-09-21 03:53:43.627+00', 11567.1), ('2023-09-21 03:54:43.503+00', 11567.5), ('2023-09-21 03:55:42.395+00', 11568),
('2023-09-21 03:56:42.804+00', 11568.4), ('2023-09-21 03:57:42.73+00', 11568.9), ('2023-09-21 03:58:42.866+00', 11569.3), ('2023-09-21 03:59:43.089+00', 11569.8), ('2023-09-21 04:00:43.191+00', 11570.2),
('2023-09-21 04:01:43.656+00', 11570.7), ('2023-09-21 04:02:43.518+00', 11571.1), ('2023-09-21 04:03:42.432+00', 11571.6), ('2023-09-21 04:04:42.773+00', 11572), ('2023-09-21 04:05:42.751+00', 11572.5),
('2023-09-21 04:06:42.883+00', 11572.9), ('2023-09-21 04:07:43.263+00', 11573.4), ('2023-09-21 04:08:37.077+00', 11573.8), ('2023-09-21 04:09:37.691+00', 11574.3), ('2023-09-21 04:10:38.38+00', 11574.7),
('2023-09-21 04:11:36.603+00', 11575.2), ('2023-09-21 04:12:37.418+00', 11575.6), ('2023-09-21 04:13:37.783+00', 11576.1), ('2023-09-21 04:14:36.29+00', 11576.5), ('2023-09-21 04:15:36.894+00', 11576.9),
('2023-09-21 04:16:35.21+00', 11577.4), ('2023-09-21 04:17:35.845+00', 11577.8), ('2023-09-21 04:18:36.612+00', 11578.3), ('2023-09-21 04:19:34.883+00', 11578.7), ('2023-09-21 04:20:35.386+00', 11579.2),
('2023-09-21 04:21:35.932+00', 11579.6), ('2023-09-21 04:22:34.707+00', 11580.1), ('2023-09-21 04:23:34.972+00', 11580.5), ('2023-09-21 04:24:35.399+00', 11581), ('2023-09-21 04:25:34.019+00', 11581.4),
('2023-09-21 04:26:34.753+00', 11581.9), ('2023-09-21 04:27:35.001+00', 11582.3), ('2023-09-21 04:28:33.671+00', 11582.8), ('2023-09-21 04:29:34.134+00', 11583.2), ('2023-09-21 04:30:32.864+00', 11583.7),
('2023-09-21 04:31:33.162+00', 11584.1), ('2023-09-21 04:32:33.664+00', 11584.6), ('2023-09-21 04:33:33.127+00', 11585), ('2023-09-21 04:34:32.725+00', 11585.5), ('2023-09-21 04:35:33.492+00', 11585.9),
('2023-09-21 04:36:33.81+00', 11586.4), ('2023-09-21 04:37:32.392+00', 11586.8), ('2023-09-21 04:38:32.822+00', 11587.3), ('2023-09-21 04:39:34.116+00', 11587.7), ('2023-09-21 04:40:31.785+00', 11588.2),
('2023-09-21 04:41:32.284+00', 11588.6), ('2023-09-21 04:42:31.139+00', 11589.1), ('2023-09-21 04:43:31.423+00', 11589.5), ('2023-09-21 04:44:31.965+00', 11590), ('2023-09-21 04:45:30.468+00', 11590.4),
('2023-09-21 04:46:30.953+00', 11590.9), ('2023-09-21 04:47:31.54+00', 11591.3), ('2023-09-21 04:48:29.913+00', 11591.8), ('2023-09-21 04:49:30.531+00', 11592.2), ('2023-09-21 04:50:28.958+00', 11592.7),
('2023-09-21 04:51:29.642+00', 11593.1), ('2023-09-21 04:52:30.051+00', 11593.6), ('2023-09-21 04:53:28.669+00', 11594), ('2023-09-21 04:54:29.338+00', 11594.5), ('2023-09-21 04:55:29.727+00', 11594.9),
('2023-09-21 04:56:28.166+00', 11595.4), ('2023-09-21 04:57:28.687+00', 11595.8), ('2023-09-21 04:58:29.489+00', 11596.3), ('2023-09-21 04:59:27.771+00', 11596.7), ('2023-09-21 05:00:28.293+00', 11597.2),
('2023-09-21 05:01:28.719+00', 11597.6), ('2023-09-21 05:02:27.536+00', 11598.1), ('2023-09-21 05:03:27.875+00', 11598.5), ('2023-09-21 05:04:28.608+00', 11599), ('2023-09-21 05:05:26.938+00', 11599.4),
('2023-09-21 05:06:27.614+00', 11599.9), ('2023-09-21 05:07:25.913+00', 11600.3), ('2023-09-21 05:08:26.482+00', 11600.8), ('2023-09-21 05:09:27.02+00', 11601.2), ('2023-09-21 05:10:25.724+00', 11601.7),
('2023-09-21 05:11:28.978+00', 11602.1), ('2023-09-21 05:12:29.345+00', 11602.6), ('2023-09-21 05:13:29.338+00', 11603), ('2023-09-21 05:14:29.482+00', 11603.5), ('2023-09-21 05:15:29.81+00', 11603.9),
('2023-09-21 05:16:29.778+00', 11604.4), ('2023-09-21 05:17:29.805+00', 11604.8), ('2023-09-21 05:18:29.015+00', 11605.3), ('2023-09-21 05:19:28.97+00', 11605.7), ('2023-09-21 05:20:29.351+00', 11606.2),
('2023-09-21 05:21:29.312+00', 11606.6), ('2023-09-21 05:22:29.46+00', 11607.1), ('2023-09-21 05:23:29.721+00', 11607.5), ('2023-09-21 05:24:22.792+00', 11608), ('2023-09-21 05:25:23.341+00', 11608.4),
('2023-09-21 05:26:28.889+00', 11608.9), ('2023-09-21 05:27:29.059+00', 11609.3), ('2023-09-21 05:28:23.166+00', 11609.8), ('2023-09-21 05:29:23.487+00', 11610.2), ('2023-09-21 05:30:21.988+00', 11610.7),
('2023-09-21 05:31:22.489+00', 11611.1), ('2023-09-21 05:32:23.127+00', 11611.6), ('2023-09-21 05:33:21.422+00', 11612), ('2023-09-21 05:34:22.057+00', 11612.5), ('2023-09-21 05:35:22.46+00', 11612.9),
('2023-09-21 05:36:21.052+00', 11613.4), ('2023-09-21 05:37:21.574+00', 11613.8), ('2023-09-21 05:38:22.161+00', 11614.3), ('2023-09-21 05:39:20.551+00', 11614.7), ('2023-09-21 05:40:23.755+00', 11615.2),
('2023-09-21 05:41:24.794+00', 11615.6), ('2023-09-21 05:42:23.801+00', 11616.1), ('2023-09-21 05:43:23.864+00', 11616.5), ('2023-09-21 05:44:24.049+00', 11617), ('2023-09-21 05:45:24.428+00', 11617.4),
('2023-09-21 05:46:24.395+00', 11617.9), ('2023-09-21 05:47:18.864+00', 11618.3), ('2023-09-21 05:48:19.389+00', 11618.8), ('2023-09-21 05:49:20.095+00', 11619.2), ('2023-09-21 05:50:18.402+00', 11619.7),
('2023-09-21 05:51:18.817+00', 11620.1), ('2023-09-21 05:52:19.442+00', 11620.6), ('2023-09-21 05:53:17.993+00', 11621), ('2023-09-21 05:54:18.579+00', 11621.5), ('2023-09-21 05:55:19.253+00', 11621.9),
('2023-09-21 05:56:17.538+00', 11622.4), ('2023-09-21 05:57:18.311+00', 11622.8), ('2023-09-21 05:58:18.536+00', 11623.3), ('2023-09-21 05:59:17.092+00', 11623.7), ('2023-09-21 06:00:17.608+00', 11624.2),
('2023-09-21 06:01:18.148+00', 11624.6), ('2023-09-21 06:02:16.704+00', 11625.1), ('2023-09-21 06:03:17.407+00', 11625.5), ('2023-09-21 06:04:15.791+00', 11626), ('2023-09-21 06:05:16.247+00', 11626.4),
('2023-09-21 06:06:16.787+00', 11626.9), ('2023-09-21 06:07:17.481+00', 11627.3), ('2023-09-21 06:08:15.829+00', 11627.8), ('2023-09-21 06:09:16.542+00', 11628.2), ('2023-09-21 06:10:14.868+00', 11628.7),
('2023-09-21 06:11:15.393+00', 11629.1), ('2023-09-21 06:12:15.852+00', 11629.6), ('2023-09-21 06:13:14.443+00', 11630.1), ('2023-09-21 06:14:16.033+00', 11630.5), ('2023-09-21 06:15:16.215+00', 11631),
('2023-09-21 06:16:16.338+00', 11631.4), ('2023-09-21 06:17:14.444+00', 11631.9), ('2023-09-21 06:18:15.135+00', 11632.3), ('2023-09-21 06:19:13.871+00', 11632.8), ('2023-09-21 06:20:14.107+00', 11633.2),
('2023-09-21 06:21:12.515+00', 11633.7), ('2023-09-21 06:22:13.252+00', 11634.1), ('2023-09-21 06:23:13.651+00', 11634.6), ('2023-09-21 06:24:14.148+00', 11635.1), ('2023-09-21 06:25:12.924+00', 11635.5),
('2023-09-21 06:26:13.286+00', 11636), ('2023-09-21 06:27:11.948+00', 11636.4), ('2023-09-21 06:28:12.262+00', 11636.9), ('2023-09-21 06:29:13.047+00', 11637.3), ('2023-09-21 06:30:11.366+00', 11637.8),
('2023-09-21 06:31:11.891+00', 11638.2), ('2023-09-21 06:32:12.416+00', 11638.7), ('2023-09-21 06:33:11.149+00', 11639.2), ('2023-09-21 06:34:11.408+00', 11639.6), ('2023-09-21 06:35:11.948+00', 11640.1),
('2023-09-21 06:36:10.468+00', 11640.5), ('2023-09-21 06:37:11.025+00', 11641), ('2023-09-21 06:38:09.54+00', 11641.4), ('2023-09-21 06:39:10.056+00', 11641.9), ('2023-09-21 06:40:10.609+00', 11642.4),
('2023-09-21 06:41:09.119+00', 11642.8), ('2023-09-21 06:42:09.584+00', 11643.3), ('2023-09-21 06:43:10.271+00', 11643.7), ('2023-09-21 06:44:08.672+00', 11644.2), ('2023-09-21 06:45:09.145+00', 11644.6),
('2023-09-21 06:46:09.605+00', 11645.1), ('2023-09-21 06:47:11.081+00', 11645.6), ('2023-09-21 06:48:11.102+00', 11646), ('2023-09-21 06:49:10.165+00', 11646.5), ('2023-09-21 06:50:10.302+00', 11646.9),
('2023-09-21 06:51:10.416+00', 11647.4), ('2023-09-21 06:52:10.651+00', 11647.8), ('2023-09-21 06:53:10.815+00', 11648.3), ('2023-09-21 06:54:11.113+00', 11648.8), ('2023-09-21 06:55:11.041+00', 11649.2),
('2023-09-21 06:56:11.373+00', 11649.7), ('2023-09-21 06:57:10.195+00', 11650.1), ('2023-09-21 06:58:10.392+00', 11650.6), ('2023-09-21 06:59:10.447+00', 11651), ('2023-09-21 07:00:10.605+00', 11651.5),
('2023-09-21 07:01:10.186+00', 11652), ('2023-09-21 07:02:10.96+00', 11652.4), ('2023-09-21 07:03:11.098+00', 11652.9), ('2023-09-21 07:04:11.103+00', 11653.3), ('2023-09-21 07:05:10.124+00', 11653.8),
('2023-09-21 07:06:10.018+00', 11654.2), ('2023-09-21 07:07:04.697+00', 11654.7), ('2023-09-21 07:08:05.308+00', 11655.2), ('2023-09-21 07:09:05.957+00', 11655.6), ('2023-09-21 07:10:05.837+00', 11656.1),
('2023-09-21 07:11:05.948+00', 11656.5), ('2023-09-21 07:12:06.985+00', 11657), ('2023-09-21 07:13:03.86+00', 11657.4), ('2023-09-21 07:14:04.378+00', 11657.9), ('2023-09-21 07:15:04.933+00', 11658.3),
('2023-09-21 07:16:03.452+00', 11658.8), ('2023-09-21 07:17:03.96+00', 11659.3), ('2023-09-21 07:18:02.426+00', 11659.7), ('2023-09-21 07:19:02.987+00', 11660.2), ('2023-09-21 07:20:03.485+00', 11660.6),
('2023-09-21 07:21:01.898+00', 11661.1), ('2023-09-21 07:22:02.569+00', 11661.5), ('2023-09-21 07:23:03.288+00', 11662), ('2023-09-21 07:24:01.604+00', 11662.5), ('2023-09-21 07:25:02.039+00', 11662.9),
('2023-09-21 07:26:02.688+00', 11663.4), ('2023-09-21 07:27:01.368+00', 11663.8), ('2023-09-21 07:28:01.709+00', 11664.3), ('2023-09-21 07:29:02.413+00', 11664.7), ('2023-09-21 07:30:03.995+00', 11665.2),
('2023-09-21 07:31:04.014+00', 11665.6), ('2023-09-21 07:32:04.187+00', 11666.1), ('2023-09-21 07:33:04.579+00', 11666.6), ('2023-09-21 07:34:04.576+00', 11667), ('2023-09-21 07:35:04.743+00', 11667.5),
('2023-09-21 07:36:04.816+00', 11667.9), ('2023-09-21 07:37:03.935+00', 11668.4), ('2023-09-21 07:38:03.944+00', 11668.8), ('2023-09-21 07:39:04.262+00', 11669.3), ('2023-09-21 07:40:04.182+00', 11669.7),
('2023-09-21 07:40:58.554+00', 11670.2), ('2023-09-21 07:41:59.049+00', 11670.6), ('2023-09-21 07:42:59.797+00', 11671.1), ('2023-09-21 07:43:58.071+00', 11671.6), ('2023-09-21 07:44:58.855+00', 11672),
('2023-09-21 07:45:59.156+00', 11672.5), ('2023-09-21 07:46:57.866+00', 11672.9), ('2023-09-21 07:47:58.175+00', 11673.4), ('2023-09-21 07:48:58.634+00', 11673.8), ('2023-09-21 07:49:57.234+00', 11674.3),
('2023-09-21 07:50:57.819+00', 11674.7), ('2023-09-21 07:51:58.313+00', 11675.2), ('2023-09-21 07:52:56.995+00', 11675.6), ('2023-09-21 07:53:57.402+00', 11676.1), ('2023-09-21 07:54:55.891+00', 11676.6),
('2023-09-21 07:55:56.369+00', 11677), ('2023-09-21 07:56:57.119+00', 11677.5), ('2023-09-21 07:57:55.453+00', 11677.9), ('2023-09-21 07:58:56.174+00', 11678.4), ('2023-09-21 07:59:56.469+00', 11678.8),
('2023-09-21 08:00:55.199+00', 11679.3), ('2023-09-21 08:01:55.557+00', 11679.7), ('2023-09-21 08:02:56.072+00', 11680.2), ('2023-09-21 08:03:54.811+00', 11680.6), ('2023-09-21 08:04:55.138+00', 11681.1),
('2023-09-21 08:05:55.696+00', 11681.6), ('2023-09-21 08:06:54.367+00', 11682),('2023-09-21 08:07:54.539+00', 11682.5), ('2023-09-21 08:08:55.395+00', 11682.9), ('2023-09-21 08:09:53.689+00', 11683.4),
('2023-09-21 08:10:54.472+00', 11683.8), ('2023-09-21 08:11:52.816+00', 11684.3),('2023-09-21 08:12:53.36+00', 11684.7), ('2023-09-21 08:13:53.873+00', 11685.2), ('2023-09-21 08:14:52.398+00', 11685.6),
('2023-09-21 08:15:53.109+00', 11686.1), ('2023-09-21 08:16:53.569+00', 11686.5), ('2023-09-21 08:17:51.902+00', 11687), ('2023-09-21 08:18:52.423+00', 11687.5), ('2023-09-21 08:19:53.196+00', 11687.9),
('2023-09-21 08:20:51.481+00', 11688.4), ('2023-09-21 08:21:52.268+00', 11688.8),('2023-09-21 08:22:53.475+00', 11689.3), ('2023-09-21 08:23:53.368+00', 11689.7), ('2023-09-21 08:24:51.489+00', 11690.2),
('2023-09-21 08:25:50.098+00', 11690.6), ('2023-09-21 08:26:50.545+00', 11691.1), ('2023-09-21 08:27:51.451+00', 11691.5), ('2023-09-21 08:28:51.869+00', 11692), ('2023-09-21 08:29:50.213+00', 11692.5),
('2023-09-21 08:30:50.808+00', 11692.9), ('2023-09-21 08:31:49.158+00', 11693.4), ('2023-09-21 08:32:49.82+00', 11693.8), ('2023-09-21 08:33:50.416+00', 11694.3), ('2023-09-21 08:34:48.849+00', 11694.7),
('2023-09-21 08:35:49.29+00', 11695.2), ('2023-09-21 08:36:49.922+00', 11695.6), ('2023-09-21 08:37:48.329+00', 11696.1), ('2023-09-21 08:38:48.988+00', 11696.6), ('2023-09-21 08:39:49.492+00', 11697),
('2023-09-21 08:40:47.935+00', 11697.5), ('2023-09-21 08:41:48.595+00', 11697.9), ('2023-09-21 08:42:47.033+00', 11698.4), ('2023-09-21 08:43:47.533+00', 11698.8), ('2023-09-21 08:44:48.1+00', 11699.3),
('2023-09-21 08:45:48.509+00', 11699.7), ('2023-09-21 08:46:47.043+00', 11700.2), ('2023-09-21 08:47:47.651+00', 11700.6), ('2023-09-21 08:48:48.275+00', 11701.1), ('2023-09-21 08:49:46.592+00', 11701.5),
('2023-09-21 08:50:47.252+00', 11702), ('2023-09-21 08:51:45.76+00', 11702.5), ('2023-09-21 08:52:46.439+00', 11702.9), ('2023-09-21 08:53:46.835+00', 11703.4), ('2023-09-21 08:54:45.358+00', 11703.8),
('2023-09-21 08:55:46.072+00', 11704.3), ('2023-09-21 08:56:46.419+00', 11704.7), ('2023-09-21 08:57:45.119+00', 11705.2), ('2023-09-21 08:58:45.536+00', 11705.6), ('2023-09-21 08:59:45.95+00', 11706.1),
('2023-09-21 09:00:44.454+00', 11706.5), ('2023-09-21 09:01:45.887+00', 11707), ('2023-09-21 09:02:45.451+00', 11707.4), ('2023-09-21 09:03:43.964+00', 11707.9), ('2023-09-21 09:04:44.669+00', 11708.4),
('2023-09-21 09:05:43.095+00', 11708.8), ('2023-09-21 09:06:43.746+00', 11709.3), ('2023-09-21 09:07:44.38+00', 11709.7), ('2023-09-21 09:08:42.674+00', 11710.2), ('2023-09-21 09:09:43.368+00', 11710.6),
('2023-09-21 09:10:43.729+00', 11711.1), ('2023-09-21 09:11:42.397+00', 11711.5), ('2023-09-21 09:12:42.799+00', 11712), ('2023-09-21 09:13:43.478+00', 11712.4), ('2023-09-21 09:14:41.831+00', 11712.9),
('2023-09-21 09:15:42.571+00', 11713.4), ('2023-09-21 09:16:42.938+00', 11713.8), ('2023-09-21 09:17:41.378+00', 11714.3), ('2023-09-21 09:18:41.944+00', 11714.7), ('2023-09-21 09:19:42.644+00', 11715.2),
('2023-09-21 09:20:40.934+00', 11715.6), ('2023-09-21 09:21:41.641+00', 11716.1), ('2023-09-21 09:22:41.987+00', 11716.5), ('2023-09-21 09:23:40.707+00', 11717), ('2023-09-21 09:24:41.053+00', 11717.5),
('2023-09-21 09:25:41.714+00', 11717.9), ('2023-09-21 09:26:40.355+00', 11718.4), ('2023-09-21 09:27:40.575+00', 11718.8), ('2023-09-21 09:28:40.676+00', 11719.3), ('2023-09-21 09:29:40.733+00', 11719.8),
('2023-09-21 09:30:40.143+00', 11720.2), ('2023-09-21 09:31:39.855+00', 11720.7), ('2023-09-21 09:32:40.03+00', 11721.2), ('2023-09-21 09:33:40.392+00', 11721.6), ('2023-09-21 09:34:40.367+00', 11722.1),
('2023-09-21 09:35:40.537+00', 11722.6), ('2023-09-21 09:36:40.654+00', 11723), ('2023-09-21 09:37:40.918+00', 11723.5), ('2023-09-21 09:38:39.712+00', 11724), ('2023-09-21 09:39:40.146+00', 11724.4),
('2023-09-21 09:40:39.999+00', 11724.9), ('2023-09-21 09:41:40.216+00', 11725.4), ('2023-09-21 09:42:40.392+00', 11725.8), ('2023-09-21 09:43:40.541+00', 11726.3), ('2023-09-21 09:44:40.68+00', 11726.8),
('2023-09-21 09:45:40.815+00', 11727.2), ('2023-09-21 09:46:40.768+00', 11727.7), ('2023-09-21 09:47:40.039+00', 11728.1), ('2023-09-21 09:48:40.001+00', 11728.6), ('2023-09-21 09:49:36.444+00', 11729.1),
('2023-09-21 09:50:36.697+00', 11729.5), ('2023-09-21 09:51:35.355+00', 11730), ('2023-09-21 09:52:35.677+00', 11730.5), ('2023-09-21 09:53:36.315+00', 11730.9), ('2023-09-21 09:54:34.723+00', 11731.4),
('2023-09-21 09:55:35.299+00', 11731.9), ('2023-09-21 09:56:35.851+00', 11732.3), ('2023-09-21 09:57:34.322+00', 11732.8), ('2023-09-21 09:58:35.417+00', 11733.2), ('2023-09-21 09:59:35.401+00', 11733.7),
('2023-09-21 10:00:35.567+00', 11734.2), ('2023-09-21 10:01:35.55+00', 11734.6), ('2023-09-21 10:02:34.606+00', 11735.1), ('2023-09-21 10:03:34.787+00', 11735.6), ('2023-09-21 10:04:35.087+00', 11736),
('2023-09-21 10:05:35.1+00', 11736.5), ('2023-09-21 10:06:35.482+00', 11737), ('2023-09-21 10:07:38.022+00', 11737.4), ('2023-09-21 10:08:32.068+00', 11737.9), ('2023-09-21 10:09:32.563+00', 11738.4),
('2023-09-21 10:10:34.745+00', 11738.8), ('2023-09-21 10:11:31.612+00', 11739.3), ('2023-09-21 10:12:32.372+00', 11739.8), ('2023-09-21 10:13:30.661+00', 11740.2), ('2023-09-21 10:14:31.241+00', 11740.7),
('2023-09-21 10:15:31.732+00', 11741.1), ('2023-09-21 10:16:30.403+00', 11741.6), ('2023-09-21 10:17:30.774+00', 11742.1), ('2023-09-21 10:18:31.534+00', 11742.5), ('2023-09-21 10:19:29.866+00', 11743),
('2023-09-21 10:20:30.35+00', 11743.5),('2023-09-21 10:21:30.874+00', 11743.9), ('2023-09-21 10:22:29.553+00', 11744.4), ('2023-09-21 10:23:29.869+00', 11744.9), ('2023-09-21 10:24:30.676+00', 11745.3),
('2023-09-21 10:25:28.967+00', 11745.8), ('2023-09-21 10:26:29.472+00', 11746.2), ('2023-09-21 10:27:29.967+00', 11746.7), ('2023-09-21 10:28:28.424+00', 11747.2), ('2023-09-21 10:29:31.324+00', 11747.6),
('2023-09-21 10:30:31.457+00', 11748.1), ('2023-09-21 10:31:30.26+00', 11748.6), ('2023-09-21 10:32:28.606+00', 11749), ('2023-09-21 10:33:29.332+00', 11749.5), ('2023-09-21 10:34:29.651+00', 11750),
('2023-09-21 10:35:29.608+00', 11750.4), ('2023-09-21 10:36:29.987+00', 11750.9), ('2023-09-21 10:37:30.03+00', 11751.3), ('2023-09-21 10:38:30.122+00', 11751.8), ('2023-09-21 10:39:28.979+00', 11752.3),
('2023-09-21 10:40:29.138+00', 11752.7), ('2023-09-21 10:41:29.347+00', 11753.2), ('2023-09-21 10:42:29.681+00', 11753.6), ('2023-09-21 10:43:29.631+00', 11754.1), ('2023-09-21 10:44:29.887+00', 11754.6),
('2023-09-21 10:45:29.97+00', 11755), ('2023-09-21 10:46:30.025+00', 11755.5), ('2023-09-21 10:47:29.226+00', 11755.9), ('2023-09-21 10:48:29.189+00', 11756.4), ('2023-09-21 10:49:29.301+00', 11756.8),
('2023-09-21 10:50:29.486+00', 11757.3), ('2023-09-21 10:51:29.688+00', 11757.8), ('2023-09-21 10:52:29.971+00', 11758.2), ('2023-09-21 10:53:29.963+00', 11758.7), ('2023-09-21 10:54:30.021+00', 11759.1),
('2023-09-21 10:55:28.991+00', 11759.6), ('2023-09-21 10:56:23.028+00', 11760), ('2023-09-21 10:57:23.685+00', 11760.5), ('2023-09-21 10:58:24.122+00', 11761), ('2023-09-21 10:59:24.993+00', 11761.4),
('2023-09-21 11:00:24.91+00', 11761.9), ('2023-09-21 11:01:28.903+00', 11762.3), ('2023-09-21 11:02:22.265+00', 11762.8), ('2023-09-21 11:03:25.233+00', 11763.2), ('2023-09-21 11:04:26.619+00', 11763.7),
('2023-09-21 11:05:26.779+00', 11764.2), ('2023-09-21 11:06:27.107+00', 11764.6), ('2023-09-21 11:07:27.037+00', 11765.1), ('2023-09-21 11:08:27.222+00', 11765.5), ('2023-09-21 11:09:27.252+00', 11766),
('2023-09-21 11:10:26.536+00', 11766.4), ('2023-09-21 11:11:21.076+00', 11766.9), ('2023-09-21 11:12:21.514+00', 11767.3), ('2023-09-21 11:13:22.228+00', 11767.8), ('2023-09-21 11:14:20.66+00', 11768.2),
('2023-09-21 11:15:21.099+00', 11768.7), ('2023-09-21 11:16:19.7+00', 11769.1), ('2023-09-21 11:17:20.101+00', 11769.6), ('2023-09-21 11:18:20.629+00', 11770.1), ('2023-09-21 11:19:19.144+00', 11770.5),
('2023-09-21 11:20:19.682+00', 11771), ('2023-09-21 11:21:20.096+00', 11771.4), ('2023-09-21 11:22:18.827+00', 11771.9), ('2023-09-21 11:23:19.092+00', 11772.3), ('2023-09-21 11:24:19.848+00', 11772.8),
('2023-09-21 11:25:18.18+00', 11773.2), ('2023-09-21 11:26:18.847+00', 11773.7), ('2023-09-21 11:27:19.375+00', 11774.1), ('2023-09-21 11:28:17.932+00', 11774.6), ('2023-09-21 11:29:18.24+00', 11775),
('2023-09-21 11:30:16.906+00', 11775.5), ('2023-09-21 11:31:17.314+00', 11775.9), ('2023-09-21 11:32:20.845+00', 11776.4), ('2023-09-21 11:33:18.501+00', 11776.9), ('2023-09-21 11:34:17.06+00', 11777.3),
('2023-09-21 11:35:17.405+00', 11777.8), ('2023-09-21 11:36:16.025+00', 11778.2), ('2023-09-21 11:37:16.534+00', 11778.7), ('2023-09-21 11:38:16.981+00', 11779.1), ('2023-09-21 11:39:15.554+00', 11779.6),
('2023-09-21 11:40:16.115+00', 11780), ('2023-09-21 11:41:16.68+00', 11780.5), ('2023-09-21 11:42:15.136+00', 11780.9), ('2023-09-21 11:43:15.916+00', 11781.4), ('2023-09-21 11:44:16.234+00', 11781.8),
('2023-09-21 11:45:14.933+00', 11782.3), ('2023-09-21 11:46:15.224+00', 11782.7), ('2023-09-21 11:47:15.665+00', 11783.2), ('2023-09-21 11:48:14.307+00', 11783.6), ('2023-09-21 11:49:14.827+00', 11784.1),
('2023-09-21 11:50:18.735+00', 11784.5), ('2023-09-21 11:51:16.13+00', 11785), ('2023-09-21 11:52:16.147+00', 11785.4), ('2023-09-21 11:53:15.412+00', 11785.9), ('2023-09-21 11:54:15.415+00', 11786.3),
('2023-09-21 11:55:15.755+00', 11786.8), ('2023-09-21 11:56:15.768+00', 11787.2), ('2023-09-21 11:57:16.069+00', 11787.7), ('2023-09-21 11:58:16.037+00', 11788.1), ('2023-09-21 11:59:16.23+00', 11788.6),
('2023-09-21 12:00:16.24+00', 11789), ('2023-09-21 12:01:12.992+00', 11789.5), ('2023-09-21 12:02:11.59+00', 11789.9), ('2023-09-21 12:03:12.348+00', 11790.4), ('2023-09-21 12:04:12.664+00', 11790.8),
('2023-09-21 12:05:11.419+00', 11791.3), ('2023-09-21 12:06:11.719+00', 11791.7), ('2023-09-21 12:07:10.443+00', 11792.2), ('2023-09-21 12:08:10.8+00', 11792.6), ('2023-09-21 12:09:11.316+00', 11793.1),
('2023-09-21 12:10:09.786+00', 11793.5), ('2023-09-21 12:11:10.404+00', 11794), ('2023-09-21 12:12:10.908+00', 11794.4), ('2023-09-21 12:13:10.951+00', 11794.9), ('2023-09-21 12:14:10.929+00', 11795.3),
('2023-09-21 12:15:11.16+00', 11795.8), ('2023-09-21 12:16:11.263+00', 11796.2), ('2023-09-21 12:17:09.518+00', 11796.6), ('2023-09-21 12:18:10.283+00', 11797.1), ('2023-09-21 12:19:10.559+00', 11797.5),
('2023-09-21 12:20:11.842+00', 11798), ('2023-09-21 12:21:09.596+00', 11798.4), ('2023-09-21 12:22:08.003+00', 11798.9), ('2023-09-21 12:23:08.591+00', 11799.3), ('2023-09-21 12:24:09.11+00', 11799.8),
('2023-09-21 12:25:07.746+00', 11800.2), ('2023-09-21 12:26:08.472+00', 11800.7), ('2023-09-21 12:27:06.725+00', 11801.1), ('2023-09-21 12:28:07.322+00', 11801.6), ('2023-09-21 12:29:07.773+00', 11802),
('2023-09-21 12:30:06.47+00', 11802.4), ('2023-09-21 12:31:06.836+00', 11802.9), ('2023-09-21 12:32:07.465+00', 11803.3), ('2023-09-21 12:33:05.827+00', 11803.8), ('2023-09-21 12:34:06.427+00', 11804.2),
('2023-09-21 12:35:06.883+00', 11804.7), ('2023-09-21 12:36:05.623+00', 11805.1), ('2023-09-21 12:37:09.441+00', 11805.6), ('2023-09-21 12:38:09.018+00', 11806), ('2023-09-21 12:39:09.77+00', 11806.5),
('2023-09-21 12:40:05.987+00', 11806.9), ('2023-09-21 12:41:06.134+00', 11807.4), ('2023-09-21 12:42:04.763+00', 11807.8), ('2023-09-21 12:43:05.215+00', 11808.3), ('2023-09-21 12:44:03.786+00', 11808.7),
('2023-09-21 12:45:06.96+00', 11809.2), ('2023-09-21 12:46:07.047+00', 11809.6), ('2023-09-21 12:47:03.313+00', 11810.1), ('2023-09-21 12:48:03.766+00', 11810.5), ('2023-09-21 12:49:04.268+00', 11811),
('2023-09-21 12:50:02.874+00', 11811.4), ('2023-09-21 12:51:03.321+00', 11811.8), ('2023-09-21 12:52:04.015+00', 11812.3), ('2023-09-21 12:53:02.348+00', 11812.7), ('2023-09-21 12:54:02.87+00', 11813.2),
('2023-09-21 12:55:03.392+00', 11813.6), ('2023-09-21 12:56:02.056+00', 11814.1), ('2023-09-21 12:57:02.546+00', 11814.5), ('2023-09-21 12:58:06.511+00', 11815), ('2023-09-21 12:59:02.926+00', 11815.4),
('2023-09-21 13:00:02.203+00', 11815.9), ('2023-09-21 13:01:00.586+00', 11816.3), ('2023-09-21 13:02:01.156+00', 11816.8), ('2023-09-21 13:03:01.737+00', 11817.2), ('2023-09-21 13:04:00.227+00', 11817.7),
('2023-09-21 13:05:00.75+00', 11818.1), ('2023-09-21 13:06:01.276+00', 11818.6), ('2023-09-21 13:07:00.013+00', 11819), ('2023-09-21 13:08:00.403+00', 11819.5), ('2023-09-21 13:09:00.719+00', 11819.9),
('2023-09-21 13:10:00.882+00', 11820.4), ('2023-09-21 13:11:03.409+00', 11820.8), ('2023-09-21 13:12:00.495+00', 11821.3), ('2023-09-21 13:12:58.86+00', 11821.7), ('2023-09-21 13:14:03.981+00', 11822.2),
('2023-09-21 13:15:00.279+00', 11822.6), ('2023-09-21 13:16:00.353+00', 11823.1), ('2023-09-21 13:17:00.498+00', 11823.5), ('2023-09-21 13:17:57.688+00', 11824), ('2023-09-21 13:18:57.933+00', 11824.4),
('2023-09-21 13:19:58.472+00', 11824.9), ('2023-09-21 13:20:57.313+00', 11825.3), ('2023-09-21 13:21:57.631+00', 11825.8), ('2023-09-21 13:22:58.245+00', 11826.2), ('2023-09-21 13:24:01.669+00', 11826.7),
('2023-09-21 13:25:02.019+00', 11827.1), ('2023-09-21 13:26:02.019+00', 11827.6), ('2023-09-21 13:26:59.552+00', 11828), ('2023-09-21 13:27:59.704+00', 11828.5), ('2023-09-21 13:28:58.61+00', 11828.9),
('2023-09-21 13:29:58.764+00', 11829.4), ('2023-09-21 13:30:58.875+00', 11829.8), ('2023-09-21 13:31:59.107+00', 11830.3), ('2023-09-21 13:33:00.545+00', 11830.7), ('2023-09-21 13:34:00.709+00', 11831.2),
('2023-09-21 13:35:00.857+00', 11831.6), ('2023-09-21 13:35:54.972+00', 11832.1), ('2023-09-21 13:36:55.494+00', 11832.5), ('2023-09-21 13:37:54.207+00', 11833), ('2023-09-21 13:38:54.571+00', 11833.4),
('2023-09-21 13:39:55.053+00', 11833.9), ('2023-09-21 13:40:53.604+00', 11834.3), ('2023-09-21 13:41:54.32+00', 11834.8), ('2023-09-21 13:42:54.624+00', 11835.2), ('2023-09-21 13:43:53.368+00', 11835.7),
('2023-09-21 13:44:53.689+00', 11836.1), ('2023-09-21 13:45:54.473+00', 11836.6), ('2023-09-21 13:46:52.757+00', 11837), ('2023-09-21 13:47:53.142+00', 11837.5), ('2023-09-21 13:48:53.979+00', 11837.9),
('2023-09-21 13:49:52.222+00', 11838.4), ('2023-09-21 13:50:52.906+00', 11838.8), ('2023-09-21 13:51:51.387+00', 11839.3), ('2023-09-21 13:52:52.112+00', 11839.7), ('2023-09-21 13:53:52.454+00', 11840.2),
('2023-09-21 13:54:51.235+00', 11840.6), ('2023-09-21 13:55:51.653+00', 11841.1), ('2023-09-21 13:56:52.024+00', 11841.5), ('2023-09-21 13:57:50.473+00', 11842), ('2023-09-21 13:58:51.15+00', 11842.4),
('2023-09-21 13:59:51.573+00', 11842.9), ('2023-09-21 14:00:50.873+00', 11843.3), ('2023-09-21 14:01:51.317+00', 11843.8), ('2023-09-21 14:02:51.287+00', 11844.2), ('2023-09-21 14:03:51.571+00', 11844.7),
('2023-09-21 14:04:50.797+00', 11845.1), ('2023-09-21 14:05:50.74+00', 11845.6), ('2023-09-21 14:06:50.578+00', 11846), ('2023-09-21 14:07:51.149+00', 11846.5), ('2023-09-21 14:08:51.828+00', 11846.9),
('2023-09-21 14:09:51.077+00', 11847.4), ('2023-09-21 14:10:52.151+00', 11847.8), ('2023-09-21 14:11:51.228+00', 11848.3), ('2023-09-21 14:12:50.821+00', 11848.7), ('2023-09-21 14:13:50.41+00', 11849.2),
('2023-09-21 14:14:50.543+00', 11849.6), ('2023-09-21 14:15:50.756+00', 11850.1), ('2023-09-21 14:16:50.795+00', 11850.5), ('2023-09-21 14:17:51.059+00', 11851), ('2023-09-21 14:18:47.501+00', 11851.4),
('2023-09-21 14:19:47.927+00', 11851.9), ('2023-09-21 14:20:46.57+00', 11852.3), ('2023-09-21 14:21:47.108+00', 11852.8), ('2023-09-21 14:22:47.755+00', 11853.2), ('2023-09-21 14:23:46.144+00', 11853.7),
('2023-09-21 14:24:46.648+00', 11854.1), ('2023-09-21 14:25:46.147+00', 11854.6), ('2023-09-21 14:26:46.139+00', 11855), ('2023-09-21 14:27:46.272+00', 11855.5), ('2023-09-21 14:28:46.812+00', 11855.9),
('2023-09-21 14:29:45.342+00', 11856.4), ('2023-09-21 14:30:45.802+00', 11856.8), ('2023-09-21 14:31:44.242+00', 11857.3), ('2023-09-21 14:32:44.867+00', 11857.7), ('2023-09-21 14:33:51.275+00', 11858.2),
('2023-09-21 14:34:43.904+00', 11858.6), ('2023-09-21 14:35:44.441+00', 11859.1), ('2023-09-21 14:36:44.998+00', 11859.5), ('2023-09-21 14:37:43.419+00', 11860), ('2023-09-21 14:38:44.052+00', 11860.4),
('2023-09-21 14:39:44.584+00', 11860.9), ('2023-09-21 14:40:43.036+00', 11861.3), ('2023-09-21 14:41:43.614+00', 11861.8), ('2023-09-21 14:42:42.136+00', 11862.2), ('2023-09-21 14:43:42.857+00', 11862.7),
('2023-09-21 14:44:43.092+00', 11863.1), ('2023-09-21 14:45:43.633+00', 11863.6), ('2023-09-21 14:46:42.493+00', 11864), ('2023-09-21 14:47:42.746+00', 11864.5), ('2023-09-21 14:48:41.239+00', 11864.9),
('2023-09-21 14:49:41.806+00', 11865.4), ('2023-09-21 14:50:42.36+00', 11865.8), ('2023-09-21 14:51:41.334+00', 11866.2), ('2023-09-21 14:52:41.364+00', 11866.7), ('2023-09-21 14:53:42.106+00', 11867.1),
('2023-09-21 14:54:41.611+00', 11867.6), ('2023-09-21 14:55:40.985+00', 11868), ('2023-09-21 14:56:41.471+00', 11868.5), ('2023-09-21 14:57:40.907+00', 11868.9), ('2023-09-21 14:58:41.05+00', 11869.4),
('2023-09-21 14:59:41.333+00', 11869.8), ('2023-09-21 15:00:41.325+00', 11870.3), ('2023-09-21 15:01:41.489+00', 11870.7), ('2023-09-21 15:02:41.82+00', 11871.2), ('2023-09-21 15:03:40.576+00', 11871.6),
('2023-09-21 15:04:41.613+00', 11872.1), ('2023-09-21 15:05:40.874+00', 11872.5), ('2023-09-21 15:06:41.058+00', 11873), ('2023-09-21 15:07:41.308+00', 11873.4), ('2023-09-21 15:08:41.305+00', 11873.9),
('2023-09-21 15:09:41.686+00', 11874.3), ('2023-09-21 15:10:41.624+00', 11874.8), ('2023-09-21 15:11:40.526+00', 11875.2), ('2023-09-21 15:12:40.874+00', 11875.7), ('2023-09-21 15:13:40.826+00', 11876.1),
('2023-09-21 15:14:41.218+00', 11876.6), ('2023-09-21 15:15:41.148+00', 11877), ('2023-09-21 15:16:41.344+00', 11877.5), ('2023-09-21 15:17:41.694+00', 11877.9), ('2023-09-21 15:18:41.597+00', 11878.4),
('2023-09-21 15:19:41.933+00', 11878.8), ('2023-09-21 15:20:40.748+00', 11879.3), ('2023-09-21 15:21:40.84+00', 11879.7), ('2023-09-21 15:22:41.175+00', 11880.2), ('2023-09-21 15:23:41.204+00', 11880.6),
('2023-09-21 15:24:41.363+00', 11881.1), ('2023-09-21 15:25:41.679+00', 11881.5), ('2023-09-21 15:26:35.239+00', 11882), ('2023-09-21 15:27:41.761+00', 11882.4), ('2023-09-21 15:28:34.231+00', 11882.9),
('2023-09-21 15:29:34.765+00', 11883.3), ('2023-09-21 15:30:35.519+00', 11883.8), ('2023-09-21 15:31:33.727+00', 11884.2), ('2023-09-21 15:32:34.382+00', 11884.7), ('2023-09-21 15:33:34.907+00', 11885.1),
('2023-09-21 15:34:33.395+00', 11885.5), ('2023-09-21 15:35:33.933+00', 11886), ('2023-09-21 15:36:32.429+00', 11886.4), ('2023-09-21 15:37:33.164+00', 11886.9), ('2023-09-21 15:38:33.509+00', 11887.3),
('2023-09-21 15:39:36.092+00', 11887.8), ('2023-09-21 15:40:36.234+00', 11888.2), ('2023-09-21 15:41:36.341+00', 11888.7), ('2023-09-21 15:42:36.51+00', 11889.1), ('2023-09-21 15:43:36.884+00', 11889.5),
('2023-09-21 15:44:36.744+00', 11890), ('2023-09-21 15:45:35.923+00', 11890.4), ('2023-09-21 15:46:35.842+00', 11890.9), ('2023-09-21 15:47:36.243+00', 11891.3), ('2023-09-21 15:48:36.188+00', 11891.8),
('2023-09-21 15:49:36.405+00', 11892.2), ('2023-09-21 15:50:36.517+00', 11892.7), ('2023-09-21 15:51:30.52+00', 11893.1), ('2023-09-21 15:52:30.82+00', 11893.5), ('2023-09-21 15:53:31.578+00', 11894),
('2023-09-21 15:54:29.937+00', 11894.4), ('2023-09-21 15:55:30.613+00', 11894.9), ('2023-09-21 15:56:30.967+00', 11895.3), ('2023-09-21 15:57:29.658+00', 11895.8), ('2023-09-21 15:58:30.028+00', 11896.2),
('2023-09-21 15:59:28.505+00', 11896.6), ('2023-09-21 16:00:29.05+00', 11897.1), ('2023-09-21 16:01:29.795+00', 11897.5), ('2023-09-21 16:02:28.036+00', 11898), ('2023-09-21 16:03:28.822+00', 11898.4),
('2023-09-21 16:04:29.125+00', 11898.9), ('2023-09-21 16:05:27.837+00', 11899.3), ('2023-09-21 16:06:28.168+00', 11899.7), ('2023-09-21 16:07:28.893+00', 11900.2), ('2023-09-21 16:08:27.245+00', 11900.6),
('2023-09-21 16:09:27.794+00', 11901.1), ('2023-09-21 16:10:28.277+00', 11901.5), ('2023-09-21 16:11:26.959+00', 11901.9), ('2023-09-21 16:12:27.303+00', 11902.4), ('2023-09-21 16:13:26.305+00', 11902.8),
('2023-09-21 16:14:26.366+00', 11903.3), ('2023-09-21 16:15:27.073+00', 11903.7), ('2023-09-21 16:16:27.427+00', 11904.1), ('2023-09-21 16:17:26.989+00', 11904.6), ('2023-09-21 16:18:26.88+00', 11905),
('2023-09-21 16:19:27.017+00', 11905.5), ('2023-09-21 16:20:25.967+00', 11905.9), ('2023-09-21 16:21:26.123+00', 11906.3), ('2023-09-21 16:22:26.513+00', 11906.8), ('2023-09-21 16:23:26.439+00', 11907.2),
('2023-09-21 16:24:26.644+00', 11907.7), ('2023-09-21 16:25:26.936+00', 11908.1), ('2023-09-21 16:26:26.902+00', 11908.5), ('2023-09-21 16:27:26.927+00', 11909), ('2023-09-21 16:28:26.127+00', 11909.4),
('2023-09-21 16:29:26.163+00', 11909.9), ('2023-09-21 16:30:26.258+00', 11910.3), ('2023-09-21 16:31:26.631+00', 11910.7), ('2023-09-21 16:32:26.61+00', 11911.2), ('2023-09-21 16:33:26.751+00', 11911.6),
('2023-09-21 16:34:27.13+00', 11912.1), ('2023-09-21 16:35:26.984+00', 11912.5), ('2023-09-21 16:36:26.009+00', 11912.9), ('2023-09-21 16:37:26.324+00', 11913.4), ('2023-09-21 16:38:26.316+00', 11913.8),
('2023-09-21 16:39:26.675+00', 11914.2), ('2023-09-21 16:40:26.586+00', 11914.7), ('2023-09-21 16:41:26.758+00', 11915.1), ('2023-09-21 16:42:27.065+00', 11915.6), ('2023-09-21 16:43:26.978+00', 11916),
('2023-09-21 16:44:25.965+00', 11916.4), ('2023-09-21 16:45:20.803+00', 11916.9), ('2023-09-21 16:46:21.124+00', 11917.3), ('2023-09-21 16:47:19.645+00', 11917.8), ('2023-09-21 16:48:20.354+00', 11918.2),
('2023-09-21 16:49:20.767+00', 11918.6), ('2023-09-21 16:50:21.993+00', 11919.1), ('2023-09-21 16:51:22.061+00', 11919.5), ('2023-09-21 16:52:22.221+00', 11920), ('2023-09-21 16:53:21.035+00', 11920.4),
('2023-09-21 16:54:21.347+00', 11920.9), ('2023-09-21 16:55:21.292+00', 11921.3), ('2023-09-21 16:56:21.666+00', 11921.7), ('2023-09-21 16:57:21.613+00', 11922.2), ('2023-09-21 16:58:22.02+00', 11922.6),
('2023-09-21 16:59:17.96+00', 11923.1), ('2023-09-21 17:00:18.735+00', 11923.5), ('2023-09-21 17:01:18.984+00', 11923.9), ('2023-09-21 17:02:17.459+00', 11924.4), ('2023-09-21 17:03:18.003+00', 11924.8),
('2023-09-21 17:04:18.805+00', 11925.3), ('2023-09-21 17:05:17.113+00', 11925.7), ('2023-09-21 17:06:17.785+00', 11926.1), ('2023-09-21 17:07:16.099+00', 11926.6), ('2023-09-21 17:08:16.856+00', 11927),
('2023-09-21 17:09:17.072+00', 11927.5), ('2023-09-21 17:10:17.863+00', 11927.9), ('2023-09-21 17:11:16.189+00', 11928.3), ('2023-09-21 17:12:16.947+00', 11928.8), ('2023-09-21 17:13:15.265+00', 11929.2),
('2023-09-21 17:14:15.981+00', 11929.7), ('2023-09-21 17:15:16.335+00', 11930.1), ('2023-09-21 17:16:15.037+00', 11930.5), ('2023-09-21 17:17:15.352+00', 11931), ('2023-09-21 17:18:16.168+00', 11931.4),
('2023-09-21 17:19:16.251+00', 11931.9), ('2023-09-21 17:20:16.588+00', 11932.3), ('2023-09-21 17:21:16.536+00', 11932.8), ('2023-09-21 17:22:16.865+00', 11933.2), ('2023-09-21 17:23:16.875+00', 11933.6),
('2023-09-21 17:24:17.176+00', 11934.1), ('2023-09-21 17:25:17.147+00', 11934.5), ('2023-09-21 17:26:16.241+00', 11935), ('2023-09-21 17:27:16.208+00', 11935.4), ('2023-09-21 17:28:16.574+00', 11935.8),
('2023-09-21 17:29:16.503+00', 11936.3), ('2023-09-21 17:30:16.863+00', 11936.7), ('2023-09-21 17:31:16.947+00', 11937.2), ('2023-09-21 17:32:17.174+00', 11937.6), ('2023-09-21 17:33:17.14+00', 11938),
('2023-09-21 17:34:17.457+00', 11938.5), ('2023-09-21 17:35:16.257+00', 11938.9), ('2023-09-21 17:36:16.535+00', 11939.4), ('2023-09-21 17:37:16.559+00', 11939.8), ('2023-09-21 17:38:16.888+00', 11940.2),
('2023-09-21 17:39:10.976+00', 11940.7), ('2023-09-21 17:40:11.642+00', 11941.1), ('2023-09-21 17:41:11.999+00', 11941.6), ('2023-09-21 17:42:10.67+00', 11942), ('2023-09-21 17:43:11.007+00', 11942.4),
('2023-09-21 17:44:09.736+00', 11942.9), ('2023-09-21 17:45:10.109+00', 11943.3), ('2023-09-21 17:46:10.56+00', 11943.8), ('2023-09-21 17:47:09.306+00', 11944.2), ('2023-09-21 17:48:09.585+00', 11944.6),
('2023-09-21 17:49:10.437+00', 11945.1), ('2023-09-21 17:50:08.653+00', 11945.5), ('2023-09-21 17:51:09.193+00', 11946), ('2023-09-21 17:52:10.222+00', 11946.4), ('2023-09-21 17:53:08.226+00', 11946.8),
('2023-09-21 17:54:09.018+00', 11947.3), ('2023-09-21 17:55:09.311+00', 11947.7), ('2023-09-21 17:56:07.987+00', 11948.2), ('2023-09-21 17:57:08.348+00', 11948.6), ('2023-09-21 17:58:07.236+00', 11949),
('2023-09-21 17:59:07.364+00', 11949.5), ('2023-09-21 18:00:08.088+00', 11949.9), ('2023-09-21 18:01:08.454+00', 11950.4), ('2023-09-21 18:02:07.135+00', 11950.8), ('2023-09-21 18:03:07.473+00', 11951.3),
('2023-09-21 18:04:08.255+00', 11951.7), ('2023-09-21 18:05:06.918+00', 11952.1), ('2023-09-21 18:06:07.268+00', 11952.6), ('2023-09-21 18:07:07.286+00', 11953), ('2023-09-21 18:08:07.574+00', 11953.5),
('2023-09-21 18:09:06.639+00', 11953.9), ('2023-09-21 18:10:06.595+00', 11954.3), ('2023-09-21 18:11:06.632+00', 11954.8), ('2023-09-21 18:12:06.986+00', 11955.2), ('2023-09-21 18:13:06.962+00', 11955.7),
('2023-09-21 18:14:07.264+00', 11956.1), ('2023-09-21 18:15:07.205+00', 11956.6), ('2023-09-21 18:16:07.619+00', 11957), ('2023-09-21 18:17:06.313+00', 11957.4), ('2023-09-21 18:18:06.624+00', 11957.9),
('2023-09-21 18:19:06.559+00', 11958.3), ('2023-09-21 18:20:07.012+00', 11958.8), ('2023-09-21 18:21:06.909+00', 11959.2), ('2023-09-21 18:22:07.287+00', 11959.6), ('2023-09-21 18:23:07.248+00', 11960.1)
;

-- calculating average works when data is not compressed
SELECT avg(value) FROM corrupt_float8;

-- compress the chunk
SELECT compress_chunk(x) FROM show_chunks('corrupt_float8') x;

-- should work as well when the data is compressed
SELECT avg(value) FROM corrupt_float8;

SELECT extract(day from time) AS day, avg(value) FROM corrupt_float8 GROUP BY 1 ORDER BY 2;

DROP TABLE corrupt_float8;
