/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import java.util.Arrays;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.types.InvalidValueException;

public class DLNACaps {
    final String[] caps;

    public DLNACaps(String[] caps) {
        this.caps = caps;
    }

    public String[] getCaps() {
        return this.caps;
    }

    public static DLNACaps valueOf(String s) throws InvalidValueException {
        if (s == null || s.isEmpty()) {
            return new DLNACaps(new String[0]);
        }
        String[] caps = s.split(",");
        String[] trimmed = new String[caps.length];
        int i = 0;
        while (i < caps.length) {
            trimmed[i] = caps[i].trim();
            ++i;
        }
        return new DLNACaps(trimmed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DLNACaps dlnaCaps = (DLNACaps)o;
        return Arrays.equals(this.caps, dlnaCaps.caps);
    }

    public int hashCode() {
        return Arrays.hashCode(this.caps);
    }

    public String toString() {
        return ModelUtil.toCommaSeparatedList(this.getCaps());
    }
}

