/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.xml.ElementHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MetaTypePropertyResolver
extends DictionaryPropertyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(MetaTypePropertyResolver.class);
    private static final String METATYPE = "OSGI-INF/metatype/metatype.xml";
    private final Dictionary<String, String> properties = MetaTypePropertyResolver.getDefaltProperties();

    public MetaTypePropertyResolver() {
        super((Dictionary)null);
        this.setProperties(this.properties);
    }

    private static Dictionary<String, String> getDefaltProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        try (InputStream stream = MetaTypePropertyResolver.class.getClassLoader().getResourceAsStream(METATYPE);){
            Element[] children;
            Element rootElement = ElementHelper.getRootElement(stream);
            for (Element element : children = ElementHelper.getChildren(rootElement, "AD")) {
                String id = element.getAttribute("id");
                String required = element.getAttribute("required");
                String defaultAttribute = element.getAttribute("default");
                if (Boolean.parseBoolean(required)) {
                    ((Dictionary)properties).put(id, defaultAttribute != null && !"".equals(defaultAttribute.trim()) ? defaultAttribute : null);
                    continue;
                }
                if (defaultAttribute == null || defaultAttribute.length() <= 0) continue;
                ((Dictionary)properties).put(id, defaultAttribute);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error("Could not parse metatype.xml. Reason: " + e.getMessage(), (Throwable)e);
            return properties;
        }
        return properties;
    }

    public Dictionary<String, String> getProperties() {
        return this.properties;
    }
}

