/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.debug.TextRegionAccessToString;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionFinder;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionExtensions;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.LineRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.SemanticRegionNullFinder;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextRegionRewriter;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;

public abstract class AbstractRegionAccess
implements ITextRegionAccess,
ITextRegionExtensions {
    @Override
    public ITextRegionExtensions getExtensions() {
        return this;
    }

    @Override
    public Iterable<ISemanticRegion> allSemanticRegions(EObject object) {
        AbstractEObjectRegion region = this.regionForEObject(object);
        if (region == null) {
            return Collections.emptyList();
        }
        return region.getAllSemanticRegions();
    }

    @Override
    public Iterable<ISemanticRegion> semanticRegions(EObject object) {
        AbstractEObjectRegion region = this.regionForEObject(object);
        if (region == null) {
            return Collections.emptyList();
        }
        return region.getSemanticRegions();
    }

    @Override
    public ISemanticRegionsFinder allRegionsFor(EObject object) {
        AbstractEObjectRegion region = this.regionForEObject(object);
        if (region == null) {
            return SemanticRegionNullFinder.INSTANCE;
        }
        return region.getAllRegionsFor();
    }

    @Override
    public EObject grammarElement(EObject obj) {
        AbstractEObjectRegion tokens = this.regionForEObject(obj);
        if (tokens == null) {
            return null;
        }
        return tokens.getGrammarElement();
    }

    @Override
    public TextRegionRewriter getRewriter() {
        return new TextRegionRewriter(this);
    }

    protected abstract String getText();

    @Override
    public ITextRegionAccess getTextRegionAccess() {
        return this;
    }

    @Override
    public ISemanticRegionFinder immediatelyFollowing(EObject owner) {
        AbstractEObjectRegion region = this.regionForEObject(owner);
        if (region != null) {
            return region.immediatelyFollowing();
        }
        return SemanticRegionNullFinder.INSTANCE;
    }

    @Override
    public ISemanticRegionFinder immediatelyPreceding(EObject owner) {
        AbstractEObjectRegion region = this.regionForEObject(owner);
        if (region != null) {
            return region.immediatelyPreceding();
        }
        return SemanticRegionNullFinder.INSTANCE;
    }

    protected Map<? extends EObject, ? extends AbstractEObjectRegion> initMap() {
        return null;
    }

    @Override
    public boolean isMultiline(EObject object) {
        AbstractEObjectRegion tokens = this.regionForEObject(object);
        if (tokens == null) {
            return false;
        }
        return tokens.isMultiline();
    }

    @Override
    public IHiddenRegion previousHiddenRegion(EObject owner) {
        AbstractEObjectRegion tokens = this.regionForEObject(owner);
        if (tokens == null) {
            return null;
        }
        return tokens.getLeadingHiddenRegion();
    }

    @Override
    public ISemanticRegionsFinder regionFor(EObject object) {
        AbstractEObjectRegion region = this.regionForEObject(object);
        if (region != null) {
            return region.getRegionFor();
        }
        return SemanticRegionNullFinder.INSTANCE;
    }

    @Override
    public abstract AbstractEObjectRegion regionForEObject(EObject var1);

    @Override
    public ILineRegion regionForLineAtOffset(int offset) {
        int end;
        String text = this.getText();
        if (offset < 0 || offset > text.length()) {
            return null;
        }
        int start = text.lastIndexOf(10, offset) + 1;
        if (start < 0) {
            start = 0;
        }
        if ((end = text.indexOf(10, offset + 1)) > 0) {
            if (text.charAt(end - 1) == '\r') {
                --end;
            }
        } else {
            end = text.length();
        }
        return new LineRegion(this, start, end - start);
    }

    @Override
    public ITextSegment regionForOffset(int offset, int length) {
        return new TextSegment(this, offset, length);
    }

    public String toString() {
        return new TextRegionAccessToString().withRegionAccess(this).toString();
    }

    @Override
    public IHiddenRegion nextHiddenRegion(EObject owner) {
        AbstractEObjectRegion tokens = this.regionForEObject(owner);
        if (tokens == null) {
            return null;
        }
        return tokens.getTrailingHiddenRegion();
    }
}

