/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.impl.ModuleToUnnamedBridge;
import org.graalvm.polyglot.io.FileSystem;

final class ModuleToUnnamedFileSystemGen
extends ModuleToUnnamedBridge.ModuleToUnnamedFileSystem {
    private static final Handles HANDLES;
    final Object receiver;

    public ModuleToUnnamedFileSystemGen(Object receiver) {
        this.receiver = Objects.requireNonNull(receiver);
    }

    @Override
    public void checkAccess(Path path_, Set<? extends AccessMode> modes_, LinkOption ... linkOptions_) {
        try {
            ModuleToUnnamedFileSystemGen.HANDLES.checkAccess_.invoke(this.receiver, path_, modes_, linkOptions_);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public void copy(Path source_, Path target_, CopyOption ... options_) {
        try {
            ModuleToUnnamedFileSystemGen.HANDLES.copy_.invoke(this.receiver, source_, target_, options_);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public void createDirectory(Path dir_, FileAttribute<?> ... attrs_) {
        try {
            ModuleToUnnamedFileSystemGen.HANDLES.createDirectory_.invoke(this.receiver, dir_, attrs_);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public void createLink(Path link_, Path existing_) {
        try {
            ModuleToUnnamedFileSystemGen.HANDLES.createLink_.invoke(this.receiver, link_, existing_);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public void createSymbolicLink(Path link_, Path target_, FileAttribute<?> ... attrs_) {
        try {
            ModuleToUnnamedFileSystemGen.HANDLES.createSymbolicLink_.invoke(this.receiver, link_, target_, attrs_);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public void delete(Path path_) {
        try {
            ModuleToUnnamedFileSystemGen.HANDLES.delete_.invoke(this.receiver, path_);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public boolean equals(Object obj_) {
        try {
            boolean result = ModuleToUnnamedFileSystemGen.HANDLES.equals_.invoke(this.receiver, obj_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public Charset getEncoding(Path path_) {
        try {
            Charset result = ModuleToUnnamedFileSystemGen.HANDLES.getEncoding_.invoke(this.receiver, path_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public String getMimeType(Path path_) {
        try {
            String result = ModuleToUnnamedFileSystemGen.HANDLES.getMimeType_.invoke(this.receiver, path_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public String getPathSeparator() {
        try {
            String result = ModuleToUnnamedFileSystemGen.HANDLES.getPathSeparator_.invoke(this.receiver);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public String getSeparator() {
        try {
            String result = ModuleToUnnamedFileSystemGen.HANDLES.getSeparator_.invoke(this.receiver);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public Path getTempDirectory() {
        try {
            Path result = ModuleToUnnamedFileSystemGen.HANDLES.getTempDirectory_.invoke(this.receiver);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public int hashCode() {
        try {
            int result = ModuleToUnnamedFileSystemGen.HANDLES.hashCode_.invoke(this.receiver);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public boolean isSameFile(Path path1_, Path path2_, LinkOption ... options_) {
        try {
            boolean result = ModuleToUnnamedFileSystemGen.HANDLES.isSameFile_.invoke(this.receiver, path1_, path2_, options_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public void move(Path source_, Path target_, CopyOption ... options_) {
        try {
            ModuleToUnnamedFileSystemGen.HANDLES.move_.invoke(this.receiver, source_, target_, options_);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path_, Set<? extends OpenOption> options_, FileAttribute<?> ... attrs_) {
        try {
            SeekableByteChannel result = ModuleToUnnamedFileSystemGen.HANDLES.newByteChannel_.invoke(this.receiver, path_, options_, attrs_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir_, DirectoryStream.Filter<? super Path> filter_) {
        try {
            DirectoryStream result = ModuleToUnnamedFileSystemGen.HANDLES.newDirectoryStream_.invoke(this.receiver, dir_, filter_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public Path parsePath(String path_) {
        try {
            Path result = ModuleToUnnamedFileSystemGen.HANDLES.parsePath_.invoke(this.receiver, path_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public Path parsePath(URI uri_) {
        try {
            Path result = ModuleToUnnamedFileSystemGen.HANDLES.parsePath1_.invoke(this.receiver, uri_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public Map<String, Object> readAttributes(Path path_, String attributes_, LinkOption ... options_) {
        try {
            Map result = ModuleToUnnamedFileSystemGen.HANDLES.readAttributes_.invoke(this.receiver, path_, attributes_, options_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public Path readSymbolicLink(Path link_) {
        try {
            Path result = ModuleToUnnamedFileSystemGen.HANDLES.readSymbolicLink_.invoke(this.receiver, link_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public void setAttribute(Path path_, String attribute_, Object value_, LinkOption ... options_) {
        try {
            ModuleToUnnamedFileSystemGen.HANDLES.setAttribute_.invoke(this.receiver, path_, attribute_, value_, options_);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public void setCurrentWorkingDirectory(Path currentWorkingDirectory_) {
        try {
            ModuleToUnnamedFileSystemGen.HANDLES.setCurrentWorkingDirectory_.invoke(this.receiver, currentWorkingDirectory_);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public Path toAbsolutePath(Path path_) {
        try {
            Path result = ModuleToUnnamedFileSystemGen.HANDLES.toAbsolutePath_.invoke(this.receiver, path_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public Path toRealPath(Path path_, LinkOption ... linkOptions_) {
        try {
            Path result = ModuleToUnnamedFileSystemGen.HANDLES.toRealPath_.invoke(this.receiver, path_, linkOptions_);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    @Override
    public String toString() {
        try {
            String result = ModuleToUnnamedFileSystemGen.HANDLES.toString_.invoke(this.receiver);
            return result;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedFileSystemGen.handleException_(t);
        }
    }

    private static <T extends Throwable> RuntimeException handleException_(Throwable t) throws T {
        throw t;
    }

    static {
        MethodHandles.Lookup lookup = ModuleToUnnamedFileSystemGen.methodHandleLookup();
        if (lookup != null) {
            try {
                HANDLES = new Handles(lookup);
            }
            catch (ReflectiveOperationException e) {
                throw new InternalError("Failed to initialize method handles for module bridge.", e);
            }
        } else {
            HANDLES = null;
        }
    }

    static final class Handles {
        private final MethodHandle checkAccess_;
        private final MethodHandle copy_;
        private final MethodHandle createDirectory_;
        private final MethodHandle createLink_;
        private final MethodHandle createSymbolicLink_;
        private final MethodHandle delete_;
        private final MethodHandle equals_;
        private final MethodHandle getEncoding_;
        private final MethodHandle getMimeType_;
        private final MethodHandle getPathSeparator_;
        private final MethodHandle getSeparator_;
        private final MethodHandle getTempDirectory_;
        private final MethodHandle hashCode_;
        private final MethodHandle isSameFile_;
        private final MethodHandle move_;
        private final MethodHandle newByteChannel_;
        private final MethodHandle newDirectoryStream_;
        private final MethodHandle parsePath_;
        private final MethodHandle parsePath1_;
        private final MethodHandle readAttributes_;
        private final MethodHandle readSymbolicLink_;
        private final MethodHandle setAttribute_;
        private final MethodHandle setCurrentWorkingDirectory_;
        private final MethodHandle toAbsolutePath_;
        private final MethodHandle toRealPath_;
        private final MethodHandle toString_;

        Handles(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
            Class<?> typeFileSystem = lookup.findClass(FileSystem.class.getName());
            Class<?> typeObject = lookup.findClass(Object.class.getName());
            this.checkAccess_ = lookup.findVirtual(typeFileSystem, "checkAccess", MethodType.methodType(Void.TYPE, List.of(Path.class, Set.class, LinkOption[].class)));
            this.copy_ = lookup.findVirtual(typeFileSystem, "copy", MethodType.methodType(Void.TYPE, List.of(Path.class, Path.class, CopyOption[].class)));
            this.createDirectory_ = lookup.findVirtual(typeFileSystem, "createDirectory", MethodType.methodType(Void.TYPE, List.of(Path.class, FileAttribute[].class)));
            this.createLink_ = lookup.findVirtual(typeFileSystem, "createLink", MethodType.methodType(Void.TYPE, List.of(Path.class, Path.class)));
            this.createSymbolicLink_ = lookup.findVirtual(typeFileSystem, "createSymbolicLink", MethodType.methodType(Void.TYPE, List.of(Path.class, Path.class, FileAttribute[].class)));
            this.delete_ = lookup.findVirtual(typeFileSystem, "delete", MethodType.methodType(Void.TYPE, List.of(Path.class)));
            this.equals_ = lookup.findVirtual(typeObject, "equals", MethodType.methodType(Boolean.TYPE, List.of(Object.class)));
            this.getEncoding_ = lookup.findVirtual(typeFileSystem, "getEncoding", MethodType.methodType(Charset.class, List.of(Path.class)));
            this.getMimeType_ = lookup.findVirtual(typeFileSystem, "getMimeType", MethodType.methodType(String.class, List.of(Path.class)));
            this.getPathSeparator_ = lookup.findVirtual(typeFileSystem, "getPathSeparator", MethodType.methodType(String.class, List.of()));
            this.getSeparator_ = lookup.findVirtual(typeFileSystem, "getSeparator", MethodType.methodType(String.class, List.of()));
            this.getTempDirectory_ = lookup.findVirtual(typeFileSystem, "getTempDirectory", MethodType.methodType(Path.class, List.of()));
            this.hashCode_ = lookup.findVirtual(typeObject, "hashCode", MethodType.methodType(Integer.TYPE, List.of()));
            this.isSameFile_ = lookup.findVirtual(typeFileSystem, "isSameFile", MethodType.methodType(Boolean.TYPE, List.of(Path.class, Path.class, LinkOption[].class)));
            this.move_ = lookup.findVirtual(typeFileSystem, "move", MethodType.methodType(Void.TYPE, List.of(Path.class, Path.class, CopyOption[].class)));
            this.newByteChannel_ = lookup.findVirtual(typeFileSystem, "newByteChannel", MethodType.methodType(SeekableByteChannel.class, List.of(Path.class, Set.class, FileAttribute[].class)));
            this.newDirectoryStream_ = lookup.findVirtual(typeFileSystem, "newDirectoryStream", MethodType.methodType(DirectoryStream.class, List.of(Path.class, DirectoryStream.Filter.class)));
            this.parsePath_ = lookup.findVirtual(typeFileSystem, "parsePath", MethodType.methodType(Path.class, List.of(String.class)));
            this.parsePath1_ = lookup.findVirtual(typeFileSystem, "parsePath", MethodType.methodType(Path.class, List.of(URI.class)));
            this.readAttributes_ = lookup.findVirtual(typeFileSystem, "readAttributes", MethodType.methodType(Map.class, List.of(Path.class, String.class, LinkOption[].class)));
            this.readSymbolicLink_ = lookup.findVirtual(typeFileSystem, "readSymbolicLink", MethodType.methodType(Path.class, List.of(Path.class)));
            this.setAttribute_ = lookup.findVirtual(typeFileSystem, "setAttribute", MethodType.methodType(Void.TYPE, List.of(Path.class, String.class, Object.class, LinkOption[].class)));
            this.setCurrentWorkingDirectory_ = lookup.findVirtual(typeFileSystem, "setCurrentWorkingDirectory", MethodType.methodType(Void.TYPE, List.of(Path.class)));
            this.toAbsolutePath_ = lookup.findVirtual(typeFileSystem, "toAbsolutePath", MethodType.methodType(Path.class, List.of(Path.class)));
            this.toRealPath_ = lookup.findVirtual(typeFileSystem, "toRealPath", MethodType.methodType(Path.class, List.of(Path.class, LinkOption[].class)));
            this.toString_ = lookup.findVirtual(typeObject, "toString", MethodType.methodType(String.class, List.of()));
        }
    }
}

