/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest;

import com.intellij.coverage.CoverageExecutor;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.execution.AbstractNodeTargetRunProfile;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationProducer;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationUtil;
import com.intellij.javascript.testing.vitest.VitestConsoleProperties;
import com.intellij.javascript.testing.vitest.VitestRunConfigurationEditor;
import com.intellij.javascript.testing.vitest.VitestRunProfileState;
import com.intellij.javascript.testing.vitest.VitestRunSettings;
import com.intellij.javascript.testing.vitest.VitestUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 D2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001DB\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020!H\u0016J \u0010(\u001a\u00020*2\u0006\u0010 \u001a\u00020!2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.J\u0010\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u001b2\u0006\u00100\u001a\u000201H\u0016J\b\u00103\u001a\u00020\u001bH\u0016J\b\u00104\u001a\u00020\u000bH\u0016J\n\u00105\u001a\u0004\u0018\u000106H\u0002J\n\u00107\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010<\u001a\u00020,2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\u0006\u0010A\u001a\u00020\u001bJ\u0006\u0010B\u001a\u00020,J\u0006\u0010C\u001a\u00020\u001bR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u00108\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006E"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;", "Lcom/intellij/javascript/nodejs/execution/AbstractNodeTargetRunProfile;", "Lcom/intellij/javascript/nodejs/debug/NodeDebugRunConfiguration;", "Lcom/intellij/javascript/testFramework/PreferableRunConfiguration;", "Lcom/intellij/javascript/JSRunProfileWithCompileBeforeLaunchOption;", "Lcom/intellij/execution/testframework/sm/runner/SMRunnerConsolePropertiesProvider;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "settings", "Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "getSettings", "()Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "setSettings", "(Lcom/intellij/javascript/testing/vitest/VitestRunSettings;)V", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "getInterpreter", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "getOrDetectVitestPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "onNewConfigurationCreated", "", "createConfigurationEditor", "Lcom/intellij/javascript/testing/vitest/VitestRunConfigurationEditor;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "configuredDebugPort", "", "getConfiguredDebugPort", "()I", "createTestConsoleProperties", "Lcom/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties;", "Lcom/intellij/javascript/testing/vitest/VitestConsoleProperties;", "withTerminalConsole", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "readConfiguration", "element", "Lorg/jdom/Element;", "writeConfiguration", "checkConfiguration", "suggestedName", "getContextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getActionName", "envData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvData", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "isPreferredOver", "otherRc", "Lcom/intellij/execution/configurations/RunConfiguration;", "sourceElement", "Lcom/intellij/psi/PsiElement;", "setOptionUpdateSnapshot", "isOptionUpdateSnapshot", "clearOptionUpdateSnapshot", "Companion", "intellij.javascript.impl"})
public final class VitestRunConfiguration
extends AbstractNodeTargetRunProfile
implements NodeDebugRunConfiguration,
PreferableRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption,
SMRunnerConsolePropertiesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private VitestRunSettings settings;
    @NotNull
    private static final Key<Boolean> WITH_UPDATE_SNAPSHOT;

    public VitestRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(project, factory, name);
        this.settings = new VitestRunSettings.Builder(null, null, null, null, null, null, null, null, 255, null).build();
    }

    @NotNull
    public final VitestRunSettings getSettings() {
        return this.settings;
    }

    public final void setSettings(@NotNull VitestRunSettings vitestRunSettings) {
        Intrinsics.checkNotNullParameter((Object)vitestRunSettings, (String)"<set-?>");
        this.settings = vitestRunSettings;
    }

    @Override
    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.settings.getInterpreterRef().resolve(this.getProject());
    }

    @NotNull
    public final NodePackage getOrDetectVitestPackage() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (RunManager.Companion.getInstance(project).isTemplate((RunConfiguration)this)) {
            NodePackage nodePackage = this.settings.getVitestPackage();
            if (nodePackage == null) {
                nodePackage = new NodePackage("");
            }
            return nodePackage;
        }
        NodePackage pkg = this.settings.getVitestPackage();
        if (pkg == null) {
            pkg = VitestUtil.INSTANCE.getPKG_DESCRIPTOR().findFirstDirectDependencyPackage(this.getProject(), null, VitestUtil.INSTANCE.findContextFile(this.settings));
            this.settings = this.settings.builder().vitestPackage(pkg).build();
        }
        return pkg;
    }

    public void onNewConfigurationCreated() {
        block1: {
            if (!StringsKt.isBlank((CharSequence)this.settings.getWorkingDir())) break block1;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = JsTestRunConfigurationProducer.Companion.guessWorkingDirectory(project, this.settings.getConfigFilePath());
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                VitestRunSettings.Builder builder2 = this.settings.builder();
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                this.settings = builder2.workingDir(string).build();
            }
        }
    }

    @NotNull
    public VitestRunConfigurationEditor createConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new VitestRunConfigurationEditor(project);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return new VitestRunProfileState(this, environment, CollectionsKt.emptyList());
    }

    @Override
    public int getConfiguredDebugPort() {
        return NodeCommandLineUtil.findDebugPort(this.settings.getNodeOptions());
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return this.createTestConsoleProperties(executor, false, null);
    }

    @NotNull
    public final VitestConsoleProperties createTestConsoleProperties(@NotNull Executor executor, boolean withTerminalConsole, @Nullable NodeTargetRun targetRun) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return new VitestConsoleProperties(this, executor, withTerminalConsole, targetRun, executor instanceof CoverageExecutor);
    }

    @Override
    public void readConfiguration(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.settings = VitestUtil.INSTANCE.readXml(element2);
    }

    @Override
    public void writeConfiguration(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        VitestUtil.INSTANCE.writeXml(element2, this.settings);
    }

    public void checkConfiguration() {
        VitestUtil.INSTANCE.checkRunConfiguration(this);
    }

    @NotNull
    public String suggestedName() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return JsTestRunConfigurationUtil.INSTANCE.suggestRunConfigurationName(project, this.getContextFile(), this.settings.getScope(), this.settings.getConfigFilePath());
    }

    private final VirtualFile getContextFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.settings.getWorkingDir());
    }

    @Nullable
    public String getActionName() {
        String preferredActionName = JsTestRunConfigurationUtil.INSTANCE.getRunConfigurationActionName((LocatableConfiguration)this, this.settings.getScope(), this.settings.getConfigFilePath(), (Function0<? extends VirtualFile>)((Function0)() -> VitestRunConfiguration.getActionName$lambda$1(this)));
        String string = preferredActionName;
        if (string == null) {
            string = super.getActionName();
        }
        return string;
    }

    @Override
    @NotNull
    public EnvironmentVariablesData getEnvData() {
        return this.settings.getEnvData();
    }

    @Override
    public boolean isPreferredOver(@NotNull RunConfiguration otherRc, @NotNull PsiElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)otherRc, (String)"otherRc");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        return false;
    }

    public final void setOptionUpdateSnapshot() {
        this.putUserData(WITH_UPDATE_SNAPSHOT, true);
    }

    public final boolean isOptionUpdateSnapshot() {
        return Intrinsics.areEqual((Object)this.getUserData(WITH_UPDATE_SNAPSHOT), (Object)true);
    }

    public final void clearOptionUpdateSnapshot() {
        this.putUserData(WITH_UPDATE_SNAPSHOT, null);
    }

    private static final VirtualFile getActionName$lambda$1(VitestRunConfiguration this$0) {
        return this$0.getContextFile();
    }

    static {
        Key key = Key.create((String)"WITH_UPDATE_SNAPSHOT");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        WITH_UPDATE_SNAPSHOT = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration$Companion;", "", "<init>", "()V", "WITH_UPDATE_SNAPSHOT", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

