/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSFindUsagesDynamicFilterValue;
import com.intellij.lang.javascript.findUsages.JSUsageViewElementsListener;
import com.intellij.lang.javascript.findUsages.JavaScriptFindUsagesConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.actions.RuleAction;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUsageFilteringRuleProvider
implements UsageFilteringRuleProvider {
    public UsageFilteringRule @NotNull [] getActiveRules(final @NotNull Project project) {
        if (project == null) {
            JSUsageFilteringRuleProvider.$$$reportNull$$$0(0);
        }
        UsageFilteringRule[] usageFilteringRuleArray = new UsageFilteringRule[]{new UsageFilteringRule(){

            public boolean isVisible(@NotNull Usage usage, @NotNull @NotNull UsageTarget @NotNull [] targets) {
                if (usage == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (targets == null) {
                    1.$$$reportNull$$$0(1);
                }
                Language language = targets.length > 0 ? JSUsageFilteringRuleProvider.getTargetsLanguage(targets) : JSUsageFilteringRuleProvider.getLanguageFromCurrentEditor(project);
                return language instanceof JsonLanguage || JavaScriptFindUsagesConfiguration.getFindUsagesDynamicFilterValue((Project)project, (Language)language).isShowDynamicUsages || !JSUsageViewElementsListener.isJavaScriptDynamicUsage(usage, targets);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "usage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targets";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/findUsages/JSUsageFilteringRuleProvider$1";
                objectArray[2] = "isVisible";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }};
        if (usageFilteringRuleArray == null) {
            JSUsageFilteringRuleProvider.$$$reportNull$$$0(1);
        }
        return usageFilteringRuleArray;
    }

    public AnAction @NotNull [] createFilteringActions(@NotNull UsageView view) {
        DataContext dataContext;
        Language language;
        if (view == null) {
            JSUsageFilteringRuleProvider.$$$reportNull$$$0(2);
        }
        if (!((language = JSUsageFilteringRuleProvider.getLanguage(view, dataContext = DataManager.getInstance().getDataContext())) instanceof JSLanguageDialect)) {
            if (AnAction.EMPTY_ARRAY == null) {
                JSUsageFilteringRuleProvider.$$$reportNull$$$0(3);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                JSUsageFilteringRuleProvider.$$$reportNull$$$0(4);
            }
            return AnAction.EMPTY_ARRAY;
        }
        final JSFindUsagesDynamicFilterValue options = JavaScriptFindUsagesConfiguration.getFindUsagesDynamicFilterValue(project, language);
        options.isShowDynamicUsages = options.isShowDynamicUsagesInPopup;
        RuleAction action = new RuleAction(JavaScriptBundle.messagePointer("js.show.dynamic.usages", new Object[0]), AllIcons.Actions.DynamicUsages){

            protected boolean getOptionValue(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return options.isShowDynamicUsagesInPopup;
            }

            protected void setOptionValue(@NotNull AnActionEvent e, boolean value) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                options.isShowDynamicUsages = options.isShowDynamicUsagesInPopup = value;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/lang/javascript/findUsages/JSUsageFilteringRuleProvider$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getOptionValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setOptionValue";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Disposer.register((Disposable)view, () -> {
            options.isShowDynamicUsages = options.isInitialShowDynamicUsages;
        });
        AnAction[] anActionArray = new AnAction[]{action};
        if (anActionArray == null) {
            JSUsageFilteringRuleProvider.$$$reportNull$$$0(5);
        }
        return anActionArray;
    }

    @Nullable
    private static Language getLanguage(@NotNull UsageView view, @NotNull DataContext dataContext) {
        Project project;
        UsageViewImpl usageViewImpl;
        Language language;
        if (view == null) {
            JSUsageFilteringRuleProvider.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            JSUsageFilteringRuleProvider.$$$reportNull$$$0(7);
        }
        if (view instanceof UsageViewImpl && (language = JSUsageFilteringRuleProvider.getTargetsLanguage((usageViewImpl = (UsageViewImpl)view).getTargets())) != null) {
            return language;
        }
        Language language2 = (Language)dataContext.getData(CommonDataKeys.LANGUAGE);
        if (language2 != null) {
            return language2;
        }
        Project contextProject = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (contextProject != null) {
            project = contextProject;
        } else if (view instanceof UsageViewImpl) {
            UsageViewImpl usageViewImpl2 = (UsageViewImpl)view;
            project = usageViewImpl2.getProject();
        } else {
            project = contextProject;
        }
        Project project2 = project;
        return JSUsageFilteringRuleProvider.getLanguageFromCurrentEditor(project2);
    }

    @Nullable
    private static Language getTargetsLanguage(UsageTarget @NotNull [] usageTargets) {
        if (usageTargets == null) {
            JSUsageFilteringRuleProvider.$$$reportNull$$$0(8);
        }
        for (UsageTarget usageTarget : usageTargets) {
            PsiElementUsageTarget psiTarget;
            PsiElement element2;
            if (!(usageTarget instanceof PsiElementUsageTarget) || (element2 = (psiTarget = (PsiElementUsageTarget)usageTarget).getElement()) == null) continue;
            return DialectDetector.languageOfElement(element2);
        }
        return null;
    }

    @Nullable
    private static Language getLanguageFromCurrentEditor(@NotNull Project project) {
        Editor editor;
        if (project == null) {
            JSUsageFilteringRuleProvider.$$$reportNull$$$0(9);
        }
        if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) == null) {
            return null;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        PsiElement elementAtCaret = CommonRefactoringUtil.getElementAtCaret((Editor)editor, (PsiFile)psiFile);
        if (elementAtCaret == null) {
            return psiFile.getLanguage();
        }
        return DialectDetector.languageOfElement(elementAtCaret);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/findUsages/JSUsageFilteringRuleProvider";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/findUsages/JSUsageFilteringRuleProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveRules";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilteringActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActiveRules";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFilteringActions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTargetsLanguage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageFromCurrentEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

