/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightingAwareElementDescriptor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.frameworks.jsx.JSXAttributeDataProviderKt;
import com.intellij.lang.javascript.frameworks.jsx.JSXAttributeDescriptor;
import com.intellij.lang.javascript.frameworks.jsx.JSXAttributeDescriptorImpl;
import com.intellij.lang.javascript.frameworks.jsx.JSXComponent;
import com.intellij.lang.javascript.frameworks.jsx.JSXImplementation;
import com.intellij.lang.javascript.frameworks.jsx.JSXXmlElementNSDescriptor;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.jsx.tsx.TypeScriptJSXTagUtil;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlCustomElementDescriptor;
import com.intellij.xml.XmlDeprecationOwnerDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXXmlElementDescriptor
implements XmlElementDescriptor,
XmlCustomElementDescriptor,
XmlDeprecationOwnerDescriptor,
XmlHighlightingAwareElementDescriptor {
    private static final Collection<String> IGNORED_ATTRIBUTES = Set.of("class", "for");
    @NotNull
    private final String myName;
    @NotNull
    private final PsiElement myContext;
    private final boolean myStrict;
    @Nullable
    private final JSXXmlElementNSDescriptor myDescriptor;

    public JSXXmlElementDescriptor(@NotNull String name, @NotNull PsiElement context2, boolean isStrict) {
        if (name == null) {
            JSXXmlElementDescriptor.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSXXmlElementDescriptor.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myContext = context2;
        this.myStrict = isStrict;
        this.myDescriptor = new JSXXmlElementNSDescriptor(this.myContext, name.contains("."), isStrict);
    }

    public String getQualifiedName() {
        return this.myName;
    }

    public String getDefaultName() {
        return this.myName;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context2) {
        XmlNSDescriptor descriptor = this.getNSDescriptor();
        if (descriptor == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        return descriptor.getRootElementsDescriptors(null);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlNSDescriptor descriptor = this.getNSDescriptor();
        return descriptor == null ? null : descriptor.getElementDescriptor(childTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context2) {
        if (context2 == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        if (JSXResolveUtil.isComponentName(context2.getName())) {
            return JSXXmlElementDescriptor.getComponentProps(context2);
        }
        return (XmlAttributeDescriptor[])JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)context2, () -> this.resolveTagAttributes(context2));
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context2) {
        if (context2 == null || DumbService.isDumb((Project)this.myContext.getProject())) {
            return new JSXAnyXmlAttributeDescriptor(attributeName);
        }
        return (XmlAttributeDescriptor)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)context2, () -> {
            if (JSXResolveUtil.isComponentName(context2.getName())) {
                return JSXXmlElementDescriptor.findComponentProp(attributeName, context2);
            }
            return this.resolveTagAttribute(context2, attributeName);
        });
    }

    public boolean isDeprecated() {
        if (this.myContext instanceof XmlTag) {
            JSXComponent component = JSXImplementation.getComponent((XmlTag)this.myContext);
            Collection<? extends PsiElement> elements = component.getElements();
            if (elements.isEmpty()) {
                return false;
            }
            return ContainerUtil.all(elements, el -> {
                PsiElement context2 = el;
                boolean isDeprecated = JSDocumentationUtils.isDeprecated(context2);
                if (!isDeprecated && (context2 = JSStubBasedPsiTreeUtil.calculateTargetElement(context2)) instanceof JSFunctionExpression) {
                    context2 = context2.getParent();
                }
                return JSDocumentationUtils.isDeprecated(context2);
            });
        }
        return false;
    }

    public boolean shouldCheckRequiredAttributes() {
        TypeScriptAnnotatorCheckerProvider provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider(this.myContext);
        return !provider.skipErrors(this.myContext);
    }

    @NotNull
    private static XmlAttributeDescriptor findComponentProp(@NonNls String attributeName, @NotNull XmlTag context2) {
        if (context2 == null) {
            JSXXmlElementDescriptor.$$$reportNull$$$0(2);
        }
        return new JSXAttributeDescriptorImpl.JSXHtmlAttributeDescriptorImpl(attributeName, JSXAttributeDataProviderKt.createLazyProvider(attributeName, context2));
    }

    private static XmlAttributeDescriptor[] getComponentProps(@NotNull XmlTag context2) {
        if (context2 == null) {
            JSXXmlElementDescriptor.$$$reportNull$$$0(3);
        }
        JSXComponent component = JSXImplementation.getComponent(context2);
        return TypeScriptJSXTagUtil.getXmlAttributeDescriptors(component.getProps());
    }

    private XmlAttributeDescriptor @NotNull [] resolveTagAttributes(XmlTag context2) {
        XmlAttributeDescriptor[] typeScriptProperties = JSXXmlElementDescriptor.getPropertyAttributes(context2);
        XmlElementDescriptor elementDescriptor = this.getXmlElementDescriptorFormParent(context2);
        if (elementDescriptor != null && !(elementDescriptor instanceof JSXXmlElementDescriptor)) {
            XmlAttributeDescriptor[] xmlAttributeDescriptorArray = this.mergeAttributes(typeScriptProperties, elementDescriptor.getAttributesDescriptors(context2));
            if (xmlAttributeDescriptorArray == null) {
                JSXXmlElementDescriptor.$$$reportNull$$$0(4);
            }
            return xmlAttributeDescriptorArray;
        }
        if (typeScriptProperties == null) {
            JSXXmlElementDescriptor.$$$reportNull$$$0(5);
        }
        return typeScriptProperties;
    }

    private static XmlAttributeDescriptor[] getPropertyAttributes(XmlTag context2) {
        JSRecordType.PropertySignature property = TypeScriptJSXTagUtil.resolveTag(context2);
        XmlAttributeDescriptor[] typeScriptProperties = XmlAttributeDescriptor.EMPTY;
        if (property != null) {
            typeScriptProperties = TypeScriptJSXTagUtil.getXmlAttributeDescriptors(property);
        }
        return typeScriptProperties;
    }

    protected XmlAttributeDescriptor[] mergeAttributes(XmlAttributeDescriptor @NotNull [] typeScriptProperties, XmlAttributeDescriptor @NotNull [] parentDescriptors) {
        if (typeScriptProperties == null) {
            JSXXmlElementDescriptor.$$$reportNull$$$0(6);
        }
        if (parentDescriptors == null) {
            JSXXmlElementDescriptor.$$$reportNull$$$0(7);
        }
        if (parentDescriptors.length == 0) {
            return typeScriptProperties;
        }
        if (typeScriptProperties.length == 0) {
            return parentDescriptors;
        }
        Set names = Arrays.stream(typeScriptProperties).map(el -> StringUtil.toLowerCase((String)el.getName())).collect(Collectors.toSet());
        List<XmlAttributeDescriptor> parentDescList = Arrays.stream(parentDescriptors).filter(descriptor -> {
            String name = descriptor.getName();
            return (name == null || !IGNORED_ATTRIBUTES.contains(name)) && !names.contains(JSXXmlElementDescriptor.normalizeAttributeName(name));
        }).toList();
        return ContainerUtil.concat(Arrays.asList(typeScriptProperties), parentDescList).toArray(XmlAttributeDescriptor.EMPTY);
    }

    @Nullable
    private XmlAttributeDescriptor resolveTagAttribute(XmlTag context2, @NonNls String attributeName) {
        XmlAttribute attribute;
        boolean hasTypeScriptDeclarations;
        JSRecordType.PropertySignature property = TypeScriptJSXTagUtil.resolveTag(context2);
        boolean bl = hasTypeScriptDeclarations = property != null;
        if (hasTypeScriptDeclarations) {
            Ref resultRef = Ref.create();
            HashSet lowCaseNames = new HashSet();
            TypeScriptJSXTagUtil.processAttributes(property, (Processor<? super JSRecordType.PropertySignature>)((Processor)el -> {
                String name = el.getMemberName();
                if (name.equals(attributeName)) {
                    resultRef.set((Object)TypeScriptJSXTagUtil.createAttributeDescriptor(el, false));
                    return false;
                }
                lowCaseNames.add(StringUtil.toLowerCase((String)name));
                return true;
            }));
            if (!resultRef.isNull() || lowCaseNames.contains(JSXXmlElementDescriptor.normalizeAttributeName(StringUtil.toLowerCase((String)attributeName))) || attributeName != null && IGNORED_ATTRIBUTES.contains(attributeName)) {
                return resultRef.isNull() ? null : (XmlAttributeDescriptor)resultRef.get();
            }
        }
        if ((attribute = context2.getAttribute(attributeName)) != null && attribute.getValueElement() == null) {
            return new JSXAnyXmlAttributeDescriptor(attributeName);
        }
        XmlElementDescriptor elementDescriptor = this.getXmlElementDescriptorFormParent(context2);
        if (elementDescriptor != null) {
            if (!(elementDescriptor instanceof JSXXmlElementDescriptor)) {
                XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attributeName, context2);
                if (attributeDescriptor == null) {
                    return JSXXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
                }
                if (!(attributeDescriptor instanceof JSXAttributeDescriptor)) {
                    attributeDescriptor = new JSXAttributeDescriptorImpl.JSXHtmlAttributeDescriptorImpl(attributeDescriptor);
                }
                return attributeDescriptor;
            }
            return JSXXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
        }
        return JSXXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
    }

    private static String normalizeAttributeName(@NotNull String attributeName) {
        if (attributeName == null) {
            JSXXmlElementDescriptor.$$$reportNull$$$0(8);
        }
        return attributeName.replace("-", "");
    }

    @Nullable
    private static XmlAttributeDescriptor getEmptyAttributeValue(@NotNull String attributeName, boolean strict) {
        if (attributeName == null) {
            JSXXmlElementDescriptor.$$$reportNull$$$0(9);
        }
        return strict ? null : new JSXAnyXmlAttributeDescriptor(attributeName);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myDescriptor;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return JSXResolveUtil.isComponentName(this.myName) && !this.requiredChildren() ? 0 : 1;
    }

    protected boolean requiredChildren() {
        if (!(this.myContext instanceof XmlTag)) {
            return true;
        }
        XmlAttributeDescriptor descriptor = this.getAttributeDescriptor("children", (XmlTag)this.myContext);
        return descriptor != null && descriptor.isRequired();
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    @Nullable
    public PsiElement getDeclaration() {
        PsiElement declaration;
        XmlElementDescriptor descriptor;
        if (!this.myStrict && this.myContext instanceof XmlTag && !JSXResolveUtil.isComponentName(this.myName) && (descriptor = this.getXmlElementDescriptorFormParent((XmlTag)this.myContext)) != null && !(descriptor instanceof JSXXmlElementDescriptor) && (declaration = descriptor.getDeclaration()) != null) {
            return declaration;
        }
        return this.myContext;
    }

    public String getName(PsiElement context2) {
        return this.getName();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JSXXmlElementDescriptor.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void init(PsiElement element2) {
    }

    @Nullable
    private XmlElementDescriptor getXmlElementDescriptorFormParent(@Nullable XmlTag context2) {
        if (context2 == null) {
            return null;
        }
        XmlNSDescriptor defaultNSDescriptor = JSXXmlLiteralExpressionImpl.getDefaultNSDescriptor(this.myContext);
        if (defaultNSDescriptor == null) {
            return null;
        }
        return defaultNSDescriptor.getElementDescriptor(context2);
    }

    public boolean isCustomElement() {
        return JSXResolveUtil.isComponentName(this.myName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/JSXXmlElementDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeScriptProperties";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDescriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXXmlElementDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTagAttributes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findComponentProp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getComponentProps";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeAttributes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAttributeName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEmptyAttributeValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10 -> new IllegalStateException(string);
        };
    }

    private static class JSXAnyXmlAttributeDescriptor
    extends AnyXmlAttributeDescriptor
    implements JSXAttributeDescriptor {
        JSXAnyXmlAttributeDescriptor(String attributeName) {
            super(attributeName);
        }

        @Override
        @Nullable
        public JSType getValueType() {
            return null;
        }
    }
}

