/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx.references;

import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXTagOrComponentReference;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class JSXNamespaceReference
extends JSReferenceSetElement
implements JSXTagOrComponentReference {
    private static final String THIS_QUALIFIER = "this";

    public JSXNamespaceReference(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement) {
        if (set == null) {
            JSXNamespaceReference.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSXNamespaceReference.$$$reportNull$$$0(1);
        }
        if (rangeInElement == null) {
            JSXNamespaceReference.$$$reportNull$$$0(2);
        }
        super(set, s, rangeInElement);
    }

    @Override
    protected ResolveResult @NotNull [] doResolve() {
        PsiElement element2 = this.getElement();
        if (this.isPrimary()) {
            if (THIS_QUALIFIER.equals(this.myCanonicalText)) {
                JSClass context2 = JSResolveUtil.getClassOfContext(element2);
                ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(ContainerUtil.createMaybeSingletonList((Object)context2));
                if (resolveResultArray == null) {
                    JSXNamespaceReference.$$$reportNull$$$0(3);
                }
                return resolveResultArray;
            }
            ResolveResult[] resolveResultArray = JSXResolveUtil.resolveTopLevelName(element2, this.myCanonicalText);
            if (resolveResultArray == null) {
                JSXNamespaceReference.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        PsiReference qualifier = this.getQualifier();
        if (!(qualifier instanceof JSXNamespaceReference)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSXNamespaceReference.$$$reportNull$$$0(5);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        JSXNamespaceReference parentReference = (JSXNamespaceReference)qualifier;
        Collection<PsiElement> elements = JSXResolveUtil.expandReferenceElements(element2, parentReference);
        if (elements.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSXNamespaceReference.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = JSXResolveUtil.resolveNestedName(element2, this.myCanonicalText, elements, parentReference);
        if (resolveResultArray == null) {
            JSXNamespaceReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    public boolean isThisQualifier() {
        return this.isPrimary() && THIS_QUALIFIER.equals(this.getCanonicalText());
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSXNamespaceReference.$$$reportNull$$$0(8);
        }
        if (THIS_QUALIFIER.equals(this.myCanonicalText)) {
            return null;
        }
        String result2 = StringUtil.join((Object[])this.getSet().getReferences(), el -> {
            if (el == this) {
                return newElementName;
            }
            return el.getCanonicalText();
        }, (String)".");
        PsiElement element2 = this.getElement();
        if (!(element2 instanceof XmlTag)) {
            return null;
        }
        String qualifiedName = result2 + "." + ((XmlTag)element2).getLocalName();
        return ((XmlTag)element2).setName(qualifiedName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/references/JSXNamespaceReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/references/JSXNamespaceReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

