/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hints;

import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.hints.JSCodeVisionLocationKind;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/hints/JSCodeVisionLocations;", "", "<init>", "()V", "acceptsFile", "", "file", "Lcom/intellij/psi/PsiFile;", "acceptsFileContent", "isImportantLocation", "element", "Lcom/intellij/psi/PsiElement;", "getLocationKind", "Lcom/intellij/lang/javascript/hints/JSCodeVisionLocationKind;", "isTopLevelCallWithCallback", "getNamedElementForLocation", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSCodeVisionLocations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSCodeVisionLocations.kt\ncom/intellij/lang/javascript/hints/JSCodeVisionLocations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,70:1\n1#2:71\n12637#3,2:72\n*S KotlinDebug\n*F\n+ 1 JSCodeVisionLocations.kt\ncom/intellij/lang/javascript/hints/JSCodeVisionLocations\n*L\n49#1:72,2\n*E\n"})
public final class JSCodeVisionLocations {
    @NotNull
    public static final JSCodeVisionLocations INSTANCE = new JSCodeVisionLocations();

    private JSCodeVisionLocations() {
    }

    public final boolean acceptsFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (file instanceof JSFile || JavaScriptIndex.getFileTypesToIndexJS().contains(file.getFileType())) && this.acceptsFileContent(file);
    }

    public final boolean acceptsFileContent(@Nullable PsiFile file) {
        return file == null || !JSMinifiedFileUtil.isFileContentMinified(file.getViewProvider().getVirtualFile());
    }

    public final boolean isImportantLocation(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.getLocationKind(element2) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final JSCodeVisionLocationKind getLocationKind(@NotNull PsiElement element2) {
        JSCodeVisionLocationKind jSCodeVisionLocationKind;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof TypeScriptInterface) {
            jSCodeVisionLocationKind = JSCodeVisionLocationKind.INTERFACE;
            return jSCodeVisionLocationKind;
        }
        if (element2 instanceof JSClass && !(element2 instanceof TypeScriptTypeAlias)) {
            jSCodeVisionLocationKind = JSCodeVisionLocationKind.CLASS;
            return jSCodeVisionLocationKind;
        }
        if (element2 instanceof JSFunctionDeclaration && ((JSFunctionDeclaration)element2).getBlock() != null) {
            jSCodeVisionLocationKind = JSCodeVisionLocationKind.FUNCTION;
            return jSCodeVisionLocationKind;
        }
        if (element2 instanceof JSVarStatement) {
            boolean bl;
            JSVariable[] jSVariableArray = ((JSVarStatement)element2).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)jSVariableArray, (String)"getVariables(...)");
            JSVariable jSVariable = (JSVariable)ArraysKt.firstOrNull((Object[])jSVariableArray);
            if (jSVariable != null) {
                JSVariable it = jSVariable;
                boolean bl2 = false;
                bl = it.getInitializer() instanceof JSFunction || it.isExported();
            } else {
                bl = false;
            }
            if (bl || ((JSVarStatement)element2).hasModifier(JSAttributeList.ModifierType.EXPORT)) {
                jSCodeVisionLocationKind = JSCodeVisionLocationKind.VAR_OR_FIELD;
                return jSCodeVisionLocationKind;
            }
        }
        if (element2 instanceof JSExportAssignment) {
            jSCodeVisionLocationKind = JSCodeVisionLocationKind.EXPORT_ASSIGNMENT;
            return jSCodeVisionLocationKind;
        }
        if (!this.isTopLevelCallWithCallback(element2)) return null;
        jSCodeVisionLocationKind = JSCodeVisionLocationKind.CALLBACK;
        return jSCodeVisionLocationKind;
    }

    private final boolean isTopLevelCallWithCallback(PsiElement element2) {
        boolean bl;
        block3: {
            JSExpression[] arguments;
            if (!(element2 instanceof JSExpressionStatement) || !(((JSExpressionStatement)element2).getParent() instanceof JSModuleStatusOwner)) {
                return false;
            }
            JSExpression jSExpression = ((JSExpressionStatement)element2).getExpression();
            JSCallExpression jSCallExpression = jSExpression instanceof JSCallExpression ? (JSCallExpression)jSExpression : null;
            if (jSCallExpression == null) {
                return false;
            }
            JSCallExpression callExpression = jSCallExpression;
            JSExpression[] jSExpressionArray = callExpression.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)jSExpressionArray, (String)"getArguments(...)");
            JSExpression[] $this$any$iv = arguments = jSExpressionArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                JSExpression element$iv;
                JSExpression it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(it instanceof JSFunction)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final PsiElement getNamedElementForLocation(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof JSVarStatement) {
            JSVariable[] jSVariableArray = ((JSVarStatement)element2).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)jSVariableArray, (String)"getVariables(...)");
            JSVariable jSVariable = (JSVariable)ArraysKt.firstOrNull((Object[])jSVariableArray);
            if (jSVariable != null) {
                JSVariable it = jSVariable;
                boolean bl = false;
                return (PsiElement)it;
            }
        }
        return element2;
    }
}

