/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPotentiallyInvalidTargetOfIndexedPropertyAccess
extends JSInspection {
    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSPotentiallyInvalidTargetOfIndexedPropertyAccess.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSPotentiallyInvalidTargetOfIndexedPropertyAccess.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSIndexedPropertyAccessExpression(@NotNull JSIndexedPropertyAccessExpression node) {
                PsiElement resolve2;
                JSExpression indexExpression;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((indexExpression = node.getIndexExpression()) instanceof JSBinaryExpression && ((JSBinaryExpression)indexExpression).getOperationSign() == JSTokenTypes.COMMA) {
                    indexExpression = ((JSBinaryExpression)indexExpression).getROperand();
                }
                JSExpression qualifier = node.getQualifier();
                if (indexExpression instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isNumericLiteral() && qualifier instanceof JSReferenceExpression && ((resolve2 = ((JSReferenceExpression)qualifier).resolve()) instanceof JSClass || ((Boolean)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)indexExpression, () -> JSPotentiallyInvalidTargetOfIndexedPropertyAccess.this.isInvalidUsage(resolve2))).booleanValue())) {
                    PsiElement element2 = ((JSReferenceExpression)qualifier).getReferenceNameElement();
                    holder.registerProblem((PsiElement)(element2 != null ? element2 : qualifier), JavaScriptBundle.message("javascript.potentially.invalid.target.of.indexed.property.access", new Object[0]), new LocalQuickFix[0]);
                }
                JSPotentiallyInvalidTargetOfIndexedPropertyAccess.checkIfComputedPropertyExpected(node, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidTargetOfIndexedPropertyAccess$1", "visitJSIndexedPropertyAccessExpression"));
            }
        };
    }

    private static void checkIfComputedPropertyExpected(@NotNull JSIndexedPropertyAccessExpression node, @NotNull ProblemsHolder holder) {
        JSExpression qualifier;
        if (node == null) {
            JSPotentiallyInvalidTargetOfIndexedPropertyAccess.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JSPotentiallyInvalidTargetOfIndexedPropertyAccess.$$$reportNull$$$0(3);
        }
        if ((qualifier = node.getQualifier()) == null) {
            return;
        }
        PsiElement afterQualifier = qualifier.getNextSibling();
        if (!(afterQualifier instanceof PsiWhiteSpace) || !afterQualifier.textContains('\n')) {
            return;
        }
        JSComputedPropertyNameOwner computedNameOwner = (JSComputedPropertyNameOwner)PsiTreeUtil.getParentOfType((PsiElement)node, JSComputedPropertyNameOwner.class);
        if (computedNameOwner instanceof JSField) {
            holder.registerProblem((PsiElement)node, JavaScriptBundle.message("javascript.indexed.property.instead.of.computed.name", new Object[0]), new LocalQuickFix[]{new InsertPrefixFix(";", afterQualifier)});
        }
    }

    public boolean isInvalidUsage(@Nullable PsiElement resolve2) {
        if (resolve2 == null) {
            return false;
        }
        if (resolve2 instanceof JSClass) {
            return true;
        }
        if (resolve2 instanceof TypeScriptVariable) {
            JSType type2 = ((TypeScriptVariable)resolve2).getJSType();
            if (type2 == null || type2 instanceof JSArrayType || type2 instanceof JSTupleType) {
                return false;
            }
            JSRecordType recordType = type2.asRecordType();
            return !recordType.hasIndexers() && !recordType.getCallSignatures().isEmpty();
        }
        return resolve2 instanceof JSFunction && !((JSFunction)resolve2).isGetProperty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidTargetOfIndexedPropertyAccess";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfComputedPropertyExpected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InsertPrefixFix
    extends LocalQuickFixOnPsiElement
    implements LocalQuickFix {
        @NotNull
        private final String myText;

        private InsertPrefixFix(@NotNull String text, @NotNull PsiElement element2) {
            if (text == null) {
                InsertPrefixFix.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                InsertPrefixFix.$$$reportNull$$$0(1);
            }
            super(element2);
            this.myText = text;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                InsertPrefixFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Document document;
            if (project == null) {
                InsertPrefixFix.$$$reportNull$$$0(3);
            }
            if (psiFile == null) {
                InsertPrefixFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                InsertPrefixFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                InsertPrefixFix.$$$reportNull$$$0(6);
            }
            if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile)) != null) {
                document.insertString(startElement.getTextRange().getStartOffset(), (CharSequence)this.myText);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("javascript.insert.symbol.fix", this.myText);
            if (string == null) {
                InsertPrefixFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidTargetOfIndexedPropertyAccess$InsertPrefixFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidTargetOfIndexedPropertyAccess$InsertPrefixFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 7: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 7 -> new IllegalStateException(string);
            };
        }
    }
}

