/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json.adapters;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.json.adapters.JSJsonArrayAdapter;
import com.intellij.lang.javascript.json.adapters.JSJsonForeignValueAdapter;
import com.intellij.lang.javascript.json.adapters.JSJsonGenericValueAdapter;
import com.intellij.lang.javascript.json.adapters.JSJsonObjectAdapter;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSJsonPropertyAdapter
implements JsonPropertyAdapter {
    @NotNull
    private final JSProperty myProperty;

    public JSJsonPropertyAdapter(@NotNull JSProperty property) {
        if (property == null) {
            JSJsonPropertyAdapter.$$$reportNull$$$0(0);
        }
        this.myProperty = property;
    }

    @Nullable
    public String getName() {
        return this.myProperty.getName();
    }

    @NotNull
    public Collection<JsonValueAdapter> getValues() {
        return this.myProperty.getValue() == null ? ContainerUtil.emptyList() : JSJsonPropertyAdapter.createValueAdaptersByType(this.myProperty.getValue());
    }

    @Nullable
    public JsonValueAdapter getNameValueAdapter() {
        return null;
    }

    @NotNull
    public PsiElement getDelegate() {
        JSProperty jSProperty = this.myProperty;
        if (jSProperty == null) {
            JSJsonPropertyAdapter.$$$reportNull$$$0(1);
        }
        return jSProperty;
    }

    @Nullable
    public JsonObjectValueAdapter getParentObject() {
        return this.myProperty.getParent() instanceof JSObjectLiteralExpression ? new JSJsonObjectAdapter((JSObjectLiteralExpression)this.myProperty.getParent()) : null;
    }

    @NotNull
    public static List<JsonValueAdapter> createValueAdaptersByType(@NotNull JSExpression value) {
        JSExpression innerExpression;
        IElementType sign;
        if (value == null) {
            JSJsonPropertyAdapter.$$$reportNull$$$0(2);
        }
        if (value instanceof JSObjectLiteralExpression) {
            List<JSJsonObjectAdapter> list = Collections.singletonList(new JSJsonObjectAdapter((JSObjectLiteralExpression)value));
            if (list == null) {
                JSJsonPropertyAdapter.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (value instanceof JSArrayLiteralExpression) {
            List<JSJsonArrayAdapter> list = Collections.singletonList(new JSJsonArrayAdapter((JSArrayLiteralExpression)value));
            if (list == null) {
                JSJsonPropertyAdapter.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (value instanceof JSLiteralExpression) {
            List<JsonValueAdapter> list = Collections.singletonList(new JSJsonGenericValueAdapter(value));
            if (list == null) {
                JSJsonPropertyAdapter.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (value instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)value).getOperationSign()) == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS) && ((JSPrefixExpression)value).getExpression() instanceof JSLiteralExpression) {
            List<JsonValueAdapter> list = Collections.singletonList(new JSJsonGenericValueAdapter(value));
            if (list == null) {
                JSJsonPropertyAdapter.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (value instanceof JSParenthesizedExpression && (innerExpression = ((JSParenthesizedExpression)value).getInnerExpression()) != null) {
            return JSJsonPropertyAdapter.createValueAdaptersByType(innerExpression);
        }
        if (value instanceof JSConditionalExpression) {
            JSExpression then = (JSExpression)((JSConditionalExpression)value).getThenBranch();
            JSExpression anElse = (JSExpression)((JSConditionalExpression)value).getElseBranch();
            List<JsonValueAdapter> thenValues = then == null ? ContainerUtil.emptyList() : JSJsonPropertyAdapter.createValueAdaptersByType(then);
            List<JsonValueAdapter> elseValues = anElse == null ? ContainerUtil.emptyList() : JSJsonPropertyAdapter.createValueAdaptersByType(anElse);
            List list = ContainerUtil.concat(thenValues, elseValues);
            if (list == null) {
                JSJsonPropertyAdapter.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<JsonValueAdapter> list = Collections.singletonList(new JSJsonForeignValueAdapter(value));
        if (list == null) {
            JSJsonPropertyAdapter.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/json/adapters/JSJsonPropertyAdapter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/json/adapters/JSJsonPropertyAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueAdaptersByType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createValueAdaptersByType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

