/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStub;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.Processor;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionImpl<StubT extends JSFunctionStub<?>>
extends JSFunctionBaseImpl<StubT>
implements JSSuppressionHolder,
JSFunctionDeclaration,
JSComputedPropertyNameOwner {
    public static final Icon CONSTRUCTOR_ICON = AllIcons.Nodes.Method;

    public JSFunctionImpl(ASTNode node) {
        super(node);
    }

    public JSFunctionImpl(StubT stub, IElementType type2) {
        super(stub, type2);
    }

    @Nullable
    public static JSType getReturnTypeInContext(@NotNull JSFunctionItem function, @Nullable PsiElement place) {
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(0);
        }
        return JSFunctionImpl.getReturnTypeInContext(function, place, JSExpectedTypeKind.CONTEXTUAL);
    }

    @Nullable
    public static JSType getReturnTypeInContext(@NotNull JSFunctionItem function, @Nullable PsiElement place, JSExpectedTypeKind kind) {
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(1);
        }
        JSType returnType2 = JSFunctionImpl.evaluateReturnTypeFromHierarchy(function);
        if (DialectDetector.isActionScript((PsiElement)function)) {
            return JSFunctionImpl.getActionScriptReturnTypeFromVector(function, place, returnType2);
        }
        return JSFunctionImpl.getWidenReturnType(function, kind, returnType2);
    }

    @Nullable
    private static JSType getWidenReturnType(@NotNull JSFunctionItem function, @NotNull JSExpectedTypeKind kind, @Nullable JSType returnType2) {
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            JSFunctionImpl.$$$reportNull$$$0(3);
        }
        if (!DialectDetector.isTypeScript((PsiElement)function)) {
            return JSTypeUtils.getApparentType(returnType2);
        }
        if (returnType2 == null || function instanceof JSFunction && (((JSFunction)function).getReturnTypeElement() != null || ((JSFunction)function).isConstructor())) {
            return returnType2;
        }
        return new JSWidenType(returnType2, new JSWidenType.ReturnTypeWidening(function, kind));
    }

    @Nullable
    private static JSType getActionScriptReturnTypeFromVector(@NotNull JSFunctionItem function, @Nullable PsiElement place, @Nullable JSType returnType2) {
        String name;
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(4);
        }
        if (returnType2 instanceof JSAnyType && ("pop".equals(name = function.getName()) || "shift".equals(name))) {
            JSResolveUtil.GenericSignature signature;
            String qualifiedExpressionType;
            JSExpression instance;
            JSType classType;
            PsiElement element2 = JSResolveUtil.findParent((PsiElement)function);
            JSType jSType = classType = element2 instanceof JSClass ? ((JSClass)element2).getJSType() : null;
            if (classType != null && JSTypeUtils.isActionScriptVectorType(classType) && place instanceof JSReferenceExpression && (instance = ((JSReferenceExpression)place).getQualifier()) != null && (qualifiedExpressionType = ActionScriptResolveUtil.getQualifiedExpressionType(instance, place.getContainingFile())) != null && (signature = JSResolveUtil.extractGenericSignature(qualifiedExpressionType)) != null) {
                return JSTypeParser.createType(function.getProject(), signature.genericType, JSTypeSourceFactory.createTypeSource(place));
            }
        } else if (JSGenericTypeImpl.isGenericActionScriptVectorType(returnType2) && place instanceof JSExpression) {
            JSExpression expression;
            JSExpression processedExpression = expression = (JSExpression)place;
            if (place instanceof JSReferenceExpression) {
                processedExpression = ((JSReferenceExpression)place).getQualifier();
            }
            if (processedExpression != null && processedExpression != expression) {
                String expressionType;
                JSExpression expressionToCheckType = processedExpression;
                PsiElement parent = processedExpression.getContext();
                if (parent instanceof JSCallExpression) {
                    expressionToCheckType = (JSExpression)parent;
                }
                if ((expressionType = ActionScriptResolveUtil.getQualifiedExpressionType(expressionToCheckType, expression.getContainingFile())) != null && (expressionType.equals("Vector") || expressionType.startsWith("Vector.<"))) {
                    return JSTypeParser.createType(function.getProject(), expressionType, JSTypeSourceFactory.createTypeSource(place));
                }
            }
        }
        return returnType2;
    }

    @Nullable
    public static JSType evaluateReturnTypeFromHierarchy(@NotNull JSFunctionItem function) {
        JSType type2;
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(5);
        }
        if (!((type2 = function.getReturnType()) == null || !type2.isSourceStrict() || type2 instanceof JSEvaluableOnlyType && type2.isJavaScript())) {
            return type2;
        }
        if (JSPsiImplUtils.isPotentialOverride(function)) {
            Ref overridden = Ref.create(null);
            JSInheritanceUtil.processNearestOverriddenMethods(function, (Processor<? super JSFunctionItem>)((Processor)function1 -> {
                overridden.set(function1);
                return function1 == null || function1.getReturnType() == null;
            }));
            if (!overridden.isNull()) {
                return ((JSFunctionItem)overridden.get()).getReturnType();
            }
        }
        return type2;
    }

    @Override
    public boolean isConstructor() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        PsiElement parent = JSResolveUtil.findParent(this);
        if (parent instanceof JSClass) {
            DialectOptionHolder dialect = DialectDetector.dialectOfElement(this);
            if (dialect != null && dialect.isECMA6) {
                return Comparing.equal((String)"constructor", (String)this.getName(), (boolean)true);
            }
            return Comparing.equal((String)((JSClass)parent).getName(), (String)ActionScriptResolveUtil.replaceInternalName(this.getName()), (boolean)true);
        }
        return super.isConstructor();
    }

    @Override
    @Nullable
    public ES6ComputedName getComputedPropertyName() {
        return this.getStubOrPsiChild(JSStubElementTypes.COMPUTED_NAME);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSFunctionImpl.$$$reportNull$$$0(6);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSFunctionDeclaration(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public Icon getIcon(int flags) {
        return JSFunctionImpl.getFunctionIcon(this, flags);
    }

    public static Icon getFunctionIcon(JSFunctionItem function, int flags) {
        JSFunction.FunctionKind kind;
        PsiElement parent = JSResolveUtil.findParent((PsiElement)function);
        JSFunction.FunctionKind functionKind = kind = function instanceof JSFunction ? ((JSFunction)function).getKind() : JSFunction.FunctionKind.SIMPLE;
        if (parent instanceof TypeScriptModule) {
            Icon accessModifierIcon = JSVisibilityUtil.getAccessModifierIcon(function);
            return JSFunctionImpl.iconWithVisibilityIfNeeded((int)flags, (Icon)IconManager.getInstance().getPlatformIcon(PlatformIcons.Function), (Icon)accessModifierIcon);
        }
        if (parent instanceof JSClass || parent instanceof JSPackageStatement) {
            JSAttributeList attributeList;
            JSAttributeList jSAttributeList = attributeList = function instanceof JSAttributeListOwner ? ((JSAttributeListOwner)((Object)function)).getAttributeList() : null;
            if (attributeList != null && function instanceof JSFunction) {
                boolean isStatic = attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                Icon baseIcon = JSFunctionImpl.blendModifierFlags(switch (kind) {
                    case JSFunction.FunctionKind.GETTER -> isStatic ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
                    case JSFunction.FunctionKind.SETTER -> isStatic ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
                    case JSFunction.FunctionKind.CONSTRUCTOR -> CONSTRUCTOR_ICON;
                    case JSFunction.FunctionKind.SIMPLE -> IconManager.getInstance().getPlatformIcon(PlatformIcons.Method);
                    default -> {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("unexpected kind: " + String.valueOf((Object)kind)));
                        }
                        yield IconManager.getInstance().getPlatformIcon(PlatformIcons.Method);
                    }
                }, attributeList, kind == JSFunction.FunctionKind.SIMPLE, flags);
                Icon accessModifierIcon = JSVisibilityUtil.getAccessModifierIcon(function);
                return JSFunctionImpl.iconWithVisibilityIfNeeded((int)flags, (Icon)baseIcon, (Icon)accessModifierIcon);
            }
        }
        return JSFunctionImpl.getIcon(function, kind == JSFunction.FunctionKind.DECORATOR ? AllIcons.Nodes.Annotationtype : JSFunctionImpl.getFunctionBaseIcon(function), flags);
    }

    @NotNull
    public static Icon getFunctionBaseIcon(@NotNull JSFunctionItem function) {
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(7);
        }
        JSQualifiedName namespace = function.getNamespace();
        IconManager iconManager = IconManager.getInstance();
        if (namespace == null) {
            Icon icon = iconManager.getPlatformIcon(function.isNamespaceExplicitlyDeclared() ? PlatformIcons.Function : PlatformIcons.Method);
            if (icon == null) {
                JSFunctionImpl.$$$reportNull$$$0(8);
            }
            return icon;
        }
        Icon icon = iconManager.getPlatformIcon(JSSymbolUtil.isExportsOrGlobalNamespace(namespace) ? PlatformIcons.Function : PlatformIcons.Method);
        if (icon == null) {
            JSFunctionImpl.$$$reportNull$$$0(9);
        }
        return icon;
    }

    @Override
    @Nullable
    public final JSQualifiedName getNamespace() {
        return this.getJSNamespace().getQualifiedName();
    }

    @Override
    @NotNull
    public final JSContext getJSContext() {
        JSContext jSContext = this.getJSNamespace().getJSContext();
        if (jSContext == null) {
            JSFunctionImpl.$$$reportNull$$$0(10);
        }
        return jSContext;
    }

    @Override
    public final boolean isNamespaceExplicitlyDeclared() {
        return this.getJSNamespace().isSourceStrict();
    }

    @Override
    @NotNull
    public final JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = (JSNamespace)JSFunctionImpl.getCachedValueStubBuildOptimized(this, NAMESPACE_PROVIDER_KEY, STUB_BUILDING_NAMESPACE_PROVIDER_KEY, NAMESPACE_PROVIDER, this);
        if (jSNamespace == null) {
            JSFunctionImpl.$$$reportNull$$$0(11);
        }
        return jSNamespace;
    }

    @NotNull
    public SearchScope getUseScope() {
        if (this.isConstructor()) {
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                JSFunctionImpl.$$$reportNull$$$0(12);
            }
            return searchScope;
        }
        SearchScope searchScope = JSUseScopeProvider.findUseScope(this);
        if (searchScope == null) {
            JSFunctionImpl.$$$reportNull$$$0(13);
        }
        return searchScope;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement parentOriginalElement;
        PsiElement parent = this.getParent();
        if (parent instanceof JSClass && (parentOriginalElement = parent.getNavigationElement()) != parent) {
            JSFunction functionByNameAndKind = ((JSClass)parentOriginalElement).findFunctionByNameAndKind(this.getName(), this.getKind());
            Object object = functionByNameAndKind != null ? functionByNameAndKind : (this.isActionScriptDecompiledConstructor() ? parentOriginalElement : this);
            if (object == null) {
                JSFunctionImpl.$$$reportNull$$$0(14);
            }
            return object;
        }
        PsiElement psiElement = JSPsiImplUtils.findTopLevelNavigatableElement(this);
        if (psiElement == null) {
            JSFunctionImpl.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    private boolean isActionScriptDecompiledConstructor() {
        if (!this.isConstructor() || !DialectDetector.isActionScript(this)) {
            return false;
        }
        JSAttributeList attributeList = this.getAttributeList();
        if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.NATIVE)) {
            return false;
        }
        JSParameterList parameterList = this.getParameterList();
        if (parameterList == null || parameterList.getParameters().length != 0) {
            return false;
        }
        return this.getReturnType() instanceof JSAnyType;
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof JSVariable) {
            String name = ((JSVariable)another).getName();
            if (Objects.equals(this.getName(), name) && ActionScriptResolveUtil.fieldIsImplicitAccessorMethod(this, (JSVariable)another)) {
                return true;
            }
        }
        return super.isEquivalentTo(another);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionBaseIcon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeInContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWidenReturnType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActionScriptReturnTypeFromVector";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluateReturnTypeFromHierarchy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionBaseIcon";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

