/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.configurationStore.Property;
import com.intellij.database.util.Case;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsUtils;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsDefault;
import com.intellij.sql.psi.SqlLanguage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCodeStyleSettings
extends CustomCodeStyleSettings
implements SqlCodeStyleConst {
    protected final boolean myGeneral;
    @NotNull
    protected final String myDialectCode;
    public int myVersion;
    protected boolean myInitialized;
    protected boolean myLoaded;
    private static final Set<String> SETTINGS_TO_HIDE = Set.of("IMP_DECLARE_ALIGN_LINE_COMMENTS");
    @NotNull
    private Set<String> myLoadedOptions;
    public boolean USE_GENERAL_STYLE;
    public boolean DISABLE_FORMATTING;
    @SqlCodeStyleConst.IdentifierCase
    public int KEYWORD_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int IDENTIFIER_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int TYPE_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int CUSTOM_TYPE_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int ALIAS_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int BUILT_IN_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int QUOTED_IDENTIFIER_CASE;
    public boolean ORIGINAL_CASE;
    public int QUOTE_IDENTIFIER;
    public int QUOTE_TYPE;
    @Property(externalName="query_sections_align")
    public int QUERY_SECTION_1ST_WORD_ALIGN;
    @Property(externalName="query_elements_place")
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int QUERY_EL_LINE;
    @Property(externalName="query_elements_comma")
    @SqlCodeStyleConst.CommaMagicValues
    public int QUERY_EL_COMMA;
    @Property(externalName="query_collapse_to_one_string")
    public int QUERY_IN_ONE_STRING;
    @Property(externalName="query_elements_true_indent")
    public boolean QUERY_TRUE_INDENT;
    @Property(externalName="query_elements_align")
    public boolean QUERY_ALIGN_ELEMENTS;
    @Property(externalName="query_line_comments_align")
    public boolean QUERY_ALIGN_LINE_COMMENTS;
    @Property(externalName="subquery_opening_place")
    @SqlCodeStyleConst.OpeningMagicValues
    public int SUBQUERY_OPENING;
    @Property(externalName="subquery_content_place")
    @SqlCodeStyleConst.ContentMagicValues
    public int SUBQUERY_CONTENT;
    @Property(externalName="subquery_closing_place")
    @SqlCodeStyleConst.ClosingMagicValues
    public int SUBQUERY_CLOSING;
    @Property(externalName="subquery_space_before_parenthesis")
    public int SUBQUERY_PAR_SPACE_BEFORE;
    @Property(externalName="subquery_space_within_parentheses")
    public boolean SUBQUERY_PAR_SPACE_INSIDE;
    @Property(externalName="insert_into_on_next_line")
    @SqlCodeStyleConst.AddRemoveAsIsMagicValues
    public int INSERT_INTO_NL;
    @Property(externalName="insert_opening_place")
    @SqlCodeStyleConst.OpeningMagicValues
    public int INSERT_OPENING;
    @Property(externalName="insert_content_place")
    @SqlCodeStyleConst.ContentMagicValues
    public int INSERT_CONTENT;
    @Property(externalName="insert_closing_place")
    @SqlCodeStyleConst.ClosingMagicValues
    public int INSERT_CLOSING;
    @Property(externalName="insert_table_columns_place")
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int INSERT_TABLE_EL_LINE;
    @Property(externalName="insert_values_place")
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int INSERT_VALUES_EL_LINE;
    @Property(externalName="insert_values_wrap")
    @SqlCodeStyleConst.WrapMagicValues
    public int INSERT_EL_WRAP;
    @Property(externalName="insert_values_comma")
    @SqlCodeStyleConst.CommaMagicValues
    public int INSERT_EL_COMMA;
    @Property(externalName="insert_space_within_parentheses")
    public boolean INSERT_SPACE_WITHIN_PARENTHESES;
    @Property(externalName="insert_collapse_multi_rows")
    public boolean INSERT_COLLAPSE_MULTI_ROW_VALUES;
    @Property(externalName="insert_matrix_align")
    public boolean INSERT_MATRIX_ALIGN;
    @Property(externalName="insert_matrix_include_header")
    public boolean INSERT_MATRIX_INCLUDING_HEADER;
    @Property(externalName="insert_matrix_mode")
    public int INSERT_MATRIX_MODE;
    @Property(externalName="insert_matrix_min_widening_threshold")
    public int INSERT_MATRIX_MIN_WIDENING_THRESHOLD;
    @Property(externalName="insert_matrix_break_threshold")
    public int INSERT_MATRIX_BREAK_THRESHOLD;
    @Property(externalName="set_elements_place")
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int SET_EL_LINE;
    @Property(externalName="set_elements_wrap")
    @SqlCodeStyleConst.WrapMagicValues
    public int SET_EL_WRAP;
    @Property(externalName="set_elements_comma")
    @SqlCodeStyleConst.ContentMagicValues
    public int SET_EL_COMMA;
    @Property(externalName="set_equal_sign_align")
    public boolean SET_ALIGN_EQUAL_SIGN;
    @Property(externalName="with_elements_place")
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int WITH_EL_LINE;
    @Property(externalName="with_elements_wrap")
    @SqlCodeStyleConst.Wrap2MagicValues
    public int WITH_EL_WRAP;
    @Property(externalName="with_elements_comma")
    @SqlCodeStyleConst.CommaMagicValues
    public int WITH_EL_COMMA;
    @Property(externalName="with_as_align")
    public boolean WITH_ALIGN_AS;
    @Property(externalName="select_elements_place")
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int SELECT_EL_LINE;
    @Property(externalName="select_elements_wrap")
    @SqlCodeStyleConst.WrapMagicValues
    public int SELECT_EL_WRAP;
    @Property(externalName="select_elements_comma")
    @SqlCodeStyleConst.CommaMagicValues
    public int SELECT_EL_COMMA;
    @Property(externalName="select_break_after_distinct")
    public boolean SELECT_NEW_LINE_AFTER_ALL_DISTINCT;
    @Property(externalName="select_collapse_when")
    public int SELECT_KEEP_N_ITEMS_IN_LINE;
    @Property(externalName="select_as_use")
    public int SELECT_USE_AS_WORD;
    @Property(externalName="select_as_align")
    public boolean SELECT_ALIGN_AS;
    @Property(externalName="select_asterisk_regular")
    public boolean SELECT_ASTERISK_REGULAR;
    @Property(externalName="from_elements_place")
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int FROM_EL_LINE;
    @Property(externalName="from_elements_wrap")
    @SqlCodeStyleConst.WrapMagicValues
    public int FROM_EL_WRAP;
    @Property(externalName="from_elements_comma")
    @SqlCodeStyleConst.CommaMagicValues
    public int FROM_EL_COMMA;
    @Property(externalName="from_first_join_wrap")
    public boolean FROM_WRAP_JOIN_1;
    @Property(externalName="from_next_join_wrap")
    public boolean FROM_WRAP_JOIN_2;
    @Property(externalName="from_on_wrap")
    public boolean FROM_WRAP_ON;
    @Property(externalName="from_join_align")
    public boolean FROM_ALIGN_JOIN_TABLES;
    @Property(externalName="from_aliases_align")
    public boolean FROM_ALIGN_ALIASES;
    @Property(externalName="from_join_indent")
    public boolean FROM_INDENT_JOIN;
    @Property(externalName="from_only_join_indent")
    @SqlCodeStyleConst.FromOnlyJoinIndentValues
    public int FROM_ONLY_JOIN_INDENT;
    @Property(externalName="from_on_place")
    @SqlCodeStyleConst.FromPlaceOnValues
    public int FROM_PLACE_ON;
    @Property(externalName="where_elements_place")
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int WHERE_EL_LINE;
    @Property(externalName="where_elements_wrap")
    @SqlCodeStyleConst.WrapMagicValues
    public int WHERE_EL_WRAP;
    @Property(externalName="where_elements_comma")
    @SqlCodeStyleConst.CommaMagicValues
    public int WHERE_EL_BOUND;
    @Property(externalName="order_elements_place")
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int ORDER_EL_LINE;
    @Property(externalName="order_elements_wrap")
    @SqlCodeStyleConst.WrapMagicValues
    public int ORDER_EL_WRAP;
    @Property(externalName="order_elements_comma")
    @SqlCodeStyleConst.CommaMagicValues
    public int ORDER_EL_COMMA;
    @Property(externalName="order_direction_align")
    public boolean ORDER_ALIGN_ASC_DESC;
    @Property(externalName="table_elements_place")
    @SqlCodeStyleConst.OpeningMagicValues
    public int TABLE_OPENING;
    @Property(externalName="table_elements_wrap")
    @SqlCodeStyleConst.ContentMagicValues
    public int TABLE_CONTENT;
    @Property(externalName="table_elements_comma")
    @SqlCodeStyleConst.ClosingMagicValues
    public int TABLE_CLOSING;
    @Property(externalName="table_types_align")
    public boolean TABLE_TYPES_ALIGN;
    @Property(externalName="table_defaults_align")
    public boolean TABLE_DEFAULTS_ALIGN;
    @Property(externalName="table_nullabilities_align")
    public boolean TABLE_NULLABILITIES_ALIGN;
    @Property(externalName="table_collapse")
    public boolean TABLE_COLLAPSE;
    @Property(externalName="table_alter_instruction_wrap")
    @SqlCodeStyleConst.AddRemoveAsIsMagicValues
    public int TABLE_ALTER_INSTRUCTION_WRAP;
    @Property(externalName="table_alter_instruction_indent")
    public boolean TABLE_ALTER_INSTRUCTION_INDENT;
    @Property(externalName="table_alter_instruction_align")
    public boolean TABLE_ALTER_INSTRUCTION_ALIGN;
    @Property(externalName="table_alter_item_wrap")
    @SqlCodeStyleConst.AddRemoveAsIsMagicValues
    public int TABLE_ALTER_ITEM_WRAP;
    @Property(externalName="table_alter_item_indent")
    public boolean TABLE_ALTER_ITEM_INDENT;
    @Property(externalName="table_alter_item_align")
    public boolean TABLE_ALTER_ITEM_ALIGN;
    @Property(externalName="constraint_level_1_wrap")
    public boolean CONSTRAINT_WRAP_1;
    @Property(externalName="constraint_level_2_wrap")
    public boolean CONSTRAINT_WRAP_2;
    @Property(externalName="constraint_level_3_wrap")
    public boolean CONSTRAINT_WRAP_3;
    @Property(externalName="constraint_level_4_wrap")
    public boolean CONSTRAINT_WRAP_4;
    @Property(externalName="postfix_first_option_wrap")
    public boolean POST_OPT_WRAP_1;
    @Property(externalName="postfix_next_option_wrap")
    public boolean POST_OPT_WRAP_2;
    @Property(externalName="postfix_option_indent")
    public boolean POST_OPT_INDENT;
    @Property(externalName="postfix_option_align")
    public boolean POST_OPT_ALIGN;
    @Property(externalName="schema_content_indent")
    public boolean CREATE_SCHEMA_CONTENT_INDENT;
    @Property(externalName="schema_blank_lines_min")
    public int CREATE_SCHEMA_BLANK_LINES_MIN;
    @Property(externalName="schema_blank_lines_max")
    public int CREATE_SCHEMA_BLANK_LINES_MAX;
    @Property(externalName="view_as_wrap")
    public boolean VIEW_WRAP_AS;
    @Property(externalName="view_query_wrap")
    public boolean VIEW_WRAP_QUERY;
    @Property(externalName="view_query_indent")
    public boolean VIEW_INDENT_QUERY;
    @Property(externalName="routine_arg_opening_place")
    @SqlCodeStyleConst.OpeningMagicValues
    public int ROUTINE_ARG_OPENING;
    @Property(externalName="routine_arg_content_place")
    @SqlCodeStyleConst.ContentMagicValues
    public int ROUTINE_ARG_CONTENT;
    @Property(externalName="routine_arg_closing_place")
    @SqlCodeStyleConst.ClosingMagicValues
    public int ROUTINE_ARG_CLOSING;
    @Property(externalName="routine_arg_wrap")
    @SqlCodeStyleConst.WrapMagicValues
    public int ROUTINE_ARG_WRAP;
    @Property(externalName="routine_arg_comma")
    @SqlCodeStyleConst.CommaMagicValues
    public int ROUTINE_ARG_COMMA;
    @Property(externalName="routine_arg_space_within_parentheses")
    public boolean ROUTINE_ARG_SPACE_WITHIN_PARENTHESES;
    @Property(externalName="routine_arg_types_align")
    public boolean ROUTINE_ARG_ALIGN_TYPES;
    @Property(externalName="routine_as_wrap")
    public boolean ROUTINE_AS_WRAP;
    public boolean ROUTINE_PG_L_QUOTE_WRAP_BEFORE;
    public boolean ROUTINE_PG_L_QUOTE_WRAP_AFTER;
    public boolean ROUTINE_PG_R_QUOTE_WRAP_BEFORE;
    public boolean ROUTINE_PG_R_QUOTE_WRAP_AFTER;
    @Property(externalName="script_stmt_semicolon_wrap")
    @SqlCodeStyleConst.AddRemoveAsIsMagicValues
    public int SCRIPT_STMT_SEMICOLON_WRAP;
    @Property(externalName="script_stmt_follows_blank_line")
    @SqlCodeStyleConst.AddRemoveAsIsMagicValues
    public int SCRIPT_STMT_FOLLOWS_BLANK_LINE;
    @Property(externalName="imp_statements_force_wrap")
    public boolean IMP_COMMON_WRAP_EVERY_STATEMENT;
    @Property(externalName="imp_statements_keep_blank_lines")
    public int IMP_COMMON_KEEP_BLANK_LINES_IN_CODE;
    @Property(externalName="imp_declare_content_wrap")
    public boolean IMP_DECLARE_CONTENT_WRAP;
    @Property(externalName="imp_declare_elements_wrap")
    @SqlCodeStyleConst.WrapMagicValues
    public int IMP_DECLARE_EL_WRAP;
    @Property(externalName="imp_declare_types_align")
    public boolean IMP_DECLARE_ALIGN_TYPE;
    @Property(externalName="imp_declare_assignments_align")
    public boolean IMP_DECLARE_ALIGN_EQ;
    @Property(externalName="imp_declare_defaults_align")
    public boolean IMP_DECLARE_ALIGN_DEFAULT;
    @Property(externalName="imp_declare_line_comments_align")
    public boolean IMP_DECLARE_ALIGN_LINE_COMMENTS;
    @Property(externalName="imp_fork_then_wrap")
    public boolean IMP_IF_THEN_WRAP_THEN;
    @Property(externalName="imp_fork_else_wrap")
    public boolean IMP_IF_THEN_WRAP_ELSE;
    @Property(externalName="imp_fork_content_wrap")
    public boolean IMP_IF_THEN_WRAP_INNER;
    @Property(externalName="imp_fork_branch_indent")
    public boolean IMP_IF_THEN_INDENT_THEN_ELSE;
    @Property(externalName="imp_fork_end_indent")
    public boolean IMP_IF_THEN_INDENT_END;
    @Property(externalName="imp_fork_collapse")
    public boolean IMP_IF_THEN_COLLAPSE;
    @Property(externalName="imp_loop_keyword_wrap")
    public boolean IMP_LOOP_LOOP_WRAP;
    @Property(externalName="imp_loop_keyword_indent")
    public boolean IMP_LOOP_LOOP_INDENT;
    @Property(externalName="imp_loop_end_indent")
    public boolean IMP_LOOP_END_INDENT;
    @Property(externalName="imp_loop_collapse")
    public boolean IMP_LOOP_COLLAPSE;
    @Property(externalName="cortege_opening_space_before")
    public boolean CORTEGE_SPACE_BEFORE_L_PAREN;
    @Property(externalName="cortege_comma1st")
    public boolean CORTEGE_COMMA_1ST;
    @Property(externalName="cortege_closing_place")
    public int CORTEGE_CLOSING;
    @Property(externalName="cortege_space_within_parentheses")
    public boolean CORTEGE_SPACE_WITHIN_PARENTHESES;
    @Property(externalName="cortege_comma_space_before")
    public boolean CORTEGE_SPACE_BEFORE_COMMA;
    @Property(externalName="cortege_comma_space_after")
    public boolean CORTEGE_SPACE_AFTER_COMMA;
    @Property(externalName="expr_space_around_operator")
    public int EXPR_SPACE_AROUND_OPERATOR;
    @Property(externalName="expr_space_within_parentheses")
    public boolean EXPR_SPACE_WITHIN_PARENTHESES;
    @Property(externalName="expr_operator_align")
    public boolean EXPR_BINARY_OP_ALIGN;
    @Property(externalName="expr_call_space_within_parentheses")
    public boolean EXPR_CALL_SPACE_INSIDE_PARENTHESES;
    @Property(externalName="expr_call_comma_space_before")
    public boolean EXPR_CALL_SPACE_BEFORE_COMMA;
    @Property(externalName="expr_call_comma_space_after")
    public boolean EXPR_CALL_SPACE_AFTER_COMMA;
    @Property(externalName="expr_case_when_wrap")
    public boolean EXPR_CASE_WHEN_WRAP;
    @Property(externalName="expr_case_when_indent")
    public boolean EXPR_CASE_WHEN_INDENT;
    @Property(externalName="expr_case_then_wrap")
    public boolean EXPR_CASE_THEN_WRAP;
    @Property(externalName="expr_case_then_align")
    public boolean EXPR_CASE_THEN_ALIGN;
    @Property(externalName="expr_case_else_under_then")
    public boolean EXPR_CASE_ELSE_ALIGN_THEN;
    @Property(externalName="expr_case_end_place")
    public int EXPR_CASE_END;
    @Property(externalName="expr_case_then_keep_following_linebreak")
    public boolean EXPR_CASE_KEEP_NL_AFTER_THEN;
    @Property(externalName="expr_case_collapse")
    public boolean EXPR_CASE_COLLAPSE;
    public String INDEX_NAME_TEMPLATE;
    public String PRIMARY_KEY_NAME_TEMPLATE;
    public String FOREIGN_KEY_NAME_TEMPLATE;
    @Deprecated
    public boolean USE_GENERIC_STYLE;
    @Deprecated
    public boolean SUBQUERY_L_PAR_NL_OUTSIDE;
    @Deprecated
    public boolean SUBQUERY_L_PAR_NL_INSIDE;
    @Deprecated
    public boolean SUBQUERY_R_PAR_NL_INSIDE;
    @Deprecated
    public int SUBQUERY_R_PAR_ALIGN;
    @Deprecated
    public boolean SUBQUERY_INDENT_INSIDE;
    @Deprecated
    public boolean SPACES_AROUND_OPERATORS;
    @Deprecated
    public boolean ALIGN_AS_IN_SELECT_STATEMENT;
    @Deprecated
    public boolean ALIGN_TYPE_IN_CREATE_STATEMENT;
    @Deprecated
    public boolean ALIGN_TYPE_IN_BLOCK_STATEMENT;
    @Deprecated
    public boolean ALIGN_TYPE_IN_ARGUMENT_DEFINITION;
    @Deprecated
    public boolean ALIGN_INSIDE_BINARY_EXPRESSION;
    @Deprecated
    public boolean ALIGN_INSIDE_QUERY_EXPRESSION;
    @Deprecated
    public boolean ALIGN_EQ_INSIDE_SET_CLAUSE;
    @Deprecated
    public boolean NEW_LINE_BEFORE_FROM;
    @Deprecated
    public boolean NEW_LINE_BEFORE_JOIN;
    @Deprecated
    public boolean NEW_LINE_BEFORE_JOIN_CONDITION;
    @Deprecated
    public boolean NEW_LINE_BEFORE_WHERE;
    @Deprecated
    public boolean NEW_LINE_BEFORE_GROUP_BY;
    @Deprecated
    public boolean NEW_LINE_BEFORE_ORDER_BY;
    @Deprecated
    public boolean NEW_LINE_BEFORE_HAVING;
    @Deprecated
    public boolean NEW_LINE_BEFORE_THEN;
    @Deprecated
    public boolean NEW_LINE_BEFORE_ELSE;
    @Deprecated
    public boolean NEW_LINE_BEFORE_OTHER_CLAUSES;
    @Deprecated
    public boolean NEW_LINE_BEFORE_COMMA;
    @Deprecated
    public boolean NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS;
    @Deprecated
    public boolean NEW_LINE_BEFORE_QUERY_INSIDE_DML;
    @Deprecated
    public boolean NEW_LINE_AROUND_SEMICOLON;
    @Deprecated
    public boolean INDENT_JOIN;
    @Deprecated
    public boolean INDENT_JOIN_CONDITION;
    @Deprecated
    public boolean INDENT_SELECT_INTO_CLAUSE;
    @Deprecated
    public int WRAP_INSIDE_CREATE_TABLE;
    @Deprecated
    public int WRAP_INSIDE_SELECT;
    @Deprecated
    public int WRAP_INSIDE_JOIN_EXPRESSION;
    @Deprecated
    public int WRAP_INSIDE_GROUP_BY;
    @Deprecated
    public int WRAP_INSIDE_WHERE;
    @Deprecated
    public int WRAP_INSIDE_ORDER_BY;
    @Deprecated
    public int WRAP_INSIDE_SET;
    @Deprecated
    public int WRAP_INSIDE_ARGUMENT_DEFINITION;
    @Deprecated
    public int WRAP_INSIDE_CALL_EXPRESSION;
    @Deprecated
    public int WRAP_INSIDE_VALUES_EXPRESSION;
    @Deprecated
    public int WRAP_VALUES_EXPRESSION;
    @Deprecated
    public int WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES;
    @Deprecated
    public boolean NEW_LINE_AFTER_SELECT;
    @Deprecated
    public boolean NEW_LINE_AFTER_SELECT_ITEM;
    @Deprecated
    public int NEW_LINE_AFTER_SELECT_2;
    private static final Logger LOG = Logger.getInstance(SqlCodeStyleSettings.class);

    public SqlCodeStyleSettings(@NotNull String dialectCode, @NotNull CodeStyleSettings container) {
        if (dialectCode == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(0);
        }
        if (container == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(1);
        }
        this(dialectCode, container, false);
    }

    @ApiStatus.Internal
    public SqlCodeStyleSettings(@NotNull String dialectCode, @NotNull CodeStyleSettings container, boolean general) {
        if (dialectCode == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(2);
        }
        if (container == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(3);
        }
        super(dialectCode + "CodeStyleSettings", container);
        this.myVersion = 7;
        this.myInitialized = false;
        this.myLoaded = false;
        this.myLoadedOptions = Collections.emptySet();
        this.DISABLE_FORMATTING = false;
        this.KEYWORD_CASE = SqlCodeStyleSettingsDefault.MODERN.KEYWORD_CASE;
        this.IDENTIFIER_CASE = SqlCodeStyleSettingsDefault.MODERN.IDENTIFIER_CASE;
        this.TYPE_CASE = SqlCodeStyleSettingsDefault.MODERN.TYPE_CASE;
        this.CUSTOM_TYPE_CASE = SqlCodeStyleSettingsDefault.MODERN.CUSTOM_TYPE_CASE;
        this.ALIAS_CASE = SqlCodeStyleSettingsDefault.MODERN.ALIAS_CASE;
        this.BUILT_IN_CASE = SqlCodeStyleSettingsDefault.MODERN.BUILT_IN_CASE;
        this.QUOTED_IDENTIFIER_CASE = SqlCodeStyleSettingsDefault.MODERN.QUOTED_IDENTIFIER_CASE;
        this.ORIGINAL_CASE = SqlCodeStyleSettingsDefault.MODERN.ORIGINAL_CASE;
        this.QUOTE_IDENTIFIER = SqlCodeStyleSettingsDefault.MODERN.QUOTE_IDENTIFIER;
        this.QUOTE_TYPE = SqlCodeStyleSettingsDefault.MODERN.QUOTE_TYPE;
        this.QUERY_SECTION_1ST_WORD_ALIGN = SqlCodeStyleSettingsDefault.MODERN.QUERY_SECTION_1ST_WORD_ALIGN;
        this.QUERY_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.QUERY_EL_LINE;
        this.QUERY_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.QUERY_EL_COMMA;
        this.QUERY_IN_ONE_STRING = SqlCodeStyleSettingsDefault.MODERN.QUERY_IN_ONE_STRING;
        this.QUERY_TRUE_INDENT = SqlCodeStyleSettingsDefault.MODERN.QUERY_TRUE_INDENT;
        this.QUERY_ALIGN_ELEMENTS = SqlCodeStyleSettingsDefault.MODERN.QUERY_ALIGN_ELEMENTS;
        this.QUERY_ALIGN_LINE_COMMENTS = SqlCodeStyleSettingsDefault.MODERN.QUERY_ALIGN_LINE_COMMENTS;
        this.SUBQUERY_OPENING = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_OPENING;
        this.SUBQUERY_CONTENT = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_CONTENT;
        this.SUBQUERY_CLOSING = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_CLOSING;
        this.SUBQUERY_PAR_SPACE_BEFORE = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_PAR_SPACE_BEFORE;
        this.SUBQUERY_PAR_SPACE_INSIDE = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_PAR_SPACE_INSIDE;
        this.INSERT_INTO_NL = SqlCodeStyleSettingsDefault.MODERN.INSERT_INTO_NL;
        this.INSERT_OPENING = SqlCodeStyleSettingsDefault.MODERN.INSERT_OPENING;
        this.INSERT_CONTENT = SqlCodeStyleSettingsDefault.MODERN.INSERT_CONTENT;
        this.INSERT_CLOSING = SqlCodeStyleSettingsDefault.MODERN.INSERT_CLOSING;
        this.INSERT_TABLE_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.INSERT_TABLE_EL_LINE;
        this.INSERT_VALUES_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.INSERT_VALUES_EL_LINE;
        this.INSERT_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.INSERT_EL_WRAP;
        this.INSERT_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.INSERT_EL_COMMA;
        this.INSERT_SPACE_WITHIN_PARENTHESES = SqlCodeStyleSettingsDefault.MODERN.INSERT_SPACE_WITHIN_PARENTHESES;
        this.INSERT_COLLAPSE_MULTI_ROW_VALUES = SqlCodeStyleSettingsDefault.MODERN.INSERT_COLLAPSE_MULTI_ROW_VALUES;
        this.INSERT_MATRIX_ALIGN = SqlCodeStyleSettingsDefault.MODERN.INSERT_MATRIX_ALIGN;
        this.INSERT_MATRIX_INCLUDING_HEADER = SqlCodeStyleSettingsDefault.MODERN.INSERT_MATRIX_INCLUDING_HEADER;
        this.INSERT_MATRIX_MODE = SqlCodeStyleSettingsDefault.MODERN.INSERT_MATRIX_MODE;
        this.INSERT_MATRIX_MIN_WIDENING_THRESHOLD = SqlCodeStyleSettingsDefault.MODERN.INSERT_MATRIX_MIN_WIDENING_THRESHOLD;
        this.INSERT_MATRIX_BREAK_THRESHOLD = SqlCodeStyleSettingsDefault.MODERN.INSERT_MATRIX_BREAK_THRESHOLD;
        this.SET_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.SET_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.SET_EL_WRAP;
        this.SET_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.SET_EL_COMMA;
        this.SET_ALIGN_EQUAL_SIGN = SqlCodeStyleSettingsDefault.MODERN.SET_ALIGN_EQUAL_SIGN;
        this.WITH_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.WITH_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.WITH_EL_WRAP;
        this.WITH_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.WITH_EL_COMMA;
        this.WITH_ALIGN_AS = SqlCodeStyleSettingsDefault.MODERN.WITH_ALIGN_AS;
        this.SELECT_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.SELECT_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.SELECT_EL_WRAP;
        this.SELECT_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.SELECT_EL_COMMA;
        this.SELECT_NEW_LINE_AFTER_ALL_DISTINCT = SqlCodeStyleSettingsDefault.MODERN.SELECT_NEW_LINE_AFTER_ALL_DISTINCT;
        this.SELECT_KEEP_N_ITEMS_IN_LINE = SqlCodeStyleSettingsDefault.MODERN.SELECT_KEEP_N_ITEMS_IN_LINE;
        this.SELECT_USE_AS_WORD = SqlCodeStyleSettingsDefault.MODERN.SELECT_USE_AS_WORD;
        this.SELECT_ALIGN_AS = SqlCodeStyleSettingsDefault.MODERN.SELECT_ALIGN_AS;
        this.SELECT_ASTERISK_REGULAR = SqlCodeStyleSettingsDefault.MODERN.SELECT_ASTERISK_REGULAR;
        this.FROM_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.FROM_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.FROM_EL_WRAP;
        this.FROM_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.FROM_EL_COMMA;
        this.FROM_WRAP_JOIN_1 = SqlCodeStyleSettingsDefault.MODERN.FROM_WRAP_JOIN_1;
        this.FROM_WRAP_JOIN_2 = SqlCodeStyleSettingsDefault.MODERN.FROM_WRAP_JOIN_2;
        this.FROM_WRAP_ON = SqlCodeStyleSettingsDefault.MODERN.FROM_WRAP_ON;
        this.FROM_ALIGN_JOIN_TABLES = SqlCodeStyleSettingsDefault.MODERN.FROM_ALIGN_JOIN_TABLES;
        this.FROM_ALIGN_ALIASES = SqlCodeStyleSettingsDefault.MODERN.FROM_ALIGN_ALIASES;
        this.FROM_INDENT_JOIN = SqlCodeStyleSettingsDefault.MODERN.FROM_INDENT_JOIN;
        this.FROM_ONLY_JOIN_INDENT = SqlCodeStyleSettingsDefault.MODERN.FROM_ONLY_JOIN_INDENT;
        this.FROM_PLACE_ON = SqlCodeStyleSettingsDefault.MODERN.FROM_PLACE_ON;
        this.WHERE_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.WHERE_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.WHERE_EL_WRAP;
        this.WHERE_EL_BOUND = SqlCodeStyleSettingsDefault.MODERN.WHERE_EL_BOUND;
        this.ORDER_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.ORDER_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.ORDER_EL_WRAP;
        this.ORDER_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.ORDER_EL_COMMA;
        this.ORDER_ALIGN_ASC_DESC = SqlCodeStyleSettingsDefault.MODERN.ORDER_ALIGN_ASC_DESC;
        this.TABLE_OPENING = SqlCodeStyleSettingsDefault.MODERN.TABLE_OPENING;
        this.TABLE_CONTENT = SqlCodeStyleSettingsDefault.MODERN.TABLE_CONTENT;
        this.TABLE_CLOSING = SqlCodeStyleSettingsDefault.MODERN.TABLE_CLOSING;
        this.TABLE_TYPES_ALIGN = SqlCodeStyleSettingsDefault.MODERN.TABLE_TYPES_ALIGN;
        this.TABLE_DEFAULTS_ALIGN = SqlCodeStyleSettingsDefault.MODERN.TABLE_DEFAULTS_ALIGN;
        this.TABLE_NULLABILITIES_ALIGN = SqlCodeStyleSettingsDefault.MODERN.TABLE_NULLABILITIES_ALIGN;
        this.TABLE_COLLAPSE = SqlCodeStyleSettingsDefault.MODERN.TABLE_COLLAPSE;
        this.TABLE_ALTER_INSTRUCTION_WRAP = SqlCodeStyleSettingsDefault.MODERN.TABLE_ALTER_INSTRUCTION_WRAP;
        this.TABLE_ALTER_INSTRUCTION_INDENT = SqlCodeStyleSettingsDefault.MODERN.TABLE_ALTER_INSTRUCTION_INDENT;
        this.TABLE_ALTER_INSTRUCTION_ALIGN = SqlCodeStyleSettingsDefault.MODERN.TABLE_ALTER_INSTRUCTION_ALIGN;
        this.TABLE_ALTER_ITEM_WRAP = SqlCodeStyleSettingsDefault.MODERN.TABLE_ALTER_ITEM_WRAP;
        this.TABLE_ALTER_ITEM_INDENT = SqlCodeStyleSettingsDefault.MODERN.TABLE_ALTER_ITEM_INDENT;
        this.TABLE_ALTER_ITEM_ALIGN = SqlCodeStyleSettingsDefault.MODERN.TABLE_ALTER_ITEM_ALIGN;
        this.CONSTRAINT_WRAP_1 = SqlCodeStyleSettingsDefault.MODERN.CONSTRAINT_WRAP_1;
        this.CONSTRAINT_WRAP_2 = SqlCodeStyleSettingsDefault.MODERN.CONSTRAINT_WRAP_2;
        this.CONSTRAINT_WRAP_3 = SqlCodeStyleSettingsDefault.MODERN.CONSTRAINT_WRAP_3;
        this.CONSTRAINT_WRAP_4 = SqlCodeStyleSettingsDefault.MODERN.CONSTRAINT_WRAP_4;
        this.POST_OPT_WRAP_1 = SqlCodeStyleSettingsDefault.MODERN.POST_OPT_WRAP_1;
        this.POST_OPT_WRAP_2 = SqlCodeStyleSettingsDefault.MODERN.POST_OPT_WRAP_2;
        this.POST_OPT_INDENT = SqlCodeStyleSettingsDefault.MODERN.POST_OPT_INDENT;
        this.POST_OPT_ALIGN = SqlCodeStyleSettingsDefault.MODERN.POST_OPT_ALIGN;
        this.CREATE_SCHEMA_CONTENT_INDENT = SqlCodeStyleSettingsDefault.MODERN.CREATE_SCHEMA_CONTENT_INDENT;
        this.CREATE_SCHEMA_BLANK_LINES_MIN = SqlCodeStyleSettingsDefault.MODERN.CREATE_SCHEMA_BLANK_LINES_MIN;
        this.CREATE_SCHEMA_BLANK_LINES_MAX = SqlCodeStyleSettingsDefault.MODERN.CREATE_SCHEMA_BLANK_LINES_MAX;
        this.VIEW_WRAP_AS = SqlCodeStyleSettingsDefault.MODERN.VIEW_WRAP_AS;
        this.VIEW_WRAP_QUERY = SqlCodeStyleSettingsDefault.MODERN.VIEW_WRAP_QUERY;
        this.VIEW_INDENT_QUERY = SqlCodeStyleSettingsDefault.MODERN.VIEW_INDENT_QUERY;
        this.ROUTINE_ARG_OPENING = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_OPENING;
        this.ROUTINE_ARG_CONTENT = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_CONTENT;
        this.ROUTINE_ARG_CLOSING = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_CLOSING;
        this.ROUTINE_ARG_WRAP = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_WRAP;
        this.ROUTINE_ARG_COMMA = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_COMMA;
        this.ROUTINE_ARG_SPACE_WITHIN_PARENTHESES = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_SPACE_WITHIN_PARENTHESES;
        this.ROUTINE_ARG_ALIGN_TYPES = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_ALIGN_TYPES;
        this.ROUTINE_AS_WRAP = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_AS_WRAP;
        this.ROUTINE_PG_L_QUOTE_WRAP_BEFORE = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_PG_L_QUOTE_WRAP_BEFORE;
        this.ROUTINE_PG_L_QUOTE_WRAP_AFTER = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_PG_L_QUOTE_WRAP_AFTER;
        this.ROUTINE_PG_R_QUOTE_WRAP_BEFORE = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_PG_R_QUOTE_WRAP_BEFORE;
        this.ROUTINE_PG_R_QUOTE_WRAP_AFTER = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_PG_R_QUOTE_WRAP_AFTER;
        this.SCRIPT_STMT_SEMICOLON_WRAP = SqlCodeStyleSettingsDefault.MODERN.SCRIPT_STMT_SEMICOLON_WRAP;
        this.SCRIPT_STMT_FOLLOWS_BLANK_LINE = SqlCodeStyleSettingsDefault.MODERN.SCRIPT_STMT_FOLLOWS_BLANK_LINE;
        this.IMP_COMMON_WRAP_EVERY_STATEMENT = SqlCodeStyleSettingsDefault.MODERN.IMP_COMMON_WRAP_EVERY_STATEMENT;
        this.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE = SqlCodeStyleSettingsDefault.MODERN.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE;
        this.IMP_DECLARE_CONTENT_WRAP = SqlCodeStyleSettingsDefault.MODERN.IMP_DECLARE_CONTENT_WRAP;
        this.IMP_DECLARE_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.IMP_DECLARE_EL_WRAP;
        this.IMP_DECLARE_ALIGN_TYPE = SqlCodeStyleSettingsDefault.MODERN.IMP_DECLARE_ALIGN_TYPE;
        this.IMP_DECLARE_ALIGN_EQ = SqlCodeStyleSettingsDefault.MODERN.IMP_DECLARE_ALIGN_EQ;
        this.IMP_DECLARE_ALIGN_DEFAULT = SqlCodeStyleSettingsDefault.MODERN.IMP_DECLARE_ALIGN_DEFAULT;
        this.IMP_DECLARE_ALIGN_LINE_COMMENTS = SqlCodeStyleSettingsDefault.MODERN.IMP_DECLARE_ALIGN_LINE_COMMENTS;
        this.IMP_IF_THEN_WRAP_THEN = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_WRAP_THEN;
        this.IMP_IF_THEN_WRAP_ELSE = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_WRAP_ELSE;
        this.IMP_IF_THEN_WRAP_INNER = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_WRAP_INNER;
        this.IMP_IF_THEN_INDENT_THEN_ELSE = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_INDENT_THEN_ELSE;
        this.IMP_IF_THEN_INDENT_END = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_INDENT_END;
        this.IMP_IF_THEN_COLLAPSE = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_COLLAPSE;
        this.IMP_LOOP_LOOP_WRAP = SqlCodeStyleSettingsDefault.MODERN.IMP_LOOP_LOOP_WRAP;
        this.IMP_LOOP_LOOP_INDENT = SqlCodeStyleSettingsDefault.MODERN.IMP_LOOP_LOOP_INDENT;
        this.IMP_LOOP_END_INDENT = SqlCodeStyleSettingsDefault.MODERN.IMP_LOOP_END_INDENT;
        this.IMP_LOOP_COLLAPSE = SqlCodeStyleSettingsDefault.MODERN.IMP_LOOP_COLLAPSE;
        this.CORTEGE_SPACE_BEFORE_L_PAREN = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_SPACE_BEFORE_L_PAREN;
        this.CORTEGE_COMMA_1ST = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_COMMA_1ST;
        this.CORTEGE_CLOSING = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_CLOSING;
        this.CORTEGE_SPACE_WITHIN_PARENTHESES = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_SPACE_WITHIN_PARENTHESES;
        this.CORTEGE_SPACE_BEFORE_COMMA = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_SPACE_BEFORE_COMMA;
        this.CORTEGE_SPACE_AFTER_COMMA = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_SPACE_AFTER_COMMA;
        this.EXPR_SPACE_AROUND_OPERATOR = SqlCodeStyleSettingsDefault.MODERN.EXPR_SPACE_AROUND_OPERATOR;
        this.EXPR_SPACE_WITHIN_PARENTHESES = SqlCodeStyleSettingsDefault.MODERN.EXPR_SPACE_WITHIN_PARENTHESES;
        this.EXPR_BINARY_OP_ALIGN = SqlCodeStyleSettingsDefault.MODERN.EXPR_BINARY_OP_ALIGN;
        this.EXPR_CALL_SPACE_INSIDE_PARENTHESES = SqlCodeStyleSettingsDefault.MODERN.EXPR_CALL_SPACE_INSIDE_PARENTHESES;
        this.EXPR_CALL_SPACE_BEFORE_COMMA = SqlCodeStyleSettingsDefault.MODERN.EXPR_CALL_SPACE_BEFORE_COMMA;
        this.EXPR_CALL_SPACE_AFTER_COMMA = SqlCodeStyleSettingsDefault.MODERN.EXPR_CALL_SPACE_AFTER_COMMA;
        this.EXPR_CASE_WHEN_WRAP = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_WHEN_WRAP;
        this.EXPR_CASE_WHEN_INDENT = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_WHEN_INDENT;
        this.EXPR_CASE_THEN_WRAP = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_THEN_WRAP;
        this.EXPR_CASE_THEN_ALIGN = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_THEN_ALIGN;
        this.EXPR_CASE_ELSE_ALIGN_THEN = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_ELSE_ALIGN_THEN;
        this.EXPR_CASE_END = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_END;
        this.EXPR_CASE_KEEP_NL_AFTER_THEN = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_KEEP_NL_AFTER_THEN;
        this.EXPR_CASE_COLLAPSE = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_COLLAPSE;
        this.INDEX_NAME_TEMPLATE = SqlCodeStyleSettingsDefault.MODERN.INDEX_NAME_TEMPLATE;
        this.PRIMARY_KEY_NAME_TEMPLATE = SqlCodeStyleSettingsDefault.MODERN.PRIMARY_KEY_NAME_TEMPLATE;
        this.FOREIGN_KEY_NAME_TEMPLATE = SqlCodeStyleSettingsDefault.MODERN.FOREIGN_KEY_NAME_TEMPLATE;
        this.USE_GENERIC_STYLE = false;
        this.SUBQUERY_L_PAR_NL_OUTSIDE = SqlCodeStyleSettingsDefault.LEGACY.SUBQUERY_L_PAR_NL_OUTSIDE;
        this.SUBQUERY_L_PAR_NL_INSIDE = SqlCodeStyleSettingsDefault.LEGACY.SUBQUERY_L_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_NL_INSIDE = SqlCodeStyleSettingsDefault.LEGACY.SUBQUERY_R_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_ALIGN = SqlCodeStyleSettingsDefault.LEGACY.SUBQUERY_R_PAR_ALIGN;
        this.SUBQUERY_INDENT_INSIDE = SqlCodeStyleSettingsDefault.LEGACY.SUBQUERY_INDENT_INSIDE;
        this.SPACES_AROUND_OPERATORS = SqlCodeStyleSettingsDefault.LEGACY.SPACES_AROUND_OPERATORS;
        this.ALIGN_AS_IN_SELECT_STATEMENT = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_AS_IN_SELECT_STATEMENT;
        this.ALIGN_TYPE_IN_CREATE_STATEMENT = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.ALIGN_TYPE_IN_BLOCK_STATEMENT = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_TYPE_IN_BLOCK_STATEMENT;
        this.ALIGN_TYPE_IN_ARGUMENT_DEFINITION = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_TYPE_IN_ARGUMENT_DEFINITION;
        this.ALIGN_INSIDE_BINARY_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_INSIDE_BINARY_EXPRESSION;
        this.ALIGN_INSIDE_QUERY_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_INSIDE_QUERY_EXPRESSION;
        this.ALIGN_EQ_INSIDE_SET_CLAUSE = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_EQ_INSIDE_SET_CLAUSE;
        this.NEW_LINE_BEFORE_FROM = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_FROM;
        this.NEW_LINE_BEFORE_JOIN = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_JOIN;
        this.NEW_LINE_BEFORE_JOIN_CONDITION = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_JOIN_CONDITION;
        this.NEW_LINE_BEFORE_WHERE = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_WHERE;
        this.NEW_LINE_BEFORE_GROUP_BY = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_GROUP_BY;
        this.NEW_LINE_BEFORE_ORDER_BY = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_ORDER_BY;
        this.NEW_LINE_BEFORE_HAVING = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_HAVING;
        this.NEW_LINE_BEFORE_THEN = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_THEN;
        this.NEW_LINE_BEFORE_ELSE = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_ELSE;
        this.NEW_LINE_BEFORE_OTHER_CLAUSES = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_OTHER_CLAUSES;
        this.NEW_LINE_BEFORE_COMMA = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_COMMA;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_DML = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_QUERY_INSIDE_DML;
        this.NEW_LINE_AROUND_SEMICOLON = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AROUND_SEMICOLON;
        this.INDENT_JOIN = SqlCodeStyleSettingsDefault.LEGACY.INDENT_JOIN;
        this.INDENT_JOIN_CONDITION = SqlCodeStyleSettingsDefault.LEGACY.INDENT_JOIN_CONDITION;
        this.INDENT_SELECT_INTO_CLAUSE = SqlCodeStyleSettingsDefault.LEGACY.INDENT_SELECT_INTO_CLAUSE;
        this.WRAP_INSIDE_CREATE_TABLE = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_CREATE_TABLE;
        this.WRAP_INSIDE_SELECT = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_SELECT;
        this.WRAP_INSIDE_JOIN_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_JOIN_EXPRESSION;
        this.WRAP_INSIDE_GROUP_BY = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_GROUP_BY;
        this.WRAP_INSIDE_WHERE = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_WHERE;
        this.WRAP_INSIDE_ORDER_BY = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_ORDER_BY;
        this.WRAP_INSIDE_SET = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_SET;
        this.WRAP_INSIDE_ARGUMENT_DEFINITION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_ARGUMENT_DEFINITION;
        this.WRAP_INSIDE_CALL_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_CALL_EXPRESSION;
        this.WRAP_INSIDE_VALUES_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_VALUES_EXPRESSION;
        this.WRAP_VALUES_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_VALUES_EXPRESSION;
        this.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES = SqlCodeStyleSettingsDefault.LEGACY.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES;
        this.NEW_LINE_AFTER_SELECT = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AFTER_SELECT;
        this.NEW_LINE_AFTER_SELECT_ITEM = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AFTER_SELECT_ITEM;
        this.NEW_LINE_AFTER_SELECT_2 = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AFTER_SELECT_2;
        this.myGeneral = general;
        this.myDialectCode = dialectCode;
        this.USE_GENERAL_STYLE = !general;
    }

    public boolean isGeneral() {
        return this.myGeneral;
    }

    public SqlCodeStyleSettings clone() {
        SqlCodeStyleSettings clone = (SqlCodeStyleSettings)super.clone();
        clone.myVersion = this.myVersion;
        clone.myLoaded = this.myLoaded;
        clone.myInitialized = this.myInitialized;
        return clone;
    }

    @NotNull
    public Language getCorrespondedDialect() {
        SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
        if (sqlLanguage == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(4);
        }
        return sqlLanguage;
    }

    @NotNull
    public CommonCodeStyleSettings getCorrespondedCommonSettings() {
        CodeStyleSettings container = this.getContainer();
        assert (container != null) : "The container of SQL custom settings must not be null";
        Language correspondedDialect = this.getCorrespondedDialect();
        CommonCodeStyleSettings commonCodeStyleSettings = container.getCommonSettings(correspondedDialect);
        if (commonCodeStyleSettings == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(5);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getCorrespondedIndentOptions() {
        CodeStyleSettings container = this.getContainer();
        assert (container != null) : "The container of SQL custom settings must not be null";
        Language correspondedDialect = this.getCorrespondedDialect();
        CommonCodeStyleSettings.IndentOptions indentOptions = container.getLanguageIndentOptions(correspondedDialect);
        assert (indentOptions != null) : "The container should contain indent options for class " + this.getClass().getSimpleName() + " and language dialect " + String.valueOf(correspondedDialect);
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        if (indentOptions2 == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(6);
        }
        return indentOptions2;
    }

    @NotNull
    public @NotNull Set<@NotNull String> getSettingsToHide() {
        Set<String> set = SETTINGS_TO_HIDE;
        if (set == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(7);
        }
        return set;
    }

    public boolean isSettingHidden(@NotNull String settingName) {
        if (settingName == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(8);
        }
        return this.getSettingsToHide().contains(settingName);
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    @NotNull
    private Case getTokenCase(@SqlCodeStyleConst.IdentifierCase int caseSetting) {
        int x = caseSetting;
        if (x == 4) {
            x = this.IDENTIFIER_CASE;
        }
        if (x == 3) {
            x = this.KEYWORD_CASE;
        }
        Case case_ = switch (x) {
            case 1 -> Case.LOWER;
            case 2 -> Case.UPPER;
            case 5 -> Case.TITLE;
            default -> Case.MIXED;
        };
        if (case_ == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(9);
        }
        return case_;
    }

    @NotNull
    public Case getKeywordCase() {
        return this.getTokenCase(this.KEYWORD_CASE);
    }

    @NotNull
    public Case getIdentifierCase() {
        return this.getTokenCase(this.IDENTIFIER_CASE);
    }

    @NotNull
    public Case getBuiltInTypeCase() {
        return this.getTokenCase(this.TYPE_CASE);
    }

    @NotNull
    public Case getCustomTypeCase() {
        return this.getTokenCase(this.CUSTOM_TYPE_CASE);
    }

    @NotNull
    public Case getBuiltInCase() {
        return this.getTokenCase(this.BUILT_IN_CASE);
    }

    @NotNull
    public Case getAliasCase() {
        return this.getTokenCase(this.ALIAS_CASE);
    }

    @NotNull
    public Case getQuotedIdentifierCase() {
        return this.getTokenCase(this.QUOTED_IDENTIFIER_CASE);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Case getCaseMode(@SqlCodeStyleConst.IdentifierCase int codeStyleSetting) {
        Case case_ = codeStyleSetting == 1 ? Case.LOWER : (codeStyleSetting == 2 ? Case.UPPER : (codeStyleSetting == 5 ? Case.TITLE : Case.MIXED));
        if (case_ == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(10);
        }
        return case_;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Case getCaseModeExt(@SqlCodeStyleConst.IdentifierCase int codeStyleSetting) {
        if (codeStyleSetting == 3) {
            Case case_ = this.getCaseModeExt(this.KEYWORD_CASE);
            if (case_ == null) {
                SqlCodeStyleSettings.$$$reportNull$$$0(11);
            }
            return case_;
        }
        return SqlCodeStyleSettings.getCaseMode(codeStyleSetting);
    }

    public boolean quotationSupportBrackets() {
        return false;
    }

    public boolean quotationSupportGraveAccent() {
        return false;
    }

    @Nullable
    public String getQuotesPriority() {
        return switch (this.QUOTE_TYPE) {
            case 0 -> null;
            case 11 -> "\"";
            case 20 -> "[\"`";
            case 21 -> "[";
            case 30 -> "`\"[";
            case 31 -> "`";
            default -> null;
        };
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        this.readFromTag(parentElement, this.getTagName());
    }

    protected void readFromTag(Element parentElement, @NotNull String tagName) {
        Element sectionElement;
        if (tagName == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(12);
        }
        if ((sectionElement = parentElement.getChild(tagName)) == null) {
            return;
        }
        this.myVersion = CustomCodeStyleSettingsUtils.readVersion((Element)sectionElement);
        if (this.myVersion == 0) {
            this.assignDefaults(SqlCodeStyleSettingsDefault.LEGACY);
        }
        this.myLoadedOptions = new HashSet<String>();
        for (Element child : sectionElement.getChildren()) {
            String optionName;
            if (!child.getName().equals("option") || (optionName = child.getAttributeValue("name")) == null) continue;
            this.myLoadedOptions.add(optionName);
        }
        super.readExternal(parentElement);
        this.myLoaded = true;
        this.myInitialized = true;
        if (this.myVersion == 2) {
            if (this.myLoadedOptions.contains("USE_GENERAL_STYLE")) {
                this.myVersion = 5;
            } else if (this.myLoadedOptions.contains("CUSTOM_TYPE_CASE")) {
                this.myVersion = 4;
            } else if (this.myLoadedOptions.contains("ALIAS_CASE") || this.myLoadedOptions.contains("BUILT_IN_CASE")) {
                this.myVersion = 3;
            }
        }
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(13);
        }
        super.writeExternal(parentElement, parentSettings);
        Element sectionElement = parentElement.getChild(this.getTagName());
        CustomCodeStyleSettingsUtils.writeVersion((Element)sectionElement, (int)this.myVersion);
    }

    public void beforeLoading() {
    }

    public void afterLoaded() {
        if (this.myInitialized) {
            if (this.myVersion <= 0) {
                this.migrateFromVersion0();
            }
            if (this.myVersion <= 1) {
                this.migrateFromVersion1();
            }
            if (this.myVersion <= 2) {
                this.migrateFromVersion2();
            }
            if (this.myVersion <= 3) {
                this.migrateFromVersion3();
            }
            if (this.myVersion <= 4) {
                this.migrateFromVersion4();
            }
            if (this.myVersion <= 5) {
                this.migrateFromVersion5();
            }
            this.myVersion = 7;
            this.myLoadedOptions = Collections.emptySet();
        } else {
            this.initialize();
        }
    }

    private void initialize() {
        CodeStyleSettings container = this.getContainer();
        if (container == null) {
            return;
        }
        if (this.getClass() != SqlCodeStyleSettings.class && !this.myLoaded) {
            this.USE_GENERAL_STYLE = true;
        }
        this.myInitialized = true;
    }

    private void migrateFromVersion0() {
        LOG.debug("Migrating SQL code style settings from version 0");
        CommonCodeStyleSettings c2 = this.getCorrespondedCommonSettings();
        int x = SqlCodeStyleSettings.countValue(2, this.WRAP_INSIDE_SET, this.WRAP_INSIDE_SELECT, this.WRAP_INSIDE_WHERE, this.WRAP_INSIDE_GROUP_BY, this.WRAP_INSIDE_ORDER_BY);
        this.QUERY_EL_LINE = x <= 2 ? 1 : (x >= 4 ? 101 : 0);
        this.SUBQUERY_PAR_SPACE_INSIDE = c2.SPACE_WITHIN_PARENTHESES;
        this.SET_ALIGN_EQUAL_SIGN = this.ALIGN_EQ_INSIDE_SET_CLAUSE;
        this.SELECT_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_SELECT);
        this.SELECT_KEEP_N_ITEMS_IN_LINE = this.WRAP_INSIDE_SELECT == 2 ? 0 : 7;
        this.SELECT_ALIGN_AS = this.ALIGN_AS_IN_SELECT_STATEMENT;
        this.FROM_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_JOIN_EXPRESSION);
        if (this.FROM_EL_WRAP == 3) {
            this.FROM_EL_WRAP = 2;
        }
        this.FROM_WRAP_JOIN_1 = this.NEW_LINE_BEFORE_JOIN;
        this.FROM_WRAP_JOIN_2 = this.NEW_LINE_BEFORE_JOIN;
        this.FROM_INDENT_JOIN = this.INDENT_JOIN;
        this.WHERE_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_WHERE);
        this.ORDER_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_ORDER_BY);
        this.ORDER_EL_COMMA = this.NEW_LINE_BEFORE_COMMA ? 1 : 2;
        this.FROM_EL_COMMA = this.ORDER_EL_COMMA;
        this.SELECT_EL_COMMA = this.ORDER_EL_COMMA;
        this.ROUTINE_ARG_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_ARGUMENT_DEFINITION);
        this.ROUTINE_ARG_COMMA = this.NEW_LINE_BEFORE_COMMA ? 1 : 2;
        this.ROUTINE_ARG_SPACE_WITHIN_PARENTHESES = c2.SPACE_WITHIN_METHOD_PARENTHESES;
        this.ROUTINE_ARG_ALIGN_TYPES = this.ALIGN_TYPE_IN_ARGUMENT_DEFINITION;
        this.CORTEGE_SPACE_BEFORE_L_PAREN = c2.SPACE_BEFORE_METHOD_PARENTHESES;
        this.CORTEGE_COMMA_1ST = this.NEW_LINE_BEFORE_COMMA;
        this.EXPR_SPACE_AROUND_OPERATOR = this.SPACES_AROUND_OPERATORS ? 1 : 2;
        this.EXPR_BINARY_OP_ALIGN = this.ALIGN_INSIDE_BINARY_EXPRESSION;
        this.EXPR_CASE_THEN_WRAP = this.NEW_LINE_BEFORE_THEN;
        this.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE = c2.KEEP_BLANK_LINES_IN_CODE;
    }

    private void migrateFromVersion1() {
        LOG.debug("Migrating SQL code style settings from version 1");
        CommonCodeStyleSettings c2 = this.getCorrespondedCommonSettings();
        this.TABLE_OPENING = SqlCodeStyleSettingsDefault.LEGACY.TABLE_OPENING;
        this.TABLE_CONTENT = SqlCodeStyleSettingsDefault.LEGACY.TABLE_CONTENT;
        this.TABLE_CLOSING = SqlCodeStyleSettingsDefault.LEGACY.TABLE_CLOSING;
        this.TABLE_ALTER_INSTRUCTION_WRAP = SqlCodeStyleSettingsDefault.LEGACY.TABLE_ALTER_INSTRUCTION_WRAP;
        this.CONSTRAINT_WRAP_1 = SqlCodeStyleSettingsDefault.LEGACY.CONSTRAINT_WRAP_1;
        this.CONSTRAINT_WRAP_2 = SqlCodeStyleSettingsDefault.LEGACY.CONSTRAINT_WRAP_2;
        this.CONSTRAINT_WRAP_3 = SqlCodeStyleSettingsDefault.LEGACY.CONSTRAINT_WRAP_3;
        this.POST_OPT_WRAP_1 = this.NEW_LINE_BEFORE_OTHER_CLAUSES;
        this.POST_OPT_WRAP_2 = this.NEW_LINE_BEFORE_OTHER_CLAUSES;
        this.TABLE_TYPES_ALIGN = this.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.TABLE_DEFAULTS_ALIGN = this.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.TABLE_NULLABILITIES_ALIGN = this.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.CORTEGE_SPACE_WITHIN_PARENTHESES = c2.SPACE_WITHIN_PARENTHESES;
        this.CORTEGE_SPACE_BEFORE_COMMA = c2.SPACE_BEFORE_COMMA;
        this.CORTEGE_SPACE_AFTER_COMMA = c2.SPACE_AFTER_COMMA;
        this.IMP_DECLARE_EL_WRAP = this.ALIGN_TYPE_IN_BLOCK_STATEMENT ? 1 : 3;
        this.IMP_DECLARE_ALIGN_TYPE = this.ALIGN_TYPE_IN_BLOCK_STATEMENT;
        this.IMP_IF_THEN_WRAP_THEN = this.NEW_LINE_BEFORE_THEN;
        this.IMP_IF_THEN_WRAP_ELSE = this.NEW_LINE_BEFORE_ELSE;
        this.IMP_IF_THEN_INDENT_THEN_ELSE = !this.NEW_LINE_BEFORE_THEN;
        this.IMP_IF_THEN_INDENT_END = !this.NEW_LINE_BEFORE_THEN;
        this.EXPR_SPACE_WITHIN_PARENTHESES = c2.SPACE_WITHIN_PARENTHESES;
        this.EXPR_CALL_SPACE_INSIDE_PARENTHESES = c2.SPACE_WITHIN_METHOD_CALL_PARENTHESES;
        this.EXPR_CALL_SPACE_BEFORE_COMMA = c2.SPACE_BEFORE_COMMA;
        this.EXPR_CALL_SPACE_AFTER_COMMA = c2.SPACE_AFTER_COMMA;
    }

    private void migrateFromVersion2() {
        LOG.debug("Migrating SQL code style settings from version 2");
        if (this.myLoadedOptions.contains("ALIAS_CASE")) {
            this.ALIAS_CASE = SqlCodeStyleSettings.swap02(this.ALIAS_CASE);
        }
        if (this.myLoadedOptions.contains("KEYWORD_CASE")) {
            this.KEYWORD_CASE = SqlCodeStyleSettings.swap02(this.KEYWORD_CASE);
        }
        if (this.myLoadedOptions.contains("TYPE_CASE")) {
            this.TYPE_CASE = SqlCodeStyleSettings.swap02(this.TYPE_CASE);
        }
        if (this.myLoadedOptions.contains("IDENTIFIER_CASE")) {
            this.IDENTIFIER_CASE = SqlCodeStyleSettings.swap02(this.IDENTIFIER_CASE);
        }
        if (this.myLoadedOptions.contains("QUOTED_IDENTIFIER_CASE")) {
            this.QUOTED_IDENTIFIER_CASE = SqlCodeStyleSettings.swap02(this.QUOTED_IDENTIFIER_CASE);
        }
        if (this.myLoadedOptions.contains("QUOTE_IDENTIFIER")) {
            this.QUOTE_IDENTIFIER = SqlCodeStyleSettings.swap02(this.QUOTE_IDENTIFIER);
        }
    }

    @SqlCodeStyleConst.IdentifierCase
    private static int swap02(@SqlCodeStyleConst.IdentifierCase int x) {
        return switch (x) {
            case 0 -> 2;
            case 2 -> 0;
            default -> x;
        };
    }

    private void migrateFromVersion3() {
        LOG.debug("Migrating SQL code style settings from version 3");
        if (this.myLoadedOptions.contains("TYPE_CASE")) {
            this.CUSTOM_TYPE_CASE = this.TYPE_CASE;
        }
    }

    private void migrateFromVersion4() {
        LOG.debug("Migrating SQL code style settings from version 4");
        if (!this.myLoadedOptions.contains("USE_GENERAL_STYLE")) {
            this.USE_GENERAL_STYLE = this.myLoadedOptions.contains("USE_GENERIC_STYLE") ? this.USE_GENERIC_STYLE : this.myLoadedOptions.isEmpty();
        }
    }

    private void migrateFromVersion5() {
        LOG.debug("Migrating SQL code style settings from version 5");
        if (!this.myLoadedOptions.contains("SCRIPT_STMT_SEMICOLON_WRAP") && !this.myLoadedOptions.contains("SCRIPT_STMT_FOLLOWS_BLANK_LINE") && this.myLoadedOptions.contains("NEW_LINE_AROUND_SEMICOLON")) {
            int toWrap;
            this.SCRIPT_STMT_SEMICOLON_WRAP = toWrap = this.NEW_LINE_AROUND_SEMICOLON ? 1 : 0;
            this.SCRIPT_STMT_FOLLOWS_BLANK_LINE = toWrap;
        }
    }

    private static int countValue(int valueToCount, int ... values) {
        int m = 0;
        int n = values.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (values[i2] != valueToCount) continue;
            ++m;
        }
        return m;
    }

    @Contract(pure=true)
    @SqlCodeStyleConst.WrapMagicValues
    private static int convertWrap(int oldWrap) {
        return switch (oldWrap) {
            case 2 -> 1;
            case 4 -> 2;
            case 1 -> 3;
            default -> 0;
        };
    }

    public void manuallyChanged() {
        if (this.myVersion < 7) {
            LOG.info(String.format("SQL code style settings version updated from %d to %d (because they were manually changed)", this.myVersion, 7));
            this.myVersion = 7;
        }
    }

    public void assignDefaults(@NotNull SqlCodeStyleSettingsDefault def) {
        if (def == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(14);
        }
        this.assignModernDefaults(def);
        this.assignLegacyDefaults(def);
    }

    private void assignModernDefaults(@NotNull SqlCodeStyleSettingsDefault def) {
        if (def == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(15);
        }
        this.KEYWORD_CASE = def.KEYWORD_CASE;
        this.IDENTIFIER_CASE = def.IDENTIFIER_CASE;
        this.TYPE_CASE = def.TYPE_CASE;
        this.CUSTOM_TYPE_CASE = def.CUSTOM_TYPE_CASE;
        this.ALIAS_CASE = def.ALIAS_CASE;
        this.BUILT_IN_CASE = def.BUILT_IN_CASE;
        this.QUOTED_IDENTIFIER_CASE = def.QUOTED_IDENTIFIER_CASE;
        this.ORIGINAL_CASE = def.ORIGINAL_CASE;
        this.QUOTE_IDENTIFIER = def.QUOTE_IDENTIFIER;
        this.QUOTE_TYPE = def.QUOTE_TYPE;
        this.QUERY_SECTION_1ST_WORD_ALIGN = def.QUERY_SECTION_1ST_WORD_ALIGN;
        this.QUERY_EL_LINE = def.QUERY_EL_LINE;
        this.QUERY_EL_COMMA = def.QUERY_EL_COMMA;
        this.QUERY_IN_ONE_STRING = def.QUERY_IN_ONE_STRING;
        this.QUERY_TRUE_INDENT = def.QUERY_TRUE_INDENT;
        this.QUERY_ALIGN_ELEMENTS = def.QUERY_ALIGN_ELEMENTS;
        this.QUERY_ALIGN_LINE_COMMENTS = def.QUERY_ALIGN_LINE_COMMENTS;
        this.SUBQUERY_OPENING = def.SUBQUERY_OPENING;
        this.SUBQUERY_CONTENT = def.SUBQUERY_CONTENT;
        this.SUBQUERY_CLOSING = def.SUBQUERY_CLOSING;
        this.SUBQUERY_PAR_SPACE_BEFORE = def.SUBQUERY_PAR_SPACE_BEFORE;
        this.SUBQUERY_PAR_SPACE_INSIDE = def.SUBQUERY_PAR_SPACE_INSIDE;
        this.INSERT_INTO_NL = def.INSERT_INTO_NL;
        this.INSERT_OPENING = def.INSERT_OPENING;
        this.INSERT_CONTENT = def.INSERT_CONTENT;
        this.INSERT_CLOSING = def.INSERT_CLOSING;
        this.INSERT_TABLE_EL_LINE = def.INSERT_TABLE_EL_LINE;
        this.INSERT_VALUES_EL_LINE = def.INSERT_VALUES_EL_LINE;
        this.INSERT_EL_WRAP = def.INSERT_EL_WRAP;
        this.INSERT_EL_COMMA = def.INSERT_EL_COMMA;
        this.INSERT_SPACE_WITHIN_PARENTHESES = def.INSERT_SPACE_WITHIN_PARENTHESES;
        this.INSERT_COLLAPSE_MULTI_ROW_VALUES = def.INSERT_COLLAPSE_MULTI_ROW_VALUES;
        this.INSERT_MATRIX_ALIGN = def.INSERT_MATRIX_ALIGN;
        this.INSERT_MATRIX_INCLUDING_HEADER = def.INSERT_MATRIX_INCLUDING_HEADER;
        this.INSERT_MATRIX_MODE = def.INSERT_MATRIX_MODE;
        this.INSERT_MATRIX_MIN_WIDENING_THRESHOLD = def.INSERT_MATRIX_MIN_WIDENING_THRESHOLD;
        this.INSERT_MATRIX_BREAK_THRESHOLD = def.INSERT_MATRIX_BREAK_THRESHOLD;
        this.SET_EL_LINE = def.SET_EL_LINE;
        this.SET_EL_WRAP = def.SET_EL_WRAP;
        this.SET_EL_COMMA = def.SET_EL_COMMA;
        this.SET_ALIGN_EQUAL_SIGN = def.SET_ALIGN_EQUAL_SIGN;
        this.WITH_EL_LINE = def.WITH_EL_LINE;
        this.WITH_EL_WRAP = def.WITH_EL_WRAP;
        this.WITH_EL_COMMA = def.WITH_EL_COMMA;
        this.WITH_ALIGN_AS = def.WITH_ALIGN_AS;
        this.SELECT_EL_LINE = def.SELECT_EL_LINE;
        this.SELECT_EL_WRAP = def.SELECT_EL_WRAP;
        this.SELECT_EL_COMMA = def.SELECT_EL_COMMA;
        this.SELECT_NEW_LINE_AFTER_ALL_DISTINCT = def.SELECT_NEW_LINE_AFTER_ALL_DISTINCT;
        this.SELECT_KEEP_N_ITEMS_IN_LINE = def.SELECT_KEEP_N_ITEMS_IN_LINE;
        this.SELECT_USE_AS_WORD = def.SELECT_USE_AS_WORD;
        this.SELECT_ALIGN_AS = def.SELECT_ALIGN_AS;
        this.SELECT_ASTERISK_REGULAR = def.SELECT_ASTERISK_REGULAR;
        this.FROM_EL_LINE = def.FROM_EL_LINE;
        this.FROM_EL_WRAP = def.FROM_EL_WRAP;
        this.FROM_EL_COMMA = def.FROM_EL_COMMA;
        this.FROM_WRAP_JOIN_1 = def.FROM_WRAP_JOIN_1;
        this.FROM_WRAP_JOIN_2 = def.FROM_WRAP_JOIN_2;
        this.FROM_WRAP_ON = def.FROM_WRAP_ON;
        this.FROM_ALIGN_JOIN_TABLES = def.FROM_ALIGN_JOIN_TABLES;
        this.FROM_ALIGN_ALIASES = def.FROM_ALIGN_ALIASES;
        this.FROM_INDENT_JOIN = def.FROM_INDENT_JOIN;
        this.FROM_ONLY_JOIN_INDENT = def.FROM_ONLY_JOIN_INDENT;
        this.FROM_PLACE_ON = def.FROM_PLACE_ON;
        this.WHERE_EL_LINE = def.WHERE_EL_LINE;
        this.WHERE_EL_WRAP = def.WHERE_EL_WRAP;
        this.WHERE_EL_BOUND = def.WHERE_EL_BOUND;
        this.ORDER_EL_LINE = def.ORDER_EL_LINE;
        this.ORDER_EL_WRAP = def.ORDER_EL_WRAP;
        this.ORDER_EL_COMMA = def.ORDER_EL_COMMA;
        this.ORDER_ALIGN_ASC_DESC = def.ORDER_ALIGN_ASC_DESC;
        this.TABLE_OPENING = def.TABLE_OPENING;
        this.TABLE_CONTENT = def.TABLE_CONTENT;
        this.TABLE_CLOSING = def.TABLE_CLOSING;
        this.TABLE_TYPES_ALIGN = def.TABLE_TYPES_ALIGN;
        this.TABLE_DEFAULTS_ALIGN = def.TABLE_DEFAULTS_ALIGN;
        this.TABLE_NULLABILITIES_ALIGN = def.TABLE_NULLABILITIES_ALIGN;
        this.TABLE_COLLAPSE = def.TABLE_COLLAPSE;
        this.TABLE_ALTER_INSTRUCTION_WRAP = def.TABLE_ALTER_INSTRUCTION_WRAP;
        this.TABLE_ALTER_INSTRUCTION_INDENT = def.TABLE_ALTER_INSTRUCTION_INDENT;
        this.TABLE_ALTER_INSTRUCTION_ALIGN = def.TABLE_ALTER_INSTRUCTION_ALIGN;
        this.TABLE_ALTER_ITEM_WRAP = def.TABLE_ALTER_ITEM_WRAP;
        this.TABLE_ALTER_ITEM_INDENT = def.TABLE_ALTER_ITEM_INDENT;
        this.TABLE_ALTER_ITEM_ALIGN = def.TABLE_ALTER_ITEM_ALIGN;
        this.CONSTRAINT_WRAP_1 = def.CONSTRAINT_WRAP_1;
        this.CONSTRAINT_WRAP_2 = def.CONSTRAINT_WRAP_2;
        this.CONSTRAINT_WRAP_3 = def.CONSTRAINT_WRAP_3;
        this.CONSTRAINT_WRAP_4 = def.CONSTRAINT_WRAP_4;
        this.POST_OPT_WRAP_1 = def.POST_OPT_WRAP_1;
        this.POST_OPT_WRAP_2 = def.POST_OPT_WRAP_2;
        this.POST_OPT_INDENT = def.POST_OPT_INDENT;
        this.POST_OPT_ALIGN = def.POST_OPT_ALIGN;
        this.CREATE_SCHEMA_CONTENT_INDENT = def.CREATE_SCHEMA_CONTENT_INDENT;
        this.CREATE_SCHEMA_BLANK_LINES_MIN = def.CREATE_SCHEMA_BLANK_LINES_MIN;
        this.CREATE_SCHEMA_BLANK_LINES_MAX = def.CREATE_SCHEMA_BLANK_LINES_MAX;
        this.VIEW_WRAP_AS = def.VIEW_WRAP_AS;
        this.VIEW_WRAP_QUERY = def.VIEW_WRAP_QUERY;
        this.VIEW_INDENT_QUERY = def.VIEW_INDENT_QUERY;
        this.ROUTINE_ARG_OPENING = def.ROUTINE_ARG_OPENING;
        this.ROUTINE_ARG_CONTENT = def.ROUTINE_ARG_CONTENT;
        this.ROUTINE_ARG_CLOSING = def.ROUTINE_ARG_CLOSING;
        this.ROUTINE_ARG_WRAP = def.ROUTINE_ARG_WRAP;
        this.ROUTINE_ARG_COMMA = def.ROUTINE_ARG_COMMA;
        this.ROUTINE_ARG_SPACE_WITHIN_PARENTHESES = def.ROUTINE_ARG_SPACE_WITHIN_PARENTHESES;
        this.ROUTINE_ARG_ALIGN_TYPES = def.ROUTINE_ARG_ALIGN_TYPES;
        this.ROUTINE_AS_WRAP = def.ROUTINE_AS_WRAP;
        this.ROUTINE_PG_L_QUOTE_WRAP_BEFORE = def.ROUTINE_PG_L_QUOTE_WRAP_BEFORE;
        this.ROUTINE_PG_L_QUOTE_WRAP_AFTER = def.ROUTINE_PG_L_QUOTE_WRAP_AFTER;
        this.ROUTINE_PG_R_QUOTE_WRAP_BEFORE = def.ROUTINE_PG_R_QUOTE_WRAP_BEFORE;
        this.ROUTINE_PG_R_QUOTE_WRAP_AFTER = def.ROUTINE_PG_R_QUOTE_WRAP_AFTER;
        this.SCRIPT_STMT_SEMICOLON_WRAP = def.SCRIPT_STMT_SEMICOLON_WRAP;
        this.SCRIPT_STMT_FOLLOWS_BLANK_LINE = def.SCRIPT_STMT_FOLLOWS_BLANK_LINE;
        this.IMP_COMMON_WRAP_EVERY_STATEMENT = def.IMP_COMMON_WRAP_EVERY_STATEMENT;
        this.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE = def.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE;
        this.IMP_DECLARE_CONTENT_WRAP = def.IMP_DECLARE_CONTENT_WRAP;
        this.IMP_DECLARE_EL_WRAP = def.IMP_DECLARE_EL_WRAP;
        this.IMP_DECLARE_ALIGN_TYPE = def.IMP_DECLARE_ALIGN_TYPE;
        this.IMP_DECLARE_ALIGN_EQ = def.IMP_DECLARE_ALIGN_EQ;
        this.IMP_DECLARE_ALIGN_DEFAULT = def.IMP_DECLARE_ALIGN_DEFAULT;
        this.IMP_DECLARE_ALIGN_LINE_COMMENTS = def.IMP_DECLARE_ALIGN_LINE_COMMENTS;
        this.IMP_IF_THEN_WRAP_THEN = def.IMP_IF_THEN_WRAP_THEN;
        this.IMP_IF_THEN_WRAP_ELSE = def.IMP_IF_THEN_WRAP_ELSE;
        this.IMP_IF_THEN_WRAP_INNER = def.IMP_IF_THEN_WRAP_INNER;
        this.IMP_IF_THEN_INDENT_THEN_ELSE = def.IMP_IF_THEN_INDENT_THEN_ELSE;
        this.IMP_IF_THEN_INDENT_END = def.IMP_IF_THEN_INDENT_END;
        this.IMP_IF_THEN_COLLAPSE = def.IMP_IF_THEN_COLLAPSE;
        this.IMP_LOOP_LOOP_WRAP = def.IMP_LOOP_LOOP_WRAP;
        this.IMP_LOOP_LOOP_INDENT = def.IMP_LOOP_LOOP_INDENT;
        this.IMP_LOOP_END_INDENT = def.IMP_LOOP_END_INDENT;
        this.IMP_LOOP_COLLAPSE = def.IMP_LOOP_COLLAPSE;
        this.CORTEGE_SPACE_BEFORE_L_PAREN = def.CORTEGE_SPACE_BEFORE_L_PAREN;
        this.CORTEGE_COMMA_1ST = def.CORTEGE_COMMA_1ST;
        this.CORTEGE_CLOSING = def.CORTEGE_CLOSING;
        this.CORTEGE_SPACE_WITHIN_PARENTHESES = def.CORTEGE_SPACE_WITHIN_PARENTHESES;
        this.CORTEGE_SPACE_BEFORE_COMMA = def.CORTEGE_SPACE_BEFORE_COMMA;
        this.CORTEGE_SPACE_AFTER_COMMA = def.CORTEGE_SPACE_AFTER_COMMA;
        this.EXPR_SPACE_AROUND_OPERATOR = def.EXPR_SPACE_AROUND_OPERATOR;
        this.EXPR_SPACE_WITHIN_PARENTHESES = def.EXPR_SPACE_WITHIN_PARENTHESES;
        this.EXPR_BINARY_OP_ALIGN = def.EXPR_BINARY_OP_ALIGN;
        this.EXPR_CALL_SPACE_INSIDE_PARENTHESES = def.EXPR_CALL_SPACE_INSIDE_PARENTHESES;
        this.EXPR_CALL_SPACE_BEFORE_COMMA = def.EXPR_CALL_SPACE_BEFORE_COMMA;
        this.EXPR_CALL_SPACE_AFTER_COMMA = def.EXPR_CALL_SPACE_AFTER_COMMA;
        this.EXPR_CASE_WHEN_WRAP = def.EXPR_CASE_WHEN_WRAP;
        this.EXPR_CASE_WHEN_INDENT = def.EXPR_CASE_WHEN_INDENT;
        this.EXPR_CASE_THEN_WRAP = def.EXPR_CASE_THEN_WRAP;
        this.EXPR_CASE_THEN_ALIGN = def.EXPR_CASE_THEN_ALIGN;
        this.EXPR_CASE_ELSE_ALIGN_THEN = def.EXPR_CASE_ELSE_ALIGN_THEN;
        this.EXPR_CASE_END = def.EXPR_CASE_END;
        this.EXPR_CASE_KEEP_NL_AFTER_THEN = def.EXPR_CASE_KEEP_NL_AFTER_THEN;
        this.EXPR_CASE_COLLAPSE = def.EXPR_CASE_COLLAPSE;
        this.INDEX_NAME_TEMPLATE = def.INDEX_NAME_TEMPLATE;
        this.PRIMARY_KEY_NAME_TEMPLATE = def.PRIMARY_KEY_NAME_TEMPLATE;
        this.FOREIGN_KEY_NAME_TEMPLATE = def.FOREIGN_KEY_NAME_TEMPLATE;
    }

    private void assignLegacyDefaults(@NotNull SqlCodeStyleSettingsDefault def) {
        if (def == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(16);
        }
        this.SUBQUERY_L_PAR_NL_OUTSIDE = def.SUBQUERY_L_PAR_NL_OUTSIDE;
        this.SUBQUERY_L_PAR_NL_INSIDE = def.SUBQUERY_L_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_NL_INSIDE = def.SUBQUERY_R_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_ALIGN = def.SUBQUERY_R_PAR_ALIGN;
        this.SUBQUERY_INDENT_INSIDE = def.SUBQUERY_INDENT_INSIDE;
        this.SPACES_AROUND_OPERATORS = def.SPACES_AROUND_OPERATORS;
        this.ALIGN_AS_IN_SELECT_STATEMENT = def.ALIGN_AS_IN_SELECT_STATEMENT;
        this.ALIGN_TYPE_IN_CREATE_STATEMENT = def.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.ALIGN_TYPE_IN_BLOCK_STATEMENT = def.ALIGN_TYPE_IN_BLOCK_STATEMENT;
        this.ALIGN_TYPE_IN_ARGUMENT_DEFINITION = def.ALIGN_TYPE_IN_ARGUMENT_DEFINITION;
        this.ALIGN_INSIDE_BINARY_EXPRESSION = def.ALIGN_INSIDE_BINARY_EXPRESSION;
        this.ALIGN_INSIDE_QUERY_EXPRESSION = def.ALIGN_INSIDE_QUERY_EXPRESSION;
        this.ALIGN_EQ_INSIDE_SET_CLAUSE = def.ALIGN_EQ_INSIDE_SET_CLAUSE;
        this.NEW_LINE_BEFORE_FROM = def.NEW_LINE_BEFORE_FROM;
        this.NEW_LINE_BEFORE_JOIN = def.NEW_LINE_BEFORE_JOIN;
        this.NEW_LINE_BEFORE_JOIN_CONDITION = def.NEW_LINE_BEFORE_JOIN_CONDITION;
        this.NEW_LINE_BEFORE_WHERE = def.NEW_LINE_BEFORE_WHERE;
        this.NEW_LINE_BEFORE_GROUP_BY = def.NEW_LINE_BEFORE_GROUP_BY;
        this.NEW_LINE_BEFORE_ORDER_BY = def.NEW_LINE_BEFORE_ORDER_BY;
        this.NEW_LINE_BEFORE_HAVING = def.NEW_LINE_BEFORE_HAVING;
        this.NEW_LINE_BEFORE_THEN = def.NEW_LINE_BEFORE_THEN;
        this.NEW_LINE_BEFORE_ELSE = def.NEW_LINE_BEFORE_ELSE;
        this.NEW_LINE_BEFORE_OTHER_CLAUSES = def.NEW_LINE_BEFORE_OTHER_CLAUSES;
        this.NEW_LINE_BEFORE_COMMA = def.NEW_LINE_BEFORE_COMMA;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS = def.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_DML = def.NEW_LINE_BEFORE_QUERY_INSIDE_DML;
        this.NEW_LINE_AROUND_SEMICOLON = def.NEW_LINE_AROUND_SEMICOLON;
        this.INDENT_JOIN = def.INDENT_JOIN;
        this.INDENT_JOIN_CONDITION = def.INDENT_JOIN_CONDITION;
        this.INDENT_SELECT_INTO_CLAUSE = def.INDENT_SELECT_INTO_CLAUSE;
        this.WRAP_INSIDE_CREATE_TABLE = def.WRAP_INSIDE_CREATE_TABLE;
        this.WRAP_INSIDE_SELECT = def.WRAP_INSIDE_SELECT;
        this.WRAP_INSIDE_JOIN_EXPRESSION = def.WRAP_INSIDE_JOIN_EXPRESSION;
        this.WRAP_INSIDE_GROUP_BY = def.WRAP_INSIDE_GROUP_BY;
        this.WRAP_INSIDE_WHERE = def.WRAP_INSIDE_WHERE;
        this.WRAP_INSIDE_ORDER_BY = def.WRAP_INSIDE_ORDER_BY;
        this.WRAP_INSIDE_SET = def.WRAP_INSIDE_SET;
        this.WRAP_INSIDE_ARGUMENT_DEFINITION = def.WRAP_INSIDE_ARGUMENT_DEFINITION;
        this.WRAP_INSIDE_CALL_EXPRESSION = def.WRAP_INSIDE_CALL_EXPRESSION;
        this.WRAP_INSIDE_VALUES_EXPRESSION = def.WRAP_INSIDE_VALUES_EXPRESSION;
        this.WRAP_VALUES_EXPRESSION = def.WRAP_VALUES_EXPRESSION;
        this.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES = def.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES;
        this.NEW_LINE_AFTER_SELECT = def.NEW_LINE_AFTER_SELECT;
        this.NEW_LINE_AFTER_SELECT_ITEM = def.NEW_LINE_AFTER_SELECT_ITEM;
        this.NEW_LINE_AFTER_SELECT_2 = def.NEW_LINE_AFTER_SELECT_2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectCode";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/SqlCodeStyleSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/SqlCodeStyleSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondedDialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondedCommonSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondedIndentOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsToHide";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenCase";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseMode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseModeExt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSettingHidden";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readFromTag";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "assignDefaults";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "assignModernDefaults";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "assignLegacyDefaults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

