/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.python;

import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/aiplayground/python/LooksLikeCode;", "", "<init>", "()V", "id", "", "assignment", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "idChain", "call", "escapeSeq", "csharpTuple", "csharpGenericTp", "csharpGenericM", "scalaTodo", "javaVarDecl", "looksLikeCode", "", "text", "intellij.aiplayground.python"})
public final class LooksLikeCode {
    @NotNull
    public static final LooksLikeCode INSTANCE = new LooksLikeCode();
    @NotNull
    private static final String id = "[a-zA-Z_$][a-zA-Z0-9_$]*";
    private static final Pattern assignment = Pattern.compile("= ['\"]");
    private static final Pattern idChain = Pattern.compile(id + "\\." + id + "\\." + id);
    private static final Pattern call = Pattern.compile(id + "\\(.*\\)");
    private static final Pattern escapeSeq = Pattern.compile("(?:\\\\[ntbru].*){2,}");
    @NotNull
    private static final String csharpTuple = "(" + id + "|\\(" + id + "(, *" + id + ")+\\))";
    @NotNull
    private static final String csharpGenericTp = "(((in|out) +)?" + csharpTuple + ")";
    private static final Pattern csharpGenericM = Pattern.compile(id + "<" + csharpGenericTp + "(, *" + csharpGenericTp + ")*>\\(.*\\)");
    private static final Pattern scalaTodo = Pattern.compile("= ?\\?\\?\\?");
    private static final Pattern javaVarDecl = Pattern.compile("\\b([A-Z])(" + id + ") ([a-z])(\\2) ?[;:,)=]");

    private LooksLikeCode() {
    }

    public final boolean looksLikeCode(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (assignment.matcher(text).find()) {
            return true;
        }
        if (idChain.matcher(text).find()) {
            return true;
        }
        if (call.matcher(text).find()) {
            return true;
        }
        if (escapeSeq.matcher(text).find()) {
            return true;
        }
        if (csharpGenericM.matcher(text).find()) {
            return true;
        }
        if (scalaTodo.matcher(text).find()) {
            return true;
        }
        return javaVarDecl.matcher(text).find();
    }
}

