/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.execution.wsl.ui.WslPathBrowserKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.remoteInterpreter.add.PyAddSdkUsingCredentialsEditor;
import com.intellij.python.remoteInterpreter.add.RemoteSdkCreationUtilKt;
import com.intellij.python.wsl.PyWSLUtilsKt;
import com.intellij.python.wsl.PythonWslBundle;
import com.intellij.remote.CredentialsType;
import com.intellij.ui.TextAccessor;
import com.intellij.wsl.remoteSdk.WSLCredentialsEditor;
import com.intellij.wsl.remoteSdk.WSLCredentialsHolder;
import com.intellij.wsl.remoteSdk.WSLCredentialsType;
import com.jetbrains.python.Result;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.remote.PyRemoteInterpreterUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0015\u0010!\u001a\u00070\t\u00a2\u0006\u0002\b\"2\u0006\u0010#\u001a\u00020 H\u0002J\u0015\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020 H\u0000\u00a2\u0006\u0002\b'R\u001e\u0010\b\u001a\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lcom/intellij/python/wsl/PyAddWslPanel;", "Lcom/intellij/python/remoteInterpreter/add/PyAddSdkUsingCredentialsEditor;", "Lcom/intellij/wsl/remoteSdk/WSLCredentialsHolder;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "<init>", "(Ljava/util/List;)V", "panelName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPanelName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "credentialsEditor", "Lcom/intellij/wsl/remoteSdk/WSLCredentialsEditor;", "getCredentialsEditor", "()Lcom/intellij/wsl/remoteSdk/WSLCredentialsEditor;", "credentialsEditor$delegate", "Lkotlin/Lazy;", "getHelpersPath", "credentials", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "getBrowseButtonActionListener", "Ljava/awt/event/ActionListener;", "createSdk", "additionalData", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalData;", "validateDataAndSuggestName", "Lorg/jetbrains/annotations/NonNls;", "sdkAdditionalData", "configure", "", "data", "configure$intellij_python_wsl", "intellij.python.wsl"})
@SourceDebugExtension(value={"SMAP\nPyAddWslSdkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyAddWslSdkProvider.kt\ncom/intellij/python/wsl/PyAddWslPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class PyAddWslPanel
extends PyAddSdkUsingCredentialsEditor<WSLCredentialsHolder> {
    @NotNull
    private final Icon icon;
    @NotNull
    private final Lazy credentialsEditor$delegate;

    public PyAddWslPanel(@NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        WSLCredentialsType wSLCredentialsType = WSLCredentialsType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)wSLCredentialsType, (String)"getInstance(...)");
        super(existingSdks, (CredentialsType)wSLCredentialsType);
        Icon icon = AllIcons.RunConfigurations.Wsl;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Wsl");
        this.icon = icon;
        this.credentialsEditor$delegate = LazyKt.lazy(PyAddWslPanel::credentialsEditor_delegate$lambda$0);
        WslDistributionManager.getInstance().getInstalledDistributionsFuture().thenAcceptAsync(arg_0 -> PyAddWslPanel._init_$lambda$3(arg_0 -> PyAddWslPanel._init_$lambda$2(this, arg_0), arg_0));
    }

    @NotNull
    public String getPanelName() {
        String string = PythonWslBundle.message("python.add.sdk.panel.name.wsl", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    protected WSLCredentialsEditor getCredentialsEditor() {
        Lazy lazy = this.credentialsEditor$delegate;
        return (WSLCredentialsEditor)lazy.getValue();
    }

    @Nullable
    protected String getHelpersPath(@NotNull WSLCredentialsHolder credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        return null;
    }

    @NotNull
    public List<ValidationInfo> validateAll() {
        List it;
        List list = WslDistributionManager.getInstance().getCachedInstalledDistributions();
        if (list != null) {
            it = list;
            boolean bl = false;
            if (it.isEmpty()) {
                return CollectionsKt.listOf((Object)new ValidationInfo(PythonWslBundle.message("wsl.error.no.installed.distributions", new Object[0])));
            }
        }
        WSLDistribution wSLDistribution = this.getCredentialsEditor().getWslDistribution();
        if (wSLDistribution != null) {
            it = wSLDistribution;
            boolean bl = false;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(it.getWindowsPath(this.getInterpreterPathField().getText()));
            if (!(virtualFile != null ? virtualFile.exists() : false)) {
                return CollectionsKt.listOf((Object)new ValidationInfo(PythonWslBundle.message("wsl.bad.interpreter.path", new Object[0])));
            }
        }
        return super.validateAll();
    }

    @NotNull
    protected ActionListener getBrowseButtonActionListener() {
        return arg_0 -> PyAddWslPanel.getBrowseButtonActionListener$lambda$7(this, arg_0);
    }

    @NotNull
    protected Sdk createSdk(@NotNull PyRemoteSdkAdditionalData additionalData) {
        Intrinsics.checkNotNullParameter((Object)additionalData, (String)"additionalData");
        return RemoteSdkCreationUtilKt.createAndInitRemoteSdk$default(null, (PyRemoteSdkAdditionalData)additionalData, (Collection)this.getExistingSdks(), (String)this.validateDataAndSuggestName(additionalData), (int)1, null);
    }

    private final String validateDataAndSuggestName(PyRemoteSdkAdditionalData sdkAdditionalData) {
        String string;
        String string2 = PyRemoteInterpreterUtil.getInterpreterVersion(null, (PyRemoteSdkAdditionalDataBase)((PyRemoteSdkAdditionalDataBase)sdkAdditionalData), (boolean)false);
        if (string2 == null) {
            String string3 = PythonWslBundle.message("wsl.bad_command", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            throw new PyExecutionException(string3, null, 2, null);
        }
        String versionString = string2;
        LanguageLevel languageLevel = PythonSdkFlavor.getLanguageLevelFromVersionStringStatic((String)versionString);
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getLanguageLevelFromVersionStringStatic(...)");
        LanguageLevel version = languageLevel;
        Result<WSLDistribution, String> it = PyWSLUtilsKt.getDistribution((PyRemoteSdkAdditionalDataBase)sdkAdditionalData);
        boolean bl = false;
        Result<WSLDistribution, String> result = it;
        if (result instanceof Result.Success) {
            string = version + " @ " + ((WSLDistribution)((Result.Success)it).getResult()).getPresentableName();
        } else if (result instanceof Result.Failure) {
            string = "Error: " + ((Result.Failure)it).getError();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public final void configure$intellij_python_wsl(@NotNull PyRemoteSdkAdditionalData data) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.getInterpreterPathField().setText(data.getInterpreterPath());
            WSLCredentialsHolder wSLCredentialsHolder = PyWSLUtilsKt.getWslCredentials((PyRemoteSdkAdditionalDataBase)data);
            if (wSLCredentialsHolder == null) break block0;
            WSLCredentialsHolder it = wSLCredentialsHolder;
            boolean bl = false;
            this.getCredentialsEditor().init(it);
        }
    }

    private static final WSLCredentialsEditor credentialsEditor_delegate$lambda$0() {
        return new WSLCredentialsEditor();
    }

    private static final void lambda$2$lambda$1(List $distros, PyAddWslPanel this$0) {
        if ($distros.isEmpty()) {
            this$0.setLayout(new BorderLayout());
            Object[] objectArray = new Object[]{"ms-windows-store://search/?query=Linux"};
            this$0.add(Messages.configureMessagePaneUi((JTextPane)new JTextPane(), (String)PythonWslBundle.message("wsl.distribution.not_installed", objectArray)), "North");
        } else {
            this$0.initUI();
            this$0.getInterpreterPathField().setText("/usr/bin/python");
        }
    }

    private static final Unit _init_$lambda$2(PyAddWslPanel this$0, List distros) {
        ApplicationManager.getApplication().invokeLater(() -> PyAddWslPanel.lambda$2$lambda$1(distros, this$0), ModalityState.any());
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void getBrowseButtonActionListener$lambda$7(PyAddWslPanel this$0, ActionEvent it) {
        block0: {
            WSLDistribution wSLDistribution = this$0.getCredentialsEditor().getWslDistribution();
            if (wSLDistribution == null) break block0;
            WSLDistribution distro = wSLDistribution;
            boolean bl = false;
            TextAccessor textAccessor = (TextAccessor)this$0.getInterpreterPathField();
            JPanel jPanel = this$0.getCredentialsEditor().getMainPanel();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getMainPanel(...)");
            WslPathBrowserKt.browseWslPath$default((TextAccessor)textAccessor, (WSLDistribution)distro, (Component)jPanel, (boolean)false, null, (int)16, null);
        }
    }
}

