/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Font;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.FacetStripTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.ThemeTextStyle;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;
import org.jetbrains.letsPlot.core.plot.builder.presentation.PlotLabelSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLabelSpecFactory;", "", "()V", "DISTANCE_TO_LABEL_IN_CHARS", "", "axisTick", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "axisTitle", "facetText", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetStripTheme;", "legendItem", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "legendTitle", "plotCaption", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;", "plotLabelSpec", "textStyle", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ThemeTextStyle;", "plotSubtitle", "plotTitle", "plot-builder"})
public final class PlotLabelSpecFactory {
    @NotNull
    public static final PlotLabelSpecFactory INSTANCE = new PlotLabelSpecFactory();
    @NotNull
    public static final String DISTANCE_TO_LABEL_IN_CHARS = "_";

    private PlotLabelSpecFactory() {
    }

    @NotNull
    public final LabelSpec plotTitle(@NotNull PlotTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        return this.plotLabelSpec(theme2.titleStyle());
    }

    @NotNull
    public final LabelSpec plotSubtitle(@NotNull PlotTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        return this.plotLabelSpec(theme2.subtitleStyle());
    }

    @NotNull
    public final LabelSpec plotCaption(@NotNull PlotTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        return this.plotLabelSpec(theme2.captionStyle());
    }

    @NotNull
    public final LabelSpec legendTitle(@NotNull LegendTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        return this.plotLabelSpec(theme2.titleStyle());
    }

    @NotNull
    public final LabelSpec legendItem(@NotNull LegendTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        return this.plotLabelSpec(theme2.textStyle());
    }

    @NotNull
    public final LabelSpec axisTick(@NotNull AxisTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        return this.plotLabelSpec(theme2.labelStyle());
    }

    @NotNull
    public final LabelSpec axisTitle(@NotNull AxisTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        return this.plotLabelSpec(theme2.titleStyle());
    }

    @NotNull
    public final LabelSpec facetText(@NotNull FacetStripTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        return this.plotLabelSpec(theme2.stripTextStyle());
    }

    private final LabelSpec plotLabelSpec(ThemeTextStyle textStyle) {
        return new PlotLabelSpec(new Font(textStyle.getFamily(), (int)textStyle.getSize(), textStyle.getFace().getBold(), textStyle.getFace().getItalic()), textStyle.getMarkdown());
    }
}

