/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.pixels;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.AbstractOutputPngStream;
import org.jetbrains.letsPlot.util.pngj.IdatChunkWriter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\f\b \u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000201H&J \u00103\u001a\u0002012\u0006\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005H&J\b\u00107\u001a\u000201H\u0016J\u0016\u00108\u001a\u0002012\u0006\u0010.\u001a\u00020(2\u0006\u00109\u001a\u00020\u0005J\u0010\u0010:\u001a\u0002012\u0006\u00104\u001a\u00020\u001eH\u0016J \u0010:\u001a\u0002012\u0006\u00104\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005H\u0016J\u0010\u0010:\u001a\u0002012\u0006\u0010<\u001a\u00020\u0005H\u0016R\u001a\u0010\t\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010)\"\u0004\b*\u0010+R$\u0010,\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020(@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010)\"\u0004\b-\u0010+R\u000e\u0010.\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0012\u00a8\u0006="}, d2={"Lorg/jetbrains/letsPlot/util/pngj/pixels/CompressorStream;", "Lorg/jetbrains/letsPlot/util/pngj/AbstractOutputPngStream;", "idatCw", "Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;", "blockLen", "", "totalbytes", "", "(Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;IJ)V", "block", "getBlock", "()I", "setBlock", "(I)V", "getBlockLen", "bytesCompressed", "bytesIn", "getBytesIn", "()J", "setBytesIn", "(J)V", "bytesOut", "getBytesOut", "setBytesOut", "bytesRaw", "compressionRatio", "", "getCompressionRatio", "()D", "<set-?>", "", "firstBytes", "getFirstBytes", "()[B", "idatChunkWriter", "getIdatChunkWriter", "()Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;", "setIdatChunkWriter", "(Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;)V", "isClosed", "", "()Z", "setClosed", "(Z)V", "isDone", "setDone", "storeFirstByte", "getTotalbytes", "close", "", "done", "mywrite", "data", "off", "len", "reset", "setStoreFirstByte", "nblocks", "write", "offset", "b", "plot-api"})
public abstract class CompressorStream
extends AbstractOutputPngStream {
    @Nullable
    private IdatChunkWriter idatChunkWriter;
    private final int blockLen;
    private final long totalbytes;
    private boolean isClosed;
    private boolean isDone;
    private long bytesIn;
    private long bytesOut;
    private long bytesRaw;
    private long bytesCompressed;
    private int block = -1;
    @Nullable
    private byte[] firstBytes;
    private boolean storeFirstByte;

    public CompressorStream(@Nullable IdatChunkWriter idatCw, int blockLen, long totalbytes) {
        int blockLen2 = blockLen;
        long totalbytes2 = totalbytes;
        this.idatChunkWriter = idatCw;
        if (blockLen2 < 0) {
            blockLen2 = 4096;
        }
        if (totalbytes2 < 0L) {
            totalbytes2 = Long.MAX_VALUE;
        }
        if (blockLen2 < 1 || totalbytes2 < 1L) {
            throw new IllegalStateException(" maxBlockLen or totalLen invalid".toString());
        }
        this.blockLen = blockLen2;
        this.totalbytes = totalbytes2;
    }

    @Nullable
    protected final IdatChunkWriter getIdatChunkWriter() {
        return this.idatChunkWriter;
    }

    protected final void setIdatChunkWriter(@Nullable IdatChunkWriter idatChunkWriter) {
        this.idatChunkWriter = idatChunkWriter;
    }

    public final int getBlockLen() {
        return this.blockLen;
    }

    public final long getTotalbytes() {
        return this.totalbytes;
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    public final boolean isDone() {
        return this.isDone;
    }

    protected final void setDone(boolean bl) {
        this.isDone = bl;
    }

    protected final long getBytesIn() {
        return this.bytesIn;
    }

    protected final void setBytesIn(long l) {
        this.bytesIn = l;
    }

    protected final long getBytesOut() {
        return this.bytesOut;
    }

    protected final void setBytesOut(long l) {
        this.bytesOut = l;
    }

    protected final int getBlock() {
        return this.block;
    }

    protected final void setBlock(int n) {
        this.block = n;
    }

    @Nullable
    public final byte[] getFirstBytes() {
        return this.firstBytes;
    }

    @Override
    public void close() {
        this.done();
        if (this.idatChunkWriter != null) {
            IdatChunkWriter idatChunkWriter = this.idatChunkWriter;
            Intrinsics.checkNotNull((Object)idatChunkWriter);
            idatChunkWriter.close();
        }
        this.isClosed = true;
    }

    public abstract void done();

    @Override
    public void write(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.write(data2, 0, data2.length);
    }

    @Override
    public void write(@NotNull byte[] data2, int offset2, int len) {
        block3: {
            int len2;
            int off;
            block2: {
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                off = offset2;
                int n = this.block;
                this.block = n + 1;
                if (len2 > this.blockLen) break block2;
                this.mywrite(data2, off, len2);
                if (!this.storeFirstByte) break block3;
                Intrinsics.checkNotNull((Object)this.firstBytes);
                if (this.block >= this.firstBytes.length) break block3;
                Intrinsics.checkNotNull((Object)this.firstBytes);
                this.firstBytes[this.block] = data2[off];
                break block3;
            }
            for (len2 = len; len2 > 0; len2 -= this.blockLen) {
                this.mywrite(data2, off, this.blockLen);
                off += this.blockLen;
            }
        }
        if (this.bytesRaw >= this.totalbytes) {
            this.done();
        }
    }

    public abstract void mywrite(@NotNull byte[] var1, int var2, int var3);

    public final double getCompressionRatio() {
        return this.bytesCompressed == 0L ? 1.0 : (double)this.bytesCompressed / (double)this.bytesRaw;
    }

    public final void setStoreFirstByte(boolean storeFirstByte, int nblocks) {
        block4: {
            block2: {
                block3: {
                    this.storeFirstByte = storeFirstByte;
                    if (!this.storeFirstByte) break block2;
                    if (this.firstBytes == null) break block3;
                    Intrinsics.checkNotNull((Object)this.firstBytes);
                    if (this.firstBytes.length >= nblocks) break block4;
                }
                this.firstBytes = new byte[nblocks];
                break block4;
            }
            this.firstBytes = null;
        }
    }

    public void reset() {
        this.done();
        this.bytesRaw = 0L;
        this.bytesCompressed = 0L;
        this.block = -1;
        this.isDone = false;
    }

    @Override
    public void write(int b2) {
        byte[] byArray = new byte[]{(byte)b2};
        this.write(byArray);
    }
}

